/* AUXIL.C -- pf auxilliary routines ******************************************

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

******************************************************************************/

#include "pf.gbl"

#ifndef CPM
STRING *GetArg(), *GetOneArg();
unsigned GetNumArg();
char MulComp();
FLAG Test();
#endif

/* -------------------------------------------------- */

/* Argument routines */

FlushArg(name)				/* get rid of the argument */
	char *name;
{
	char *IGetTok();
	STRING *token;

	INextTok();
	repeat {
		while (IGetType()!=COMMAND)
			if (IGetType()==EOFT) {
				IUnGet();
				return;
				}
			else INextTok();
		INextTok();
		if (SCComp(IGetTok(),"end")) {
			if (SCompToC(token=GetOneArg(RETURN),name)) {
				SFree(token);
				return;
				}
			if (token) SFree(token);
			}
		INextTok();
		}
	}

FLAG
ArgOn(cmd)				/* start up a GetArg */
	char *cmd;
{
	char *IGetTok();

	if (getarginited) TIntError("ArgOnned");
	INextTok();
	if (IGetType()==EOFT) {
		IUnGet();
		return(FALSE);
		}
	if ((getargclose=MatchOpen(*IGetTok()))==NUL) {
		TError("Missing argument to '",cmd,"'.");
		return(FALSE);
		}
	getarginited=TRUE;
	INextTok();
	return(TRUE);
	}

ArgOff(cmd)				/* finish up a GetArg */
	char *cmd;
{
	if (getarginited && GetArg(ARGFLUSH)) TError("Extra arguments to '",cmd,"'.");
	getarginited=FALSE;
	}

STRING *
GetArg(what)			/* return an argument, token by token */
	char what;		/* FLUSH, RETURN, SAMPLE (return delim) */
{
	char *IGetTok();
	STRING *token;

	if (!getarginited) return(NULL);

	argquoted=FALSE;
	while (IsType(WHITESPACE,NEWLINE,HEADERCENTER,HEADERRIGHT,HEADERLINE,
		 NUL) || MulComp(IGetTok(),"=",",") || MulComp(IGetTok(),"/",";")) {
		INextTok();
		}
	if (IGetType()==EOFT) {
		IUnGet();
		getarginited=FALSE;
		return(NULL);
		}
	if (IGetType()==DELIM) {
		if (getargclose == *IGetTok()) {
			getarginited=FALSE;
			return(NULL);
			}
		if (what==SAMPLE) return(*IGetTok());
		argquoted=TRUE;
		IUnGet();
		token=GetOneArg(what);
		INextTok();
		return(token);
		}
	else if (what==SAMPLE) return(NUL);
	IPushBuf();
	while (IsType(TOKEN,COMMAND,DELIM,NUL) || (IGetType()==TOKENBREAK &&
		 !MulComp(IGetTok(),"=",",") && !MulComp(IGetTok(),"/",";"))) {
		if (IGetType()==DELIM && *IGetTok()==getargclose) break;
		if (what==RETURN) IAppTok();
		INextTok();
		}
	if (IGetType()==EOFT) {
		IUnGet();
		getarginted=FALSE;
		}
	token=IGetBuf();
	if (what==ARGFLUSH) SFree(token);
	IPopBuf();
	return(token);
	}

PushArg()				/* save GetArg's state */
{
	saveclose=getargclose;
	getarginited=FALSE;
	}

PopArg()				/* restore the state */
{
	getargclose=saveclose;
	getarginited=TRUE;
	}

STRING *
GetOneArg(arg)				/* return the argument as a single token */
	char arg;				/* HOLD, PRINT, RETURN, ARGFLUSH */
{
	char howend;
	char *IGetTok();
	STRING *token;

	INextTok();
	howend=MatchOpen(*IGetTok());
	if (howend==NUL) {
		TError("Missing single argument.",NULL,NULL);
		return(SCToS(IGetTok()));
		}
	if (arg==RETURN || arg==PRINT) IPushBuf();
	INextTok();
	newl=FALSE;
	while (IGetType()!=EOFT && (IGetType()!=DELIM || *IGetTok()!=howend)) {
		if (IGetType()==NEWLINE) {
			if (newl) {
				TError("Warning: Argument terminated by paragraph break.",
					NULL,NULL);
				break;
				}
			newl=TRUE;
			}
		else newl=FALSE;
		if (arg!=ARGFLUSH) IAppTok();
		INextTok();
		}
	newl=FALSE;
	if (IGetType()==EOFT) IUnGet();
	if (arg==RETURN) {		/* return the argument */
		token=IGetBuf();
		IPopBuf();
		return(token);
		}
	else if (arg==PRINT) {	/* print it on the console */
		token=IGetBuf();
		IPopBuf();
		TPuts(SSToC(token));
		SFree(token);
		}
	return(TRUE);
	}

/* -------------------------------------------------- */

/* standard environment routines */

FLAG
GetOpen()					/* pick up the opening delimiter */
{
	char *IGetTok();

	openneeded=FALSE;
	INextTok();
	if (IGetType()!=DELIM || (env.howclose=MatchOpen(*IGetTok()))==NUL) {
		TError("Bad opening character '",IGetTok(),"'.");
		EPop();
		return(FALSE);
		}
	return(TRUE);
	}

FLAG
InLine(token,trialname,onchar,offchar)		/* do an inline environment */
	char *token;
	char *trialname;
	char onchar, offchar;
{
	int CloseInLine();

	if (SCComp(token,trialname)) {
		PutOneCh(onchar);
		EPush();
		env.name=trialname;
		env.closeproc=CloseInLine;
		env.closechar=offchar;
		if (!GetOpen()) PutOneCh(offchar);
		return(TRUE);
		}
	return(FALSE);
	}

char
MulComp(token,name1,name2)	/* do a compare on more than one thing */
	char *token;
	char *name1, *name2;
{
	if (SCComp(token,name1)) return(1);
	else if (SCComp(token,name2)) return(2);
	return(NUL);
	}

char
MulTest(token,name1,name2)	/* do a Test on more than one thing */
	char *token;
	char *name1, *name2;
{
	if (Test(token,name1)) return(1);
	else if (Test(token,name2)) return(2);
	return(NUL);
	}

NormalEnv(tname,whitep,fillp,just)		/* set up a "normal" environment */
	char *tname, just;
	FLAG whitep, fillp;
{
	int ParaStan();

	EPush();
	env.name=tname;
	env.howclose=NUL;
	env.iswhiteintact=whitep;
	env.isfill=fillp;
	env.iswrap=TRUE;
	env.justifytype=just;
	env.linespacing=LINEHEIGHT;
	env.paraproc=ParaStan;
	}

StartEnv()				/* start an environment */
{
	if (openneeded && !GetOpen()) return;
	BreakLine();
	PPutVert(sty.above);
	if (env.paraproc) (*env.paraproc)();
	if (env.isfill) FlushWhite();
	}

FLAG
Test(token,trialname)		/* test for an environment and do some set up */
	char *token;
	char *trialname;
{
	int CloseStan();

	if (SCComp(token,trialname)) {
		EPush();
		env.name=trialname;
		env.iswhiteintact=FALSE;
		env.isfill=TRUE;
		env.iswrap=TRUE;
		env.justifytype='l';
		env.paraproc=NULL;
		env.closeproc=CloseStan;
		env.preveleft=env.eleft;
		return(TRUE);
		}
	return(FALSE);
	}

/* -------------------------------------------------- */

/* routines to handle paragraph breaks */

ParaEnum()				/* enumerate paragraphs */
{
	MICA amt;
	char nums[10];

	env.eleft=env.preveleft;
	SNToC(env.enumcount++,nums);
	strcat(nums,".");
	PutStr(nums);
	amt=LGetLength(nums,env.preveleft);
	BreakTok();
	LPutWhite(env.cureleft-(env.preveleft+amt));
	}

ParaItem()				/* itemize paragraph */
{
	char chr;

	env.eleft=env.preveleft;
	chr= env.itemlevel&1 ? '-' : '*';
	PutOneCh(chr);
	BreakTok();
	LPutWhite(env.cureleft-(env.preveleft+Width(chr)));
	}

#ifdef LARGE
ParaLevel()				/* Level environment */
{
	int *indx;

	ParaOut();
	for (indx= &level[0]; *(indx+1); ++indx) PutNum(NULL,(*indx)-1,".");
	PutNum(NULL,(*indx)++,".");
	BreakTok();
	LPutWhite(2*CHARWIDTH);
	if (sty.levhang) env.cureleft=LGetCol();
	}
#endif

ParaOut()					/* outdented paragraphs */
{
	env.eleft=env.preveleft;
	LPutWhite(0);
	}

ParaStan()				/* standard paragraph breaker */
{
	LPutWhite(sty.indent * dev.stdhoriz);
	}

/* -------------------------------------------------- */

/* Routines that close out environments */

CloseCase()				/* close out a Case statement */
{
	INextTok();
	PopArg();
	while (GetArg(ARGFLUSH));
	EPop();
	}

CloseFoots()				/* close footnote environments */
{
	if (sty.footstyle=='i') PutOneCh(']');
	else {
		BreakLine();
		PNoFootnote();
		IPopBuf();
		}
	EPop();
	}

CloseInLine()				/* in-line environment closer */
{
	PutOneCh(env.closechar);
	EPop();
	}

#ifdef LARGE
CloseLevel()				/* Level environment closer */
{
	int *indx;

	for (indx= &level[0]; *indx; ++indx);
	if (indx> &level[0]) *(--indx)=NULL;
	CloseStan();
	}
#endif

CloseSec()				/* sectioning environment closer */
{
	PutOneCh(env.closechar);
	BreakLine();
	PPutVert(2*LINEHEIGHT);
	EPop();
	}

CloseStan()				/* standard environment closer */
{
	BreakLine();
	PPutVert(sty.below);
	EPop();
	}

/* END OF AUXIL.C */
                            