/* pp.H	Global declarations for pp.C and drivers  ************************

	(C) 1982 Perfect Software, Inc.

	01/26/82	Version 1.00 by Barry A. Dobyns

***************************************************************************/


#ifdef YINYANG
#include "date.c"
#endif

#define TRUE			(-1)
#define FALSE			0
#define NULL			0
#define ERROR			(-1)

#define NUL			0x0		/* ^@ */
#define STX			0x2		/* ^B */
#define ETX			0x3		/* ^C */
#define ENQ			0x5		/* ^E */
#define ACK			0x6		/* ^F */
#define BEL			0x7		/* ^G */
#define BS			0x8		/* ^H */
#define TAB			0x9		/* ^I */
#define LF			0xA		/* ^J */
#define FF			0xC		/* ^L */
#define CR			0xD		/* ^M */
#define SO			0xE		/* ^N */
#define SI			0xF		/* ^O */
#define DC1			0x11		/* ^Q */
#define DC3			0x13		/* ^S */
#define ESC			0x1B		/* ESC */
#define RS			0x1E		/* ^^ */
#define US			0x1F		/* ^_ */
#define DEL			0x7F		/* DEL */
#define CPM_EOF			0x1A		/* CP/M end of text marker */
#define ABORTFILE		0x7		/* ^G */
#define ABORTALL		0x1A		/* ^Z */
#define EXIT			0x3		/* ^C */
#define DUMMYCHAR		0x20		/* space */

#define FLAG			char
#define MICA			unsigned
#define repeat			while (1)
#define ENDLIST		(-1)

#define INPUT			0
#define ABSOLUTE		0
#define DEFAULT		0


/* Special command characters */

#define SENTENCEBREAK	'\177'	/* ^? */
#define TOKENBREAK		'\240'	/* ~  */

#define BOLDON			'\302'	/* ~B */
#define BOLDOFF		'\342'	/* ~b */
#define ROMANON		'\322'	/* ~R */
#define ROMANOFF		'\362'	/* ~r */
#define UNNBON			'\325'	/* ~U underscore tokens */
#define UNNBOFF		'\365'	/* ~u */
#define UNALLON		'\301'	/* ~A underscore everything */
#define UNALLOFF		'\341'	/* ~a */
#define UNANON			'\316'	/* ~N underscore alphanumeric */
#define UNANOFF		'\356'	/* ~n */
#define ITALON			'\311'	/* ~I italics */
#define ITALOFF		'\351'	/* ~i */
#define BITALON		'\320'	/* ~P bold italics */
#define BITALOFF		'\360'	/* ~p */
#define SUPERON		'\323'	/* ~S superscripts */
#define SUPEROFF		'\363'	/* ~s */
#define SUBON			'\324'	/* ~T subscripts (why not?) */
#define SUBOFF			'\364'	/* ~t */
#define EXITON			'\330'	/* ~X eXit unusual attributes */
#define EXITOFF		'\370'	/* ~x */
#define F1ON			'\260'	/* ~0 Font 1 */	
#define F1OFF			'\261'	/* ~1 */
#define F2ON			'\262'	/* ~2 Font 2 */
#define F2OFF			'\263'	/* ~3 */
#define F3ON			'\264'	/* ~4 Font 3 */
#define F3OFF			'\265'	/* ~5 */

#define JUSTIFY		'\212'	/* ~^J */
#define HORIZSPACE		'\210'	/* ~^H */
#define VERTSPACE		'\226'	/* ~^V */

#define MAXMICA	48000	/* largest possible mica measurement */


/* Printing options */
FLAG pausep;					/* pause for page changes? */
FLAG quietp;					/* turns off user interaction */
int startpage,					/* page to start printing on */
    curpage;					/* current page */


/* For communication with driver */
#define BOLD			'B'
#define UNDERSCORE		'U'
#define ITALIC			'I'
#define HORIZONTAL		'H'
#define VERTICAL		'V'
#define OVP			'O'
#define BIDIREC		'D'
#define F1			'X'
#define F2			'Y'
#define F3			'Z'
#define CENTCHAR		'C'


/* Input line buffer */
#define ILINEMAX		256		/* chars in input line buffer */
#define ITOKENMAX		128		/* tokens in input line */
char iline[ILINEMAX];
struct token {
	int tokbegin;				/* index in line */
	int tokwidth;				/* width of token */
	int toklead;				/* leading whitespace */
	char tokscript;			/* normal, super, or sub */
	char tokuscore;			/* underscored? */
	FLAG tokbold;				/* boldface? */
	FLAG tokital;				/* italic? */
	FLAG tokf1;				/* font 1 */
	FLAG tokf2;				/* font 2 */
	FLAG tokf3;				/* font 3 */
	char tokjust;				/* justify on left of this token? */
	} itokens[ITOKENMAX];
int inchars, intokens;
FLAG forcetok;					/* force new token on next char? */
FLAG superp, subp;				/* super- or sub-script? */

#define ATTRMAX		16		/* max depth of attribute stack */
struct token attrstack[ATTRMAX];
int attrsp;					/* stack pointer */

struct justdesc {
	int jlefttok; 				/* token on which justification begins */
	int jspace;				/* amount of whitespace to add */
	int jnbrk;				/* number of token breaks */
	} just;					/* this will have to be a list to get .. */
FLAG justp;					/* .. two columns right */


#define BUFBLKS		64		/* 4K input buffer */
struct fbuf {
	char fname[20];
	int fchan, fnleft;
	char *fnextp, fbuff[BUFBLKS][128];
	} inputbuf;


char *title, *portname;


/**************** Printer globals ****************/

int phpos, pvpos;				/* current position */
int pageh, pagev;				/* page size */
int charh, linev;				/* std character cell */
int spaceh;					/* width of ' ' */
FLAG hackdone;					/* paper hack done? */

#define FORWARD		1
#define BACKWARD		(-1)

FLAG warned, fwarned;			/* you have been warned */

/* Underline map */
struct {
	int ulon, uloff;
	} ulmap[128];
int nuls;
FLAG ulonp;
FLAG boldp, italicp, ulitalp, f1p, f2p, f3p;

/* Output line buffer */
struct {
	char ochar;
	int ohpos;
	FLAG obold, oital, of1, of2, of3;
	} outline[200];
int olen;


/**************** Device globals ****************/

int datfd;

/* CONFIG.DAT header and data records */

#define PORT		2
#define MICRO 		3
#define PRINT		4


struct header {
			/* Input/output port descriptions */
	int fport;			/* the first port record */
	int coninp;			/* console input port */
	int conoutp;			/* console output port */
	int prtinp;			/* Printer input(??) port */
	int prtoutp;			/* printer output port */
	int modinp;			/* modem input port */
	int modoutp;			/* modem output port */
			/* Terminal type descriptions */
	int fterm;			/* first terminal record */
	int ourterm;			/* the default terminal type */
	int simterm;			/* terminal type to simulate */
			/* Printer descriptions */
	int fprint;			/* first printer record */
	int ourprint;			/* the default printer type */
	int conprint;			/* the printer type of the console */
			/* Character width tables */
	int fmicro;			/* the first micro-spacing table record */
	int maxmicro;			/* the number of micro spacing records */
			/* Character translation tables */
	int ftran;			/* the first translation record */
			/* The size of the data file */
	int hmax;				/* number of records including header */

	int cpuspeed;			/* cpu speed in 100KHz */
	char verse[16];		/* versn */
	} hdr;


#define SSPACE	128-66
struct printdesc {		/* describes the output device */
	char dname[16];		/* name of the device */
	MICA dwidth;			/* width of the printing surface */
	MICA dheight;			/* height of the print surface */
	MICA micahoriz;		/* size of smallest horizontal increment */
	MICA micavert;			/* size of smallest vertical increment */
	FLAG isprop;			/* does it have a proportional width font? */
	char fontnum;			/* if isprop, which width table to use */
	MICA stdhoriz;			/* width of a canonical character */
	MICA stdvert;			/* height of a single spaced line */
	FLAG isfile;			/* do plain file output? */
	char prtcode;			/* printer type code for pp */
	MICA paperoffset;		/* height paper is assumed to start at */
	FLAG backspace;		/* Does backspace work */
	FLAG barecr;			/* does bare CR work */
	FLAG formfeed;			/* does form feed work */
	char synctype;			/* Type of waiting to do: NONE, ETX/ACK, ^S^Q */
	FLAG needtran;			/* Do character translation on output? */
	char trannum;			/* Translation table number */
	struct str {			/* Various strings to send */
		char idx;					/* index into space */
		char len;					/* length */
		} initstr,			/* ... set things up */
			finistr,			/* ... clean up after */
			donewline,		/* ... do a newline */
			boldon,			/* ... turn on boldface */
			boldoff,			/* turn off boldface */
			italon,			/* turn on italics */
			italoff,			/* turn off italics */
			f1on,			/* Font one on */
			f1off,			/* font one off */
			f2on,			/* font 2 on */
			f2off,			/* font2 off */
			f3on,			/* font3 on */
			f3off;			/* font3 off */
	char strspc[SSPACE];	/* where strings are stored */
	} dev;


MICA widtab[128];			/* Character width table */

char trantbl[128];			/* Character translation table */

char tsect[128];

int dhpos, dvpos;
int dbold, dital, df1, df2, df3;

#define NOCHAR		(-1)
int dbufchar;


/* Control code types */
#define VANILLA		1		/* no microspacing, standard controls */
#define DIABLO			2		/* 1620 & anything compatible */
#define EPSON			3		/* MX-80 (microvert) */
#define IDS460			4		/* IDS 460 proportional */
#define SPINWRITER		5		/* Spinwriter & friends */
#define CITOH			6		/* Citoh 8510 */
#define CEN737			8		/* Centronics 737 */

#define SPRINT1		-1		/* Qume Sprint1 */
#define SPRINT5		-1		/* Qume Sprint5 */



/**************** Output globals ****************/

struct portdesc {
	char pname[16];		/* Zero terminated port name */
	FLAG dbiosp;		/* Use the bios call numbered by the data
                                   port if non-zero */
	char dataport;		/* Data port, or bios call number */
	char datamask;		/* Mask to AND data with */
	FLAG sbiosp;		/* Use the bios call numbered by the status
                                   port if non-zero */
	char statport;		/* Status port, or bios call number */
	char readymask;		/* Mask to AND status with */
	char polarity;		/* (Status AND mask == <this>) if ready */
} iport, oport;


/* Output queue */
#define QUEUE_SIZE		192		/* Size of output queue */
int oqueue [QUEUE_SIZE + 4];

/* Synchronization control */
#define NOSYNC		1
#define ETX_ACK	2
#define XON_XOFF	3
#define SYNCBUFSIZE	60
#define SEQSTART	0x100
#define SEQEND		(SEQSTART + 0x20)

FLAG syncok;					/* for XON/XOFF: OK to send character? */
int synccnt;					/* for ETX/ACK: no of chars sent so far */
int syncnbufs;					/* for ETX/ACK: no of buffers sent */


/**************** Globals for printer drivers ****************/

#define UNINITIALIZED	0x8000

int drvhpos, drvvpos;			/* current horizontal, vertical position */

int drvhpitch, drvvpitch;		/* current pitch of printer */

int drvdirec;					/* current print direction */

FLAG drvshiftp;				/* is printer shifted? */

int (*dvfinit)(),				/* init funct */
    (*dvffini)(),				/* fini funct */
    (*dvfprtmov)(),				/* prtmove funct */
    (*dvfinfo)();				/* info funct */

/* End of pp.H  --  globals for PF print program */
#define DATE	"May 26, 1983"
#define VERSION	"1.10"
char		IChar();
struct token	*GetTok();
struct token	*AttrPush();
struct fbuf	*IOpen();
char		INext();
char		*IName();
FLAG		PIRdy();
char		PIGet();
FLAG		PORdy();
FLAG		FindRec();
FLAG		OStKnown();
FLAG		OReady();
FLAG		VInfo();
FLAG		DbInfo();
FLAG		EpInfo();
FLAG		IDSInfo();
FLAG		SpInfo();
FLAG		CenInfo();
FLAG		CitInfo();

/*
**	End of ``pp.h''
**	What follows is IBM PC specific changes
*/
#include <stdio.h>
#include <ctype.h>
#define dskreset()

#define ForceTok		FnForceTok
#define PHPos			FnPHPos
#define PVPos			FnPVPos
#define DHPos			FnDHPos
#define DVPos			FnDVPos

#define DFLTLPT			"lpt1:"
int	lpt_fd = -1;
int	lpt_stat;
