#include <stdio.h>
#include "globals.h"
#include "addrmodes.h"
#include "sym.h"
#include "inst.h"
int ea();
int r0_r9();
int ea_imm9();
int ea_imm();
int ea_r9();
int word_ext();
int long_ext();
int r9_imm0();
int r0_imm9();
int r0_imm();
int ea_r0();
int ext_r0();
int no_operands();
int r0();
int ea6_ea();
int spimm0();
int rext12_specialreg();
int r0_usp();
int r0disp_r9();
int ea_rext();
int cas_encode();
int cas2_encode();
int bfea();
int bfea_r();
int ea_rext2();

/*  the array base_inst.  This array should be initialized from the least
    to the most commonly used instruction, as the enter() routine links
    new entries to the FRONT of the hash chain. Additionally, within
    an instruction, the templates should be ordered with the most favorable
    (size, execution speed) FIRST.  Thus, if two instructions can move the
    immediate number 7 into d0, and inst A takes an immediate ea encoded in
    the following long and inst B encodes the small immediate operand in the
    instruction, instruction B should appear in the template first.

*/

inst_t base_inst[]  = 
{
	{"abcd",   	0,	&template[0],},
	{"addb",   	0,	&template[3],},
	{"addl",   	0,	&template[8],},
	{"addqb",   	0,	&template[14],},
	{"addql",   	0,	&template[16],},
	{"addqw",   	0,	&template[18],},
	{"addw",   	0,	&template[20],},
	{"addxb",   	0,	&template[26],},
	{"addxl",   	0,	&template[29],},
	{"addxw",   	0,	&template[32],},
	{"andb",   	0,	&template[35],},
	{"andl",   	0,	&template[40],},
	{"andw",   	0,	&template[44],},
	{"aslb",   	0,	&template[49],},
	{"asll",   	0,	&template[52],},
	{"aslw",   	0,	&template[55],},
	{"asrb",   	0,	&template[59],},
	{"asrl",   	0,	&template[62],},
	{"asrw",   	0,	&template[65],},
	{"bkpt",   	0,	&template[69],},
	{"bcc",   	0,	&template[71],},
	{"bcs",   	0,	&template[73],},
	{"beq",   	0,	&template[75],},
	{"bge",   	0,	&template[77],},
	{"bgt",   	0,	&template[79],},
	{"bhi",   	0,	&template[81],},
	{"ble",   	0,	&template[83],},
	{"bls",   	0,	&template[85],},
	{"blt",   	0,	&template[87],},
	{"bmi",   	0,	&template[89],},
	{"bne",   	0,	&template[91],},
	{"bpl",   	0,	&template[93],},
	{"bvc",   	0,	&template[95],},
	{"bvs",   	0,	&template[97],},
	{"bra",   	0,	&template[99],},
	{"bccs",   	0,	&template[101],},
	{"bcss",   	0,	&template[103],},
	{"beqs",   	0,	&template[105],},
	{"bges",   	0,	&template[107],},
	{"bgts",   	0,	&template[109],},
	{"bhis",   	0,	&template[111],},
	{"bles",   	0,	&template[113],},
	{"blss",   	0,	&template[115],},
	{"blts",   	0,	&template[117],},
	{"bmis",   	0,	&template[119],},
	{"bnes",   	0,	&template[121],},
	{"bpls",   	0,	&template[123],},
	{"bvcs",   	0,	&template[125],},
	{"bvss",   	0,	&template[127],},
	{"bras",   	0,	&template[129],},
	{"braw",   	0,	&template[131],},
	{"bchg",   	0,	&template[133],},
	{"bclr",   	0,	&template[137],},
	{"bfchg",   	0,	&template[141],},
	{"bfclr",   	0,	&template[143],},
	{"bfexts",   	0,	&template[145],},
	{"bfextu",   	0,	&template[147],},
	{"bfffo",   	0,	&template[149],},
	{"bfins",   	0,	&template[151],},
	{"bfset",   	0,	&template[153],},
	{"bftst",   	0,	&template[155],},
	{"bset",   	0,	&template[157],},
	{"btst",   	0,	&template[161],},
	{"bsr",   	0,	&template[165],},
	{"bsrs",   	0,	&template[168],},
	{"bsrw",   	0,	&template[171],},
	{"callm",   	0,	&template[174],},
	{"casb",   	0,	&template[176],},
	{"casl",   	0,	&template[178],},
	{"casw",   	0,	&template[180],},
	{"cas2l",   	0,	&template[182],},
	{"cas2w",   	0,	&template[184],},
	{"chk",   	0,	&template[186],},
	{"chkl",   	0,	&template[188],},
	{"chkw",   	0,	&template[190],},
	{"chk2b",   	0,	&template[192],},
	{"chk2l",   	0,	&template[194],},
	{"chk2w",   	0,	&template[196],},
	{"clrb",   	0,	&template[198],},
	{"clrw",   	0,	&template[200],},
	{"clrl",   	0,	&template[202],},
	{"cmpb",   	0,	&template[204],},
	{"cmpw",   	0,	&template[208],},
	{"cmpl",   	0,	&template[213],},
	{"cmpmb",   	0,	&template[218],},
	{"cmpml",   	0,	&template[220],},
	{"cmpmw",   	0,	&template[222],},
	{"cmp2b",   	0,	&template[224],},
	{"cmp2l",   	0,	&template[226],},
	{"cmp2w",   	0,	&template[228],},
	{"dbcc",   	0,	&template[230],},
	{"dbcs",   	0,	&template[232],},
	{"dbeq",   	0,	&template[234],},
	{"dbf",   	0,	&template[236],},
	{"dbge",   	0,	&template[238],},
	{"dbgt",   	0,	&template[240],},
	{"dbhi",   	0,	&template[242],},
	{"dble",   	0,	&template[244],},
	{"dbls",   	0,	&template[246],},
	{"dblt",   	0,	&template[248],},
	{"dbmi",   	0,	&template[250],},
	{"dbne",   	0,	&template[252],},
	{"dbpl",   	0,	&template[254],},
	{"dbra",   	0,	&template[256],},
	{"dbt",   	0,	&template[258],},
	{"dbvc",   	0,	&template[260],},
	{"dbvs",   	0,	&template[262],},
	{"divs",   	0,	&template[264],},
	{"divsl",   	0,	&template[266],},
	{"divsll",   	0,	&template[269],},
	{"divsw",   	0,	&template[271],},
	{"divu",   	0,	&template[273],},
	{"divul",   	0,	&template[275],},
	{"divull",   	0,	&template[278],},
	{"divuw",   	0,	&template[280],},
	{"eorb",   	0,	&template[282],},
	{"eorw",   	0,	&template[286],},
	{"eorl",   	0,	&template[290],},
	{"exg",   	0,	&template[293],},
	{"exgl",   	0,	&template[297],},
	{"extw",   	0,	&template[301],},
	{"extbw",   	0,	&template[303],},
	{"extl",   	0,	&template[305],},
	{"extwl",   	0,	&template[307],},
	{"extbl",   	0,	&template[309],},
	{"illegal",   	0,	&template[311],},
	{"jcc",   	0,	&template[313],},
	{"jcs",   	0,	&template[315],},
	{"jeq",   	0,	&template[317],},
	{"jge",   	0,	&template[319],},
	{"jgt",   	0,	&template[321],},
	{"jhi",   	0,	&template[323],},
	{"jle",   	0,	&template[325],},
	{"jls",   	0,	&template[327],},
	{"jlt",   	0,	&template[329],},
	{"jmi",   	0,	&template[331],},
	{"jne",   	0,	&template[333],},
	{"jpl",   	0,	&template[335],},
	{"jvc",   	0,	&template[337],},
	{"jvs",   	0,	&template[339],},
	{"jra",   	0,	&template[341],},
	{"jmp",   	0,	&template[344],},
	{"jbsr",   	0,	&template[346],},
	{"jsr",   	0,	&template[349],},
	{"lea",   	0,	&template[352],},
	{"link",   	0,	&template[354],},
	{"linkl",   	0,	&template[356],},
	{"linkw",   	0,	&template[358],},
	{"lslb",   	0,	&template[360],},
	{"lsll",   	0,	&template[363],},
	{"lslw",   	0,	&template[366],},
	{"lsrb",   	0,	&template[370],},
	{"lsrl",   	0,	&template[373],},
	{"lsrw",   	0,	&template[376],},
	{"movb",   	0,	&template[380],},
	{"movec",   	0,	&template[382],},
	{"movepw",   	0,	&template[385],},
	{"movepl",   	0,	&template[388],},
	{"movesb",   	0,	&template[391],},
	{"movesl",   	0,	&template[394],},
	{"movesw",   	0,	&template[397],},
	{"movw",   	0,	&template[400],},
	{"movl",   	0,	&template[407],},
	{"moveml",   	0,	&template[413],},
	{"movemw",   	0,	&template[416],},
	{"moveq",   	0,	&template[419],},
	{"muls",   	0,	&template[421],},
	{"mulsw",   	0,	&template[423],},
	{"mulsl",   	0,	&template[425],},
	{"mulu",   	0,	&template[428],},
	{"mulul",   	0,	&template[430],},
	{"muluw",   	0,	&template[433],},
	{"nbcd",   	0,	&template[435],},
	{"negb",   	0,	&template[437],},
	{"negw",   	0,	&template[439],},
	{"negl",   	0,	&template[441],},
	{"negxb",   	0,	&template[443],},
	{"negxw",   	0,	&template[445],},
	{"negxl",   	0,	&template[447],},
	{"nop",   	0,	&template[449],},
	{"notb",   	0,	&template[451],},
	{"notw",   	0,	&template[453],},
	{"notl",   	0,	&template[455],},
	{"orb",   	0,	&template[457],},
	{"orw",   	0,	&template[461],},
	{"orl",   	0,	&template[467],},
	{"pea",   	0,	&template[471],},
	{"reset",   	0,	&template[473],},
	{"rolb",   	0,	&template[475],},
	{"rolw",   	0,	&template[478],},
	{"roll",   	0,	&template[481],},
	{"rorb",   	0,	&template[485],},
	{"rorw",   	0,	&template[488],},
	{"rorl",   	0,	&template[491],},
	{"roxlb",   	0,	&template[495],},
	{"roxlw",   	0,	&template[498],},
	{"roxll",   	0,	&template[501],},
	{"roxrb",   	0,	&template[505],},
	{"roxrw",   	0,	&template[508],},
	{"roxrl",   	0,	&template[511],},
	{"rtd",   	0,	&template[515],},
	{"rte",   	0,	&template[517],},
	{"rtm",   	0,	&template[519],},
	{"rtr",   	0,	&template[522],},
	{"rts",   	0,	&template[524],},
	{"sbcd",   	0,	&template[526],},
	{"scc",   	0,	&template[529],},
	{"scs",   	0,	&template[531],},
	{"seq",   	0,	&template[533],},
	{"sf",   	0,	&template[535],},
	{"sge",   	0,	&template[537],},
	{"sgt",   	0,	&template[539],},
	{"shi",   	0,	&template[541],},
	{"sle",   	0,	&template[543],},
	{"sls",   	0,	&template[545],},
	{"slt",   	0,	&template[547],},
	{"smi",   	0,	&template[549],},
	{"sne",   	0,	&template[551],},
	{"spl",   	0,	&template[553],},
	{"st",   	0,	&template[555],},
	{"svc",   	0,	&template[557],},
	{"svs",   	0,	&template[559],},
	{"stop",   	0,	&template[561],},
	{"subb",   	0,	&template[563],},
	{"subl",   	0,	&template[568],},
	{"subqb",   	0,	&template[574],},
	{"subql",   	0,	&template[576],},
	{"subqw",   	0,	&template[578],},
	{"subw",   	0,	&template[580],},
	{"subxb",   	0,	&template[586],},
	{"subxl",   	0,	&template[589],},
	{"subxw",   	0,	&template[592],},
	{"swap",   	0,	&template[595],},
	{"tasb",   	0,	&template[597],},
	{"trap",   	0,	&template[599],},
	{"trapcc",   	0,	&template[601],},
	{"trapccl",   	0,	&template[603],},
	{"trapccw",   	0,	&template[605],},
	{"trapcs",   	0,	&template[607],},
	{"trapcsl",   	0,	&template[609],},
	{"trapcsw",   	0,	&template[611],},
	{"trapeq",   	0,	&template[613],},
	{"trapeql",   	0,	&template[615],},
	{"trapeqw",   	0,	&template[617],},
	{"trapf",   	0,	&template[619],},
	{"trapfl",   	0,	&template[621],},
	{"trapfw",   	0,	&template[623],},
	{"trapge",   	0,	&template[625],},
	{"trapgel",   	0,	&template[627],},
	{"trapgew",   	0,	&template[629],},
	{"trapgt",   	0,	&template[631],},
	{"trapgtl",   	0,	&template[633],},
	{"trapgtw",   	0,	&template[635],},
	{"traphi",   	0,	&template[637],},
	{"traphil",   	0,	&template[639],},
	{"traphiw",   	0,	&template[641],},
	{"traple",   	0,	&template[643],},
	{"traplel",   	0,	&template[645],},
	{"traplew",   	0,	&template[647],},
	{"trapls",   	0,	&template[649],},
	{"traplsl",   	0,	&template[651],},
	{"traplsw",   	0,	&template[653],},
	{"traplt",   	0,	&template[655],},
	{"trapltl",   	0,	&template[657],},
	{"trapltw",   	0,	&template[659],},
	{"trapmi",   	0,	&template[661],},
	{"trapmil",   	0,	&template[663],},
	{"trapmiw",   	0,	&template[665],},
	{"trapne",   	0,	&template[667],},
	{"trapnel",   	0,	&template[669],},
	{"trapnew",   	0,	&template[671],},
	{"trappl",   	0,	&template[673],},
	{"trappll",   	0,	&template[675],},
	{"trapplw",   	0,	&template[677],},
	{"trapt",   	0,	&template[679],},
	{"traptl",   	0,	&template[681],},
	{"traptw",   	0,	&template[683],},
	{"trapvc",   	0,	&template[685],},
	{"trapvcl",   	0,	&template[687],},
	{"trapvcw",   	0,	&template[689],},
	{"trapvs",   	0,	&template[691],},
	{"trapvsl",   	0,	&template[693],},
	{"trapvsw",   	0,	&template[695],},
	{"trapv",   	0,	&template[697],},
	{"tstb",   	0,	&template[699],},
	{"tstl",   	0,	&template[701],},
	{"tstw",   	0,	&template[703],},
	{"unlk",   	0,	&template[705],},
};
