#! /bin/sh
changequote([[,]])
undefine([[eval]])
undefine([[shift]])
# NAME
#	install - install commands
# SYNOPSIS
#	install [options] filelist [dir ...]
#
# In the following matrix, a 1 means the options are incompatible.
#	|---|
#    m  | 1 |
#	|---|---|
#    u  |   | 1 |
#	|---|---|---|
#    g  |   |   | 1 |
#	|---|---|---|---|
#    i  |   |   |   |   |
#	|---|---|---|---|---|
#    oO |   |   |   |   |   |
#	|---|---|---|---|---|---|
#    s  |   |   |   |   |   |   |
#	|---|---|---|---|---|---|---|
#    c  |   |   |   | 1 | 1 |   | 1 |
#	|---|---|---|---|---|---|---|---|
#    f  | 1 | 1 | 1 | 1 |   |   | 1 | 1 |
#	|---|---|---|---|---|---|---|---|---|
#    F  |   |   |   | 1 |   |   | 1 | 1 | 1 |
#	|---|---|---|---|---|---|---|---|---|---|
#    n  |   |   |   |   |   |   | 1 | 1 | 1 | 1 |
#	|---|---|---|---|---|---|---|---|---|---|---|
#    dir|   |   |   | 1 |   |   | 1 | 1 | 1 | 1 |   |
#	|---|---|---|---|---|---|---|---|---|---|---|---|
#    ln |   |   |   |   |   |   |   | 1 |   |   |   | 1 |
#	|---|---|---|---|---|---|---|---|---|---|---|---|---|
#    lns|   |   |   |   |   |   |   | 1 |   |   |   | 1 | 1 |
#	|---|---|---|---|---|---|---|---|---|---|---|---|---|---|
#    src|   |   |   |   |   |   |   |   |   |   |   | 1 | 1 | 1 |
#	|---|---|---|---|---|---|---|---|---|---|---|---|---|---|---|
#    idb|   |   |   |   |   |   |   |   |   |   |   |   |   |   |   |
#	|---|---|---|---|---|---|---|---|---|---|---|---|---|---|---|
#	  m   u   g   i   o   s   c   f   F   n  dir ln  lns src idb 
#
#
me=`basename $0`
if test -n "$IDB"; then
	find="eval cd $ROOT; find"
	srchdirs="bin usr/bin etc lib usr/lib"	# must be relative!
	echo=:
	cwd=`pwd`
	srcroot=
	for comp in `echo $cwd | tr '/' ' '`; do
		srcroot=$srcroot/$comp
		if test $comp = "src"; then
			break
		fi
	done
	srcbase=`expr $cwd : "$srcroot/\(.*\)"`
else
	find=find
	srchdirs="$ROOT/bin $ROOT/usr/bin $ROOT/etc $ROOT/lib $ROOT/usr/lib"
	echo=echo 
	if test -n "$HOSTENV" -a -z "$ROOT"; then
		echo
	"$me: HOSTENV set but ROOT unset; bailing out lest I trash your root!"
		exit 1
	fi
fi

ifelse(SYSTEM,SVR3,[[
# isabspath pathname - check for an absolute pathname
Isabspath() {
	test `expr "x$*" : 'x/.*'` -gt 0; return
}
define(isabspath, Isabspath $1)
]],[[
define(isabspath, test `expr "x$1" : 'x/.*'` -gt 0)
]])

ifelse(SYSTEM,SVR3,[[
# notsticky mode - check whether a mode includes the sticky bit
Notsticky() {
	test `expr $1 : '0*[1357]...'` -eq 0; return
}
define(notsticky, Notsticky $1)
]],[[
define(notsticky, test `expr $1 : '0*[1357]...'` -eq 0)
]])

ifelse(SYSTEM,SVR3,[[
# stickyfile pathname - check whether a file is sticky
Stickyfile() {
	test -k $*; return
}
define(stickyfile, Stickyfile $1)
]],[[
define(stickyfile, test -k $1)
]])

# exit status, set by primitive failure below
status=0

ifelse(SYSTEM,SVR3,[[
# chmog mode owner group destpath
Chmog() {
	if chmod $1 $4 && chgrp $3 $4 && chown $2 $4; then
		:
	else
		status=$?
	fi
	return
}
define(chmog, Chmog $1 $2 $3 $4)
]],[[
define(chmog,
	if chmod $1 $4 && chgrp $3 $4 && chown $2 $4; then
		:
	else
		status=$?
	fi
)
]])

put=cp
ifelse(SYSTEM,SVR3,[[
# putit mode owner group destpath srcpath
Putit() {
	if test "$put" != "cp"; then
		rm -f $4
	fi
	if $put $5 $4; then
		Chmog $1 $2 $3 $4
	else
		status=$?
	fi
	return
}
define(putit, Putit $1 $2 $3 $4 $5)
]],[[
define(putit,
	{ test "$put" != "cp" && rm -f $4;
	  $put $5 $4 && chmod $1 $4 && chgrp $3 $4 && chown $2 $4;
	  status=$?; })
]])

ifelse(SYSTEM,SVR3,[[
# saveold owner group destdir filename isitbusy
Saveold() {
	if test $5 = maybe; then
		rm -f $3/$4
	fi
	if test -f $3/$4; then
		mv -f $3/$4 $3/OLD$4
		if cp $3/OLD$4 $3/$4; then
			$echo "$4 moved to $3/OLD$4"
			chgrp $2 $3/$4
			chown $1 $3/$4
			return
		else
			echo "$me: cp $3/OLD$4 $3/$4 failed"
			exit 2
		fi
	fi
}
define(saveold, Saveold $1 $2 $3 $4 $5)
]],[[
define(saveold,
	if test $5 = maybe; then
		rm -f $3/$4
	fi
	if test -f $3/$4; then
		mv -f $3/$4 $3/OLD$4
		if cp $3/OLD$4 $3/$4; then
			$echo "$4 moved to $3/OLD$4"
			chgrp $2 $3/$4
			chown $1 $3/$4
		else
			echo "$me: cp $3/OLD$4 $3/$4 failed"
			exit 2
		fi
	fi
)
]])

idbattrs=""
ifelse(SYSTEM,SVR3,[[
# putidbrec type mode owner group destpath srcpath
Putidbrec() {
	case "$put" in
	  ln*)
		# no links to implicit directories
		if test $1 != "D"; then
			echo l $2 $3 $4 $5 - "symval($6)" $idbattrs
		else
			echo $* $idbattrs
		fi
		;;
	  *)
		echo $* $idbattrs
	esac >> $IDB
}
define(putidbrec, Putidbrec $1 $2 $3 $4 $5 $6)
]],[[
define(putidbrec,[[
	ifelse($1,D,[[
		echo $1 $2 $3 $4 $5 $6 $7 $8 $9 $idbattrs >> $IDB
	]],[[
		case "$put" in
		  ln*)
			# no links to implicit directories
			echo l $2 $3 $4 $5 - "symval($6)" $idbattrs
			;;
		  *)
			echo $1 $2 $3 $4 $5 $6 $7 $8 $9 $idbattrs
		esac >> $IDB
	]])
]])
]])

# source may be set by an option to the relative path to a source file;
# destdir is the absolute path to the installation directory.  
source=""
destdir=""
syslist="$ROOT/etc/syslist"
installhow=dontknow	# -c, -f, -F, or -dir
found=dontknow
moveold=no

# initialize mode, owner, and group
mode=755
forceowner=no
ids="`id`"
owner=`expr "$ids" : '.*uid=[0-9]*(\([^)]*\)).*'`
if test "$owner" = ""; then
	owner=`expr "$ids" : '.*uid=\([0-9]*\).*'`
fi
group=`expr "$ids" : '.*gid=[0-9]*(\([^)]*\))'`
if test "$group" = ""; then
	group=`expr "$ids" : '.*gid=\([0-9]*\)'`
fi

# check whether we are being run by root
if test $owner = root -o $owner = 0; then
	isroot=yes
	owner=bin
	group=bin
	impdirmode=755
	impdirowner=bin
	impdirgroup=bin
elif test `expr "$ROOT" : '/[^/].*'` -gt 0; then
	# allow developers to use -u and -g in their private root areas
	isroot=yes
	impdirmode=755
	impdirowner=$owner
	impdirgroup=$group
else
	isroot=no
	impdirmode=755
	impdirowner=bin
	impdirgroup=bin
fi

# process options (oh wonderful anti-orthogonality)
while test $# -gt 0; do
	# make sure unary options have arguments
	option=$1
	case $option in
	  -[mugcfFn]|-dir|-ln|-lns|-src|-idb)
		if test $# -le 1; then
			echo "$me: $option must be followed by an argument"
			exit 1
		fi
		;;
	  -[ioOs])	# these are nullary options
		;;
	  -*)
		echo "$me: illegal option $option"; exit 1
		;;
	  *)
		break
	esac

	# now interpret each option, enforcing anti-orthogonality
	badopts=
	goodopts=
	case $option in
	  -m)
		badopts='-f'
		mode=$2
		shift
		;;
	  -u)
		badopts='-f'
		if test $isroot = no; then
			echo "$me: must be root to use -u; ignored"
		else
			owner=$2
			forceowner=yes
		fi
		shift
		;;
	  -g)
		badopts='-f'
		if test $isroot = no; then
			echo "$me: must be root to use -g; ignored"
		else
			group=$2
		fi
		shift
		;;
	  -i)
		badopts='-c|-f|-F|-dir'
		srchdirs=""
		;;
	  -o)
		badopts='-c'
		moveold=yes
		;;
	  -O)
		badopts='-c'
		moveold=maybe
		;;
	  -s)
		echo=:
		;;
	  -c)
		badopts='-i|-o|-f|-F|-n|-dir'
		installhow=$1
		destdir=$2
		shift
		;;
	  -f)
		goodopts='-o|-s|-src'
		installhow=$1
		destdir=$2
		shift
		;;
	  -F)
		badopts='-i|-c|-f|-n|-dir'
		installhow=$1
		destdir=$2
		shift
		;;
	  -n)
		badopts='-c|-f|-F|-dir'
		lastresort=$2
		shift
		found=no
		;;
	  -dir)
		badopts='-i|-c|-f|-F|-n'
		installhow=$1
		;;
	  -ln)
		badopts='-f|-lns|-src'
		put=ln
		source=$2
		shift
		;;
	  -lns)
		badopts='-f|-ln|-src'
		put="ln -s"
		source=$2
		shift
		;;
	  -src)
		badopts='-f|-ln|-lns'
		source=$2
		shift
		;;
	  -idb)
		idbattrs="$idbattrs${idbattrs:+ }$2"
		shift
		option=""
		;;
	  -*)
		echo "$me: illegal option $1"; exit 1
	esac

	# if badopts or goodopts was set, test options for presence (bad)
	# or absense (good)
	if test -n "$badopts"; then
		badopts="$badopts|$option"
		if echo "$options\c" | tr '|' '\012' | egrep -s "($badopts)"
		then
			echo "$me: don't use $option with `echo $badopts |
			    sed -e 's/|/, /g' -e 's/.*, /&or /'`"
			exit 1
		fi
	elif test -n "$goodopts"; then
		if echo "$options\c" | tr '|' '\012' | egrep -sv "($goodopts)"
		then
			echo "$me: use $option with `echo $goodopts |
			    sed -e 's/|/, /g' -e 's/.*, /&and /'` only"
			exit 1
		fi
	fi

	options="$options${options:+|}$option"
	shift
done

# we're done with the options, so look for source to install
if test $# -eq 0; then
	if test -z "$source"; then
		echo "$me: nothing to install"; exit 1
	fi
	targets=$source
else
	targets=$1	# may be a quoted filelist
	shift
fi

# the remaining arguments are extra directories in which to look
usrdirs="$*"

# prefix $ROOT to destdir only for absolute paths.
if isabspath($destdir); then
	rdestdir=$ROOT$destdir
	if test -z "$IDB"; then
		destdir=$rdestdir
	fi
else
	rdestdir=$destdir
fi

if test -z "$IDB" -a \
    -n "$rdestdir" -a ! -d "$rdestdir" -a $installhow != -F; then
	echo "$me: installation directory $rdestdir does not exist"
	exit 1
fi

#
# This loop iterates destpath over names in the target filelist.  srcpath is
# a relative path to the source file such that putit executed from the current
# directory will find the source to install.  filename is the target basename.
# If IDB is set, srcpath spells the path from /.../src to the source.
#
for destpath in $targets; do
	srcpath=${source:-${destpath}}
	if isabspath($srcpath); then
		if test -z "$IDB"; then
			srcpath=$ROOT$srcpath
		fi
	elif test -n "$IDB"; then
		srcpath=$srcbase/$srcpath
	fi
	filename=`basename "$destpath"`

	case "$installhow" in
	  -dir)
		# XXX needs to work with -F?
		if test -n "$IDB"; then
			putidbrec(d,$mode,$owner,$group,$destpath,-)
			continue
		fi

		if isabspath($destpath); then
			destpath=$ROOT$destpath
		fi
		if test ! -d $destpath; then
			mkdir $destpath
			$echo "$destpath created"
		fi
		chmog($mode,$owner,$group,$destpath)
		;;
	  -c|-f)
		if test $destpath != $filename; then
			echo "$me: don't use relative pathnames with -c and -f"
			exit 1
		fi
		absdestpath=$rdestdir/$filename

		# XXX why the second predicate?
		if test -f $absdestpath -o -f $absdestpath/$filename; then
			owner=`ls -l $rdestdir/$filename | awk '{print $3}'`
			group=`ls -l $rdestdir/$filename | awk '{print $4}'`

			if stickyfile($destdir/$filename); then
				if test -z "$HOSTENV" -a -z "$IDB"; then
					chmod -t $destdir/$filename
					$destdir/$filename < /dev/null \
					    > /dev/null
				fi
				tbit=on
			else
				tbit=off
			fi

			if test -n "$IDB"; then
				if test $tbit = on && notsticky($mode); then
					mode=1`expr $mode : '0*\([0-7]*\)'`
				fi
				putidbrec(f,$mode,$owner,$group, \
					  $destdir/$filename,$srcpath)
				continue
			fi

			case $installhow in
			  -c)
				echo \
				    "$me: $filename already exists in $destdir"
				exit 2
			esac

			if test $moveold != no; then
				saveold($owner,$group,$destdir,$filename, \
					$moveold)
			fi
			if test "$put" != "cp"; then
				rm -f $destdir/$filename
			fi
			if $put $srcpath $destdir/$filename; then
				$echo \
				    "$destpath installed as $destdir/$filename"
			fi
			if test $tbit = on; then
				chmod +t $destdir/$filename
			fi
			continue
		fi

		if test -n "$IDB"; then
			putidbrec(f,$mode,$owner,$group, \
				  $destdir/$filename, $srcpath)
			continue
		fi

		if putit($mode,$owner,$group,$destdir/$filename,$srcpath); then
			$echo "$destpath installed as $destdir/$filename"
		fi
		;;

	  -F)
		if isabspath($destpath); then
			echo \
			  "$me: warning: installing absolute pathname with -F"
			exit 1
		fi

		# create required directories for the target file
		dp=$destdir/$destpath
		if isabspath($dp); then
			idp=/		# incremental absolute destpath
		else
			idp=		# incremental relative destpath
		fi
		for comp in `dirname $dp | tr '/' ' '`; do
			if test $comp = "." -o $comp = "/"; then
				break
			fi
			idp=$idp$comp/
			if test -n "$IDB"; then
				putidbrec(D,$impdirmode,$impdirowner, \
					  $impdirgroup,$idp,-)
			elif test ! -d $idp; then
				mkdir $idp || exit 2
				$echo "$idp created"
				chmog($impdirmode,$impdirowner,$impdirgroup, \
				      $idp)
			fi
		done

		if test -n "$IDB"; then
			putidbrec(f,$mode,$owner,$group, \
				  $destdir/$destpath,$srcpath)
			continue
		fi

		if test $moveold != no; then
			saveold($owner,$group,`dirname $dp`,`basename $dp`, \
				$moveold)
		fi
		if putit($mode,$owner,$group,$dp,$srcpath); then
			$echo "$srcpath installed as $dp"
		fi
		;;

	  dontknow)
		puthere=""
		foundit=$found
	
		# look for file in user-specified directories
		for i in $usrdirs; do
			if isabspath($i); then
				if test -n "$IDB"; then	# strip leading ///s
					i=`expr x$i : 'x/*\(.*\)'`
				else
					i=$ROOT$i
				fi
			fi
			puthere=`
			    $find $i -name $filename -type f -print |
			    sed '2,$d'`
			if test -n "$puthere"; then
				if test -n "$IDB"; then	# put back a leading /
					puthere=/$puthere
				fi
				break
			fi
		done
	
		# look for $filename in $syslist
		if test -z "$puthere" -a -r $syslist; then
			puthere=`grep "/$filename\$" $syslist | sed '2,$d'`
			if test -z "$IDB" -a -n "$puthere"; then
				puthere=$ROOT$puthere
			fi
		fi
	
		# look for file in $srchdirs
		if test -z "$puthere" -a -n "$srchdirs"; then
			puthere=`
			    $find $srchdirs -name $filename -type f -print |
			    sed '2,$d'`
		fi
	
		# if we found where it goes, put it there
		if test -n "$puthere"; then
			if test -n "$IDB"; then
				rputhere=$ROOT/$puthere
				if test $forceowner = yes; then
					realowner=$owner
				else
					realowner=`
					    ls -l $rputhere 2>/dev/null |
					    awk '{print $3}'`
					if test -z "$realowner"; then
						realowner=$owner
					fi
				fi
				if stickyfile($rputhere) && notsticky($mode)
				then
					mode=1`expr $mode : '0*\([0-7]*\)'`
				fi
				putidbrec(f,$mode,$realowner,$group, \
					  $puthere,$srcpath)
				continue
			fi

			if stickyfile($puthere); then
				chmod -t $puthere
				if test -z "$HOSTENV"; then
					$puthere < /dev/null > /dev/null
				fi
				tbit=on
			else
				tbit=off
			fi

			if test -f $puthere -a $moveold != no; then
				saveold($owner,$group,`dirname $puthere`, \
					$filename,$moveold)
			fi
			foundit=yes

			if test "$put" != "cp"; then
				rm -f $puthere
			fi
			if $put $srcpath $puthere; then
				if test $tbit = on; then
					chmod +t $puthere
				fi
				$echo "$srcpath installed as $puthere"
				continue
			fi
			exit 2
		fi
	
		# not found anywhere; try $lastresort
		case $foundit in
		  yes)
			echo "$me: internal error: found a not-found target!"
			exit 2
			;;
		  no) 
			if test -n "$IDB"; then
	    			putidbrec(f,$mode,$owner,$group, \
					  $lastresort/$file,$srcpath)
				continue
			fi
	
			if isabspath($lastresort); then
				lastresort=$ROOT$lastresort
			fi
			puthere=$lastresort/$filename
			if putit($mode,$owner,$group,$puthere,$srcpath); then
				$echo \
				  "$srcpath installed as $puthere by default!"
			fi
			;;
		  dontknow)
			echo "$me: $filename was not found anywhere!"
			exit 2
			;;
		esac
		;;
	esac
done
exit $status
