static	char	*Init	= "@(#)init.c	1.19";
/*
 * global variable initializaton
 *
 * @(#)init.c	3.33 (Berkeley) 6/15/81
 * @(#)init.c	1.19 6/14/85
 *
 */

#include <ctype.h>
#include "rogue.h"

#ifndef	gl2
#define	NUMCHR	128		/* number of characters in font A */
#endif	gl2

bool	playing = TRUE, running = FALSE, wizard = FALSE;
bool	notify = TRUE, fight_flush = FALSE, terse = FALSE, door_stop = FALSE;
bool	jump = FALSE, slow_invent = FALSE, firstmove = FALSE, askme = FALSE;
bool	amulet = FALSE, in_shell = FALSE;
struct	linked_list *lvl_obj = NULL, *mlist = NULL;
struct	object	*cur_weapon = NULL;
int	mpos = 0, no_move = 0, no_command = 0, level = 1, purse = 0, inpack = 0;
int	total = 0, no_food = 0, count = 0, fung_hit = 0, quiet = 0;
int	food_left = HUNGERTIME, group = 1, hungry_state = 0;
int	lastscore = -1;
char	*plusstr = "+";
uchar	wallv = '|', wallh = '-';
uchar	wallur = '-', walllr = '-', wallul = '-', wallll = '-';
uchar	door = Door, floor = Floor, passage = Passage;
uchar	cursor = Cursor;
#ifdef	iris
char	*more = "-More-";
#else	iris
char	*more = "--More--";
#endif	iris
int	maxmsg;			/* max message length in pixels */

#ifdef	iris
#ifdef	gl2
int	regfont = 0;		/* regular font */
int	msgfont = 0;		/* font for messages (top line) */
#else	gl2
int	regfont = 0;		/* regular font */
int	msgfont = 2;		/* font for messages (top line) */
						/* define usual font	     */
short	n		= 0;			/* font number		     */
short	ht		= 16;			/* font height		     */
short	nc		= NUMCHR;		/* number of chars   in font */
short	nr		= (NUMCHR-32)*16+32*32;	/* number of rasters in font */
						/* define message line  font */
short	engl_n  = 2;			/* font number		     */
short	engl_ht = 41;			/* font height		     */
short	engl_nc = 128;			/* number of chars   in font */
short	engl_nr = 8159+112;		/* number of rasters in font */
#endif	gl2

int rgb_vals[][3] = {
		/* normally used colors */
/* red	green	blue */
{0,	0,	0},	/* black	*/
{255,	0,	0},	/* red		*/
{0,	255,	0},	/* green	*/
{255,	255,	0},	/* yellow	*/
{0,	0,	255},	/* blue		*/
{255,	0,	255},	/* magenta	*/
{0,	255,	255},	/* cyan		*/
{255,	255,	255},	/* white	*/
		/* bluish tint for scroll/wand of light */
{0,	0,	120+0},	/* black	*/
{255,	0,	150+0},	/* red		*/
{0,	255,	150+0},	/* green	*/
{255,	255,	150+0},	/* yellow	*/
{0,	0,	255},	/* blue		*/
{180,	0,	255},	/* magenta	*/
{0,	180,	255},	/* cyan		*/
{180,	180,	255},	/* white	*/
		/* all colors black */
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
{0,	0,	0},
};
#endif


#define ___ 1
#define _x {1,1}
struct	monster monsters[26] = {
	/* Name		 CARRY	FLAG    str, exp, lvl, amr, hpt, dmg */
	{ "giant ant",	 0,	ISMEAN,	{ _x, 10,   2,   3, ___, "1d6" } },
	{ "bat",	 0,	0,	{ _x,  1,   1,   3, ___, "1d2" } },
	{ "centaur",	 15,	0,	{ _x, 15,   4,   4, ___, "1d6/1d6" } },
	{ "dragon",	 100,	ISGREED,{ _x,9000, 10,  -1, ___, "1d8/1d8/3d10" } },
	{ "floating eye",0,	0,	{ _x,  5,   1,   9, ___, "0d0" } },
	{ "violet fungi",0,	ISMEAN,	{ _x, 85,   8,   3, ___, "000d0" } },
	{ "gnome",	 10,	0,	{ _x,  8,   1,   5, ___, "1d6" } },
	{ "hobgoblin",	 0,	ISMEAN,	{ _x,  3,   1,   5, ___, "1d8" } },
	{ "invisible stalker",0,ISINVIS,{ _x,120,   8,   3, ___, "4d4" } },
	{ "jackal",	 0,	ISMEAN,	{ _x,  2,   1,   7, ___, "1d2" } },
	{ "kobold",	 0,	ISMEAN,	{ _x,  1,   1,   7, ___, "1d4" } },
	{ "leprechaun",	 0,	0,	{ _x, 10,   3,   8, ___, "1d1" } },
	{ "mimic",	 30,	0,	{ _x,140,   7,   7, ___, "3d4" } },
	{ "nymph",	 100,	0,	{ _x, 40,   3,   9, ___, "0d0" } },
	{ "orc",	 15,	ISBLOCK,{ _x,  5,   1,   6, ___, "1d8" } },
	{ "purple worm", 70,	0,	{ _x,7000, 15,   6, ___, "2d12/2d4" } },
	{ "quasit",	 30,	ISMEAN,	{ _x, 35,   3,   2, ___, "1d2/1d2/1d4" } },
	{ "rust monster",0,	ISMEAN,	{ _x, 25,   5,   2, ___, "0d0/0d0" } },
	{ "snake",	 0,	ISMEAN,	{ _x,  3,   1,   5, ___, "1d3" } },
	{ "troll",	 50,	ISREGEN|ISMEAN,{ _x, 55,   6,   4, ___, "1d8/1d8/2d6" } },
	{ "umber hulk",	 40,	ISMEAN,	{ _x,130,   8,   2, ___, "3d4/3d4/2d5" } },
	{ "vampire",	 20,	ISREGEN|ISMEAN,{ _x,380,   8,   1, ___, "1d10" } },
	{ "wraith",	 0,	0,	{ _x, 55,   5,   4, ___, "1d6" } },
	{ "xorn",	 0,	ISMEAN,	{ _x,120,   7,  -2, ___, "1d3/1d3/1d3/4d6" } },
	{ "yeti",	 30,	0,	{ _x, 50,   4,   6, ___, "1d6/1d6" } },
	{ "zombie",	 0,	ISMEAN,	{ _x,  7,   2,   8, ___, "1d8" } }
};
#undef ___

/*
 * init_player:
 *	roll up the rogue
 */

init_player()
{
    pstats.s_lvl = 1;
    pstats.s_exp = 0L;
    max_hp = pstats.s_hpt = 12;
    if (rnd(100) == 7) {
	pstats.s_str.st_str = 18;
	pstats.s_str.st_add = rnd(100) + 1;
    } else {
	pstats.s_str.st_str = 16;
	pstats.s_str.st_add = 0;
    }
    pstats.s_dmg = "1d4";
    pstats.s_arm = 10;
    max_stats = pstats;
    pack = NULL;
}

/*
 * Contains defintions and functions for dealing with things like
 * potions and scrolls
 */

static	char	*rainbow[] = {
    "Red",
    "Blue",
    "Green",
    "Yellow",
    "Black",
    "Brown",
    "Orange",
    "Pink",
    "Purple",
    "Grey",
    "White",
    "Silver",
    "Gold",
    "Violet",
    "Clear",
    "Vermilion",
    "Ecru",
    "Turquoise",
    "Magenta",
    "Amber",
    "Topaz",
    "Plaid",
    "Tan",
    "Tangerine"
};

#define NCOLORS (sizeof rainbow / sizeof (char	*))

static	char	*sylls[] = {
    "a", "ab", "ag", "aks", "ala", "an", "ankh", "app", "arg", "arze",
    "ash", "ban", "bar", "bat", "bek", "bie", "bin", "bit", "bjor",
    "blu", "bot", "bu", "byt", "comp", "con", "cos", "cre", "dalf",
    "dan", "den", "do", "e", "eep", "el", "eng", "er", "ere", "erk",
    "esh", "evs", "fa", "fid", "for", "fri", "fu", "gan", "gar",
    "glen", "gop", "gre", "ha", "he", "hyd", "i", "ing", "ion", "ip",
    "ish", "it", "ite", "iv", "jo", "kho", "kli", "klis", "la", "lech",
    "man", "mar", "me", "mi", "mic", "mik", "mon", "mung", "mur",
    "nej", "nelg", "nep", "ner", "nes", "nes", "nih", "nin", "o", "od",
    "ood", "org", "orn", "ox", "oxy", "pay", "pet", "ple", "plu", "po",
    "pot", "prok", "re", "rea", "rhov", "ri", "ro", "rog", "rok", "rol",
    "sa", "san", "sat", "see", "sef", "seh", "shu", "ski", "sna",
    "sne", "snik", "sno", "so", "sol", "sri", "sta", "sun", "ta",
    "tab", "tem", "ther", "ti", "tox", "trol", "tue", "turs", "u",
    "ulk", "um", "un", "uni", "ur", "val", "viv", "vly", "vom", "wah",
    "wed", "werg", "wex", "whon", "wun", "xo", "y", "yot", "yu",
    "zant", "zap", "zeb", "zim", "zok", "zon", "zum",
};

static	char	*rings[] = {
    "Agate",
    "Alexandrite",
    "Amethyst",
    "Carnelian",
    "Diamond",
    "Emerald",
    "Granite",
    "Jade",
    "Kryptonite",
    "Lapus lazuli",
    "Moonstone",
    "Obsidian",
    "Onyx",
    "Opal",
    "Pearl",
    "Ruby",
    "Saphire",
    "Tiger eye",
    "Topaz",
    "Turquoise",
};

#define NRINGS (sizeof rings / sizeof (char	*))

static	char	*wood[] = {
    "Avocado wood",
    "Balsa",
    "Banyan",
    "Birch",
    "Cedar",
    "Cherry",
    "Cinnibar",
    "Driftwood",
    "Ebony",
    "Eucalyptus",
    "Hemlock",
    "Ironwood",
    "Mahogany",
    "Manzanita",
    "Maple",
    "Oak",
    "Persimmon wood",
    "Redwood",
    "Rosewood",
    "Teak",
    "Walnut",
    "Zebra wood",
};

#define NWOOD (sizeof wood / sizeof (char	*))

static	char	*metal[] = {
    "Aluminium",
    "Bone",
    "Brass",
    "Bronze",
    "Copper",
    "Iron",
    "Lead",
    "Pewter",
    "Steel",
    "Tin",
    "Zinc",
};

#define NMETAL (sizeof metal / sizeof (char	*))

struct	magic_item things[NUMTHINGS] = {
    { 0,			27 },	/* potion */
    { 0,			27 },	/* scroll */
    { 0,			18 },	/* food */
    { 0,			 9 },	/* weapon */
    { 0,			 9 },	/* armor */
    { 0,			 5 },	/* ring */
    { 0,			 5 },	/* stick */
};

struct	magic_item s_magic[MAXSCROLLS] = {
    { "monster confusion",	 8, 170 },
    { "magic mapping",		 5, 180 },
    { "light",			10, 100 },
    { "hold monster",		 2, 200 },
    { "sleep",			 5,  50 },
    { "enchant armor",		 8, 130 },
    { "identify",		21, 100 },
    { "scare monster",		 4, 180 },
    { "gold detection",		 4, 110 },
    { "teleportation",		 7, 175 },
    { "enchant weapon",		10, 150 },
    { "create monster",		 5,  75 },
    { "remove curse",		 8, 105 },
    { "aggravate monsters",	 1,  60 },
    { "blank paper",		 1,  50 },
    { "genocide",		 1, 200 },
};

struct	magic_item p_magic[MAXPOTIONS] = {
    { "confusion",		 8,  50 },
    { "paralysis",		10,  50 },
    { "poison",			 8,  50 },
    { "gain strength",		15, 150 },
    { "see invisible",		 2, 170 },
    { "healing",		15, 130 },
    { "monster detection",	 6, 120 },
    { "magic detection",	 6, 105 },
    { "raise level",		 2, 220 },
    { "extra healing",		 5, 180 },
    { "haste self",		 4, 200 },
    { "restore strength",	14, 120 },
    { "blindness",		 4,  50 },
    { "thirst quenching",	 1,  50 },
};

struct	magic_item r_magic[MAXRINGS] = {
    { "protection",		 9, 200 },
    { "add strength",		 9, 200 },
    { "sustain strength",	 5, 180 },
    { "searching",		10, 200 },
    { "see invisible",		10, 175 },
    { "adornment",		 1, 100 },
    { "aggravate monster",	11, 100 },
    { "dexterity",		 8, 220 },
    { "increase damage",	 8, 220 },
    { "regeneration",		 4, 260 },
    { "slow digestion",		 9, 240 },
    { "telportation",		 9, 100 },
    { "stealth",		 7, 100 },
};

struct	magic_item W_magic[MAXWANDS] = {
    { "light",			12, 120 },
    { "striking",		 9, 115 },
    { "lightning",		 3, 200 },
    { "fire",			 3, 200 },
    { "cold",			 3, 200 },
    { "polymorph",		15, 210 },
    { "magic missile",		10, 170 },
    { "haste monster",		 9,  50 },
    { "slow monster",		11, 220 },
    { "drain life",		 9, 210 },
    { "nothing",		 1,  70 },
    { "teleport away",		 5, 140 },
    { "teleport to",		 5,  60 },
    { "cancellation",		 5, 130 },
};

int	a_class[MAXARMORS] = {
    8,
    7,
    7,
    6,
    5,
    4,
    4,
    3,
};

char	*a_names[MAXARMORS] = {
    "leather armor",
    "ring mail",
    "studded leather armor",
    "scale mail",
    "chain mail",
    "splint mail",
    "banded mail",
    "plate mail",
};

int	a_chances[MAXARMORS] = {
    20,
    35,
    50,
    63,
    75,
    85,
    95,
    100
};

/*
 * init_things
 *	Initialize the probabilities for types of things
 */
init_things()
{
    reg1 rega1	struct	magic_item *mp;

    for (mp = &things[1]; mp < &things[NUMTHINGS]; mp++)
	mp->mi_prob += (mp-1)->mi_prob;
    badcheck("things", things, NUMTHINGS);
}

/*
 * init_colors:
 *	Initialize the potion color scheme for this time
 */

init_colors()
{
    reg1 regd1	int	i;
    reg2 rega1	char	*str;
#ifdef	COLOR
    reg3 regd2	int	j;
    static	struct	{
	int	*C_ptr;
	char	*C_name;
    } C_map[] = {
	&C_black,"black",
	&C_white,"white",
	&C_red,"red",
	&C_yellow,"gold",	/* use gold if yellow not available */
	&C_yellow,"yellow",
	&C_gold,"yellow",	/* use yellow if gold not available */
	&C_gold,"gold",
	&C_blue,"blue",
	&C_green,"green",
	&C_cyan,"turquoise",
	&C_cyan,"cyan",
	&C_magenta,"purple",
	&C_magenta,"violet",
	&C_magenta,"magenta",
	0,0
    };
#endif

#ifdef	COLOR
    for (i=0; i<Ncolors; i++) {
	str = Colors[i];
	*str = toupper(*str);
	while (*++str)
		*str = tolower(*str);
	for (j=0; j<NCOLORS; j++)
		if (!strcmp(Colors[i],rainbow[j]))
			rainbow[j][0] = tolower(rainbow[j][0]);
    }
#endif
    for (i = 0; i < MAXPOTIONS; i++) {
#ifdef	COLOR
	p_Colors[i] = Dforeground;	/* no actual color yet */
#endif
	do {
#ifdef	COLOR
	    j = rnd(Ncolors+NCOLORS);
	    if (j<Ncolors) {
	        str = Colors[j];
		p_Colors[i] = j;	/* remember color for color CRTs */
	    } else
	        str = rainbow[j-Ncolors];
#else
	    str = rainbow[rnd(NCOLORS)];
#endif
	} until (isupper(*str));
	*str = tolower(*str);
	p_colors[i] = str;
	p_know[i] = FALSE;
	p_guess[i] = NULL;
	if (i > 0)
	    p_magic[i].mi_prob += p_magic[i-1].mi_prob;
    }
    badcheck("potions", p_magic, MAXPOTIONS);
#ifdef	COLOR
    for (i=0; i<Ncolors; i++)
	Colors[i][0] = tolower(Colors[i][0]);
    i = (-1);
	/*
	 * First initialize all colors to default foreground color.
	 * Then try to find each color. This way we can try to approximate
	 * each color, e.g. yellow for gold.
	 */
    while (C_map[++i].C_ptr)
	*C_map[i].C_ptr = Dforeground;
    i = (-1);
    while (C_map[++i].C_ptr)
	for (j=0; j<Ncolors; j++)
	    if (!strcmp(C_map[i].C_name,Colors[j])) {
		*C_map[i].C_ptr = j;
		break;
	    }
#endif
}

/*
 * init_names:
 *	Generate the names of the various scrolls
 */

init_names()
{
    reg1 regd1	int	nsyl;
    reg2 rega1	char	*cp;
    reg3 rega2	char	*sp;
    reg4 regd2	int	i;
    reg5 regd3	int	nwords;

    for (i = 0; i < MAXSCROLLS; i++) {
	cp = prbuf;
	nwords = rnd(4)+2;
	while (nwords--) {
	    nsyl = rnd(3)+1;
	    while (nsyl--) {
		sp = sylls[rnd((sizeof sylls) / (sizeof (char	*)))];
		while (*sp)
		    *cp++ = *sp++;
	    }
	    *cp++ = ' ';
	}
	*--cp = '\0';
	s_names[i] = (char	*) new(strlen(prbuf)+1);
	s_know[i] = FALSE;
	s_guess[i] = NULL;
	strcpy(s_names[i], prbuf);
	if (i > 0)
		s_magic[i].mi_prob += s_magic[i-1].mi_prob;
    }
    badcheck("scrolls", s_magic, MAXSCROLLS);
}

/*
 * init_rings:
 *	Initialize the ring stone setting scheme for this time
 */

init_rings()
{
    reg1 regd1	int	i;
    reg2 rega1	char	*str;

    for (i = 0; i < MAXRINGS; i++) {
	do
	    str = rings[rnd(NRINGS)];
	until (isupper(*str));
	*str = tolower(*str);
	r_rings[i] = str;
	r_know[i] = FALSE;
	r_guess[i] = NULL;
	if (i > 0)
	    r_magic[i].mi_prob += r_magic[i-1].mi_prob;
    }
    badcheck("rings", r_magic, MAXRINGS);
}

/*
 * init_materials:
 *	Initialize the construction materials for wands and staffs
 */

init_materials()
{
    reg1 regd1	int	i;
    reg2 rega1	char	*str;

    for (i = 0; i < MAXWANDS; i++) {
	do
	    if (rnd(100) > 50) {
		str = metal[rnd(NMETAL)];
		if (isupper(*str))
			W_type[i] = "wand";
	    } else {
		str = wood[rnd(NWOOD)];
		if (isupper(*str))
			W_type[i] = "staff";
	    }
	until (isupper(*str));
	*str = tolower(*str);
	W_made[i] = str;
	W_know[i] = FALSE;
	W_guess[i] = NULL;
	if (i > 0)
		W_magic[i].mi_prob += W_magic[i-1].mi_prob;
    }
    badcheck("sticks", W_magic, MAXWANDS);
}

badcheck(name, magic, bound)
char	*name;
reg1 rega1	struct	magic_item *magic;
reg2 regd1	int	bound;
{
    reg3 rega2	struct	magic_item *end;

    if (magic[bound - 1].mi_prob == 100)
	return;
    printf("\nBad percentages for %s:\n", name);
    for (end = &magic[bound]; magic < end; magic++)
	printf("%3d%% %s\n", magic->mi_prob, magic->mi_name);
    printf("[hit RETURN to continue]");
    fflush(stdout);
    while (getchar() != '\n')
	continue;
}

struct	h_list helpstr[] = {
    '?',	"	prints help",
    '/',	"	identify object",
    'h',	"	left",
    'j',	"	down",
    'k',	"	up",
    'l',	"	right",
    'y',	"	up & left",
    'u',	"	up & right",
    'b',	"	down & left",
    'n',	"	down & right",
    'H',	"	run left",
    'J',	"	run down",
    'K',	"	run up",
    'L',	"	run right",
    'Y',	"	run up & left",
    'U',	"	run up & right",
    'B',	"	run down & left",
    'N',	"	run down & right",
    't',	"<dir>	throw something",
    'f',	"<dir>	forward until find something",
    'p',	"<dir>	zap wand in direction",
    'z',	"	zap wand or staff",
    '>',	"	go down a staircase",
    's',	"	search for trap/secret door",
    REST,	"	rest for a while",
    'i',	"	inventory",
    'I',	"	inventory single item",
    'q',	"	quaff potion",
    'r',	"	read paper",
    'e',	"	eat food",
    'w',	"	wield a weapon",
    'W',	"	wear armor",
    'T',	"	take armor off",
    'd',	"	drop object",
    'c',	"	call object",
    'P',	"	put on ring",
    'R',	"	remove ring",
    'o',	"	examine/set options",
    CTRL(R),	"	redraw screen",
    'v',	"	print program version number",
    CTRL(P),	"	repeat previous message",
    '!',	"	shell escape",
    'S',	"	save game",
    'Q',	"	quit",
    '+',	"	wizardry",
    0, 0
};

struct	h_list wizhelp[] = {
    '@',	"	position",
    'C',	"	create object",
    '+',	"	wizard switch",
    CTRL(I),	"	inventory",
    CTRL(W),	"	what is",
    CTRL(D),	"	descend to new level",
    CTRL(F),	"	show standard window",
    CTRL(X),	"	show monster window",
    CTRL(M),	"	memory usage",
#ifdef WIZD
    'D',	"	display fuses and daemons",
#endif
    0, 0
};

/*
 * init_vwalls:
 *	Generate the walls, allowing for graphics
 */

init_vwalls()
{
#ifdef	Curses
#ifdef	iris
#ifdef	gl2
    cursor=CTRL(A);	/* a block (undocumented) */
#else	gl2
    if (_iris) {
	    wallh=CTRL(A);
	    wallv=CTRL(B);
	    wallur=CTRL(C);
	    walllr=CTRL(D);
	    wallul=CTRL(E);
	    wallll=CTRL(F);
	    passage=CTRL(G);
	    door=CTRL(K);
	    floor=CTRL(L);
	    cursor=0177;
    }
    else
#endif	gl2
#endif	iris
    {
	if (_mapchr[CTRL(A)])
	    wallh=CTRL(A);
	if (_mapchr[CTRL(B)])
	    wallv=CTRL(B);
	if (_mapchr[CTRL(C)])
	    wallur=CTRL(C);
	if (_mapchr[CTRL(D)])
	    walllr=CTRL(D);
	if (_mapchr[CTRL(E)])
	    wallul=CTRL(E);
	if (_mapchr[CTRL(F)])
	    wallll=CTRL(F);
	if (_mapchr[CTRL(K)])
	    door=CTRL(K);
	if (_mapchr[CTRL(L)])
	    floor=CTRL(L);
    }
#endif	Curses
}

/*
 * init_termcap:
 *	Set up termcap things not handled by curses
 */

init_termcap()
{
#ifdef	Curses
    if (CF)
        printf("%s",CF);		/* make cursor invisible	*/
#endif	Curses
}

init_graph()
{
#ifdef	COLOR
#ifdef	iris
		int	i;
	static	char	pstr[2];

	if (_iris) {
#ifdef	gl2
		_linblit[0] = YMAXSCREEN+1;
		_linblit[1] = _linblit[0] - CHEIGHT - 8 - 3; /* 3 needed */
		for (i=2; i<49; i++)
			_linblit[i] = _linblit[i-1]-CHEIGHT;
#else	gl2
		init_fontA();		/* Helvetica + line drawing */
		init_fontB();		/* Old English for messages */
					/*
					 * adjust Y addresses of lines for tall
					 * Old English on top line
					 */
		_linblit[0] = YMAXSCREEN+1;
		_linblit[1] = _linblit[0]-engl_ht /* + 8 */;
					/* 8 for Old Eng descenders */
		_linblit[2] = _linblit[1] - CHEIGHT - 8 - 3; /* 3 needed */
		for (i=3; i<49; i++)
			_linblit[i] = _linblit[i-1]-CHEIGHT;
		_linfont[0] = msgfont;	/* top line is msg font (Old English) */
		_linvs[0] = 1;		/* Old English is variable spaces */
		_linfont[1] = regfont;	/* other lines are reg font */
		_nowfont = msgfont;
		font(_nowfont);
#endif	gl2
		pstr[0] = cursor;
		maxmsg = XMAXSCREEN + 1 - strwidth(more) - strwidth(pstr);
		set_colors();
	} else
#endif
#endif
		maxmsg = COLS - strlen(more) - 1;	/* 1 column = cursor */
}

#ifdef	iris

set_colors()
{
    int i;

    for (i = sizeof rgb_vals / sizeof *rgb_vals - 1; i >= 0; i--)
	mapcolor((Colorindex)i,(RGBvalue)rgb_vals[i][0],
	  (RGBvalue)rgb_vals[i][1],(RGBvalue)rgb_vals[i][2]);
}

#ifndef	gl2

Fontchar chars[NUMCHR];

unsigned char	fontA[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^A long dash (entire width) */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xff,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^B long vertical bar (entire height) */
0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
/* ^C upper right corner */
0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^D lower right corner */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf8,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
/* ^E upper left corner */
0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
0x0f,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^F lower left corner */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0f,0x80,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,0x08,0x00,
/* ^G passage */
0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,
0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,0xff,0x80,
/* ^H unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^I unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^J unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^K door */
0x08,0x00,0x08,0x00,0x1c,0x00,0x1c,0x00,0x3e,0x00,0x3e,0x00,0x7f,0x00,0xff,0x80,
0xff,0x80,0x7f,0x00,0x3e,0x00,0x3e,0x00,0x1c,0x00,0x1c,0x00,0x08,0x00,0x08,0x00,
/* ^L floor */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^M unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^N unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^O unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^P unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^Q unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^R unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^S unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^T unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^U unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^V unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^W unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^X unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^Y unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ^Z unused */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* space */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ! */
0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x00,
/* " */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x22,0x22,0x77,0x77,0x77,0x00,0x00,
/* # */
0x00,0x00,0x00,0x00,0x48,0x48,0x48,0xff,0x24,0x24,0x24,0xff,0x12,0x12,0x12,0x00,
/* $ */
0x00,0x00,0x00,0x08,0x3c,0x6a,0x6a,0x0a,0x0e,0x3c,0x78,0x68,0x49,0x4b,0x3d,0x08,
/* % */
0x00,0x00,0x00,0x00,0x46,0x2d,0x2d,0x1d,0x16,0x08,0x68,0xd4,0xd4,0xde,0x62,0x00,
/* & */
0x00,0x00,0x00,0x31,0x4a,0xcc,0xcc,0x4a,0x3b,0x18,0x34,0x32,0x32,0x3c,0x18,0x00,
/* ' */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x18,0x18,0x00,
/* ( */
0x00,0x00,0x00,0x00,0x02,0x04,0x08,0x18,0x18,0x18,0x18,0x18,0x08,0x04,0x02,0x00,
/* ) */
0x00,0x00,0x00,0x00,0x40,0x20,0x10,0x18,0x18,0x18,0x18,0x18,0x10,0x20,0x40,0x00,
/* * */
0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x54,0x38,0xfe,0x38,0x54,0x10,0x00,0x00,0x00,
/* + */
0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x7f,0x08,0x08,0x08,0x00,0x00,0x00,0x00,
/* , */
0x00,0x20,0x10,0x18,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* - */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* . */
0x00,0x00,0x00,0x10,0x38,0x38,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* / */
0x00,0x00,0x00,0x00,0x40,0x20,0x20,0x10,0x10,0x08,0x08,0x04,0x04,0x02,0x02,0x00,
/* 0 */
0x00,0x00,0x00,0x00,0x18,0x3c,0x24,0x66,0x66,0x66,0x66,0x66,0x24,0x3c,0x18,0x00,
/* 1 */
0x00,0x00,0x00,0x00,0x7e,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x78,0x18,0x08,
/* 2 */
0x00,0x00,0x00,0x00,0x7e,0x7e,0x22,0x10,0x08,0x04,0x06,0x66,0x66,0x24,0x38,0x00,
/* 3 */
0x00,0x00,0x00,0x00,0x38,0x44,0x66,0x66,0x04,0x18,0x0c,0x66,0x66,0x44,0x38,0x00,
/* 4 */
0x00,0x00,0x00,0x00,0x1e,0x0c,0x0c,0xfe,0x4c,0x4c,0x2c,0x1c,0x0c,0x0c,0x04,0x00,
/* 5 */
0x00,0x00,0x00,0x00,0x38,0x64,0x66,0x06,0x06,0x24,0x38,0x20,0x20,0x3c,0x3e,0x00,
/* 6 */
0x00,0x00,0x00,0x00,0x38,0x74,0x66,0x66,0x66,0x74,0x78,0x60,0x76,0x36,0x1c,0x00,
/* 7 */
0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x18,0x08,0x08,0x08,0x44,0x7c,0x7e,0x00,
/* 8 */
0x00,0x00,0x00,0x00,0x38,0x44,0x46,0x46,0x2e,0x1c,0x34,0x62,0x62,0x62,0x3c,0x00,
/* 9 */
0x00,0x00,0x00,0x00,0x38,0x6c,0x46,0x1e,0x3e,0x66,0x66,0x66,0x66,0x2c,0x18,0x00,
/* : */
0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,
/* ; */
0x00,0x00,0x10,0x08,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,
/* < */
0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x04,0x00,0x00,
/* = */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x00,0x7f,0x00,0x00,0x00,0x00,0x00,
/* > */
0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x20,0x00,0x00,
/* ? */
0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x18,0x08,0x04,0x66,0x66,0x3c,0x00,
/* @ */
0x00,0x00,0x00,0x00,0x1c,0x22,0x40,0x4d,0x53,0x53,0x4f,0x42,0x24,0x18,0x00,0x00,
/* A */
0x00,0x00,0x00,0x00,0xef,0x46,0x46,0x2c,0x3c,0x2c,0x2c,0x18,0x18,0x18,0x18,0x00,
/* B */
0x00,0x00,0x00,0x00,0xfe,0x63,0x63,0x63,0x62,0x7c,0x66,0x66,0x66,0x66,0xfc,0x00,
/* C */
0x00,0x00,0x00,0x00,0x18,0x34,0x22,0x62,0x60,0x60,0x60,0x62,0x22,0x36,0x1a,0x00,
/* D */
0x00,0x00,0x00,0x00,0xf8,0x64,0x66,0x63,0x63,0x63,0x63,0x63,0x66,0x64,0xf8,0x00,
/* E */
0x00,0x00,0x00,0x00,0xfe,0x62,0x60,0x60,0x68,0x78,0x68,0x60,0x60,0x62,0xfe,0x00,
/* F */
0x00,0x00,0x00,0x00,0xf0,0x60,0x60,0x60,0x68,0x78,0x68,0x60,0x60,0x62,0xfe,0x00,
/* G */
0x00,0x00,0x00,0x00,0x1a,0x36,0x26,0x66,0x6f,0x60,0x60,0x62,0x22,0x36,0x1a,0x00,
/* H */
0x00,0x00,0x00,0x00,0xff,0x66,0x66,0x66,0x66,0x7e,0x66,0x66,0x66,0x66,0xff,0x00,
/* I */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x3c,0x00,
/* J */
0x00,0x00,0x00,0x00,0x38,0x6c,0x6c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,
/* K */
0x00,0x00,0x00,0x00,0xff,0x66,0x6c,0x6c,0x78,0x78,0x78,0x70,0x68,0x64,0xf7,0x00,
/* L */
0x00,0x00,0x00,0x00,0xfe,0x62,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0x60,0xf0,0x00,
/* M */
0x00,0x00,0x00,0x00,0xe7,0x42,0x5a,0x5a,0x5a,0x66,0x66,0x66,0x66,0x42,0x42,0x00,
/* N */
0x00,0x00,0x00,0x00,0xe2,0x42,0x46,0x46,0x4e,0x4e,0x5a,0x5a,0x72,0x72,0xe7,0x00,
/* O */
0x00,0x00,0x00,0x00,0x3c,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x3c,0x00,
/* P */
0x00,0x00,0x00,0x00,0xf0,0x60,0x60,0x60,0x60,0x7c,0x66,0x66,0x66,0x66,0xfc,0x00,
/* Q */
0x00,0x00,0x00,0x07,0x3f,0x6e,0x6e,0x66,0x66,0x66,0x66,0x66,0x66,0x66,0x3c,0x00,
/* R */
0x00,0x00,0x00,0x00,0xf3,0x67,0x6c,0x6c,0x68,0x78,0x64,0x66,0x66,0x64,0xf8,0x00,
/* S */
0x00,0x00,0x00,0x00,0x5c,0x66,0x42,0x06,0x0e,0x3c,0x78,0x60,0x42,0x46,0x3a,0x00,
/* T */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x5a,0x7e,0x7e,0x00,
/* U */
0x00,0x00,0x00,0x00,0x18,0x34,0x62,0x62,0x62,0x62,0x62,0x62,0x62,0x62,0xf7,0x00,
/* V */
0x00,0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x1c,0x34,0x34,0x34,0x62,0x62,0xf7,0x00,
/* W */
0x00,0x00,0x00,0x00,0x42,0x42,0x66,0x66,0x66,0x7e,0x5a,0x5a,0x42,0x42,0xe7,0x00,
/* X */
0x00,0x00,0x00,0x00,0xef,0x46,0x2c,0x1c,0x18,0x18,0x18,0x38,0x34,0x62,0xf7,0x00,
/* Y */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x34,0x34,0x62,0xf7,0x00,
/* Z */
0x00,0x00,0x00,0x00,0x7e,0x62,0x30,0x30,0x18,0x18,0x18,0x0c,0x0c,0x46,0x7e,0x00,
/* [ */
0x00,0x00,0x00,0x00,0x1e,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x1e,0x00,
/* \ */
0x00,0x00,0x00,0x00,0x02,0x04,0x04,0x08,0x08,0x10,0x10,0x20,0x20,0x40,0x40,0x00,
/* ] */
0x00,0x00,0x00,0x00,0x78,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x78,0x00,
/* ^ */
0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x49,0x2a,0x1c,0x08,0x08,0x00,
/* _ */
0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
/* ` */
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x10,0x08,0x00,
/* a */
0x00,0x00,0x00,0x00,0x3b,0x67,0x67,0x36,0x1e,0x06,0x66,0x7c,0x00,0x00,0x00,0x00,
/* b */
0x00,0x00,0x00,0x00,0x58,0x64,0x66,0x66,0x66,0x66,0x64,0x78,0x60,0x60,0xe0,0x00,
/* c */
0x00,0x00,0x00,0x00,0x1c,0x32,0x60,0x60,0x60,0x60,0x36,0x1e,0x00,0x00,0x00,0x00,
/* d */
0x00,0x00,0x00,0x00,0x1f,0x26,0x66,0x66,0x66,0x66,0x26,0x1e,0x06,0x06,0x0e,0x00,
/* e */
0x00,0x00,0x00,0x00,0x1e,0x31,0x60,0x60,0x7f,0x63,0x32,0x1c,0x00,0x00,0x00,0x00,
/* f */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x7e,0x19,0x19,0x0e,0x00,
/* g */
0x00,0x3c,0x66,0x06,0x1e,0x26,0x66,0x66,0x66,0x66,0x26,0x1e,0x00,0x00,0x00,0x00,
/* h */
0x00,0x00,0x00,0x00,0xff,0x66,0x66,0x66,0x66,0x66,0x66,0x7c,0x60,0x60,0xe0,0x00,
/* i */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x38,0x00,0x18,0x18,0x00,
/* j */
0x00,0x78,0x6c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x1c,0x00,0x0c,0x0c,0x00,
/* k */
0x00,0x00,0x00,0x00,0xff,0x6c,0x6c,0x78,0x78,0x70,0x68,0x6e,0x60,0x60,0xe0,0x00,
/* l */
0x00,0x00,0x00,0x00,0x3c,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x38,0x00,0x00,
/* m */
0x00,0x00,0x00,0x00,0xf7,0x63,0x63,0x6b,0x6b,0x6b,0x77,0xe6,0x00,0x00,0x00,0x00,
/* n */
0x00,0x00,0x00,0x00,0xff,0x66,0x66,0x66,0x66,0x66,0x66,0xfc,0x00,0x00,0x00,0x00,
/* o */
0x00,0x00,0x00,0x00,0x18,0x24,0x66,0x66,0x66,0x66,0x24,0x18,0x00,0x00,0x00,0x00,
/* p */
0x00,0xf0,0x60,0x60,0x78,0x64,0x66,0x66,0x66,0x66,0x64,0xf8,0x00,0x00,0x00,0x00,
/* q */
0x00,0x07,0x03,0x03,0x1f,0x23,0x63,0x63,0x63,0x63,0x23,0x1d,0x00,0x00,0x00,0x00,
/* r */
0x00,0x00,0x00,0x00,0x78,0x30,0x30,0x30,0x30,0x30,0x36,0x7c,0x00,0x00,0x00,0x00,
/* s */
0x00,0x00,0x00,0x00,0x5e,0x61,0x43,0x1e,0x3c,0x60,0x42,0x3e,0x00,0x00,0x00,0x00,
/* t */
0x00,0x00,0x00,0x00,0x1c,0x32,0x32,0x32,0x30,0x30,0x30,0xfe,0x10,0x10,0x00,0x00,
/* u */
0x00,0x00,0x00,0x00,0x3f,0x66,0x66,0x66,0x66,0x66,0x66,0xee,0x00,0x00,0x00,0x00,
/* v */
0x00,0x00,0x00,0x00,0x08,0x18,0x34,0x34,0x34,0x62,0x62,0xf7,0x00,0x00,0x00,0x00,
/* w */
0x00,0x00,0x00,0x00,0x63,0x77,0x7f,0x6b,0x6b,0x63,0x63,0x63,0x00,0x00,0x00,0x00,
/* x */
0x00,0x00,0x00,0x00,0xf7,0x26,0x1c,0x18,0x18,0x38,0x34,0xf7,0x00,0x00,0x00,0x00,
/* y */
0x00,0x60,0x60,0x10,0x10,0x10,0x08,0x18,0x34,0x22,0x66,0xef,0x00,0x00,0x00,0x00,
/* z */
0x00,0x00,0x00,0x00,0x7e,0x32,0x30,0x18,0x18,0x0c,0x4c,0x7e,0x00,0x00,0x00,0x00,
/* { */
0x00,0x00,0x00,0x00,0x0f,0x18,0x18,0x18,0x18,0x70,0x18,0x18,0x18,0x18,0x0f,0x00,
/* | */
0x00,0x00,0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,
/* } */
0x00,0x00,0x00,0x00,0xf0,0x18,0x18,0x18,0x18,0x0e,0x18,0x18,0x18,0x18,0xf0,0x00,
/* ~ */
0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x09,0x91,0x90,0x50,0x60,0x00,0x00,0x00,0x00,
/* DEL (\177) used for cursor */
0xff,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0x81,0xff,
};
/* old passage way */
/* 0xf5,0xaa,0x55,0xaa,0x57,0xea,0x55,0xaa,0x55,0xae,0x55,0xaa,0x75,0xaa,0x55,0xea, */

Fontchar engl_font[] = {
/*	offset	w	h	xoff	yoff	width	*/
/*^@ */	0,	0,	0,	0,	0,	0,
/*^A */	0,	0,	0,	0,	0,	0,
/*^B */	0,	0,	0,	0,	0,	0,
/*^C */	0,	0,	0,	0,	0,	0,
/*^D */	0,	0,	0,	0,	0,	0,
/*^E */	0,	0,	0,	0,	0,	0,
/*^F */	0,	0,	0,	0,	0,	0,
/*^G */	0,	0,	0,	0,	0,	0,
/*^H */	0,	0,	0,	0,	0,	0,
/*^I */	0,	0,	0,	0,	0,	0,
/*^J */	0,	0,	0,	0,	0,	0,
/*^K */	0,	0,	0,	0,	0,	0,
/*^L */	0,	0,	0,	0,	0,	0,
/*^M */	0,	0,	0,	0,	0,	0,
/*^N */	0,	0,	0,	0,	0,	0,
/*^O */	0,	0,	0,	0,	0,	0,
/*^P */	0,	0,	0,	0,	0,	0,
/*^Q */	0,	0,	0,	0,	0,	0,
/*^R */	0,	0,	0,	0,	0,	0,
/*^S */	0,	0,	0,	0,	0,	0,
/*^T */	0,	0,	0,	0,	0,	0,
/*^U */	0,	0,	0,	0,	0,	0,
/*^V */	0,	0,	0,	0,	0,	0,
/*^W */	0,	0,	0,	0,	0,	0,
/*^X */	0,	0,	0,	0,	0,	0,
/*^Y */	0,	0,	0,	0,	0,	0,
/*^Z */	0,	0,	0,	0,	0,	0,
/*^[ */	0,	0,	0,	0,	0,	0,
/*^\ */	0,	0,	0,	0,	0,	0,
/*^] */	0,	0,	0,	0,	0,	0,
/*^^ */	0,	0,	0,	0,	0,	0,
/*^_ */	0,	0,	0,	0,	0,	0,
/*   */	0,	1,	1,	0,	0,	26,
/* ! */	1,	0,	0,	0,	0,	0,
/* " */	1,	0,	0,	0,	0,	0,
/* # */	1,	0,	0,	0,	0,	0,
/* $ */	1,	0,	0,	0,	0,	0,
/* % */	1,	0,	0,	0,	0,	0,
/* & */	1,	0,	0,	0,	0,	0,
/* ' */	1,	7,	8,	0,	23,	11,
/* ( */	9,	11,	35,	0,	0,	15,
/* ) */	79,	11,	35,	0,	0,	15,
/* * */	149,	0,	0,	0,	0,	0,
/* + */	149,	0,	0,	0,	0,	0,
/* , */	149,	9,	10,	0,	-4,	14,
/* - */	169,	15,	5,	0,	9,	19,
/* . */	179,	9,	7,	0,	-1,	14,
/* / */	193,	0,	0,	0,	0,	0,
/* 0 */	193,	26,	29,	0,	1,	29,
/* 1 */	309,	18,	30,	0,	1,	21,
/* 2 */	399,	23,	30,	0,	1,	26,
/* 3 */	489,	25,	30,	0,	1,	28,
/* 4 */	609,	24,	27,	0,	1,	27,
/* 5 */	690,	24,	30,	0,	1,	27,
/* 6 */	780,	26,	29,	0,	1,	29,
/* 7 */	896,	23,	29,	0,	1,	26,
/* 8 */	983,	26,	29,	0,	1,	29,
/* 9 */	1099,	26,	28,	0,	1,	29,
/* : */	1211,	0,	0,	0,	0,	0,
/* ; */	1211,	0,	0,	0,	0,	0,
/* < */	1211,	0,	0,	0,	0,	0,
/* = */	1211,	0,	0,	0,	0,	0,
/* > */	1211,	0,	0,	0,	0,	0,
/* ? */	1211,	25,	33,	0,	-1,	30,
/* @ */	1343,	0,	0,	0,	0,	0,
/* A */	1343,	40,	41,	0,	-7,	44,
/* B */	1548,	39,	41,	0,	-8,	43,
/* C */	1753,	36,	41,	0,	-6,	40,
/* D */	1958,	40,	40,	0,	-8,	44,
/* E */	2158,	40,	38,	0,	-6,	44,
/* F */	2348,	40,	40,	0,	-8,	44,
/* G */	2548,	40,	38,	0,	-5,	44,
/* H */	2738,	44,	39,	0,	-6,	48,
/* I */	2972,	21,	31,	0,	1,	24,
/* J */	3065,	27,	32,	0,	1,	30,
/* K */	3193,	42,	38,	0,	-5,	46,
/* L */	3421,	33,	38,	0,	-6,	37,
/* M */	3611,	50,	38,	0,	-6,	55,
/* N */	3877,	42,	38,	0,	-5,	46,
/* O */	4105,	39,	37,	0,	-5,	43,
/* P */	4290,	38,	37,	0,	-5,	42,
/* Q */	4475,	39,	36,	0,	-5,	43,
/* R */	4655,	40,	38,	0,	-6,	44,
/* S */	4845,	38,	32,	0,	0,	42,
/* T */	5005,	35,	37,	0,	-6,	39,
/* U */	5190,	41,	38,	0,	-5,	45,
/* V */	5418,	42,	38,	0,	-6,	46,
/* W */	5646,	51,	36,	0,	-5,	56,
/* X */	5898,	37,	31,	0,	1,	41,
/* Y */	6053,	41,	38,	0,	-6,	45,
/* Z */	6281,	36,	37,	0,	-5,	40,
/* [ */	6466,	0,	0,	0,	0,	0,
/* \ */	6466,	0,	0,	0,	0,	0,
/* ] */	6466,	0,	0,	0,	0,	0,
/* ^ */	6466,	0,	0,	0,	0,	0,
/* _ */	6466,	0,	0,	0,	0,	0,
/* ` */	6466,	0,	0,	0,	0,	0,
/* a */	6466,	24,	19,	0,	0,	27,
/* b */	6523,	24,	28,	0,	1,	27,
/* c */	6607,	18,	18,	0,	1,	21,
/* d */	6661,	23,	29,	0,	1,	26,
/* e */	6748,	22,	19,	0,	0,	25,
/* f */	6805,	18,	30,	0,	0,	21,
/* g */	6895,	23,	25,	0,	-7,	26,
/* h */	6970,	23,	28,	0,	0,	26,
/* i */	7054,	10,	28,	0,	0,	12,
/* j */	7110,	13,	33,	0,	-5,	15,
/* k */	7176,	25,	29,	0,	0,	28,
/* l */	7292,	10,	29,	0,	0,	12,
/* m */	7350,	37,	18,	0,	0,	41,
/* n */	7440,	23,	16,	0,	1,	26,
/* o */	7488,	20,	16,	0,	1,	23,
/* p */	7536,	24,	22,	0,	-5,	27,
/* q */	7602,	21,	22,	0,	-5,	24,
/* r */	7668,	19,	16,	0,	1,	22,
/* s */	7716,	23,	17,	0,	0,	26,
/* t */	7767,	13,	24,	0,	1,	15,
/* u */	7815,	23,	16,	0,	1,	26,
/* v */	7863,	21,	16,	0,	1,	24,
/* w */	7911,	34,	16,	0,	1,	38,
/* x */	7991,	24,	17,	0,	1,	27,
/* y */	8042,	23,	23,	0,	-6,	26,
/* z */	8111,	21,	16,	0,	1,	24,
/* { */	8159,	0,	0,	0,	0,	0,
/* | */	8159,	0,	0,	0,	0,	0,
/* } */	8159,	0,	0,	0,	0,	0,
/* ~ */	8159,	0,	0,	0,	0,	0,
/*^? */	8159,	32,	31,	0,	-3,	36,	/* used for cursor */
};

Byte engl_bits[] = {
0x00, 0x10, 0x38, 0x7c, 0x38, 0x38, 0xfe, 0x38, 
0x10, 0x00, 0xe0, 0x03, 0xc0, 0x07, 0x80, 0x0f, 
0x80, 0x0f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x3f, 
0x00, 0x3e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0xfe, 
0x00, 0x7e, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x1c, 
0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 
0x00, 0x3c, 0x00, 0x3c, 0x00, 0x7e, 0x00, 0xfe, 
0x00, 0x7e, 0x00, 0x7e, 0x00, 0x3e, 0x00, 0x3f, 
0x00, 0x1f, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x0f, 
0x80, 0x07, 0x80, 0x03, 0xc0, 0x00, 0xe0, 0xe0, 
0x00, 0x78, 0x00, 0x3c, 0x00, 0x3e, 0x00, 0x1e, 
0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x80, 0x0f, 
0x80, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xe0, 0x0f, 
0xc0, 0x07, 0x80, 0x07, 0x80, 0x07, 0x00, 0x07, 
0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 
0x80, 0x07, 0x80, 0x0f, 0xc0, 0x0f, 0xe0, 0x0f, 
0xc0, 0x0f, 0xc0, 0x0f, 0x80, 0x1f, 0x80, 0x1f, 
0x00, 0x1f, 0x00, 0x1e, 0x00, 0x3e, 0x00, 0x3c, 
0x00, 0x78, 0x00, 0xe0, 0x00, 0x1c, 0x00, 0x03, 
0x00, 0x01, 0x80, 0x83, 0x80, 0x67, 0x00, 0x7f, 
0x00, 0x7f, 0x00, 0x7f, 0x00, 0x63, 0x00, 0x80, 
0x80, 0x10, 0x10, 0x3f, 0xf8, 0xff, 0xfe, 0x3f, 
0xf8, 0x10, 0x10, 0x80, 0x80, 0x63, 0x00, 0x7f, 
0x00, 0x7f, 0x00, 0x7f, 0x00, 0x63, 0x00, 0x80, 
0x80, 0x00, 0x08, 0x00, 0x00, 0x00, 0x3c, 0x00, 
0x00, 0x00, 0x63, 0x80, 0x00, 0x01, 0xc1, 0xfe, 
0x00, 0x0f, 0xc0, 0xff, 0x80, 0xff, 0x80, 0xff, 
0x00, 0x7f, 0x80, 0x7f, 0x00, 0x7f, 0x80, 0x7f, 
0x00, 0x7f, 0x80, 0x7f, 0x00, 0x3f, 0x80, 0x7f, 
0x00, 0x3f, 0x80, 0x7f, 0x00, 0x3f, 0x80, 0x7f, 
0x00, 0x3f, 0x80, 0x7f, 0x00, 0x3f, 0x80, 0x7f, 
0x00, 0x3f, 0x80, 0x7f, 0x80, 0x3f, 0x80, 0x7f, 
0x80, 0x3f, 0x80, 0x7f, 0x80, 0x3f, 0x80, 0x7f, 
0x80, 0x3f, 0x80, 0x7f, 0x80, 0x3f, 0x80, 0x7f, 
0x80, 0x3f, 0x80, 0x7f, 0x80, 0x3f, 0x80, 0x7f, 
0x80, 0x3f, 0x80, 0x7f, 0x80, 0x3f, 0xc0, 0x7f, 
0xc0, 0x7f, 0xc0, 0x7f, 0x00, 0x3f, 0xe0, 0xf0, 
0x00, 0x00, 0xe1, 0xc0, 0x00, 0x00, 0x1f, 0x00, 
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x70, 0x00, 
0x00, 0xf8, 0x00, 0x03, 0xfe, 0x00, 0x1f, 0xff, 
0xc0, 0x0f, 0xff, 0x00, 0x03, 0xfe, 0x00, 0x01, 
0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 
0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 
0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 
0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 
0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 
0x00, 0x01, 0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 
0xfe, 0x00, 0x01, 0xfe, 0x00, 0x01, 0xff, 0x00, 
0x0f, 0xff, 0xc0, 0xff, 0xff, 0xc0, 0xf1, 0xfc, 
0x00, 0xf0, 0x78, 0x00, 0xf0, 0x70, 0x00, 0x80, 
0x00, 0x20, 0xf8, 0x01, 0xe0, 0xff, 0xff, 0xf0, 
0xff, 0xff, 0xfc, 0x7f, 0xff, 0xfe, 0x6f, 0xff, 
0xfe, 0x23, 0xff, 0xf8, 0x30, 0x7f, 0xf0, 0x18, 
0x03, 0xe0, 0x0c, 0x00, 0x60, 0x06, 0x00, 0x00, 
0x03, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0xf0, 
0x00, 0x00, 0x7f, 0x00, 0x00, 0x1f, 0xfe, 0x00, 
0x0f, 0xfc, 0x00, 0x07, 0xfc, 0x00, 0x07, 0xfc, 
0x78, 0x03, 0xfc, 0x7e, 0x03, 0xfc, 0x7e, 0x03, 
0xfc, 0x7e, 0x03, 0xfc, 0x7e, 0x03, 0xfc, 0x7e, 
0x03, 0xfc, 0x7f, 0x03, 0xfe, 0x1f, 0x87, 0xf0, 
0x01, 0xcf, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x30, 
0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 
0x00, 0x01, 0x83, 0x80, 0x00, 0x7f, 0x01, 0xfc, 
0x00, 0x7f, 0x00, 0xff, 0x80, 0x7e, 0x00, 0xff, 
0x80, 0x7e, 0x00, 0xff, 0x00, 0x7e, 0x00, 0xff, 
0x00, 0x7e, 0x00, 0xff, 0x00, 0x40, 0x00, 0xff, 
0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 
0x00, 0x00, 0x01, 0xff, 0x80, 0x00, 0x03, 0xc0, 
0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x7e, 0x00, 
0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 0x01, 0xf8, 
0x00, 0x00, 0x01, 0xff, 0x80, 0x70, 0x00, 0xff, 
0x00, 0x7f, 0x00, 0xff, 0x00, 0x7e, 0x00, 0xff, 
0x00, 0x7e, 0x00, 0xff, 0x00, 0x7e, 0x00, 0xff, 
0x00, 0x7f, 0x01, 0xff, 0x00, 0xff, 0x01, 0xff, 
0x00, 0x1f, 0x81, 0xff, 0x80, 0x01, 0xc3, 0xe0, 
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x1c, 0x00, 
0x00, 0x00, 0x01, 0xc0, 0x00, 0x03, 0xe0, 0x00, 
0x3f, 0xf0, 0x00, 0x3f, 0xfe, 0x00, 0x0f, 0xf8, 
0x00, 0x07, 0xf8, 0x00, 0x07, 0xf8, 0xff, 0xff, 
0xff, 0xe0, 0x07, 0xf8, 0x70, 0x07, 0xf8, 0x38, 
0x07, 0xf0, 0x1c, 0x07, 0xf0, 0x0e, 0x0f, 0xf8, 
0x0e, 0x0f, 0xf8, 0x07, 0x1f, 0xfc, 0x03, 0xc3, 
0xf0, 0x03, 0xe1, 0xc0, 0x01, 0xf0, 0x00, 0x00, 
0xf8, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x7e, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x3f, 
0xc0, 0x00, 0x1f, 0xe0, 0x00, 0x1f, 0xf0, 0x00, 
0x0f, 0xf8, 0x00, 0x78, 0x00, 0x00, 0xc4, 0x00, 
0x03, 0x83, 0x00, 0x0e, 0x03, 0xc0, 0xfe, 0x01, 
0xfc, 0xfc, 0x01, 0xff, 0xfc, 0x01, 0xfe, 0xf8, 
0x00, 0xfe, 0xf8, 0x00, 0xfe, 0xd8, 0x00, 0xfe, 
0x00, 0x00, 0xfe, 0x00, 0x00, 0xfe, 0x40, 0x01, 
0xfe, 0x60, 0x01, 0xfe, 0x60, 0x01, 0xfe, 0x70, 
0x03, 0xfe, 0x4c, 0x07, 0xe0, 0x47, 0xff, 0x00, 
0x41, 0xf8, 0x00, 0x40, 0x00, 0x00, 0x40, 0x00, 
0x00, 0x60, 0x00, 0x00, 0x70, 0x00, 0x00, 0x7f, 
0xfe, 0x00, 0x7f, 0xff, 0x00, 0x7f, 0xff, 0x00, 
0x7f, 0xff, 0x00, 0x7f, 0xff, 0x80, 0x7f, 0xff, 
0xe0, 0x1f, 0xff, 0xf0, 0x00, 0x0c, 0x00, 0x00, 
0x00, 0x1f, 0x00, 0x00, 0x00, 0x61, 0xc0, 0x00, 
0x01, 0xc0, 0xf0, 0x00, 0x1f, 0x80, 0x7c, 0x00, 
0xff, 0x80, 0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0x80, 
0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 
0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 
0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 
0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0xc0, 0x7f, 0xc0, 
0x7f, 0xe0, 0xfc, 0x00, 0x7f, 0x99, 0xf0, 0x00, 
0x7f, 0x87, 0x80, 0x00, 0x7f, 0x80, 0x00, 0x00, 
0x7f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x3e, 0x00, 
0x7f, 0x80, 0x7e, 0x00, 0x7f, 0x80, 0x7e, 0x00, 
0xff, 0x80, 0x7e, 0x00, 0x3f, 0x80, 0xff, 0x00, 
0x03, 0xe1, 0xfe, 0x00, 0x00, 0xe1, 0x80, 0x00, 
0x00, 0x3e, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 
0x00, 0xc0, 0x00, 0x01, 0xe0, 0x00, 0x07, 0xf8, 
0x00, 0x0f, 0xff, 0x00, 0x1f, 0xff, 0x00, 0x07, 
0xff, 0x00, 0x01, 0xff, 0x00, 0x00, 0xff, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x1f, 
0x00, 0x00, 0x0f, 0x00, 0x00, 0x07, 0x00, 0x00, 
0x03, 0x80, 0x00, 0x01, 0x80, 0x00, 0x01, 0x80, 
0x00, 0x00, 0xc0, 0x10, 0x00, 0x40, 0x10, 0x00, 
0x60, 0x38, 0x00, 0x20, 0x3c, 0x00, 0x10, 0x7e, 
0x00, 0x10, 0x7f, 0xff, 0x88, 0xff, 0xff, 0xf8, 
0xff, 0xff, 0xfc, 0x3f, 0xff, 0xfc, 0x3f, 0xff, 
0xfe, 0x1f, 0xff, 0xfe, 0x10, 0x00, 0x02, 0x00, 
0x0c, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00, 0x00, 
0xe0, 0xc0, 0x00, 0x1f, 0x80, 0x70, 0x00, 0xff, 
0x00, 0x3f, 0x00, 0x7e, 0x00, 0x3f, 0xc0, 0x7c, 
0x00, 0x3f, 0xc0, 0x7c, 0x00, 0x3f, 0xc0, 0x7c, 
0x00, 0x7f, 0x80, 0x7c, 0x00, 0xff, 0x80, 0x7c, 
0x01, 0xff, 0x80, 0xfe, 0x07, 0xff, 0xc0, 0x07, 
0x0f, 0xff, 0xc0, 0x01, 0xff, 0xff, 0x00, 0x00, 
0xff, 0xfe, 0x00, 0x03, 0xff, 0xf0, 0x00, 0x0f, 
0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0x7f, 
0xfe, 0x60, 0x00, 0x3f, 0xfc, 0x3f, 0x00, 0x3f, 
0xf0, 0x3f, 0x00, 0x3f, 0xc0, 0x1f, 0x00, 0x3f, 
0x80, 0x1f, 0x00, 0x7f, 0x80, 0x3f, 0x00, 0xff, 
0x80, 0x3f, 0x00, 0x3f, 0x80, 0x7f, 0x00, 0x01, 
0xe1, 0xf0, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 
0x18, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 
0xc0, 0x00, 0x00, 0x01, 0x81, 0xe0, 0x00, 0x3f, 
0x80, 0xff, 0xc0, 0x3f, 0x00, 0x7f, 0xc0, 0x3f, 
0x00, 0x7f, 0x80, 0x3f, 0x00, 0x7f, 0x80, 0x3f, 
0x00, 0x7f, 0x80, 0x3f, 0x00, 0x7f, 0x80, 0x00, 
0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x01, 
0xfc, 0x7f, 0x80, 0x0f, 0xc3, 0xff, 0x80, 0xff, 
0x81, 0xff, 0x80, 0xff, 0x80, 0xff, 0x80, 0x7f, 
0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 
0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 
0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 
0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 
0x80, 0xff, 0x80, 0xff, 0xc0, 0xff, 0xc0, 0x01, 
0xe1, 0xe0, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 
0x1e, 0x00, 0x00, 0x00, 0x80, 0x80, 0x00, 0x00, 
0x63, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 
0x7f, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 
0x63, 0x00, 0x00, 0x00, 0x88, 0x80, 0x00, 0x00, 
0x1c, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 
0x7f, 0x00, 0x00, 0x00, 0xff, 0x80, 0x00, 0x01, 
0xff, 0xc0, 0x00, 0x01, 0xff, 0xc0, 0x00, 0x00, 
0x7f, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 
0x3e, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 
0x0f, 0xe0, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x3f, 
0x00, 0x7f, 0x80, 0x7f, 0x80, 0x3f, 0x00, 0x7f, 
0x80, 0x3e, 0x00, 0x7f, 0x80, 0x1e, 0x00, 0x3f, 
0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1c, 
0x00, 0x1e, 0x00, 0x3c, 0x00, 0x1e, 0x00, 0x3e, 
0x00, 0x3e, 0x00, 0x7e, 0x00, 0x3f, 0x00, 0xff, 
0x00, 0x7f, 0x80, 0x1f, 0x80, 0xfc, 0x00, 0x03, 
0xff, 0xe0, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 
0x00, 0x3e, 0x00, 0x00, 0x00, 0x00, 0x3f, 0x00, 
0x00, 0x00, 0x00, 0x6f, 0x00, 0x00, 0x00, 0x00, 
0x6e, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 0x00, 
0x01, 0x00, 0x60, 0x00, 0x00, 0x03, 0x80, 0x40, 
0x06, 0x00, 0x07, 0xe0, 0x40, 0x07, 0x00, 0x1f, 
0xf8, 0x40, 0x0f, 0x80, 0xff, 0xff, 0x40, 0x1f, 
0xe0, 0xff, 0xfe, 0x47, 0xff, 0xff, 0x3f, 0xf8, 
0x43, 0xff, 0xfe, 0x07, 0xf8, 0x61, 0xff, 0xf8, 
0x03, 0xf0, 0x61, 0xff, 0xe0, 0x00, 0xf0, 0x60, 
0xff, 0xc0, 0x00, 0xf0, 0x61, 0xff, 0x80, 0x00, 
0x70, 0x61, 0xff, 0x80, 0x00, 0x70, 0x61, 0xff, 
0x00, 0x00, 0x3f, 0xff, 0xff, 0x00, 0x00, 0x3f, 
0xff, 0xfe, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 
0x00, 0x1c, 0x0f, 0xfc, 0x00, 0x02, 0x0c, 0x0f, 
0xf8, 0x00, 0x0f, 0x8c, 0x0f, 0xf8, 0x00, 0x1c, 
0xec, 0x1f, 0xf8, 0x00, 0x31, 0xe6, 0x1f, 0xf0, 
0x00, 0x33, 0xe6, 0x1f, 0xf0, 0x00, 0x73, 0xe6, 
0x3f, 0xf0, 0x00, 0x73, 0xe3, 0x3f, 0xe0, 0x00, 
0x73, 0xe3, 0x7f, 0xe0, 0x00, 0x73, 0xe3, 0xff, 
0xe0, 0x00, 0x70, 0x01, 0xff, 0xc0, 0x00, 0x70, 
0x01, 0xff, 0xc0, 0x00, 0x30, 0x03, 0xff, 0xc0, 
0x00, 0x38, 0x07, 0xff, 0xc0, 0x00, 0x3c, 0x0f, 
0xff, 0xc0, 0x00, 0x1f, 0xff, 0xfd, 0xc0, 0x00, 
0x0f, 0xff, 0xf8, 0xe0, 0x00, 0x0f, 0xff, 0xe0, 
0x70, 0x00, 0x03, 0xff, 0x80, 0x18, 0x00, 0x01, 
0xfc, 0x00, 0x00, 0x00, 0x00, 0x00, 0x07, 0x80, 
0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 
0x0f, 0xc0, 0x00, 0x00, 0x00, 0x0b, 0xc0, 0x00, 
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x00, 0x08, 
0x00, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x80, 
0x00, 0x3c, 0x00, 0x00, 0xc0, 0x00, 0x7e, 0x00, 
0x00, 0xf0, 0x01, 0xff, 0xc0, 0x02, 0x7f, 0xff, 
0xff, 0xff, 0xfe, 0x3f, 0xff, 0xff, 0xdf, 0xfc, 
0x1f, 0xff, 0xff, 0xcf, 0xfc, 0x07, 0xff, 0xff, 
0x0f, 0xfc, 0x03, 0xff, 0xfe, 0x0f, 0xfc, 0x01, 
0xff, 0xfc, 0x0f, 0xfc, 0x00, 0xff, 0xcc, 0x0f, 
0xfc, 0x00, 0xff, 0x8c, 0x0f, 0xfc, 0x00, 0xff, 
0x8c, 0x0f, 0xfc, 0x00, 0xff, 0x8c, 0x0f, 0xfc, 
0x00, 0xff, 0x8c, 0x0f, 0xf8, 0x00, 0xff, 0x8c, 
0x0f, 0xf8, 0x00, 0xff, 0x8c, 0x1f, 0xf0, 0x1f, 
0xff, 0x84, 0x1f, 0xc0, 0x1f, 0xff, 0x87, 0xff, 
0x00, 0x1f, 0xff, 0xc7, 0xfe, 0x00, 0x0f, 0xff, 
0xc6, 0xff, 0xc0, 0x0f, 0xff, 0xc6, 0x1f, 0xf0, 
0x0f, 0xff, 0xc6, 0x0f, 0xfc, 0x0f, 0xff, 0xc6, 
0x0f, 0xfe, 0x00, 0xff, 0xc6, 0x07, 0xfe, 0x00, 
0xff, 0xc6, 0x07, 0xfe, 0x00, 0xff, 0xc6, 0x07, 
0xfe, 0x00, 0xff, 0xc6, 0x07, 0xfe, 0x00, 0xff, 
0xc6, 0x07, 0xfc, 0x7f, 0xff, 0xc6, 0x07, 0xfc, 
0xff, 0xff, 0xc6, 0x0f, 0xf0, 0xfc, 0x0f, 0xe6, 
0x1f, 0xc0, 0xfc, 0x01, 0xff, 0xff, 0x00, 0xfe, 
0x00, 0x3f, 0xf0, 0x00, 0x7e, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 
0x00, 0x1f, 0x80, 0x00, 0x00, 0x00, 0x13, 0xc0, 
0x00, 0x00, 0x00, 0x33, 0xc0, 0x00, 0x00, 0x00, 
0x33, 0x80, 0x00, 0x00, 0x00, 0x32, 0x00, 0x00, 
0x0f, 0xfe, 0x30, 0x00, 0x00, 0x7f, 0xff, 0xf0, 
0x00, 0x01, 0xff, 0x00, 0xf0, 0x00, 0x03, 0xfc, 
0x00, 0x38, 0x00, 0x07, 0xfc, 0x00, 0x3c, 0x00, 
0x0f, 0xfe, 0x00, 0x36, 0x00, 0x1f, 0xf3, 0x80, 
0x33, 0x00, 0x3f, 0xe1, 0xe0, 0x31, 0x80, 0x3f, 
0xe1, 0xf8, 0x30, 0xc0, 0x7f, 0xe1, 0xfe, 0x30, 
0xc0, 0xff, 0xe1, 0xfc, 0x30, 0x60, 0xff, 0xc1, 
0xfc, 0x30, 0x70, 0xff, 0xc1, 0xfc, 0x30, 0x30, 
0xff, 0xc1, 0xfc, 0x30, 0x00, 0xff, 0xc1, 0xfc, 
0x30, 0x00, 0xff, 0xc1, 0xfc, 0x30, 0x00, 0xff, 
0xc1, 0xfc, 0x30, 0x00, 0xff, 0xc1, 0xfc, 0x30, 
0x00, 0xff, 0xc1, 0xfc, 0x18, 0x00, 0xff, 0xc1, 
0xfc, 0x18, 0x00, 0x7f, 0xc1, 0xfc, 0x18, 0x00, 
0x7f, 0xc1, 0xfc, 0x18, 0x00, 0x7f, 0xc1, 0xfc, 
0x18, 0x00, 0x3f, 0xc1, 0xfc, 0x18, 0x00, 0x3f, 
0xe1, 0xfc, 0x18, 0x00, 0x1f, 0xe1, 0xfc, 0x18, 
0x00, 0x0f, 0xf1, 0xfc, 0x1c, 0x00, 0x0f, 0xff, 
0xfc, 0x1c, 0x00, 0x03, 0xf3, 0xfc, 0x1e, 0x00, 
0x03, 0xf8, 0xfc, 0x1e, 0x00, 0x00, 0xfc, 0x7c, 
0x1f, 0x80, 0x00, 0x7e, 0x1e, 0x1f, 0xe0, 0x00, 
0x1f, 0x06, 0x3f, 0xf0, 0x00, 0x03, 0x03, 0xfe, 
0x00, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 
0x01, 0xc0, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 
0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x05, 
0xe0, 0x00, 0x00, 0x00, 0x04, 0xc0, 0x00, 0x00, 
0x00, 0x0c, 0x00, 0x00, 0x40, 0x00, 0x0e, 0x00, 
0x00, 0x70, 0x00, 0x3f, 0x00, 0x00, 0x3c, 0x00, 
0xff, 0xc0, 0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 
0x0f, 0xff, 0xff, 0xff, 0xff, 0x03, 0xff, 0xff, 
0xff, 0xfe, 0x01, 0xff, 0xff, 0xe7, 0xfe, 0x00, 
0xff, 0xff, 0x87, 0xfe, 0x00, 0xff, 0xff, 0x07, 
0xfe, 0x00, 0xff, 0xe6, 0x07, 0xfe, 0x00, 0xff, 
0xc6, 0x07, 0xfe, 0x00, 0xff, 0xc6, 0x07, 0xfe, 
0x00, 0xff, 0xc6, 0x07, 0xfe, 0x00, 0xff, 0xc6, 
0x07, 0xfe, 0x00, 0xff, 0xc6, 0x07, 0xfe, 0x30, 
0xff, 0xc6, 0x07, 0xfe, 0x18, 0xff, 0xc2, 0x07, 
0xfe, 0x1f, 0xff, 0xc2, 0x07, 0xfe, 0x0f, 0xff, 
0xe3, 0x1f, 0xfe, 0x0f, 0xff, 0xe3, 0xff, 0xfe, 
0x0f, 0xff, 0xe3, 0x07, 0xfe, 0x0f, 0xff, 0xe2, 
0x07, 0xfe, 0x07, 0xff, 0xe2, 0x07, 0xfe, 0x04, 
0x7f, 0xe2, 0x07, 0xfe, 0x00, 0x7f, 0xe2, 0x07, 
0xfe, 0x00, 0x7f, 0xe2, 0x07, 0xfe, 0x00, 0x7f, 
0xe2, 0x07, 0xfe, 0x00, 0xff, 0xe2, 0x07, 0xfe, 
0x0f, 0xff, 0xe2, 0x07, 0xfc, 0xff, 0xff, 0xe2, 
0x07, 0xfc, 0xfc, 0x0f, 0xf2, 0x07, 0xfc, 0xfc, 
0x00, 0xfe, 0x1f, 0xe0, 0xfc, 0x00, 0x1f, 0xff, 
0xc0, 0x3c, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 
0x0f, 0x80, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 
0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x1f, 
0x80, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 
0x00, 0x18, 0x00, 0x00, 0x00, 0x70, 0x18, 0x00, 
0x80, 0x00, 0x78, 0x18, 0x03, 0xc0, 0x00, 0xfc, 
0x18, 0x1f, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xff, 
0x3f, 0xff, 0xff, 0xff, 0xfc, 0x1f, 0xff, 0x98, 
0x0f, 0xf0, 0x07, 0xff, 0x18, 0x07, 0xf0, 0x03, 
0xff, 0x18, 0x01, 0xe0, 0x03, 0xff, 0x18, 0x01, 
0xe0, 0x01, 0xff, 0x18, 0x00, 0xc0, 0x01, 0xff, 
0x09, 0x00, 0xc0, 0x01, 0xff, 0x09, 0x00, 0xc0, 
0x01, 0xff, 0x09, 0x80, 0xc0, 0x01, 0xff, 0x0b, 
0x80, 0x00, 0x31, 0xff, 0x0f, 0xc0, 0x00, 0x3f, 
0xff, 0x9f, 0xe0, 0x00, 0x3f, 0xff, 0xff, 0xfc, 
0x00, 0x1f, 0xff, 0xff, 0xf8, 0x00, 0x1f, 0xff, 
0xff, 0xf0, 0x00, 0x1f, 0xff, 0x8f, 0xe0, 0x00, 
0x1f, 0xff, 0x0f, 0xe0, 0x00, 0x11, 0xff, 0x0d, 
0xc0, 0x00, 0x01, 0xff, 0x0d, 0xc0, 0x00, 0x01, 
0xff, 0x0c, 0xc1, 0x80, 0x01, 0xff, 0x8c, 0xc1, 
0xc0, 0x01, 0xff, 0x8c, 0x81, 0xe0, 0x03, 0xff, 
0x8c, 0x03, 0xf8, 0x1f, 0xff, 0x8c, 0x03, 0xfc, 
0x7f, 0xff, 0x8c, 0x07, 0xff, 0xf8, 0x3f, 0x8c, 
0x0f, 0xf0, 0xfc, 0x07, 0xfc, 0x3f, 0xe0, 0x7c, 
0x00, 0x7f, 0xff, 0x00, 0x00, 0x00, 0x07, 0x00, 
0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 
0x0f, 0xc0, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 
0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 0x0f, 
0x80, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 
0x20, 0x0c, 0x00, 0x00, 0x00, 0x70, 0x0c, 0x00, 
0x00, 0x00, 0xf8, 0x0c, 0x00, 0x00, 0x0f, 0xfe, 
0x0c, 0x00, 0x00, 0x3f, 0xff, 0xfc, 0x00, 0x00, 
0x1f, 0xff, 0xfc, 0x00, 0x00, 0x07, 0xff, 0xcc, 
0x00, 0x00, 0x03, 0xff, 0x8c, 0x00, 0x00, 0x03, 
0xff, 0x0c, 0x00, 0x00, 0x01, 0xff, 0x0c, 0x00, 
0x00, 0x01, 0xff, 0x0c, 0x00, 0x00, 0x01, 0xff, 
0x0c, 0x80, 0x00, 0x01, 0xff, 0x0d, 0x80, 0x00, 
0x21, 0xff, 0x0d, 0x80, 0x00, 0x31, 0xff, 0x0f, 
0xc0, 0x00, 0x1f, 0xff, 0x0f, 0xe0, 0x00, 0x1f, 
0xff, 0xff, 0xf0, 0x00, 0x1f, 0xff, 0xff, 0xfc, 
0x00, 0x1f, 0xff, 0xff, 0xfe, 0x00, 0x1f, 0xff, 
0xff, 0xf8, 0x00, 0x1f, 0xff, 0xff, 0xe0, 0x00, 
0x0b, 0xff, 0x0f, 0xe0, 0x00, 0x01, 0xff, 0x0f, 
0xc0, 0x00, 0x01, 0xff, 0x0c, 0xc1, 0x00, 0x01, 
0xff, 0x0c, 0x81, 0x80, 0x01, 0xff, 0x0c, 0x01, 
0xc0, 0x01, 0xff, 0x0c, 0x03, 0xe0, 0x7f, 0xff, 
0x0c, 0x03, 0xf0, 0xff, 0xff, 0x8c, 0x07, 0xfc, 
0xfc, 0x7f, 0x8c, 0x0f, 0xfe, 0xfc, 0x0f, 0xcc, 
0x1f, 0xf3, 0x7c, 0x01, 0xff, 0xff, 0xc0, 0x00, 
0x00, 0x3f, 0xfe, 0x00, 0x00, 0x00, 0x00, 0x3e, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 
0x00, 0x6f, 0x00, 0x00, 0x00, 0x00, 0x6f, 0x00, 
0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x01, 0xfc, 
0xe0, 0x00, 0x00, 0x3f, 0xff, 0xe0, 0x00, 0x00, 
0xfe, 0x00, 0xfc, 0x00, 0x03, 0xf8, 0x00, 0x7f, 
0x00, 0x0f, 0xf8, 0x00, 0x67, 0xc0, 0x0f, 0xfc, 
0x00, 0x63, 0xe0, 0x3f, 0xe7, 0x00, 0x63, 0xf0, 
0x3f, 0xc7, 0x80, 0x61, 0xf8, 0x7f, 0xc3, 0xf0, 
0x61, 0xfc, 0x7f, 0xc3, 0xfc, 0x61, 0xfc, 0xff, 
0xc3, 0xf8, 0x61, 0xfe, 0xff, 0xc3, 0xf8, 0x61, 
0xfe, 0xff, 0xc3, 0xf8, 0x61, 0xfe, 0xff, 0xc3, 
0xf8, 0x63, 0xff, 0xff, 0xc3, 0xf8, 0x63, 0xff, 
0xff, 0xc3, 0xf8, 0x67, 0xff, 0xff, 0xc3, 0xf8, 
0x67, 0xfe, 0xff, 0xc3, 0xf8, 0x7f, 0xfe, 0x7f, 
0xc3, 0xf8, 0xff, 0xfc, 0x7f, 0xc3, 0xff, 0xff, 
0xfc, 0x7f, 0xc3, 0xf8, 0x7f, 0xf8, 0x3f, 0xc3, 
0xf8, 0x61, 0xf8, 0x3f, 0xc3, 0xf8, 0x60, 0xf0, 
0x1f, 0xe3, 0xf8, 0x60, 0x60, 0x1f, 0xe3, 0xf8, 
0x60, 0x00, 0x0f, 0xfb, 0xf8, 0x60, 0x00, 0x07, 
0xff, 0xf8, 0x70, 0x00, 0x03, 0xfb, 0xf8, 0x78, 
0x00, 0x01, 0xf9, 0xf8, 0x7c, 0x00, 0x00, 0x7c, 
0x78, 0x7f, 0x00, 0x00, 0x1e, 0x38, 0x7f, 0xc0, 
0x00, 0x07, 0x1f, 0xff, 0xc0, 0x00, 0x00, 0x07, 
0xfe, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 
0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x0f, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 
0x40, 0x00, 0x0d, 0x80, 0x00, 0x00, 0x70, 0x03, 
0x0c, 0x00, 0x00, 0x00, 0x3c, 0x0f, 0x04, 0x00, 
0x30, 0x00, 0x1f, 0xff, 0x84, 0x00, 0xfc, 0x00, 
0x0f, 0xff, 0xc4, 0x03, 0xfe, 0x00, 0x0f, 0xff, 
0xfc, 0x3f, 0xff, 0x80, 0x07, 0xff, 0xfc, 0x0f, 
0xff, 0xf0, 0x03, 0xff, 0xfc, 0x07, 0xff, 0xe0, 
0x01, 0xff, 0xcc, 0x03, 0xff, 0x00, 0x01, 0xff, 
0xc4, 0x03, 0xff, 0x00, 0x00, 0xff, 0x84, 0x03, 
0xff, 0x00, 0x00, 0xff, 0x84, 0x03, 0xff, 0x00, 
0x00, 0xff, 0x84, 0x03, 0xff, 0x00, 0x00, 0xff, 
0x84, 0x03, 0xff, 0x00, 0x00, 0xff, 0xc4, 0x03, 
0xff, 0x00, 0x31, 0xff, 0xc4, 0x03, 0xff, 0x00, 
0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 0x1f, 0xff, 
0xff, 0xff, 0xff, 0x00, 0x1f, 0xff, 0xff, 0xff, 
0xff, 0x00, 0x1f, 0xff, 0xff, 0xff, 0xff, 0x00, 
0x0f, 0xff, 0xce, 0xff, 0xff, 0x00, 0x0f, 0xff, 
0xc6, 0x03, 0xff, 0x00, 0x09, 0xff, 0xc6, 0x03, 
0xff, 0x00, 0x01, 0xff, 0xc4, 0x03, 0xff, 0x00, 
0x01, 0xff, 0xc4, 0x03, 0xff, 0x00, 0x01, 0xff, 
0xc4, 0x03, 0xff, 0x00, 0x01, 0xff, 0xc4, 0x03, 
0xff, 0x00, 0x01, 0xff, 0xe4, 0x07, 0xff, 0x00, 
0x7f, 0xff, 0xfc, 0x0f, 0xff, 0xc0, 0xff, 0xff, 
0xfc, 0x3f, 0xff, 0xf0, 0xf0, 0xff, 0x0c, 0x07, 
0xff, 0x00, 0xf8, 0x3e, 0x04, 0x00, 0xfc, 0x00, 
0x78, 0x1c, 0x04, 0x00, 0x78, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x30, 0x00, 0x00, 0x1c, 0x00, 0x00, 
0x3e, 0x00, 0x00, 0xff, 0x00, 0x1f, 0xff, 0xe0, 
0x0f, 0xff, 0xf8, 0x01, 0xff, 0xc0, 0x01, 0xff, 
0xc0, 0x00, 0xff, 0xc0, 0x00, 0xff, 0xc0, 0x00, 
0xff, 0xc0, 0x00, 0xff, 0xc0, 0x00, 0xff, 0xc0, 
0x00, 0xff, 0xc0, 0x10, 0xff, 0xc0, 0x1f, 0xff, 
0xc0, 0x0f, 0xff, 0xc0, 0x0f, 0xff, 0xc0, 0x0f, 
0xff, 0xc0, 0x0f, 0xff, 0xc0, 0x0f, 0xff, 0xc0, 
0x0c, 0xff, 0xc0, 0x00, 0xff, 0xc0, 0x00, 0xff, 
0xc0, 0x00, 0xff, 0xc0, 0x00, 0xff, 0xc0, 0x0f, 
0xff, 0xc0, 0x7f, 0xff, 0xe0, 0xff, 0xff, 0xf0, 
0xf8, 0x7f, 0xf0, 0xfc, 0x3f, 0x00, 0x7c, 0x00, 
0x00, 0x1f, 0xfc, 0x00, 0x00, 0x38, 0x3f, 0x00, 
0x00, 0x70, 0x1f, 0xc0, 0x00, 0xe0, 0x0f, 0xf0, 
0x00, 0xfc, 0x07, 0xfc, 0x00, 0xfe, 0x07, 0xff, 
0xe0, 0xfe, 0x03, 0xff, 0x80, 0xff, 0x03, 0xff, 
0x00, 0xff, 0x03, 0xff, 0x00, 0xfe, 0x03, 0xfe, 
0x00, 0x7e, 0x03, 0xfe, 0x00, 0x18, 0x03, 0xfe, 
0x00, 0x00, 0x03, 0xfe, 0x00, 0x00, 0x83, 0xfe, 
0x00, 0x00, 0xc3, 0xfe, 0x00, 0x00, 0x7f, 0xfe, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x7f, 0xfe, 
0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xfe, 
0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x07, 0xfe, 
0x00, 0x00, 0x03, 0xfe, 0x00, 0x00, 0x03, 0xfe, 
0x00, 0x00, 0x03, 0xfe, 0x00, 0x00, 0x03, 0xfe, 
0x00, 0x00, 0x07, 0xfe, 0x00, 0x03, 0xff, 0xff, 
0x00, 0x07, 0xff, 0xff, 0x80, 0x07, 0xc3, 0xff, 
0xc0, 0x07, 0xe0, 0xfc, 0x00, 0x07, 0xe0, 0x70, 
0x00, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 
0x00, 0x07, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x06, 
0xe0, 0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x30, 
0x00, 0x04, 0x00, 0x00, 0x00, 0x38, 0x01, 0x84, 
0x00, 0x00, 0x00, 0x1e, 0x07, 0x84, 0x00, 0x70, 
0x00, 0x0f, 0xff, 0xc4, 0x03, 0xf8, 0x00, 0x07, 
0xff, 0xc4, 0x07, 0xfe, 0x00, 0x07, 0xff, 0xec, 
0x0f, 0xff, 0xc0, 0x01, 0xff, 0xfc, 0x0f, 0xff, 
0x00, 0x00, 0xff, 0xfc, 0x0f, 0xfe, 0x00, 0x00, 
0xff, 0xfc, 0x0f, 0xfc, 0x00, 0x00, 0xff, 0xcc, 
0x0f, 0xf8, 0x00, 0x00, 0xff, 0xcc, 0x0f, 0xf0, 
0x00, 0x00, 0xff, 0xcc, 0x0f, 0xe0, 0x00, 0x30, 
0xff, 0xcc, 0x1f, 0xc0, 0x00, 0x18, 0xff, 0xcc, 
0x1f, 0x00, 0x00, 0x1f, 0xff, 0xcc, 0x3e, 0x00, 
0x00, 0x1f, 0xff, 0xcc, 0x78, 0x00, 0x00, 0x0f, 
0xff, 0xff, 0xe0, 0x00, 0x00, 0x0f, 0xff, 0xff, 
0x80, 0x00, 0x00, 0x0f, 0xff, 0xcf, 0xc0, 0x00, 
0x00, 0x0f, 0xff, 0x8c, 0x70, 0x00, 0x00, 0x0c, 
0xff, 0x8c, 0x18, 0x00, 0x00, 0x00, 0xff, 0x8c, 
0x0e, 0x00, 0x00, 0x00, 0xff, 0x8c, 0x07, 0x00, 
0x00, 0x00, 0xff, 0x8c, 0x07, 0x80, 0x00, 0x00, 
0xff, 0x8c, 0x07, 0xc0, 0x00, 0x00, 0xff, 0x8c, 
0x07, 0xe0, 0x00, 0x00, 0xff, 0xcc, 0x07, 0xf0, 
0x00, 0x03, 0xff, 0xcc, 0x07, 0xf8, 0x00, 0xff, 
0xff, 0xfc, 0x0f, 0xfc, 0x00, 0xf1, 0xff, 0x8c, 
0x1f, 0xfe, 0x00, 0xf0, 0x7e, 0x04, 0x03, 0xff, 
0x00, 0x70, 0x38, 0x04, 0x00, 0xf0, 0x00, 0x00, 
0x00, 0x04, 0x00, 0x60, 0x00, 0x00, 0x00, 0x03, 
0xe0, 0x00, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00, 
0x00, 0x06, 0xe0, 0x00, 0x00, 0x00, 0x07, 0xe0, 
0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x00, 
0x06, 0x00, 0x00, 0x20, 0x00, 0x06, 0x00, 0x00, 
0x30, 0x00, 0x06, 0x00, 0x00, 0x3c, 0x00, 0x07, 
0xc0, 0x00, 0x0f, 0x00, 0x0f, 0xe0, 0x00, 0x0f, 
0xff, 0xff, 0xf0, 0x00, 0x03, 0xff, 0xff, 0xf8, 
0x00, 0x01, 0xff, 0xff, 0xfc, 0x00, 0x00, 0xff, 
0xff, 0xfe, 0x00, 0x00, 0xff, 0xff, 0xff, 0x80, 
0x00, 0xff, 0xff, 0x80, 0x00, 0x00, 0xff, 0xce, 
0x00, 0x00, 0x00, 0xff, 0xc6, 0x00, 0x00, 0x30, 
0xff, 0xc6, 0x00, 0x00, 0x30, 0xff, 0xc6, 0x00, 
0x00, 0x18, 0xff, 0xc6, 0x00, 0x00, 0x1f, 0xff, 
0xc6, 0x00, 0x00, 0x0f, 0xff, 0xc6, 0x00, 0x00, 
0x0f, 0xff, 0xc6, 0x00, 0x00, 0x0f, 0xff, 0xc6, 
0x00, 0x00, 0x0f, 0xff, 0xc6, 0x00, 0x00, 0x07, 
0xff, 0xc6, 0x00, 0x00, 0x00, 0xff, 0xc6, 0x00, 
0x00, 0x00, 0xff, 0xc6, 0x00, 0x00, 0x00, 0xff, 
0xc6, 0x1c, 0x00, 0x00, 0xff, 0xc6, 0x7e, 0x00, 
0x00, 0xff, 0xc6, 0x7f, 0x00, 0x00, 0xff, 0xc6, 
0x3f, 0x80, 0x7f, 0xff, 0xc6, 0x3f, 0x00, 0xff, 
0xff, 0xc6, 0x3c, 0x00, 0xf8, 0x3f, 0xc6, 0x38, 
0x00, 0x78, 0x07, 0xe6, 0x70, 0x00, 0x00, 0x00, 
0xff, 0x80, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x6e, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 
0xe0, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0xe0, 
0x00, 0xe0, 0x00, 0x00, 0xfc, 0x03, 0xf8, 0x01, 
0xf8, 0x00, 0x0f, 0xff, 0x0f, 0xfe, 0x1f, 0xfe, 
0x00, 0x07, 0xff, 0x0f, 0xfe, 0x3f, 0xff, 0xc0, 
0x00, 0xfe, 0x0f, 0xfe, 0x1f, 0xfe, 0x00, 0x00, 
0x78, 0x0f, 0xfc, 0x0f, 0xfe, 0x00, 0x00, 0x38, 
0x0f, 0xfc, 0x0f, 0xfe, 0x00, 0x00, 0x38, 0x0f, 
0xfc, 0x0f, 0xfe, 0x00, 0x00, 0x38, 0x1f, 0xfc, 
0x0f, 0xfe, 0x00, 0x00, 0x18, 0x1f, 0xfc, 0x0f, 
0xfe, 0x00, 0x00, 0x18, 0x3f, 0xf6, 0x0f, 0xfe, 
0x00, 0x02, 0x18, 0x3f, 0xf6, 0x0f, 0xfe, 0x00, 
0x03, 0x18, 0x7f, 0xe3, 0x0f, 0xfe, 0x00, 0x03, 
0xf8, 0x7f, 0xe3, 0x0f, 0xfe, 0x00, 0x01, 0xf8, 
0x7f, 0xe1, 0x8f, 0xfe, 0x00, 0x01, 0xf8, 0xff, 
0xe1, 0x8f, 0xfe, 0x00, 0x01, 0xf8, 0xff, 0xe0, 
0xcf, 0xfe, 0x00, 0x01, 0xf9, 0xff, 0xe0, 0xcf, 
0xfe, 0x00, 0x01, 0xf9, 0xff, 0xe0, 0x4f, 0xfe, 
0x00, 0x00, 0x1b, 0xff, 0x60, 0x6f, 0xfe, 0x00, 
0x00, 0x1b, 0xff, 0x60, 0x3f, 0xfe, 0x00, 0x00, 
0x1f, 0xff, 0x20, 0x3f, 0xfe, 0x00, 0x00, 0x1f, 
0xfe, 0x20, 0x3f, 0xfe, 0x00, 0x00, 0x3f, 0xfe, 
0x20, 0x1f, 0xfe, 0x00, 0x00, 0x3f, 0xfe, 0x20, 
0x1f, 0xff, 0x00, 0x07, 0xff, 0xff, 0x20, 0x3f, 
0xff, 0xc0, 0x7f, 0xff, 0xff, 0xe0, 0xff, 0xff, 
0x00, 0xfc, 0x1f, 0xf0, 0x60, 0x1f, 0xfc, 0x00, 
0xfc, 0x07, 0x80, 0x60, 0x03, 0xf0, 0x00, 0x7c, 
0x07, 0x00, 0x60, 0x01, 0xe0, 0x00, 0x00, 0x00, 
0x00, 0x20, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x01, 
0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0x80, 0x40, 
0x00, 0x00, 0x20, 0x01, 0x80, 0xc0, 0x00, 0x00, 
0x70, 0x01, 0x81, 0xc0, 0x00, 0x07, 0xf8, 0x01, 
0x83, 0xe0, 0x00, 0x1f, 0xfe, 0x01, 0x87, 0xe0, 
0x00, 0x07, 0xff, 0xc1, 0x87, 0xf0, 0x00, 0x00, 
0xfc, 0x01, 0x9f, 0xf0, 0x00, 0x00, 0x78, 0x03, 
0x9f, 0xf8, 0x00, 0x00, 0x70, 0x03, 0xff, 0xfe, 
0x00, 0x00, 0x30, 0x03, 0xff, 0xff, 0x00, 0x00, 
0x30, 0x03, 0xff, 0xfc, 0x00, 0x00, 0x30, 0x03, 
0xff, 0xf8, 0x00, 0x00, 0x30, 0x03, 0xff, 0xf8, 
0x00, 0x00, 0x30, 0x0f, 0xff, 0xd8, 0x00, 0x00, 
0x30, 0x0f, 0xff, 0xd8, 0x00, 0x04, 0x30, 0x3f, 
0xff, 0x98, 0x00, 0x07, 0x70, 0x3f, 0xff, 0x18, 
0x00, 0x07, 0xe0, 0x7f, 0xfe, 0x18, 0x00, 0x03, 
0xe0, 0xff, 0xfc, 0x18, 0x00, 0x03, 0xe1, 0xff, 
0xf8, 0x18, 0x00, 0x03, 0xf3, 0xff, 0xf0, 0x18, 
0x00, 0x03, 0xf7, 0xff, 0xe0, 0x18, 0x00, 0x00, 
0x3f, 0xff, 0xc0, 0x18, 0x00, 0x00, 0x3f, 0xff, 
0x80, 0x18, 0x00, 0x00, 0x3f, 0xff, 0x80, 0x18, 
0x00, 0x00, 0x7f, 0xff, 0x80, 0x18, 0x00, 0x00, 
0xff, 0xff, 0x80, 0x3c, 0x00, 0x03, 0xff, 0xfd, 
0x80, 0x7c, 0x00, 0xff, 0xff, 0xfd, 0x00, 0xfe, 
0x00, 0xf8, 0x3f, 0xe1, 0x03, 0xff, 0x80, 0xf8, 
0x1f, 0x01, 0x00, 0xff, 0xc0, 0x78, 0x06, 0x01, 
0x00, 0x3c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x18, 
0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 
0x00, 0xf8, 0x00, 0x00, 0x00, 0x01, 0xf8, 0x00, 
0x00, 0x00, 0x01, 0xb8, 0x00, 0x00, 0x00, 0x01, 
0x80, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 
0x0f, 0xff, 0x80, 0x00, 0x00, 0x7f, 0x07, 0xf0, 
0x00, 0x01, 0xfc, 0x01, 0xfc, 0x00, 0x07, 0xf8, 
0x01, 0xff, 0x00, 0x0f, 0xf0, 0x00, 0x9f, 0x80, 
0x1f, 0xe6, 0x00, 0x8f, 0xc0, 0x3f, 0xe3, 0xc0, 
0x8f, 0xe0, 0x7f, 0xc3, 0xf8, 0x87, 0xf0, 0x7f, 
0xc3, 0xf8, 0x87, 0xf8, 0xff, 0xc3, 0xf8, 0x87, 
0xf8, 0xff, 0xc3, 0xf8, 0x87, 0xfc, 0xff, 0xc3, 
0xf8, 0x87, 0xfe, 0xff, 0xc3, 0xf8, 0x83, 0xfe, 
0xff, 0xc3, 0xf8, 0x83, 0xfe, 0xff, 0xc3, 0xf8, 
0x83, 0xfe, 0xff, 0xc3, 0xf8, 0x83, 0xfe, 0xff, 
0xc3, 0xf8, 0x83, 0xfe, 0xff, 0xc3, 0xf8, 0x83, 
0xfe, 0xff, 0xc3, 0xf8, 0xc3, 0xfe, 0x7f, 0xc3, 
0xf8, 0xc3, 0xfe, 0x7f, 0xe3, 0xf8, 0xc7, 0xfe, 
0x3f, 0xe3, 0xf8, 0xc7, 0xfe, 0x3f, 0xe3, 0xf8, 
0xc7, 0xfc, 0x1f, 0xf3, 0xf8, 0xc7, 0xfc, 0x0f, 
0xff, 0xf8, 0xc7, 0xf8, 0x07, 0xff, 0xf8, 0xcf, 
0xf0, 0x03, 0xfd, 0xf8, 0xdf, 0xe0, 0x00, 0xfc, 
0x78, 0xdf, 0xe0, 0x00, 0x3e, 0x3c, 0xff, 0x80, 
0x00, 0x0f, 0x9d, 0xfe, 0x00, 0x00, 0x01, 0x83, 
0xf8, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 
0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 0x07, 0xc0, 
0x00, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x00, 
0x05, 0x80, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 
0x00, 0x18, 0x04, 0x00, 0x00, 0x00, 0x38, 0x0c, 
0x00, 0x00, 0x00, 0xfc, 0x0c, 0x00, 0x00, 0x07, 
0xfe, 0x0c, 0x00, 0x00, 0x1f, 0xff, 0xfc, 0x00, 
0x00, 0x07, 0xff, 0xfc, 0x00, 0x00, 0x01, 0xff, 
0xcc, 0x00, 0x00, 0x01, 0xff, 0xc4, 0x00, 0x00, 
0x00, 0xff, 0xc4, 0x00, 0x00, 0x00, 0xff, 0xc4, 
0x00, 0x00, 0x00, 0xff, 0xc4, 0x00, 0x00, 0x00, 
0xff, 0xc4, 0x00, 0x00, 0x00, 0xff, 0xc4, 0x00, 
0x00, 0x20, 0xff, 0xc4, 0x00, 0x00, 0x30, 0xff, 
0xc4, 0x00, 0x00, 0x3f, 0xff, 0xc4, 0x00, 0x00, 
0x1f, 0xff, 0xc4, 0x7f, 0xc0, 0x1f, 0xff, 0xc7, 
0xff, 0xf0, 0x1f, 0xff, 0xc6, 0x1f, 0xf8, 0x1f, 
0xff, 0xc7, 0x0f, 0xfc, 0x0f, 0xff, 0xc7, 0x87, 
0xfc, 0x08, 0xff, 0xc7, 0x83, 0xfc, 0x00, 0xff, 
0xc7, 0x83, 0xfc, 0x00, 0xff, 0xc4, 0x03, 0xfc, 
0x00, 0xff, 0xc4, 0x03, 0xfc, 0x00, 0xff, 0xc4, 
0x03, 0xfc, 0xff, 0xff, 0xc4, 0x03, 0xf8, 0xff, 
0xff, 0xc4, 0x07, 0xf0, 0xf8, 0x3f, 0xc4, 0x07, 
0xe0, 0xf8, 0x07, 0xe4, 0x1f, 0xc0, 0x7c, 0x00, 
0xfe, 0x3e, 0x00, 0x00, 0x40, 0x00, 0x18, 0x00, 
0x00, 0x70, 0x00, 0x7c, 0x00, 0x00, 0x1e, 0x03, 
0xfe, 0x00, 0x00, 0x07, 0xff, 0xff, 0x00, 0x00, 
0x01, 0xff, 0xff, 0x80, 0x00, 0x00, 0xff, 0xff, 
0xe0, 0x00, 0x3f, 0xff, 0xfc, 0x00, 0x00, 0xfc, 
0x01, 0xf8, 0x00, 0x03, 0xf8, 0x01, 0xfc, 0x00, 
0x0f, 0xf0, 0x01, 0xbf, 0x00, 0x1f, 0xe0, 0x01, 
0x9f, 0x80, 0x3f, 0xe3, 0x01, 0x9f, 0xe0, 0x7f, 
0xc3, 0x81, 0x8f, 0xf0, 0x7f, 0xc3, 0xe1, 0x8f, 
0xf0, 0xff, 0xc3, 0xf9, 0x87, 0xf8, 0xff, 0xc3, 
0xf9, 0x87, 0xfc, 0xff, 0xc3, 0xf9, 0x83, 0xfc, 
0xff, 0xc3, 0xf9, 0x83, 0xfe, 0xff, 0xc3, 0xf9, 
0x83, 0xfe, 0xff, 0xc3, 0xf9, 0x83, 0xfe, 0xff, 
0xc3, 0xf9, 0x83, 0xfe, 0xff, 0xc3, 0xf9, 0x83, 
0xfe, 0xff, 0xc3, 0xf9, 0x83, 0xfe, 0xff, 0xc3, 
0xf9, 0x83, 0xfe, 0xff, 0xc3, 0xf9, 0x83, 0xfe, 
0x7f, 0xc3, 0xf9, 0x83, 0xfe, 0x7f, 0xc3, 0xf9, 
0x83, 0xfe, 0x3f, 0xc3, 0xf9, 0x87, 0xfc, 0x3f, 
0xe3, 0xf9, 0x87, 0xfc, 0x0f, 0xe3, 0xf9, 0x87, 
0xf8, 0x07, 0xf3, 0xf9, 0x8f, 0xf0, 0x07, 0xf3, 
0xf9, 0x8f, 0xe0, 0x01, 0xf8, 0xf9, 0x9f, 0xc0, 
0x00, 0x7c, 0x79, 0xff, 0x80, 0x00, 0x1e, 0x3d, 
0xff, 0x00, 0x00, 0x07, 0x0f, 0xfc, 0x00, 0x00, 
0x00, 0x07, 0x80, 0x00, 0x00, 0x00, 0x0f, 0x80, 
0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x00, 
0x0f, 0xc0, 0x00, 0x00, 0x00, 0x0d, 0x80, 0x00, 
0x00, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x0c, 
0x00, 0x00, 0x00, 0x38, 0x0c, 0x00, 0x60, 0x00, 
0x7c, 0x0c, 0x00, 0xf0, 0x00, 0xff, 0x0c, 0x07, 
0xfc, 0x1f, 0xff, 0xfc, 0x1f, 0xff, 0x1f, 0xff, 
0xfc, 0x0f, 0xfe, 0x03, 0xff, 0xfc, 0x0f, 0xfc, 
0x01, 0xff, 0xcc, 0x0f, 0xfc, 0x00, 0xff, 0xcc, 
0x0f, 0xf8, 0x00, 0xff, 0xcc, 0x0f, 0xf0, 0x00, 
0xff, 0xcc, 0x0f, 0xe0, 0x00, 0xff, 0xcc, 0x0f, 
0xe0, 0x00, 0xff, 0xcc, 0x0f, 0xc0, 0x00, 0xff, 
0xcc, 0x1f, 0x80, 0x18, 0xff, 0xcc, 0x3f, 0x00, 
0x1f, 0xff, 0xcc, 0x3c, 0x00, 0x0f, 0xff, 0xff, 
0xf8, 0x00, 0x0f, 0xff, 0xff, 0xf8, 0x00, 0x0f, 
0xff, 0xc4, 0x7f, 0x80, 0x0f, 0xff, 0xc4, 0x1f, 
0xe0, 0x0f, 0xff, 0xc4, 0x1f, 0xf0, 0x06, 0xff, 
0xc4, 0x0f, 0xf8, 0x00, 0xff, 0xc4, 0x0f, 0xfc, 
0x00, 0xff, 0xc4, 0x07, 0xfc, 0x00, 0xff, 0xc4, 
0x07, 0xfc, 0x00, 0xff, 0xc4, 0x07, 0xfc, 0x1f, 
0xff, 0xc6, 0x0f, 0xf8, 0x7f, 0xff, 0xc6, 0x0f, 
0xf8, 0xfc, 0x1f, 0xe6, 0x1f, 0xe0, 0xfc, 0x01, 
0xff, 0xff, 0x80, 0xfc, 0x00, 0x1f, 0xfc, 0x00, 
0x7c, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 
0x00, 0x00, 0xff, 0x80, 0x1e, 0x00, 0x00, 0xc0, 
0xc0, 0x1f, 0xf0, 0x00, 0xc0, 0x70, 0x3f, 0xff, 
0x80, 0xc0, 0x30, 0xff, 0xf8, 0xe0, 0xf0, 0x1f, 
0xff, 0xf0, 0xf0, 0x3f, 0xff, 0xff, 0xc0, 0xf0, 
0x3f, 0xff, 0xff, 0x80, 0xf8, 0x0f, 0xff, 0xfe, 
0x01, 0xf8, 0x03, 0xff, 0xf0, 0x03, 0xfc, 0x00, 
0x0f, 0xe0, 0x0f, 0xfc, 0x00, 0x00, 0x60, 0xff, 
0xfc, 0x00, 0x00, 0x7f, 0xff, 0xfc, 0x00, 0x03, 
0xff, 0xff, 0xf8, 0x00, 0x1f, 0xff, 0xff, 0xf8, 
0x00, 0x7f, 0xff, 0xff, 0xf0, 0x01, 0xff, 0xff, 
0xff, 0xf0, 0x03, 0xff, 0xff, 0xff, 0xc0, 0x07, 
0xff, 0xff, 0xff, 0x80, 0x0f, 0xff, 0xff, 0xfe, 
0x00, 0x0f, 0xff, 0xff, 0xe0, 0x00, 0x0f, 0xff, 
0xff, 0xc0, 0x00, 0x0f, 0xff, 0xe0, 0xe0, 0x00, 
0x0f, 0xfc, 0x00, 0xe0, 0x00, 0x0f, 0xe0, 0x00, 
0xf8, 0x30, 0x0f, 0xc0, 0x01, 0xf8, 0x3c, 0x0f, 
0x80, 0x07, 0xfe, 0x3c, 0x07, 0x80, 0x0f, 0xff, 
0xfc, 0x03, 0x80, 0x3f, 0xf8, 0xfc, 0x01, 0xc1, 
0xff, 0xe0, 0x10, 0x00, 0xff, 0xff, 0x00, 0x00, 
0x00, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x1c, 0x00, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 
0x00, 0x00, 0x37, 0x00, 0x00, 0x00, 0x00, 0x37, 
0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00, 0x00, 
0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 
0x00, 0x00, 0x00, 0x60, 0x00, 0x00, 0x01, 0xe0, 
0x60, 0x00, 0x00, 0x07, 0xf8, 0x60, 0x00, 0x00, 
0x7f, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xff, 0xe0, 
0x00, 0x00, 0x1f, 0xfe, 0x60, 0x00, 0x00, 0x0f, 
0xfc, 0x20, 0x00, 0x00, 0x0f, 0xfc, 0x20, 0x00, 
0x00, 0x0f, 0xfc, 0x20, 0x00, 0x00, 0x0f, 0xfc, 
0x20, 0x00, 0x00, 0x0f, 0xfc, 0x20, 0x00, 0x00, 
0x0f, 0xfc, 0x20, 0x00, 0x01, 0x0f, 0xfc, 0x20, 
0x00, 0x01, 0x8f, 0xfc, 0x20, 0x00, 0x01, 0xff, 
0xfc, 0x30, 0x00, 0xc0, 0xff, 0xfc, 0x30, 0x60, 
0xe0, 0xff, 0xfc, 0x30, 0xe0, 0xf0, 0xff, 0xfc, 
0x33, 0xe0, 0xf8, 0x7f, 0xfc, 0x33, 0xe0, 0xf8, 
0x7f, 0xfc, 0x3f, 0xe0, 0xfc, 0x47, 0xfc, 0x3f, 
0xe0, 0xfe, 0x07, 0xfc, 0x3f, 0xe0, 0xfe, 0x07, 
0xfc, 0x3f, 0xe0, 0xff, 0x07, 0xfc, 0x3f, 0xe0, 
0xff, 0x07, 0xfc, 0x3f, 0xe0, 0xff, 0x87, 0xfc, 
0x3f, 0xe0, 0xff, 0x87, 0xfc, 0x3f, 0xe0, 0xff, 
0xc7, 0xfc, 0x7f, 0xe0, 0xff, 0xef, 0x1e, 0x7f, 
0xe0, 0x01, 0xfe, 0x07, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0xe0, 0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 
0x00, 0x00, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 
0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 
0x03, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 
0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x00, 0x01, 
0xff, 0xf8, 0x00, 0x00, 0x00, 0x0f, 0xe3, 0x8e, 
0x00, 0x00, 0x00, 0x7f, 0xc3, 0x83, 0x80, 0x00, 
0x07, 0xff, 0xc3, 0x81, 0xe0, 0x00, 0x03, 0xff, 
0xc3, 0x80, 0xfc, 0x00, 0x00, 0xff, 0xc1, 0x80, 
0xf8, 0x00, 0x00, 0xff, 0xc1, 0x80, 0x70, 0x00, 
0x00, 0xff, 0xc1, 0x80, 0x70, 0x00, 0x00, 0xff, 
0xc1, 0x80, 0x60, 0x00, 0x00, 0xff, 0xc1, 0x80, 
0x60, 0x00, 0x00, 0xff, 0xc1, 0x80, 0x20, 0x00, 
0x10, 0xff, 0xc1, 0x80, 0x20, 0x00, 0x18, 0xff, 
0xc1, 0x80, 0x20, 0x00, 0x1f, 0xff, 0xc1, 0xff, 
0xe0, 0x00, 0x0f, 0xff, 0xc1, 0xff, 0xe0, 0x00, 
0x0f, 0xff, 0xc1, 0x9e, 0x60, 0x00, 0x0f, 0xff, 
0xc1, 0x80, 0x20, 0x00, 0x07, 0xff, 0xc1, 0x80, 
0x20, 0x00, 0x07, 0xff, 0xc1, 0x80, 0x60, 0x00, 
0x00, 0xff, 0xc1, 0x80, 0x70, 0x00, 0x00, 0xff, 
0xc1, 0x80, 0x70, 0x00, 0x00, 0xff, 0xc1, 0x80, 
0x70, 0x00, 0x00, 0xff, 0xc1, 0x80, 0xf8, 0x00, 
0x00, 0xff, 0xc1, 0x81, 0xfc, 0x00, 0x01, 0xff, 
0xe1, 0x83, 0xfe, 0x00, 0x7f, 0xff, 0xf1, 0x8f, 
0xff, 0x80, 0xff, 0xff, 0x81, 0x8f, 0xff, 0x80, 
0xf8, 0x3f, 0x01, 0x80, 0xfe, 0x00, 0xf8, 0x1e, 
0x01, 0x80, 0x78, 0x00, 0x00, 0x00, 0x01, 0x80, 
0x30, 0x00, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 
0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x00, 
0x00, 0xce, 0x00, 0x00, 0x00, 0x00, 0x00, 0x9e, 
0x00, 0x00, 0x00, 0x00, 0x01, 0x9c, 0x00, 0x00, 
0x00, 0x00, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x01, 0xc0, 
0x00, 0x00, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 
0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00, 0x00, 0x01, 
0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7f, 0xfe, 
0x00, 0x00, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 
0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x00, 0x00, 
0x7f, 0xf8, 0x00, 0x00, 0x00, 0x00, 0xff, 0xf8, 
0x00, 0x00, 0x00, 0x00, 0xff, 0xe8, 0x00, 0x00, 
0x00, 0x01, 0xff, 0xcc, 0x00, 0x00, 0x01, 0x01, 
0xff, 0xc6, 0x00, 0x00, 0x01, 0x83, 0xff, 0xc6, 
0x00, 0x00, 0x01, 0xff, 0xff, 0x82, 0x00, 0x00, 
0x01, 0xff, 0xff, 0x83, 0x00, 0x00, 0x00, 0xff, 
0xff, 0x81, 0x00, 0x00, 0x00, 0xff, 0xfe, 0x81, 
0x80, 0x00, 0x00, 0xff, 0xfc, 0x80, 0x80, 0x00, 
0x00, 0xff, 0xfc, 0x80, 0xc0, 0x00, 0x00, 0x7f, 
0xf8, 0x80, 0x40, 0x00, 0x00, 0x7f, 0xf0, 0x80, 
0x60, 0x00, 0x00, 0xff, 0xf0, 0x80, 0x60, 0x00, 
0x00, 0xff, 0xf0, 0x80, 0x70, 0x00, 0x01, 0xff, 
0xf0, 0xc0, 0x78, 0x00, 0x03, 0xff, 0xf0, 0xc0, 
0xfc, 0x00, 0x7f, 0xff, 0xf0, 0x81, 0xfe, 0x00, 
0xff, 0xff, 0xf0, 0x87, 0xff, 0xc0, 0xf0, 0x7f, 
0x80, 0xc3, 0xff, 0xc0, 0xf8, 0x3e, 0x00, 0xc0, 
0x7c, 0x00, 0xfc, 0x00, 0x00, 0xc0, 0x38, 0x00, 
0x78, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x7c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x80, 0xc0, 0x00, 0x00, 0x00, 0x00, 
0x01, 0xc0, 0xc0, 0x18, 0x00, 0x00, 0x00, 0x03, 
0xe0, 0x40, 0x3e, 0x00, 0x00, 0x00, 0x1f, 0xf8, 
0x47, 0xfe, 0x00, 0x00, 0x00, 0x3f, 0xfe, 0x47, 
0xff, 0xc0, 0x00, 0x00, 0x1f, 0xfe, 0x43, 0xff, 
0xe0, 0x00, 0x00, 0x0f, 0xfc, 0x43, 0xff, 0x80, 
0x00, 0x00, 0x0f, 0xfc, 0x63, 0xff, 0x80, 0x00, 
0x00, 0x0f, 0xfc, 0x63, 0xff, 0x80, 0x00, 0x00, 
0x1f, 0xfc, 0x63, 0xff, 0x80, 0x00, 0x00, 0x1f, 
0xfc, 0x67, 0xff, 0x80, 0x00, 0x00, 0x1f, 0xf6, 
0x67, 0xfc, 0xc0, 0x00, 0x00, 0x1f, 0xf2, 0x6f, 
0xfc, 0xc0, 0x00, 0x04, 0x3f, 0xe3, 0x6f, 0xfc, 
0x40, 0x00, 0x07, 0xff, 0xe3, 0x7f, 0xf8, 0x60, 
0x00, 0x07, 0xff, 0xe1, 0xff, 0xf8, 0x60, 0x00, 
0x03, 0xff, 0xc1, 0xff, 0xf8, 0x20, 0x00, 0x03, 
0xff, 0xc0, 0xff, 0xf0, 0x30, 0x00, 0x03, 0xff, 
0xc0, 0xff, 0xf0, 0x30, 0x00, 0x02, 0xff, 0xc0, 
0xff, 0xe0, 0x10, 0x00, 0x00, 0xff, 0x80, 0x7f, 
0xe0, 0x18, 0x00, 0x00, 0xff, 0x80, 0x7f, 0xe0, 
0x18, 0x00, 0x00, 0xff, 0x80, 0xff, 0xc0, 0x1c, 
0x00, 0x01, 0xff, 0x80, 0xff, 0xc0, 0x1e, 0x00, 
0x01, 0xff, 0x81, 0xff, 0xc0, 0x3f, 0x00, 0xff, 
0xff, 0xc3, 0xff, 0xe0, 0x7f, 0x80, 0xff, 0xff, 
0xc7, 0xff, 0xf0, 0xff, 0xe0, 0xe1, 0xfe, 0x01, 
0xff, 0xf0, 0xff, 0x80, 0xe0, 0x78, 0x00, 0x3f, 
0x00, 0x0f, 0x00, 0xf0, 0x00, 0x00, 0x0c, 0x00, 
0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x00, 0xc0, 
0x18, 0x00, 0x18, 0x00, 0xf0, 0x7c, 0x00, 0x3c, 
0x00, 0x7f, 0xfc, 0x00, 0x7f, 0x00, 0x3f, 0xff, 
0x01, 0xff, 0xc0, 0x1f, 0xff, 0x87, 0xff, 0xf8, 
0x0f, 0xff, 0x87, 0xff, 0xf0, 0x03, 0xfe, 0x0f, 
0xfe, 0x00, 0x00, 0x7e, 0x0f, 0xfc, 0x00, 0x00, 
0x06, 0x1f, 0xfc, 0x00, 0x00, 0x03, 0x3f, 0xf0, 
0x00, 0x00, 0x03, 0x3f, 0xf0, 0x00, 0x00, 0x00, 
0xff, 0xe0, 0x00, 0x00, 0x00, 0xff, 0xc0, 0x00, 
0x00, 0x00, 0xff, 0xc0, 0x00, 0x00, 0x21, 0xff, 
0x80, 0x00, 0x00, 0x3f, 0xff, 0xc0, 0x00, 0x00, 
0x3f, 0xff, 0xe0, 0x00, 0x00, 0x3f, 0xff, 0xf0, 
0x00, 0x00, 0x1f, 0xff, 0xf0, 0x00, 0x00, 0x07, 
0xfe, 0x00, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 
0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 0x1f, 0xf9, 
0x80, 0x00, 0x00, 0x3f, 0xf8, 0xfe, 0x00, 0x00, 
0x3f, 0xf8, 0xff, 0x00, 0x3f, 0xff, 0xf8, 0x7f, 
0x80, 0xff, 0xff, 0xf8, 0x7f, 0xc0, 0xf0, 0x7f, 
0xf0, 0x3f, 0xc0, 0xf0, 0x1f, 0x80, 0x1c, 0x60, 
0x78, 0x0e, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 
0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 
0x00, 0x00, 0x00, 0x00, 0xf8, 0x00, 0x00, 0x00, 
0x00, 0x00, 0xd8, 0x00, 0x00, 0x00, 0x00, 0x00, 
0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 
0x00, 0x00, 0x00, 0x01, 0xc0, 0x00, 0x00, 0x00, 
0x00, 0x03, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x07, 
0xc0, 0x00, 0x00, 0x00, 0x00, 0x0f, 0xe0, 0x00, 
0x00, 0x00, 0x01, 0xff, 0xfc, 0x00, 0x00, 0x00, 
0x01, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x7f, 
0xf8, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 
0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 
0x00, 0x3f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x3f, 
0xf0, 0x00, 0x00, 0x00, 0x00, 0x3f, 0xf0, 0x00, 
0x00, 0x00, 0x80, 0x7f, 0xf0, 0x00, 0x00, 0x00, 
0x80, 0xff, 0xf0, 0x00, 0x00, 0x00, 0xe0, 0xff, 
0xf0, 0x00, 0x00, 0x00, 0x7f, 0xff, 0xf8, 0x00, 
0x00, 0x00, 0x7f, 0xff, 0xd8, 0x00, 0x00, 0x00, 
0x7f, 0xff, 0xcc, 0x00, 0x00, 0x00, 0x7f, 0xff, 
0xc4, 0x00, 0x00, 0x00, 0x7f, 0xfe, 0xc6, 0x00, 
0x00, 0x00, 0x1f, 0xfc, 0xc3, 0x00, 0x00, 0x00, 
0x1f, 0xf8, 0xc1, 0x80, 0x00, 0x00, 0x3f, 0xf8, 
0xc1, 0x80, 0x00, 0x00, 0x7f, 0xf0, 0xc0, 0xc0, 
0x00, 0x00, 0xff, 0xe0, 0x80, 0xe0, 0x00, 0x01, 
0xff, 0xe0, 0x80, 0xf0, 0x00, 0x03, 0xff, 0xe0, 
0x80, 0xfc, 0x00, 0xff, 0xff, 0xf0, 0x81, 0xff, 
0x80, 0xff, 0xff, 0xe0, 0x8f, 0xff, 0x80, 0xf1, 
0xfe, 0x00, 0x01, 0xfc, 0x00, 0xf8, 0xf8, 0x00, 
0x00, 0x78, 0x00, 0x30, 0x60, 0x00, 0x00, 0x30, 
0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 
0x7c, 0x00, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 
0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x00, 0xf8, 
0x00, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00, 0x03, 
0x00, 0xc0, 0x00, 0x00, 0x03, 0x80, 0xc0, 0x03, 
0x00, 0x07, 0xe0, 0xc0, 0x07, 0x00, 0x1f, 0xff, 
0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xe0, 
0xff, 0xfc, 0xff, 0xff, 0xf0, 0x7f, 0xfc, 0xc0, 
0x7f, 0xf0, 0x3f, 0xff, 0xc0, 0x1f, 0xc0, 0x0f, 
0xff, 0xc0, 0x0f, 0x80, 0x0f, 0xff, 0xc0, 0x0f, 
0x80, 0x03, 0xff, 0xc0, 0x07, 0x00, 0x03, 0xff, 
0xe0, 0x03, 0x00, 0x01, 0xff, 0xf0, 0x03, 0x00, 
0x00, 0x7f, 0xf8, 0x02, 0x00, 0x00, 0x3f, 0xfc, 
0x00, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x00, 
0x07, 0xff, 0x80, 0x00, 0x00, 0x03, 0xff, 0xc0, 
0x00, 0x00, 0x01, 0xff, 0xe0, 0x00, 0x02, 0x00, 
0xff, 0xf0, 0x00, 0x06, 0x00, 0x7f, 0xf8, 0x00, 
0x06, 0x00, 0x7f, 0xfc, 0x00, 0x07, 0x00, 0x7f, 
0xff, 0x00, 0x0f, 0x00, 0x6f, 0xff, 0x00, 0x1f, 
0x80, 0x67, 0xff, 0xc0, 0x3f, 0xf0, 0x63, 0xff, 
0xc0, 0x3f, 0xff, 0xff, 0xfe, 0x00, 0x0f, 0xfc, 
0x7f, 0xfc, 0x00, 0x07, 0xc0, 0x00, 0xfc, 0x00, 
0x03, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x00, 
0x08, 0x00, 0x0c, 0x00, 0x00, 0x1e, 0x00, 0xe0, 
0xff, 0x83, 0xf8, 0x7f, 0xff, 0xff, 0x7f, 0xff, 
0xfc, 0x7f, 0x83, 0xfc, 0x7f, 0x83, 0xfc, 0x7f, 
0x83, 0xfc, 0x7f, 0x83, 0xfc, 0x0f, 0xff, 0xfc, 
0x01, 0xff, 0xfc, 0x07, 0x83, 0xfc, 0x1c, 0x03, 
0xfc, 0x30, 0x07, 0xfc, 0x7f, 0xff, 0xfc, 0x7e, 
0xff, 0xff, 0x7c, 0x3f, 0xfc, 0x3c, 0x0f, 0x80, 
0x00, 0x03, 0x00, 0x00, 0x1e, 0x00, 0x00, 0xff, 
0x80, 0x7f, 0xff, 0xf8, 0x3f, 0xfc, 0xff, 0x1f, 
0xf0, 0xfe, 0x1f, 0xc0, 0xfe, 0x1f, 0x80, 0xfe, 
0x1f, 0x80, 0xfe, 0x1f, 0x80, 0xfe, 0x1f, 0x80, 
0xfe, 0x1f, 0x80, 0xfe, 0x1f, 0x80, 0xfe, 0x1f, 
0x81, 0xfe, 0x1f, 0xff, 0xff, 0x1f, 0xff, 0xff, 
0x1f, 0xc3, 0xf8, 0x1f, 0xc1, 0xe0, 0x1f, 0xc0, 
0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 
0xc0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 
0x1f, 0xc0, 0x00, 0x7f, 0xc0, 0x00, 0xff, 0xe0, 
0x00, 0x3f, 0xe0, 0x00, 0x0f, 0x80, 0x00, 0x00, 
0xf0, 0x00, 0x03, 0xf8, 0x00, 0x7f, 0xff, 0x00, 
0x7f, 0xf0, 0x00, 0x7f, 0xc0, 0x00, 0x7f, 0x00, 
0x00, 0x7f, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 
0x00, 0x00, 0x7f, 0x00, 0x00, 0x7f, 0x02, 0x00, 
0x7f, 0x03, 0x00, 0x7f, 0x03, 0x00, 0x7f, 0x07, 
0x80, 0xff, 0x8f, 0xc0, 0x01, 0xff, 0xc0, 0x00, 
0x1f, 0x00, 0x00, 0x06, 0x00, 0x00, 0x78, 0x00, 
0x01, 0xfc, 0x00, 0x07, 0xff, 0x80, 0xff, 0xff, 
0xfc, 0xff, 0xe3, 0xf8, 0x7f, 0x83, 0xf8, 0x7f, 
0x03, 0xf8, 0x7e, 0x03, 0xf8, 0x7e, 0x03, 0xf8, 
0x7e, 0x03, 0xf8, 0x7e, 0x03, 0xf8, 0x7e, 0x03, 
0xf8, 0x7f, 0x03, 0xf8, 0x7f, 0x83, 0xf8, 0x7f, 
0xe7, 0xf8, 0x3f, 0xff, 0xf8, 0x07, 0xc3, 0xf8, 
0x01, 0xc3, 0xf8, 0x00, 0x03, 0xf8, 0x00, 0x03, 
0xf8, 0x00, 0x03, 0xf8, 0x00, 0x03, 0xf8, 0x00, 
0x07, 0xf8, 0x00, 0x1f, 0xfc, 0x00, 0x3f, 0xfe, 
0x0f, 0xff, 0xfc, 0x07, 0xff, 0x80, 0x01, 0xfe, 
0x00, 0x00, 0x78, 0x00, 0x00, 0x70, 0x00, 0x00, 
0xfc, 0x00, 0x07, 0xff, 0x80, 0xff, 0xff, 0xf8, 
0x7f, 0xf8, 0x00, 0x7f, 0xe0, 0x00, 0x7f, 0x80, 
0x00, 0x7f, 0x80, 0x00, 0x7f, 0xe0, 0x00, 0x7f, 
0x1e, 0x00, 0x7f, 0x07, 0xf8, 0x7f, 0x0f, 0xfc, 
0x7f, 0x1f, 0xf0, 0x7f, 0xbf, 0xc0, 0xff, 0xff, 
0x80, 0xff, 0xff, 0x00, 0x03, 0xfe, 0x00, 0x00, 
0x7c, 0x00, 0x00, 0x18, 0x00, 0x00, 0x40, 0x00, 
0x01, 0xe0, 0x00, 0x0f, 0xf8, 0x00, 0x7f, 0xff, 
0x00, 0x3f, 0xf0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 
0xc0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 
0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 
0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 0xff, 
0xf8, 0x00, 0xff, 0xf8, 0x00, 0xff, 0xf8, 0x00, 
0xff, 0xfc, 0x00, 0x1f, 0xc4, 0x00, 0x1f, 0xc0, 
0x00, 0x1f, 0xc0, 0x00, 0x1f, 0xc0, 0x00, 0x1f, 
0xc6, 0x00, 0x1f, 0xc6, 0x00, 0x1f, 0xcf, 0x00, 
0x7f, 0xff, 0x80, 0x47, 0xff, 0xc0, 0x00, 0x7f, 
0x00, 0x00, 0x1e, 0x00, 0x00, 0x0e, 0x00, 0x78, 
0x00, 0x00, 0xfc, 0x03, 0xf8, 0xf8, 0x00, 0x7c, 
0xf8, 0xc0, 0x3e, 0x7e, 0x00, 0x7e, 0x00, 0x00, 
0x7e, 0x00, 0x80, 0xfe, 0x01, 0xe0, 0xfe, 0x0f, 
0xff, 0xfe, 0xff, 0xff, 0xfc, 0x7f, 0xe1, 0xfc, 
0x3f, 0xc1, 0xfc, 0x3f, 0x81, 0xfc, 0x3f, 0x81, 
0xfc, 0x3f, 0x81, 0xfc, 0x3f, 0x81, 0xfc, 0x3f, 
0x81, 0xfc, 0x3f, 0x81, 0xfc, 0x3f, 0x83, 0xfc, 
0x3f, 0x8f, 0xfe, 0x3f, 0x9f, 0xfe, 0x7f, 0xff, 
0xfe, 0x07, 0xff, 0xe0, 0x00, 0x7f, 0x00, 0x00, 
0x1c, 0x00, 0x08, 0x00, 0x20, 0x3e, 0x00, 0x70, 
0xff, 0x81, 0xfc, 0x7f, 0xc3, 0xfe, 0x3f, 0x03, 
0xfc, 0x3f, 0x03, 0xf8, 0x3f, 0x03, 0xf8, 0x3f, 
0x03, 0xf8, 0x3f, 0x03, 0xf8, 0x3f, 0x03, 0xf8, 
0x3f, 0x03, 0xf8, 0x3f, 0x03, 0xf8, 0x3f, 0x07, 
0xf8, 0x3f, 0x9f, 0xf8, 0x3f, 0xff, 0xfc, 0x3f, 
0x9f, 0xf0, 0x3f, 0x87, 0x80, 0x3f, 0x83, 0x00, 
0x3f, 0x80, 0x00, 0x3f, 0x80, 0x00, 0x3f, 0x80, 
0x00, 0x3f, 0x80, 0x00, 0x3f, 0x80, 0x00, 0x7f, 
0x80, 0x00, 0xff, 0x80, 0x00, 0x7f, 0xc0, 0x00, 
0x1f, 0x00, 0x00, 0x0c, 0x00, 0x00, 0x0c, 0x00, 
0x7f, 0x80, 0xff, 0xc0, 0x7f, 0x00, 0x7f, 0x00, 
0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 
0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 
0xff, 0x80, 0xff, 0xc0, 0x3f, 0x00, 0x1e, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
0x0c, 0x00, 0x3e, 0x00, 0x3f, 0x00, 0xff, 0xc0, 
0x7f, 0x80, 0x1f, 0x00, 0x0c, 0x00, 0x5c, 0x00, 
0xcf, 0x00, 0xef, 0xe0, 0xef, 0xe0, 0xef, 0xe0, 
0xef, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 
0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 
0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 
0x0f, 0xe0, 0x1f, 0xe0, 0x7f, 0xe0, 0x1f, 0xf0, 
0x07, 0xc0, 0x03, 0x80, 0x00, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x00, 0x00, 0x03, 0xc0, 0x07, 0xe0, 
0x1f, 0xf8, 0x0f, 0xf0, 0x03, 0xc0, 0x01, 0xc0, 
0x0e, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x78, 0x00, 
0xff, 0xe0, 0xff, 0x80, 0x3f, 0x80, 0xfe, 0x00, 
0x3f, 0x80, 0xfc, 0x00, 0x3f, 0x80, 0xf8, 0x00, 
0x3f, 0x81, 0xf0, 0x00, 0x3f, 0x81, 0xe0, 0x00, 
0x3f, 0xc3, 0x80, 0x00, 0x3f, 0xfe, 0x00, 0x00, 
0x1f, 0x83, 0x00, 0x00, 0x1f, 0x81, 0x80, 0x00, 
0x1f, 0x80, 0xe0, 0x00, 0x1f, 0x81, 0xf8, 0x00, 
0x1f, 0x81, 0xfe, 0x00, 0x1f, 0x81, 0xf8, 0x00, 
0x1f, 0x80, 0x70, 0x00, 0x1f, 0x80, 0x00, 0x00, 
0x3f, 0x80, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 
0x3f, 0x80, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 
0x3f, 0xc0, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 
0x3f, 0xc0, 0x00, 0x00, 0xff, 0xf0, 0x00, 0x00, 
0x7f, 0xc0, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 
0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x1f, 0x00, 
0xff, 0xc0, 0x7f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 
0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 
0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 
0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 
0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 
0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x7f, 0xc0, 
0xff, 0xc0, 0x3f, 0x80, 0x0e, 0x00, 0x00, 0x00, 
0x00, 0x00, 0x80, 0x0e, 0x00, 0x78, 0x03, 0xf0, 
0x1f, 0xc3, 0xfe, 0x0f, 0xf8, 0xff, 0x81, 0xfc, 
0x07, 0xe0, 0x7f, 0x01, 0xfc, 0x07, 0xe0, 0x3f, 
0x01, 0xfc, 0x07, 0xe0, 0x3f, 0x01, 0xfc, 0x07, 
0xe0, 0x3f, 0x00, 0xfc, 0x07, 0xe0, 0x3f, 0x00, 
0xfc, 0x07, 0xe0, 0x3f, 0x00, 0xfc, 0x07, 0xe0, 
0x3f, 0x00, 0xfc, 0x07, 0xe0, 0x3f, 0x00, 0xfc, 
0x07, 0xf0, 0x3f, 0x81, 0xfe, 0x0f, 0xf0, 0x3f, 
0xc3, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0xff, 0xff, 
0xf8, 0x7f, 0x80, 0xf8, 0x03, 0xc0, 0x0e, 0x00, 
0x38, 0x00, 0x80, 0x04, 0x00, 0x00, 0x00, 0x00, 
0x1e, 0x00, 0xf8, 0x3f, 0x81, 0xfe, 0xff, 0x83, 
0xfc, 0x7f, 0x03, 0xf8, 0x7f, 0x03, 0xf8, 0x7f, 
0x03, 0xf8, 0x3f, 0x03, 0xf8, 0x3f, 0x03, 0xf8, 
0x3f, 0x03, 0xf8, 0x3f, 0x03, 0xf8, 0x3f, 0x03, 
0xf8, 0x3f, 0x03, 0xfc, 0x7f, 0x87, 0xfe, 0xff, 
0xff, 0xfc, 0x7f, 0x81, 0xf0, 0x1e, 0x00, 0x60, 
0x01, 0xf0, 0x00, 0x03, 0xfc, 0x00, 0xff, 0xe7, 
0xe0, 0xff, 0xc7, 0xf0, 0xff, 0x87, 0xf0, 0xfe, 
0x07, 0xf0, 0x7e, 0x07, 0xf0, 0xfe, 0x07, 0xf0, 
0xfe, 0x07, 0xf0, 0xfe, 0x07, 0xf0, 0xfe, 0x1f, 
0xf0, 0xfe, 0x7f, 0xf0, 0xfe, 0xff, 0xf0, 0x0f, 
0xff, 0xf0, 0x03, 0xfe, 0x00, 0x00, 0xf8, 0x00, 
0x06, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x3f, 0xc0, 
0x00, 0x1f, 0x80, 0x00, 0x1f, 0x80, 0x00, 0x1f, 
0x80, 0x00, 0x1f, 0x80, 0x20, 0x1f, 0x80, 0x78, 
0x1f, 0xe7, 0xfe, 0x1f, 0x83, 0xfe, 0x1f, 0x80, 
0xfe, 0x1f, 0x80, 0xfe, 0x1f, 0x80, 0xfe, 0x1f, 
0x80, 0xfe, 0x1f, 0x80, 0xfe, 0x1f, 0x80, 0xfe, 
0x1f, 0x80, 0xfe, 0x3f, 0xc0, 0xfe, 0xff, 0xe1, 
0xfe, 0x1f, 0xff, 0xff, 0x0f, 0x00, 0xfc, 0x00, 
0x00, 0x30, 0x00, 0x01, 0xc0, 0x00, 0x07, 0xf0, 
0x00, 0x0f, 0xf8, 0x00, 0x03, 0xf0, 0x00, 0x03, 
0xe0, 0x00, 0x03, 0xe0, 0x07, 0x03, 0xe0, 0x1f, 
0x83, 0xe0, 0xff, 0x83, 0xe0, 0xff, 0x03, 0xe0, 
0x7e, 0x03, 0xe0, 0x7e, 0x03, 0xe0, 0x7e, 0x03, 
0xe0, 0x7e, 0x03, 0xf0, 0x7e, 0x03, 0xf0, 0x7e, 
0x03, 0xf0, 0xfe, 0x0f, 0xf0, 0xfe, 0x1f, 0xf0, 
0x7f, 0xff, 0xf8, 0x0f, 0xff, 0xc0, 0x00, 0xfc, 
0x00, 0x00, 0x30, 0x00, 0x03, 0x00, 0x00, 0x1f, 
0x80, 0x00, 0x3f, 0xc0, 0x00, 0x1f, 0x80, 0x00, 
0x1f, 0x80, 0x00, 0x1f, 0x80, 0x00, 0x1f, 0x80, 
0x00, 0x1f, 0x80, 0x00, 0x1f, 0x80, 0x00, 0x1f, 
0x80, 0x00, 0x1f, 0x81, 0x00, 0x1f, 0x83, 0x80, 
0x3f, 0x87, 0x80, 0xff, 0xff, 0xe0, 0x1e, 0x07, 
0x80, 0x00, 0x01, 0x00, 0x00, 0xe0, 0x00, 0x01, 
0xfe, 0x00, 0xff, 0xff, 0xf8, 0x7f, 0xe3, 0xf8, 
0x1f, 0xc3, 0xf8, 0x07, 0x03, 0xf8, 0x00, 0x03, 
0xf8, 0x00, 0xe3, 0xf8, 0xff, 0xfc, 0x08, 0x7f, 
0x04, 0x00, 0x7f, 0x01, 0x00, 0x7f, 0x01, 0x80, 
0x7f, 0x3f, 0xc0, 0x7f, 0x7f, 0xe0, 0xff, 0xff, 
0xf8, 0x00, 0xff, 0xb8, 0x00, 0x1c, 0x06, 0x03, 
0x80, 0x0f, 0xf0, 0x3f, 0xf0, 0x3f, 0x80, 0x3f, 
0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 
0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 
0x80, 0x3f, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x3f, 
0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 
0x80, 0x07, 0x80, 0x01, 0x80, 0x00, 0x80, 0x1e, 
0x00, 0x70, 0xff, 0xff, 0xfc, 0x7f, 0x07, 0xfc, 
0x7f, 0x01, 0xfc, 0x7f, 0x01, 0xf8, 0x7f, 0x01, 
0xf8, 0x7f, 0x01, 0xfc, 0x7f, 0x01, 0xfc, 0x7f, 
0x01, 0xfc, 0x7f, 0x01, 0xfc, 0x7f, 0x01, 0xfc, 
0x7f, 0x01, 0xfc, 0x7f, 0x03, 0xfc, 0xff, 0x03, 
0xfe, 0x3f, 0x01, 0xf8, 0x18, 0x00, 0x30, 0x00, 
0xe0, 0x00, 0x03, 0xf0, 0x00, 0x03, 0xf8, 0x00, 
0x07, 0xf8, 0x00, 0x07, 0xf8, 0x00, 0x07, 0xe0, 
0x00, 0x0f, 0xc0, 0x00, 0x0f, 0x80, 0x00, 0x1f, 
0x80, 0x00, 0x1f, 0x83, 0x00, 0x3f, 0x03, 0x00, 
0x3f, 0x03, 0x80, 0x7f, 0x83, 0xc0, 0xff, 0x07, 
0xf8, 0x3c, 0x07, 0xf0, 0x1c, 0x01, 0xc0, 0x00, 
0x60, 0x03, 0x00, 0x00, 0x01, 0xf8, 0x0f, 0x80, 
0x00, 0x0f, 0xfe, 0x3f, 0xf0, 0x00, 0x07, 0xfc, 
0x3f, 0xe0, 0x00, 0x07, 0xfc, 0x3f, 0x00, 0x00, 
0x07, 0xf0, 0x3f, 0x00, 0x00, 0x07, 0xe0, 0x3e, 
0x00, 0x00, 0x07, 0xe0, 0x7e, 0x00, 0x00, 0x0f, 
0xe1, 0xfc, 0x00, 0x00, 0x1f, 0xc1, 0xfc, 0x08, 
0x00, 0x3f, 0xc1, 0xfc, 0x0c, 0x00, 0x3f, 0xc1, 
0xfc, 0x0c, 0x00, 0xff, 0xc1, 0xfc, 0x0f, 0x00, 
0xff, 0xc7, 0xfc, 0x1f, 0xc0, 0x3e, 0x03, 0xf0, 
0x0f, 0x80, 0x0c, 0x00, 0x60, 0x02, 0x00, 0x1c, 
0x00, 0x30, 0x3f, 0x01, 0xfc, 0xff, 0x0f, 0xff, 
0x1e, 0x0f, 0xfc, 0x06, 0x0f, 0xf0, 0x00, 0x1f, 
0xc0, 0x00, 0xff, 0xc0, 0x00, 0xff, 0x00, 0x00, 
0xfe, 0x00, 0x01, 0xfe, 0x00, 0x03, 0xfe, 0x00, 
0x0f, 0xf9, 0x00, 0x1f, 0xe1, 0xc0, 0x7f, 0xe1, 
0xe0, 0x7f, 0xe3, 0xfc, 0x0f, 0x81, 0xf0, 0x06, 
0x00, 0xe0, 0x3e, 0x00, 0x00, 0xc1, 0x80, 0x3e, 
0x80, 0x40, 0x3e, 0x80, 0x00, 0x3e, 0x80, 0x07, 
0xfc, 0x60, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x0f, 
0xff, 0xf0, 0x0f, 0x81, 0xf8, 0x0f, 0x81, 0xfc, 
0x1f, 0x81, 0xfc, 0x3f, 0x81, 0xfc, 0x3f, 0x80, 
0xfc, 0x3f, 0x80, 0xfc, 0x3f, 0x80, 0xfc, 0x3f, 
0x80, 0xfc, 0x3f, 0x80, 0xfc, 0x3f, 0x81, 0xfc, 
0x3f, 0x81, 0xfc, 0xff, 0xc1, 0xfe, 0xff, 0xc3, 
0xfe, 0x3f, 0x01, 0xf8, 0x0e, 0x00, 0x70, 0x0e, 
0x00, 0x30, 0x3f, 0x80, 0xf8, 0xff, 0xc3, 0xf8, 
0x7f, 0x00, 0x78, 0x3f, 0x80, 0x30, 0x1f, 0xe0, 
0x10, 0x0f, 0xf0, 0x00, 0x07, 0xf8, 0x00, 0x03, 
0xfc, 0x00, 0x00, 0xff, 0x00, 0x10, 0x7f, 0x00, 
0x18, 0x3f, 0xc0, 0x1c, 0x1f, 0xe0, 0x3f, 0x1f, 
0xf8, 0x3f, 0xff, 0xc0, 0x18, 0x03, 0x80, 
/* ^? */
0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
/* 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, */
/* 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, */
/* 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, */
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
0xe0, 0x00, 0x00, 0x07, 0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff,
0xff, 0xff, 0xff, 0xff, /* extra */
};

init_fontA()
{
	int	i;

	for (i=0; i<32; i++) {	/* fancy characters */
		chars[i].offset	= i*32;
		chars[i].w	= 16;
		chars[i].h	= CHEIGHT;
		chars[i].xoff	= 0;
		chars[i].yoff	= -CDESCEND;
		chars[i].width	= CWIDTH;
	}
	for (i=32; i<NUMCHR; i++) {
		chars[i].offset	= (i-32)*16+32*32;
		chars[i].w	= 8;
		chars[i].h	= CHEIGHT;
		chars[i].xoff	= 0;
		chars[i].yoff	= -CDESCEND;
		chars[i].width	= CWIDTH;
	}
	defrasterfont(n, ht, nc, chars, nr, fontA);
}

init_fontB()
{
	defrasterfont(engl_n,engl_ht,engl_nc,
	  engl_font,engl_nr,engl_bits);
}

#endif	gl2

#endif	iris
