#include "gl.h"

Matrix beziermatrix = {
	{ -1, 3, -3, 1 },
	{ 3, -6, 3, 0 },
	{ -3, 3, 0, 0 },
	{ 1, 0, 0, 0 }
};	

#define BEZIER 1

Matrix geom1[4][3] = {
	{ 100.0, 100.0, 0.0, 1.0},
	{ 200.0, 200.0, 0.0, 1.0},
	{ 200.0, 0.0, 0.0, 1.0},
	{ 300.0, 100.0, 0.0, 1.0}
};	

Matrix precisionmatrix = {
	{ 6.0/8000.0, 0, 0, 0},
	{ 6.0/8000.0, 2.0/400.0, 0, 0},
	{ 1.0/8000.0, 1.0/400.0, 1/20.0, 0},
	{ 0, 0, 0, 1}
};	

main ()
{

	ginit();
	color(BLACK);
	clear();
	pushmatrix(); /* the current transformation matrix on the
			matrix stack is saved */
	multmatrix(geom1); /* the product of the current transformation
		matrix and the matrix containing the control points becomes
			the new current transformation matrix */
	multmatrix(beziermatrix); /* the product of the basis matrix and the
		current transformation matrix becomes the new current
			transformation matrix */
	multmatrix(precisionmatrix); /* the product of the precision matrix
		and the current transformation matrix becomes the new current
			transformation matrix */
	move(0.0,0.0,0.0); /* this command must be issued so that the correct
			first point is generated by the curveit command */
	color(RED);
	curveit(20); /* a curve consisting of 20 line segments is drawn */
	popmatrix(); /* the original transformation matrix is restored */

	gexit();
}
