/* buffcopy.mic  -- buffcopy << GL2 >>
 *
 *	BUFFER_COPY(flag)
 *
 *	copies from the front to the back buffer (flag=0) or vice versa
 *			(flag = 1) 
 */

#include "mas.h"
#include "fbcparams.h"
#include "fbc.h"
#include "consts.h"
#include "fbc.mic.h"

buffcopy()
{
newfile("buffcopy.c");

label(BUFFER_COPY)
#define _FROM_TO_FLAG	6
#define _NEWCONFIG	7
#define _WK     5

    _NS LOADMAR(_MULTIVIEW); CONST(_MULTIVIEW); _ES

    _NS LOADREG(_FROM_TO_FLAG,ALL16,NOMORE); _ES

    _NS RAM(RAMRD, _WK, HOLD); _ES

    _NS SEQ(JUMP); NEXT(MULTCOPY); COND(IFNZ); _ES

    _NS LOADMAR(_CHARVIEW); CONST(_CHARVIEW); _ES

    _NS RAM(RAMRD, _X1, INC); _ES
    _NS RAM(RAMRD, _Y1, INC); _ES
    _NS RAM(RAMRD, _X2, INC); _ES
    _NS RAM(RAMRD, _Y2, HOLD); _ES
    _NS REGREG(RONLYOP, P0, _X1, _X1); DOTOOUTREG; BPCCMD(LOADXS); _ES
    _NS REGREG(RONLYOP, P0, _Y1, _Y1); DOTOOUTREG; BPCCMD(LOADYS); _ES
    _NS REGREG(RONLYOP, P0, _X2, _X2); DOTOOUTREG; BPCCMD(LOADXE); _ES
    _NS REGREG(RONLYOP, P0, _Y2, _Y2); DOTOOUTREG; BPCCMD(LOADYE); _ES

    _NS LOADMAR(_CONFIG+1); CONST(_CONFIG+1); _ES

    _NS IMMRAM(ANDOP, P0, 0x13, _NEWCONFIG, HOLD); CONST(0x13); _ES

    _NS 
	ALUOP(IOROP, P0);
	SETROP(0, ALL16); CONST(0xc); LOADDI(UCONST);
	SETSOP(NONQOP, _NEWCONFIG, RAMNOP);
	FTOYANDQ(FF, OLDQ, REGWRD);
	DOTOOUTREG;
	BPCCMD(LOADCONFIG);
    _ES

    _NS IMMRAM(ANDOP, P0, 1, _WK, HOLD); CONST(1); _ES

    _NS REGREG(XOROP, P0, _FROM_TO_FLAG, _WK); _ES

    _NS REGHOLD; COND(IFZ); SEQ(JUMP); NEXT(SGLCOPY_A_B); _ES

/**********/
label(SGLCOPY_B_A)
    _NS REGHOLD; DOJSUB(COPYBUFFER_B_A); _ES

    _NS REGHOLD; DOJUMP(BUFFERCOPYEXIT);_ES
/**********/

/**********/
label(SGLCOPY_A_B)
    _NS REGHOLD; DOJSUB(COPYBUFFER_A_B); _ES

    _NS REGHOLD; DOJUMP(BUFFERCOPYEXIT);_ES
/**********/

label(MULTCOPY)
    _NS LOADMAR(_CONFIG+1); CONST(_CONFIG+1); _ES

    _NS IMMRAM(ANDOP, P0, 0x13, _NEWCONFIG, HOLD); CONST(0x13); _ES

    _NS 
	ALUOP(IOROP, P0);
	SETROP(0, ALL16); CONST(0xc); LOADDI(UCONST);
	SETSOP(NONQOP, _NEWCONFIG, RAMNOP);
	FTOYANDQ(FF, OLDQ, REGWRD);
	DOTOOUTREG;
	BPCCMD(LOADCONFIG);
    _ES

    _NS IMMRAM(ANDOP, P0, 1, _WK, HOLD); CONST(1); _ES

    _NS REGREG(XOROP, P0, _FROM_TO_FLAG, _WK); _ES

    _NS REGHOLD; COND(IFZ); SEQ(JUMP); NEXT(A_TO_B); _ES

    _NS REGHOLD; DOJSUB(RESET_MASKS); _ES

label(COPY_LOOP_B_A)
    _NS LOADMAR(_CHARVIEW); CONST(_CHARVIEW); _ES
    _NS RAM(RAMRD, _X1, INC); _ES
    _NS RAM(RAMRD, _Y1, INC); _ES
    _NS RAM(RAMRD, _X2, INC); _ES
    _NS RAM(RAMRD, _Y2, HOLD); _ES

    _NS REGHOLD; DOJSUB(COPYBUFFER_B_A); DOTOOUTREG; BPCCMD(SETADDRS); _ES

    _NS DOJSUB(NEW_MASK); _ES

    _NS REGHOLD; COND(IFNZ); DOJUMP(COPY_LOOP_B_A); _ES

    _NS REGHOLD; DOJUMP(BUFFERCOPYEXIT);_ES


/**********/
label(BUFFERCOPYEXIT)
    _NS LOADMAR(_CONFIG+1); CONST(_CONFIG+1); _ES

    _NS RAM(RAMRD, _WK, HOLD); DOTOOUTREG; BPCCMD(LOADCONFIG); 
	SEQ(JUMP); NEXT(DISPATCH); GEGET; _ES
/**********/

label(A_TO_B)
    _NS REGHOLD; DOJSUB(RESET_MASKS); _ES

label(COPY_LOOP_A_B)
    _NS LOADMAR(_CHARVIEW); CONST(_CHARVIEW); _ES
    _NS RAM(RAMRD, _X1, INC); _ES
    _NS RAM(RAMRD, _Y1, INC); _ES
    _NS RAM(RAMRD, _X2, INC); _ES
    _NS RAM(RAMRD, _Y2, HOLD); _ES

    _NS REGHOLD; DOJSUB(COPYBUFFER_A_B); DOTOOUTREG; BPCCMD(SETADDRS); _ES

    _NS DOJSUB(NEW_MASK); _ES

    _NS REGHOLD; COND(IFNZ); DOJUMP(COPY_LOOP_A_B); _ES

    _NS REGHOLD; DOJUMP(BUFFERCOPYEXIT);_ES

/**********/
label(COPYBUFFER_A_B)
    _NS /* figure the counts */ 
	REGREG(SUBRSOP, P1, _X2, _X1);
	DOTOOUTREG;
	BPCCMD(SETADDRS);
    _ES

    _NS /* figure the counts */ 
	REGREG(SUBSROP, P0, _Y2, _Y1);
    _ES

label(ABCOPYLOOP)
    _NS
	SEQ(RETN);
	COND(IFNNEG);
	REGREG(RONLYOP, P0, _X1, _X1);
	DOTOOUTREG;
    _ES

    _NS /* load the counter */
	SEQ(LDCT);
	LOADDI(OUTPUTCOUNT);
    _ES

label(ABINNERLOOP)

    _NS
	BPCCMD(READPIXELAB);
	DOTOOUTREG;
    _ES

    _NS 
	ALUOP(RONLYOP, P0);
	SETROP(0, ALL16); LOADDI(BPCDATA); READBPCBUS; DOTOOUTREG;
	COND(IFFALSE); SEQ(CJPP);
	SETSOP(NONQOP, _WK, RAMNOP);
	FTOYANDQ(FF, OLDQ, REGWRE);
    _ES

    _NS 
	REGREG(RONLYOP, P0, _WK, _WK);
	BPCCMD(DRAWPIXELAB); DOTOOUTREG;
	SEQ(RPCT);
	NEXT(ABINNERLOOP);
    _ES

    _NS /* add one to the y count */
	REGREG(RONLYOP, P1, _Y1, _Y1);
	SEQ(JUMP);
	NEXT(ABCOPYLOOP);
    _ES


/************/
label(COPYBUFFER_B_A)
    _NS /* figure the counts */ 
	REGREG(SUBRSOP, P1, _X2, _X1);
	DOTOOUTREG;
	BPCCMD(SETADDRS);
    _ES

    _NS /* figure the counts */ 
	REGREG(SUBSROP, P0, _Y2, _Y1);
    _ES

label(BACOPYLOOP)
    _NS
	SEQ(RETN);
	COND(IFNNEG);
	REGREG(RONLYOP, P0, _X1, _X1);
	DOTOOUTREG;
    _ES

    _NS /* load the counter */
	REGHOLD;
	SEQ(LDCT);
	LOADDI(OUTPUTCOUNT);
    _ES

label(BAINNERLOOP)
    _NS
	BPCCMD(READPIXELCD);
	DOTOOUTREG;
    _ES

    _NS 
	ALUOP(RONLYOP, P0);
	SETROP(0, ALL16); LOADDI(BPCDATA); READBPCBUS; DOTOOUTREG;
	COND(IFFALSE); SEQ(CJPP);
	SETSOP(NONQOP, _WK, RAMNOP);
	FTOYANDQ(FF, OLDQ, REGWRE);
    _ES

    _NS 
	REGREG(RONLYOP, P0, _WK, _WK);
	BPCCMD(DRAWPIXELAB); DOTOOUTREG;
	SEQ(RPCT);
	NEXT(BAINNERLOOP);
    _ES

    _NS /* add one to the y count */
	REGREG(RONLYOP, P1, _Y1, _Y1);
	SEQ(JUMP);
	NEXT(BACOPYLOOP);
    _ES
}
