a_man/man1/clri.1m                                                                                     664    1776     311         3037  3536641340   7267                                                                                                                                                                                                                                                                                                                                                                      .TH CLRI 1M
.SH NAME
clri \- clear inode
.SH SYNOPSIS
.B /etc/clri
file-system i-number ...
.SH DESCRIPTION
.I clri\^
writes zeros on the area of the volume
.I file-system
occupied by the
.I inode
numbered
.IR i-number .
.I file-system\^
must be a device file
which contains a file system.
Bell file systems and Extent file systems are both supported.
.PP
After
.I clri\^
is executed, the i-node
can be allocated.
Any blocks formerly claimed by
the affected file
may show up as ``missing'' in an
.IR fsck (1M)
of the
.IR file-system .
.PP
This command should only be used in emergencies,
and only on quiescent file systems.
Extreme care should be exercised.
.PP
The primary purpose of this command
is to remove a file which
for some reason does not appear
in any directory.
If it is used to
.I zap\^
an inode
which does appear in a directory,
be careful to track down
the entry and remove it beforehand.
Otherwise, when the inode is reallocated to some new file,
the old entry will still point to that file.
At that point removing the old entry will destroy the new file.
The new entry will again point to an unallocated inode,
so the whole cycle is likely to be repeated again and again.
.SH EXAMPLE
.IP
clri /dev/md0c 100
.PP
zaps inode 100 on device /dev/md0c.
.SH SEE ALSO
fsck(1M),
fsdb(1M),
ncheck(1M),
fs(4),
inode(4).
.SH BUGS
If the file is open,
.I clri\^
is likely to be ineffective.
.br
Inodes are written a block at a time,
so if the file system is not quiescent,
inodes physically nearby the target inode may be damaged.
.\"	@(#)clri.1m	5.1 of 10/17/83
oy the new file.
The new entry will again point to an unallocated inode,
so the whole cycle is likely to be repeated again and again.
.SH EXAMPLE
.IP
clri /dev/md0c 100
.PP
zaps inode 100 on device /dev/md0c.
.SH SEE ALSO
fsck(1M),
fsdb(1M),
ncheck(1M),
fs(4),
inode(4).
.SH BUGS
If the file is open,
.I clri\^
is likely to be ineffective.
.br
Inodes are written a block at a time,
so if the file system is not quiescent,
inodes physically nearby the target inode may be damaged.
.a_man/man1/colord.1m                                                                                   664    1776     311         3766  3525461307   7632                                                                                                                                                                                                                                                                                                                                                                      .TH COLORD 1
.SH NAME
colord \- Tektronix 4692 color printer daemon and spooler
.SH SYNOPSIS
.B /usr/lib/colord
[
.B "\-i"
[
.B \-h
resolution xsize ysize copies
] ] [
.B "\-o"
ofile
]
.SH DESCRIPTION
.I Colord\^
is the daemon for controlling the Tektronix 4692 color graphics printer.
With no parameters, it forks itself into the background
and starts processing files in the queue directory, \f2/usr/spool/colord\f1.
.PP
.I Colord\^
may also be used to queue up files to be printed. 
Specify
the
.B \-i
flag for queueing the files.
With no other flags,
.I colord\^
reads the complete data file, 
using the header from standard input and queues
it up.
.PP
If the
.B \-h
flag is specified then the next three arguments specify
the image resolution and the final argument (\f2copies\f1) specifies 
the number of copies
to print.
The argument \f2xsize\f1 indicates the number of pixels in the
.I x
direction and 
\f2ysize\f1 indicates the number of pixels in the
.I y
direction.
The resolution may be 1, 2, or 4 
bits per RGB component per pixel.
Up to 100 copies may be made of an image, paper allowing.
.PP
All remaining data should be the actual raster data in the
format required by the
.B /dev/tek
device, documented in
.IR tek (7).
.PP
The
.B \-o
flag allows specification of the device file.
If
.I ofile
is a dash, 
.B "\-" ,
then standard output is used.
.SH FILES
.TP "\w'/usr/spool/colord/\(**\ \ \ 'u"
/usr/lib/colord
color printer daemon.
.TP
/usr/spool/colord/\(**
spool area.
.TP
/dev/tek
device file
.PD
.SH SEE ALSO
capture(1G), capture(3G), coloropen(3), tek(7)
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\"Revision 1.4  85/08/06  11:24:05  robinf
.\"Cosmetic changes
.\"
.\"Revision 1.3  85/06/17  15:39:07  robinf
.\"Cosmetic changes
.\"
.\"Revision 1.2  85/06/14  19:46:09  robinf
.\"Update for GL2-W2.3 and GL1-W2.3 after review
.\"
.\"Revision 1.1  85/05/31  16:27:58  robinf
.\"More edits for GL2-W2.3
.\"
.\" Revision 1.0  85/05/31  13:32:04  robinf
.\" Initial Revision

LSO
captura_man/man1/df.1m                                                                                       664    1776     311         1611  3534470047   6725                                                                                                                                                                                                                                                                                                                                                                      .TH DF 1M
.SH NAME
df \- report number of free disk blocks
.SH SYNOPSIS
.B df
[
.B \-f
]
[
.B \-i
] [ file-systems ]
.SH DESCRIPTION
.I df\^
reports the number of free disk blocks
(1 disk block equals 1 kbyte)
available for on-line file systems.
The
.I file-systems\^
argument
may be specified either by a device name (e.g.,
.IR /dev/md0c )
or by a mounted directory name (e.g.,
.IR /usr ).
If
the
.I file-systems\^
argument
is unspecified,
.I df\^
reports on all file systems listed in the file
.IR /etc/mnttab .
.PP
Normally, the
free block information is gleaned from the file system's superblock.
The
.B \-f
flag forces a scan of the free block list.
.PP
The
.B \-i
flag
reports the number and percentage of free inodes.
.SH FILES
/etc/mnttab
.SH SEE ALSO
checklist(4), ustat(2), fs(4), mnttab(4).
.SH BUGS
Free counts may be incorrect, with or without
the
.B \-f
flag.
.\"	@(#)df.1m	5.1 of 10/17/83


the
.I file-systems\^
argument
is unspecified,
.I df\^
reports on all file systems listed in the file
.IR /etc/mnttab a_man/man1/fsck.1m                                                                                     664    1776     311        17277  3541100240   7300                                                                                                                                                                                                                                                                                                                                                                      .de us
\\$1\l'|0\(ul'
..
.ds P UNIX
.TH FSCK 1M
.SH NAME
fsck, dfsck \- file system consistency check and interactive repair
.SH SYNOPSIS
.nh
.na
.BR /etc/fsck\0 [\
\f3\-y\f1\ ]
[\ 
.BR \-n\ ]
[\ 
.BR \-s X\ ]
[\ 
.BR \-S X\ ]
[\ 
.BR \-b "numbers\ ]"
[\ 
.BR \-t " file\ ]"
.in +\w'/etc/fsck\ \ 'u
[\ 
.BR \-q\ ]
[\ 
.BR \-D\ ]
[\ 
.BR \-f\ ]
[\ file-system .\^.\^.\ ]
.PP
.B /etc/dfsck
[\ options1\ ]
filsys1
.B .\^.\^.
.B \-
[\ options2\ ]
filsys2
.B .\^.\^.
.in
.ad
.hy
.SH DESCRIPTION
.SS Fsck
.I  fsck\^
audits and interactively repairs inconsistent conditions
for U\s-2NIX\s+2 file systems.
Bell file systems and Extent file systems are both supported
(see
.IR fs (4)).
If the file system is consistent then the number of files, number of blocks
used, and number of blocks free are reported.
If the file system is inconsistent the operator is prompted for a response
before each correction is attempted.
Most corrective actions will result in some loss
of data.
To determine the amount and 
severity of data lost, examine the diagnostic
output.
The default action for each consistency correction
is to wait for the operator to respond yes or no.
If the operator does not have write permission, 
.I fsck\^
will default to a 
.BR "\-n " action.
.PP
.I fsck\^
has more consistency checks than
its predecessors
.IR check ,
.IR dcheck ,
.IR fcheck ,
and
.I icheck\^
combined.
.PP
The following options are interpreted by
.IR fsck .
.TP 6
.B  \-y
Assume a yes response to all questions asked by 
.IR fsck .
.TP 6
.B  \-n
Assume a no response to all questions asked by 
.IR fsck ;
do not open the file system for writing.
.TP 6
.BR \-s \f2X
Ignore the actual free list and (unconditionally) reconstruct a new
one by rewriting the super-block of the file system.  
The file system should be unmounted doing this.  If unmounting the
file system
is not possible, be sure that the system is quiescent
and that you reboot it immediately afterwards.
This precaution is necessary so that the old, bad, in-core copy
of the superblock will not continue to be used, or written on the file system.
.IP
The
.BR \-s \f2X
option allows for creating an optimal free-list organization.
The following forms of
.I X\^
are supported for the following devices:
.sp
.nf
	\-s3 (\s-1RP\s+1\&03)
	\-s4 (\s-1RP\s+1\&04, \s-1RP\s+1\&05, \s-1RP\s+1\&06)
	\-s\f2Blocks-per-cylinder\f3:\f2Blocks-to-skip\f1 (for anything else)
.fi
.IP "" 6
If 
.I X\^
is not given,
the values used when the file system was created
are used.
If these values were not specified, then the value
.IB 400 : 7
is used.
The
.I X\^
parameter is meaningful only for Bell file systems.
It is ignored for Extent file systems.
.TP 6
.BR \-S \f2X
Conditionally reconstruct the free list. This option
is like
.BR \-s \f2X
above except that the free list is rebuilt only
if there were no discrepancies discovered in the
file system. Using
.B \-S
will force a no response to all questions asked
by
.IR fsck .
This option is useful for forcing free list reorganization
on uncontaminated file systems.
.TP 6
.BR \-b
Report files using any of the given physical block
.IR numbers.
.TP 6
.B \-t
If
.I fsck\^
cannot obtain enough memory to keep its tables,
it uses a scratch file. If the \f3\-t\fP option is
specified, the file named in the next argument
is used as the scratch file. Without the
.BR "\-t " flag,
.I fsck\^
will prompt the operator for the name of the
scratch file. The file chosen should not be on the
file system being checked, and if it is not
a special file or did not already exist, it is
removed when
.I fsck\^
completes.
.TP 6
.B \-q
Quiet
.I fsck.\^
Do not print size-check messages in Phase 1.
Unreferenced
.I fifos
will silently be removed. 
If
.I fsck
requires it, counts in the superblock will be automatically
fixed and the free list salvaged.
.TP 6
.B \-D
Directories are checked for bad blocks.
Useful after the system crashes.
.TP 6
.B \-f
Fast check.
Check block and sizes (Phase 1) and check the free list (Phase 5).
If it is necessary, the free list will be reconstructed (Phase 6).
.PP
If no
.I file-systems\^
are specified,
.I fsck\^
will read a list of default file systems from
the file
.IR /etc/checklist .
.PP
.ne 10
Inconsistencies checked are as follows:
.RS .3i
.PD 0
.TP 4
1.
Blocks claimed by more than one inode or the free list.
.TP 4
2.
Blocks claimed by an inode or the free list outside the range of the file system.
.TP 4
3.
Incorrect link counts.
.TP 4
4.
Size checks:
.IP "" 8
Incorrect number of blocks.
.br
Directory size not 16-byte aligned.
.TP 4
5.
Bad inode format.
.TP 4
6.
Blocks not accounted for anywhere.
.TP 4
7.
Directory checks:
.IP "" 8
File pointing to unallocated inode.
.br
Inode number out of range.
.TP 4
8.
Super block checks:
.IP "" 8
More than 65536 inodes.
.br
More blocks for inodes than there are in the file system.
.TP 4
9.
Bad free block list format.
.TP 4
10.
Total free block and/or free inode count incorrect.
.RE
.PD
.PP
Nonempty orphaned files and directories (allocated but unreferenced) are,
with the operator's concurrence, reconnected by
placing them in the 
.I lost+found
directory.
The user will be notified whether or not the file or directory is empty.
If it is empty,
.I fsck
will silently remove them.
.I fsck
will force the reconnection of nonempty directories.
The name assigned is the inode number.
The only restriction
is that the directory 
.I lost+found
must preexist
in the root of the file system being checked and
must have empty slots in which entries can be made.
This is accomplished by making 
.IR lost+found ,
copying a number of files to the directory, and then removing them
(before
.I
fsck
is executed). A utility, 
.IR mklost\+found (1M), 
is provided to do this.
.PP
Checking the raw device is almost always faster and should be used
with everything but the
.I root
file system.  Do not check the raw device if it is mounted.
.PP
.SS Dfsck
.sp 1
.I dfsck
allows two file system checks on two different drives simultaneously.
.I options1
and
.I options2
are used to pass options to
.I fsck
for the two sets of file systems.
A
.B \-
is the separator between the file system groups.
.PP
The
.I dfsck
program permits an operator to interact with two
.IR fsck (1M)
programs
at once.
To aid in this,
.I dfsck
will print the file system name for each
message to the operator.
When answering a question from
.IR dfsck ,
the operator must prefix the response with a
.B 1
or a
.B 2
(indicating that the answer refers to the first or second file system group).
.PP
Do not use
.I dfsck
to check the
.I root
file system (because pipes are created).
.SH EXAMPLES
.IP
/etc/fsck \-q /dev/md0a /dev/rmd0c
.PP
checks the consistency of a IRIS 1400 or 2400 workstation with a single disk.
.IP
/etc/fsck \-q /dev/md0a /dev/rmd0c /dev/rmd1[ac]
.PP
checks the consistency of a IRIS 1400 or 2400 workstation with two disks.
.SH FILES
/etc/fsck.bell
.br
/etc/fsck.efs
.br
/etc/checklist	default list of file systems to check.
.br
.SH "SEE ALSO"
clri(1M),
mklost+found(1M),
ncheck(1M),
checklist(4),
fs(4),
crash(8)
.PP
``fsck'', 
.I "IRIS Workstation Guide, Series 2000", 
Appendix A.
.SH BUGS
Inode numbers for
.B .
and
.B .\|.
in each directory should be checked for validity.
.SH DIAGNOSTICS
The diagnostics produced by 
.I fsck\^
are intended to be self-explanatory.
.\"	@(#)fsck.1m	5.1 of 11/1/83
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.4  85/08/15  12:29:34  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.3  85/08/07  17:38:19  locke
.\" Turbo option update
.\" 
.\" Revision 1.1  85/05/01  16:56:21  robinf
.\" Updates from 2000 Series workstation guide, Version 1.0
.\" 
.\" Revision 1.3  85/03/15  18:05:36  bob
.\" Localized.
.\" 
.\" Revision 1.2  85/03/15  17:29:57  bob
.\" Mentioned fsdb, checkall, why dfsck shouldn't be used on root fs.
.\" 

85/08/15 12:29:34 robinf Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.4  85/08/15  12:29:34  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.3  85/08/07  17:38:19  locke
.\" Turbo option update
.\" 
.\" Revision 1.1  85/05/01  16:56:21  robinf
.\" Updates from 2000 Series workstation guide, Versioa_man/man1/mkfs.1m                                                                                     664    1776     311        13206  3540723770   7320                                                                                                                                                                                                                                                                                                                                                                      .TH MKFS 1M
.SH NAME
mkfs \- construct a file system
.SH SYNOPSIS
.B /etc/mkfs
[
.B \-C
cgfsize[:cgisize]
] [
.B \-D
deviceproto ]
] [
.B \-G
heads sectors ] 
.br
.in +\w'/etc/mkfs\ \ 'u
special [ proto ]
.PP
.B /etc/mkfs.bell
special proto [ m n ]
.br
.SH DESCRIPTION
.I mkfs\^
constructs an Extent file system
by writing on the file
.I special
according to the directions
found in the remainder of the command line.
The file system is created with (at least) a root
directory and the
.I lost\+found
directory used by
.IR fsck (1M).
.I mkfs.bell\^
constructs a Bell file system.
The file system is created with (at least) a root directory.
The optional modifiers are different
for the two types of file systems,
and are described later.
.PP
The
.I proto
argument specifies the size
and content of the file system.
If
.I proto
is of the form
.IR number[:number] ,
.I mkfs\^
builds a file system with at most the first
.I number
of physical blocks and approximately
the second
.I number
of inodes,
containing a root directory.
.I mkfs
(but not
.IR mkfs.bell )
also creates the directory
.I lost+found
used by
.IR fsck (1M).
The actual sizes are rounded up or down according
to a formula.
If the second
.I number
is not given,
the number of inodes is set to
approximately
the number of
.I logical\^
blocks divided by 5 (4 for a Bell file system).
In either case,
the boot program is left uninitialized.
.PP
Otherwise,
.I mkfs\^
uses
.I proto
as the name of
a description file
containing tokens separated by white space.
The first token is the name of a file
to be copied onto block zero as the bootstrap program.
The second token is a number specifying the
size of the created file system in
physical
disk blocks.
Typically it will be the number of blocks on the device,
perhaps diminished by space for swapping.
The next token is the number of inodes in the file system.
The maximum number of inodes configurable is 65500.
The next set of tokens comprise the specification
for the root directory.
File specifications consist of tokens
giving the mode,
the user \s-1ID\s0,
the group \s-1ID\s0,
and the initial contents of the file.
The syntax of the contents field
depends on the mode.
.PP
The mode token for a file is a 6-character string.
The first character
specifies the type of the file.
(The characters
.B \-bcd
specify regular, block special,
character special and directory files
respectively.)
The second character of the type
is either
.B u
or
.B \-
to specify set-user-id mode or not.
The third is
.B g
or
.B \-
for the set-group-id mode.
The rest of the mode
is a 3-digit octal number giving the
owner, group, and other read, write, execute
permissions (see
.IR chmod (1)).
.PP
Two decimal number
tokens come after the mode; they specify the
user and group \s-1ID\s0's of the owner of the file.
.PP
If the file is a regular file,
the next token is a path name
whence the contents and size are copied.
If the file is a block or character special file,
two decimal number tokens
follow which give the major and minor device numbers.
If the file is a directory,
.I mkfs\^
makes the entries `.' and `..' and then
reads (recursively) a list of names and 
file specifications for the entries
in the directory.
The scan is terminated with the token `$'.
.PP
A sample prototype specification follows:
.PP
.nf
.in +5
/stand/ diskboot\^
4872 110
d\-\^\^\-777 3 1
usr	d\-\^\^\-777 3 1
	sh	\-\^\^\-\^\^\-755 3 1 /bin/sh
	ken	d\-\^\^\-755 6 1
		$
	b0	b\-\^\^\-644 3 1 0 0
	c0	c\-\^\^\-644 3 1 0 0
	$
$
.in -5
.fi
.PP
.SS "Mkfs Options"
.sp 1
.PP
.I mkfs
needs the the number of heads,
the number of sectors per track,
and the size in
.I physical
blocks
for the disk and partition on which
.I filsys
resides.
The cylinder group size,
and the number of inodes per cylinder group
are also needed.
If these are not specified on the command line,
they are read from the disk label
(heads, sectors, and size)
or computed from a formula
(cylinder group size and inodes per cylinder group).
.PP
.B \-C
cgfsize[:cgisize]
.br
gives the (approximate)
size and number of inodes in a cylinder group.
The actual sizes are rounded up or down according
to a formula.
.PP
.BR \-D\^ device
.br
specifies another file system device
whose disk label parameters are to be used as defaults.
.PP
.B \-G
heads sectors
.br
specifies the geometry of the
disk on which
.I filsys
resides.
.PP
.SS "Mkfs.bell Options"
.sp 1
.PP
The optional
.I m
and
.I n
arguments
to
.I mkfs.bell
are used to tune the construction of the freelist
(and thus the allocation of files)
for particular disk on which
.B filsys
resides.
.I Mkfs.bell
will process
.I m
consecutive blocks at a time,
arranging them such that
consecutive allocations are mostly
.I n
blocks apart.
Typically,
.B n
is the number of
.I logical
blocks per cylinder.
A default will be used if the supplied
.I m
or
.I n
is missing or illegal.
The proper selection of the 
.I m
and 
.I n
parameters can improve file system efficiency.
Disks which have
full or partial track buffering should specify a 
.I m
and
.I n
of 1 and 1;  
.I m
and 
.I n
for other disks must be determined by trial and error as the disk
latency is related to rotational latency and CPU speed.
.SH EXAMPLE
.IP
mkfs \-D /dev/md0a /dev/rmd1a
.PP
makes a minimal Extent file system
on
.IR /dev/rmd1a ,
with the same parameters as
.IR /dev/md0a .
.PP
.IP
mkfs.bell /dev/fd0 2000 7 50
.PP
makes a minimal Bell file system of size 2000 on disk
.IR /dev/fd0 .
The freelist is processed
50 blocks at a time,
in such a way that consecutive allocations
will be mostly 7 blocks apart.
.SH SEE ALSO
dir(4), fs(4), boot(8)
.SH BUGS
If a prototype is used, it is not possible to initialize
a file larger than 64K bytes, nor is there a way
to specify links.
.\"	@(#)mkfs.1m	5.1 of 10/17/83
ent file system
on
.IR /dev/rmd1a ,
with the same parameters as
.IR /dev/md0a .
.PP
.IP
mkfs.bell /dev/fd0 2000 7 50
.PP
makes a minimal Bell file system of size 2000 on disk
.IR /dev/fd0 .
The freelist is processed
50 blocks at a time,
in such a way that consecutive allocations
will be mostly 7 blocks apart.
.SH SEE ALSO
dir(4), fs(4), boot(8)
.SH BUGS
If a prototype is useda_man/man1/ncheck.1m                                                                                   664    1776     311         2605  3540727504   7573                                                                                                                                                                                                                                                                                                                                                                      .TH NCHECK 1M 
.SH NAME
ncheck \- generate names from i-numbers
.SH SYNOPSIS
.B /etc/ncheck
[
.B \-i
numbers...\ ]  [\ 
.B \-a
\ ] [\ 
.B \-s
\ ]  [\ file-system\ ]
.SH DESCRIPTION
.PP
.I ncheck\^
associates pathnames with i-numbers
from a raw
.IR file-system .
Bell file systems and Extent file systems are both supported
(see
.IR fs (4)).
.PP
.I ncheck\^
with no argument
generates a path name accompanied by an i-number
list of all files
on a set of default file systems.
Names of directory files are followed by `/.'.
The
.B \-i
option reduces the report to only those files whose i-numbers follow.
The
.B \-a
option
allows printing of the names `.'  and `..',
which are ordinarily suppressed.
The
.B \-s
option reduces the report to special files
and files with set-user-\s-1ID\s0 mode;
it is intended to discover concealed violations
of security policy.
.PP
A file system may be specified.
.PP
The report is in no useful
order, and probably should be sorted.
.SH EXAMPLE
.IP
ncheck /dev/md0a
.PP
will report the pathnames and i-numbers of files on
the specified device.
.SH FILES
.ta \w'/etc/checklist/\ \ \ 'u
/etc/checklist	list of default file systems.
.SH "SEE ALSO"
checklist(4),
fs(4),
fsck(1M), sort(1).
.SH DIAGNOSTICS
When the file system structure is improper,
`??' denotes the ``parent'' of
a parentless file and
a path name beginning with `...' denotes a loop.
.\"	@(#)ncheck.1m	5.1 of 10/17/83
he report is in no useful
order, and probably should be sorted.
.SH EXAMPLE
.IP
ncheck /dev/md0a
.PP
will report the pathnaa_man/man1/reboot.1m                                                                                   664    1776     311         2253  3534456364   7637                                                                                                                                                                                                                                                                                                                                                                      .TH REBOOT 1M
.SH NAME
reboot \- \s-1UNIX\s0 bootstrapping procedures
.SH SYNOPSIS
.B /etc/reboot
[\ 
.B \-n
\ ] [\ 
.B \-q
\ ] 
.SH DESCRIPTION
.PP
U\s-2NIX\s0 is started by placing it in memory
at a particular location and transferring to that location.
Since the system is not reentrant,
it is necessary to read it in from disk or tape
each time it is to be bootstrapped.
.PP
.B Rebooting a running system.
When U\s-2NIX\s0 is running and a reboot is desired,
.I /etc/reboot
can be used.
.I reboot\^
causes the disks to be synced, and a
reboot to be initiated.
.PP
Options to
.I reboot\^
are:
.TP
.B \-n
avoids the sync.  It can be used if a disk or the processor
is on fire. 
.TP
.B \-q
reboots quickly, without executing commands in 
.IR /etc/rebootrc .
.SH FILES
.ta \w'/etc/rebootrc   'u
/etc/rebootrc	reboot shell script
.SH "SEE ALSO"
crash(8),
fsck(1M),
init(1M),
brc(1M),
kill(2)
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/08/27  16:42:42  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.1  85/08/27  16:41:51  robinf
.\" Changes for Turbo Option
.\" 
.\" Revision 1.0  85/05/01  16:34:24  robinf
.\" Initial Revision

.B \-q
reboots quickly, without executing commands in 
.IR /etc/rebootrc .
.SH FILES
.ta \w'/etc/rebootrc   'u
/etc/rebootrc	reboot shell script
.SH "SEE ALSO"
crash(8),
fsck(1M),
init(1M),
brc(1M),
kill(2)
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/08/27  16:42:42  robinf
a_man/man1/sgilabel.1m                                                                                 664    1776     311         3021  3540727676  10125                                                                                                                                                                                                                                                                                                                                                                      .TH SGILABEL 1M
.SH NAME
sgilabel \- print or update the SGI disk label of a drive
.SH SYNOPSIS
.B sgilabel
[\  
.B \-n
drivename\ ] [\  
.B \-s 
driveserial\ ]
disk
.SH DESCRIPTION
.I sgilabel
has two forms.
If a
.I disk
is a drive 
(e.g., md0, ip1),
.I sgilabel
will print out the whole drive label.
This information includes the drive label, serial number,
type of drive and controller, size (cylinders/heads/sectors),
and the sizes of each file system on the drive.
.PP
If
.I disk
is a file system
(e.g., md0a, ip1d),
.I sgilabel
will print out the size of the file system
and the size of a cylinder (both in 512 byte blocks).
.RI ( newfs (1M)
uses this information.)
.PP
The
.B \-n
option sets 
the drive name in the label to
.IR drivename .
The
.B \-s
option
sets the
the drive serial number in the label to
.IR driveserial .
.PP
Disk labels are not supported for floppy disk drives.
.SH FILES
.ta \w'/dev/md*h\ \ 'u
/dev/md*h	the \f2h\fP partition accesses the label
.br
/dev/ip*h	the \f2h\fP partition accesses the label
.SH "SEE ALSO"
newfs(1M)
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.5  85/08/15  12:28:49  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.4  85/08/07  15:20:35  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.3  85/07/12  17:15:23  robinf
.\" Update for IRIS 3400
.\" 
.\" Revision 1.2  85/05/02  18:21:04  robinf
.\" Updates from 2000 Series Workstation Guide
.\" 
.\" Revision 1.1  84/12/16  08:08:43  bob
.\" Initial revision
.\" 
O"
newfs(1M)
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.5  85/08/15  12:28:49  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.4  85/08/07  15:20:35  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.3  85/07/12  17:15:23  robinf
.\" Update for IRIS 3400
.\" 
.\" Revision 1.2  85/05/02  18:21:04  robinf
.\" Updates from 2000 Series Workstation Guide
.\" 
.\" Revision 1.1  84/12/16  08:08:43  bob
.\" Initia_man/man1/volcopy.1m                                                                                  664    1776     311         7616  3540727735  10050                                                                                                                                                                                                                                                                                                                                                                      .TH VOLCOPY 1M
.SH NAME
volcopy, labelit \- copy file systems with label checking
.SH SYNOPSIS
.B /etc/volcopy
[\ options\ ] fsname special1 volname1 special2 volname2
.PP
.B /etc/labelit
special [\ fsname volume [\ \f3\-n\fP\ ]\ ]
.SH DESCRIPTION
.I volcopy\^
makes a literal copy of the file system
using
a blocksize matched to the device to which or from which it is copying.
Bell file systems and Extent file systems are both supported
(see
.IR fs (4)).
The file system type (Bell file system vs. Extent file system)
is preserved.
.I options
are:
.PD 0
.RS .3i
.TP
.B \-a
Invoke a verification sequence
requiring a positive operator response.
.TP
.B \-s
(default) Inhibit the
verification sequence.
.PD
.RE
.PP
Other \f2options\fP are used only with tapes:
.PD 0
.RS .3i
.TP \w'\f3\-bpi\fPdensity\ \ 'u
.BI \-bpi density
Bits-per-inch (i.e., 800/1600/6250).
.TP
.BI \-feet size
Size of reel in feet (i.e., 1200/2400).
.TP
.BI \-reel num
Beginning reel number for a restarted copy.
.TP
.B \-buf
Use double buffered I/O.
.PD
.RE
.PP
The program requests length and density
information if it is not given on the
command line or is not recorded on an input tape label.
If the file system is too large to fit on one reel,
.I volcopy\^
will prompt for additional reels.
Labels of all reels are checked.
Tapes may  be mounted alternately on two or more drives.
.PP
The
.I fsname\^
argument represents the mounted name (
.IR root ,
.IR u1 ,
etc.)
of the file system being copied.
.PP
The
.I special\^
device name should be the physical disk section or tape
(\f2/dev/rmd1a, /dev/rmt1,\f1 etc.).
.PP
The
.I volname\^
argument is the physical volume name (e.g.:
.IR pk3 ,
.IR t0122 ,
etc.)
and should match the external label sticker.
Such label names are limited to six or fewer characters.
.I volname
may be
.B \-
to use the existing volume name.
.PP
.I special1\^
and
.I volname1\^
are the device and volume from which the copy of the file system is
being extracted.
.I special2\^
and
.I volname2\^
are the destination device and volume.
.PP
.I fsname\^
and
.I volname\^
are recorded in the last 12 characters
of the superblock (\f2char fsname[6], volname[6];\fP).
.PP
.I labelit\^
can be used to provide initial labels for unmounted disk
or tape file systems.
Bell file systems and Extent file systems are both supported
(see
.IR fs (4)).
With the optional arguments omitted,
.I labelit\^
prints current label values.
The
.B \-n
option provides for initial labeling of new tapes and
destroys the previous contents of the tape.
.SH EXAMPLE
.IP
volcopy newsys /dev/rmd0a 1 /dev/rmt1 1
.PP
copies volume 1 of the file system labeled 
.I newsys 
mounted on 
.I /dev/rmd0a
onto volume 1 of 
.IR /dev/rmt1 .
.IP
labelit /dev/rmt1 oldsys save
.PP
relabels the file system mounted on 
.I /dev/rmt1
with a new 
.I fsname 
of 
.I oldsys 
and a new 
.I volname 
of save.
.SH FILES
.ta \w'/etc/log/filesave.log\ \ \ 'u
/etc/log/filesave.log	a record of file systems/volumes copied
.DT
.SH "SEE ALSO"
fs(4)
.SH BUGS
You can copy from tape to disk,
from disk to disk,
from disk to tape,
but not from tape to tape.
Only device names beginning
.I /dev/rmt
are treated as tapes.
Tape record sizes are determined both by density and by
drive type.
Records are 5,120 bytes long at 800 and 1600
bits-per-inch, and 25,600 bytes long at 6250 bits-per-inch.
.\"	@(#)volcopy.1m	5.1 of 10/17/83
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.4  85/08/15  12:29:24  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.3  85/07/26  11:10:41  locke
.\" cosmetic changes
.\" 
.\" Revision 1.2  85/07/12  17:20:17  robinf
.\" Update for IRIS 3400
.\" 
.\" Revision 1.1  85/05/01  17:02:15  robinf
.\" Updates from 2000 Series workstation guide, Version 1.0

.\" Revision 1.2  85/03/12  01:13:10  bob
.\" Changed to reflect that there is no longer "hit DEL to abort" or the
.\" sleep(10).
.\" Changed device names to SGI standards.
.\" 
1.4  85/08/15  12:29:24  robinf
.\" Updates after 1st review for Turbo option
.\" 
.\" Revision 1.3  85/07/26  11:u_man/man1/apply.1                                                                                     664    1776     311         2521  3525461274   7333                                                                                                                                                                                                                                                                                                                                                                      .TH APPLY 1
.SH NAME
apply \- apply a command to a set of arguments
.SH SYNOPSIS
.B apply
[
.BR \-a c
] [
\-n
] command args ...
.SH DESCRIPTION
.I Apply\^
runs the named
.I command
on each
argument
.I arg
in turn.
Normally arguments are chosen singly; the optional number
.I n
specifies the number of arguments to be passed to
.I command.
If
.I n
is zero,
.I command
is run without arguments once for each
.I arg.
Character sequences of the form %\f2d\fP
in
.I command,
where
.I d
is a digit from 1 to 9,
are replaced by the
\f2d\fP'th following unused
.I arg.
If any such sequences occur,
.I n
is ignored,
and the number of arguments passed to
.I command
is the maximum value of
.I d
in
.I command.
The character `%' may be changed by the
.B \-a
option.
.PP
.SH EXAMPLES
.RS
apply echo *
.RE
is similar to 
.IR ls (1);
.PP
.RS
apply \-2 cmp a1 b1 a2 b2 ...
.RE
compares the `a' files to the `b' files;
.PP
.RS
apply \-0 who 1 2 3 4 5
.RE
runs 
.IR who (1) 
5 times; and
.PP
.RS
apply \(aaln %1 /usr/joe\(aa *
.RE
links all files in the current directory to the directory /usr/joe.
.SH "SEE ALSO"
csh(1), sh(1)
.SH AUTHOR
Rob Pike
.SH BUGS
Shell metacharacters in
.I command
may have bizarre effects; it is best to enclose complicated
commands in single quotes \(aa\ \(aa.
.sp
There is no way to pass a literal `%2' if `%' is the
argument expansion character.
a2 b2 ...
.RE
compares the `a' files to the `b' files;
.PP
.RS
apply \-0 who 1 2 3 4 5
.RE
runs 
.IR who (1) 
5 times; and
.PP
.RS
apply \(aaln %1 /usr/joe\(aa *
.RE
links allu_man/man1/arch.1d                                                                                     664    1776     311         3403  3525522570   7264                                                                                                                                                                                                                                                                                                                                                                      .TH ARCH 1D
.SH NAME
arch \- display a simulated architectural model
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/arch  
.PP
.BR /usr/people/mexdemos/arch \0\0(GL2 only)
.in
.ad
.hy
.SH DESCRIPTION
.PP
.I Arch
displays a model of an imaginary city block.
Operator controls adjust the viewing position and select one or several
structures for display.
.PP
Most of the user interface is through the mouse buttons.
Each non-zero combination of mouse buttons causes a different viewpoint
movement.
The mouse valuators are ignored.
.PP
In the initial state, a single building is displayed.
Typing keys create different actions.
.nf
.sp
	Key 	Function
.sp
	s	turn on (or off) wireframe buildings that complete the block.
.br
	f 	cover (or uncover) building surfaces
.br 
	m	turn on (or off) automatic movement around the city
.br
	r 	to initialize the program
.br
	h 	for help menu (does not work in window manager)
.br
	ESC 	to exit the program
.sp
.fi
.SH "DISPLAY OPTIONS (GL2 only)"
.PP
Upon entry into the program,
.I arch
is set for NTSC or high resolution output, depending on the currently
selected monitor.
The display monitor can be altered during program execution by
pressing the proper control character.
.nf
.sp
	Key		Display Monitor
.sp
	CTRL-a		60 HZ monitor
.br
	CTRL-b		30 HZ monitor
.br 
	CTRL-c		NTSC (RS-170A) display
.br
	CTRL-d		PAL (European Video) display
.sp
.fi
.SH "WINDOW MANAGER (GL2 only)"
.PP
The window manager version of arch only runs 
with the 60 Hz non-interlaced monitor.
If the site is in constant motion, it stays in motion, even if
the window is detached.
.sp
There is no help menu in the window manager version of arch.
Raster fonts do not scale to arbitrarily sized windows.
.SH AUTHOR
.PP
Gary Tarolli
\.".SH BUGS
\.".PP
\."Some of the colors are a bit tacky.
Z monitor
.br 
	CTRL-c		NTSC (RS-170A) display
.br
	CTRL-d		PAL (European Video) display
.sp
.fi
.SH "WINDOW MANAGER (GL2 only)"
.PP
The window manager version of arch only runs 
with the 60 Hz non-interlaced monitor.
If the site is in constant motion, u_man/man1/as20.1                                                                                      664    1776     311         1703  3536624533   6755                                                                                                                                                                                                                                                                                                                                                                      .TH AS20 1
.SH NAME
as20 \- assembler
.SH SYNOPSIS
.B as20
.B \-o
objfile [
.B \-i
] [\ inputfile\ ]
.SH DESCRIPTION
.I as20\^
assembles the 68010 or 68020 assembly language file
.I inputfile.
If no file name is specified the standard input is used.
.PP
All undefined symbols in the assembly are treated as global.
.PP
The relocatable output of the assembly is put in the file
.IR objfile ,
which 
must
be specified.
.PP
The
.B \-i
option restricts 
the instruction set of
.I as20
to 68010 instructions.
.SH EXAMPLE
.IP
as20 \-o file.o filea 
.PP
would assemble the 
file ``filea'' and put the output
of the assembly into ``file.o''.
.IP
/lib/ccom file.c | as20 -o file.o
.PP
would cause 
.I as20
to assemble the output of 
``/lib/ccom''
and place the resultant object file in
``file.o''.
.SH "SEE ALSO"
adb(1),
ld(1),
nm(1),
a.out(4)
.br
.IR "AS20 Reference Guide" ,
in Appendix L of the 
.I "IRIS Workstation Guide, Series 2000" 
.\"	@(#)as20.1	5.1 of 11/15/83
he instruction set of
.I as20
to 68010 instructions.
.SH EXAMu_man/man1/bckgrnd.1d                                                                                  644    1776     311          464  3543636730   7747                                                                                                                                                                                                                                                                                                                                                                      .TH BCKGRND 1D
.SH NAME
bckgrnd \- generate a textured background texture
.SH SYNOPSIS
.B bckgrnd 
number
.SH DESCRIPTION
.I bckgrnd 
generates a textured background for the window manager.
.I number 
is an integer from 1 to 16 which selects a texture 
pattern; larger numbers
produce unpredictable results.
m(1),
a.out(4)
.br
.IR "AS20 Reference Guide" ,
in Appendix L of the 
.I "IRIS Workstation Guide, Series 2000" 
.\"	@(#)as20.1	5.1 of 11/15/83
he instruction set of
.I as20
to 680/doc/vol1/u_man/man1     u_man/man1/bfs.1                                                                                       664    1776     311        15345  3534737626   7017                                                                                                                                                                                                                                                                                                                                                                      .TH BFS 1
.SH NAME
bfs \- big file scanner
.SH SYNOPSIS
.B bfs
[
.B \-
] name
.SH DESCRIPTION
.I bfs\^
is (almost) like
.IR ed\^ (1)
except that it is read-only
and processes much larger files.
Files can be up to 1024K bytes (the maximum possible size) and
32K lines, with up to 255 characters per line.
.I bfs\^
is usually more efficient than
.I ed\^
for scanning a file,
since the file is not copied to a buffer.
It is most useful for identifying sections of
a large file where
.IR csplit\^ (1)
can be used to divide it into more manageable pieces for editing.
.PP
Normally,
the size of the file being scanned is printed,
as is the size of any file written with the
.B w
command.
The optional
.B \-
suppresses printing of sizes.
Input is prompted with
.B \(**
if
.B P
and a carriage return are typed as in
.IR ed .
Prompting can be turned off again by
inputting another
.B P
and carriage
return.
Note that messages are given in response
to errors if prompting is turned on.
.PP
All address expressions described under
.I ed\^
are supported.
In addition, regular expressions may be surrounded with two
symbols besides
.B /
and
.BR ? :
.B >
indicates
downward search without wrap-around,
and
.B <
indicates upward search without wrap-around.
Since
.I bfs\^
uses a different regular expression-matching routine
from 
.IR ed ,
the regular expressions accepted are slightly wider in scope (see
.IR regcmp\^ (3X)).
There is a slight difference in mark names: only the letters
.B a
through
.B z
may be used,
and all 26 marks are remembered.
.PP
The
.BR e ,
.BR g ,
.BR v ,
.BR k ,
.BR p ,
.BR q ,
.BR w ,
.BR = ,
.B !
and null
commands operate
as described under
.IR ed .
The
.BR n 
command does not operate as described in
.IR ed ;
when invoked, it prints the names of all marks
that are currently set.
Commands such as \f3\-\-\-\fP, \f3+++\-\fP,
\f3+++=\fP, \f3\-12\fP, and \f3+4p\fP are accepted.
Note that \f31,10p\fP and \f31,10\fP will both print 
the first ten lines.
The
.B f
command only prints the name of the file being scanned;
there is no 
.I remembered\^
file name.
The
.B w
command is independent of output diversion,
truncation, or crunching
(see the
.BR xo , \ xt \ and \ xc
commands, below).
The following additional commands are available:
.RS .3i
.TP .3i
.BI xf " file"\^
Further commands are taken from the named
.IR file .
When an end-of-file is reached,
an interrupt signal is received or an error occurs,
reading resumes with the
file containing the
.BR xf .
.B \s-1X\s0f
commands may be nested to a depth of 10.
.TP 
.BI xo " \f1[\^\fPfile\f1\^]\fP"\^
Further output from the
.B p
and null
commands is diverted to the named
.IR file ,
which, if necessary, is created mode 666.
If
.I file\^
is missing, output is diverted to the standard output.
Note that each diversion causes truncation
or creation of the file.
.TP 
.BI : " label"\^
This positions a
.I label\^
in a command file.
The
.I label\^
is terminated by new-line, and
blanks between the
.B :
and the start of the
.I label\^
are ignored.
This command may also be used to insert comments
into a command file,
since labels need not be referenced.
.TP 
( \f3. \f1, \f3. \f1)\f3xb\fP/\f2regular expression\fP/\f2label\f1
A jump (either upward or downward) is made to \f2label\fP if
the command succeeds.
It fails under any of the following conditions:
.RS
.IP "1." 3
Either address is not between
.B 1
and
.BR $ .
.IP 2. 
The second address is less than the first.
.IP 3. 
The regular expression doesn't match at least one line
in the specified range, including the first and last lines.
.RE
.TP
\&
On success, \f3\s+3.\s0\fP is set to the line matched and a jump
is made to \f2label\fP.
This command is the only one that doesn't issue an error
message on bad addresses, so it may be used to
test whether addresses are bad before other commands are executed.
Note that the command
.RS 10
.sp
xb/^/ label
.RE
.TP
\&
is an unconditional jump.
.br
The
.B xb
command is allowed only if
it is read from someplace other than a terminal.
If it is read from a pipe only a downward jump is possible.
.TP
.BI xt " number"\^
Output from the
.B p
and null commands is
truncated to at most
.I number\^
characters.
The initial number is 255.
.TP
\f3xv\f1[\^\f2digit\f1\^]\|[\^\f2spaces\f1\^]\|[\^\f2value\f1\^]
The variable name is the specified
.I digit\^
following the \f3xv\fP.
\f3xv5100\fP or \f3xv5 100\fP both
assign the value 
\f3100\fP to the variable
.BR 5 .
.B \s-1X\s0v61,100p
assigns the value
.B 1,100p
to the variable
.BR 6 .
To reference a variable, put a
.B %
in front of the variable name.
For example, using the above assignments
for variables \f35\fP and \f36\fP:
.PP
.RS 10
1,%5p
.br 
1,%5
.br 
%6
.br
.RE
.TP
\&
will all print the first 100 lines.
.PP
.RS 10
g/%5/p
.RE
.TP
\&
would globally search for the characters \f3100\fP
and print each line containing a match.
To escape the special meaning of
.BR % ,
a
.B \e
must
precede it.
.PP
.RS 10
g/".*\\%[cds]/p
.RE
.TP
\&
could be used to match and list lines 
containing
.I printf\^
of characters, decimal integers, or strings.
.bp
Another feature of the
.B xv
command is that the first line
of output from a \s-1UNIX\s0 System command can
be stored into a variable.
The only
requirement is that the first character
of
.I value\^
be an
\f3!\fP.
For example:
.PP
.RS 10
\f3\&.\f1w junk
.br
xv5!cat junk
.br 
!rm junk
.br 
!echo "%5"
.br 
xv6!expr %6 + 1
.RE
.TP
\&
would put the current line into variable \f35\fP,
print it, and increment the variable \f36\fP by one.
To escape the special meaning of
.B !
as the
first character of
.IR value ,
precede it with a
\f3\e\fP.
.PP
.RS 10
.br
.ne 2v
xv7\\!date
.RE
.TP
\&
stores the
value \f3!date\fP into
variable \f37\fP.
.TP
.BI xbz " label"\^
\&
.PD 0
.TP
.BI xbn " label"\^
.PD
These two commands will test the last saved
.I "return code\^"
from the execution of a
.SM UNIX
System command
(\f3!\f2command\^\f1)
or nonzero value, respectively, to the
specified label.
The two examples below both 
search for the next five lines containing
the string \f3size\fP.
.PP
.RS 10
xv55
.br 
: l
.br 
/size/
.br 
xv5!expr %5 \- 1
.br 
!if 0%5 != 0 exit 2
.br 
xbn l
.br
xv45
.br 
: l
.br 
/size/
.br 
xv4!expr %4 \- 1
.br 
!if 0%4 = 0 exit 2
.br 
xbz l
.br
.RE
.TP
\f3xc\fP\ [\f2switch\fP\^]
If
.I switch\^
is \f31\fP, output from the
.B p
and null commands is crunched;
if
.I switch\^
is \f30\fP it isn't.
Without an argument,
.B xc
reverses \f2switch\fP.
Initially \f2switch\fP is set for no crunching.
Crunched output has strings of tabs and blanks reduced
to one blank and blank lines suppressed.
.RE
.PP
.i0
.ne 5
.fi
.i0
.SH EXAMPLE
.IP
bfs text
.PP
will invoke \f2bfs\^\f1 with the file named "text".
.bp
.SH "SEE ALSO"
csplit(1), ed(1), regcmp(3X).
.SH DIAGNOSTICS
.B ?
for errors in commands, if prompting is turned off.
Self-explanatory error messages when prompting is on.
.\"	@(#)bfs.1	5.1 of 11/17/83
n't.
Without an argument,
.B xc
reverses \f2switch\fP.
Initially \f2switch\fP is set for no crunching.
Crunched output has strings of tabs and blanks reduced
to one blank and blank lines suppressed.
.RE
.PP
.i0
.ne 5
.fi
.i0
.SH EXAMPLE
.IP
bfs text
.PP
will invoke \f2bfs\^\f1 with u_man/man1/capture.1g                                                                                  664    1776     311         1321  3525461304  10007                                                                                                                                                                                                                                                                                                                                                                      .TH CAPTURE 1G
.rs
.sp 0.1i
.SH\(Dy
.SH NAME 
capture
\- dump screen images to file or hard copy device.
.SH SPECIFICATION
.B capture
[ dest ]
.sp
.SH DESCRIPTION
.I Capture
dumps a representation of the screen into the file
.I dest
in a format
compatible with a Tektronix 4692 color inkjet printer.
The function used to open the destination,
.I dest ,
for output
allows for spooling to other machines (print servers) as described
in the \f2coloropen\f1(3).
For example, if
.I dest
is a colon ( : ), then 
.IR coloropen (3)
will send the output via XNS to a remote
printer.
.SH "SEE ALSO"
colord(1), capture(3G), coloropen(3), tek(7)
.SH NOTE
This command works only on Series 2000 workstations under the window manager.
n into the file
.I dest
in a format
compatible with a Tektronix 4692 color inkjet printer.
The function used to open the destination,
.I dest ,
for output
allows for spooling to other machines (print servers) as described
in the \f2coloropen\f1(3).
For example, if
.I dest
is a colon ( : ), then 
.IR cou_man/man1/cc.1j                                                                                       664    1776     311        34742  3540722411   6765                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH CC 1
.SH NAME
cc, pc, f77 \- C, Pascal and FORTRAN compilers for the 68000/68020
.SH SYNOPSIS
.B cc
[ options ] files ...
.br
.B pc
[ options ] files ...
.br
.B f77
[ options ] files ...
.SH DESCRIPTION
.I cc
is a general driver for the U\s-2NIX\s+2 C, Pascal and FORTRAN compilers 
for the 68000/68020.  It is
also available under the names
.I f77
and
.I pc.
The names are synonymous 
.I except
during the linking phase, when it is used to create the
appropriate run-time environment.
.I cc 
accepts many types of input files, determined by the file's suffix.
The highest form of input is language source:  
C (\f2.c\fP), Pascal (\f2.p\fP) or
FORTRAN (\f2.f\fP\^).
These are tranlated to assembler (in the case of C), to 
U\s-2NIX\s+2 object files (\f2.o\fP), 
and finally to an executable file called \f2a.out\fP.
Input to
.I cc
may consist of any of these types of files
and translation may be stopped at any point.
.PP
Translation proceeds as follows:
.TP 8
a)
Each
.IR .c ,
.I .p
and
.I .f
input is run through the C macro preprocessor
\f2cpp\fP.  In the case of Pascal source, 
.I cpp 
is given the
.B "\-p"
switch. This switch tells 
.I cpp
to ignore Pascal-style comments and do the
correct things with preprocessor control lines so that the
line numbers in the resultant Pascal file will be the same as
the original.
.TP 8
b)
The preprocessed C files are then run through the C compiler
.I ccom
and, if specified, 
the C optimizer
.I c2.
The resulting
.I .s
files are then assembled,
producing U\s-2NIX\s+2 binaries (\f2.o\fP).
.TP 8
c)
Preprocessed FORTRAN (\f2.f\^\^\fP) and Pascal (\f2.p\fP) files are run 
through the
appropriate SVS front end,
.I fortran
or 
.I pascal,
then through the code generator 
.I code,
and object code formatter
.I ulinker,
to produce a U\s-2NIX\s+2 binary (\f2.o\fP).
.TP 8
d)
Finally, all U\s-2NIX\s+2 object files are passed to
\f2ld\fP(1),
along with the U\s-2NIX\s+2 startup file
.I /lib/crt0.o,
and the appropriate libraries,
to produce a single executable named
\f2a.out\fP.
.PP
Preprocessed source files and assembler files are usually removed.
All U\s-2NIX\s+2 binaries (\f2.o\fP) 
are preserved, 
.B unless 
there was
a single source (\f2.f\fP, \f2.p\fP, or \f2.c\fP) file being compiled, no
previously-compiled binaries are being loaded, and the
compilation is continuing to an executable.  In this case, the single
binary file is not saved.
.PP
If C and FORTRAN files are mixed in a single executable, special
interface routines may need to be generated as described in Appendix C
of the \f2IRIS Workstation Guide, Series 2000\fP.
If C and Pascal procedures are mixed, the user should consult the
\f2SVS Pascal Reference Manual\fP for instructions on altering the external
procedure declarations in Pascal.
.SH OPTIONS
The following options are interpreted by
.I "cc (f77,pc)."
Some options have meaning for only one of these languages.
(see
.IR ld (1)
for load-time options):
.TP 8
.B \-c
Suppress the loading phase of the compilation, and force
an object file to be produced even if only one source file is given.
.TP
.B \-g
Generate debugging information.
Currently, this does not have meaning when C is intermixed with
another language.  For FORTRAN and Pascal files, the
appropriate 
compiler will be called with the 
.B +d 
switch.  This causes
a symbol table to be produced for \f3each\f1 binary and placed
in a file with the suffix \f2odbg\fP.
When the load step is performed, the symbol tables for each object file
are combined and placed in a file named
\f2x.dbg\fP,
where
.I x
is the name of the final program.  For pure C programs, additional
symbol table information 
will be generated for 
.IR dbx (1).  
.TP
.BI \-l\^ x
Include lib\f2x\fP.a as a library which
.I ld
should search for undefined references.
.I ld
will look for the library first in the directory
.I lib,
then in
\f2usr/lib\fP, and finally in \f2usr/local/lib\fP relative
to the root of the library tree.  The root of the library
tree defaults to \f2/\fP, but may be set using the \f3\-ZR\fP
switch.
The string
.I x
may be more than one letter.
.TP
.B \-\^\^\-n
Normally,
.I cc
passes the
.B \-n
switch to
\f2ld\fP,
which causes it to load the program with shared text.  The
.B \-\^\^\-n
switch suppresses the passing of 
.B \-n 
to 
.I ld.
.TP
.B \-o\0\f2output\fP
Name the final output file \f2output\fP.  \f2output\fP is normally
an executable; however,
if a single input file is being translated to a \f2.s\fP or a \f2.o\fP 
file, the final output file will be named \f2output\fP, regardless of its type.
This provides a facility for naming an output file by other than the
default method of suffix-replacement.
.TP
.B \-p
Tell
.I ccom
to generate code to count subroutine calls for use with
\f2prof\^\^\fP(1).
FORTRAN and Pascal do not support profiling.
.TP
.B \-\^\^\-x
By default,
.I cc
passes the
.B \-x
flag to
\f2ld\fP,
in order to suppress local symbols from the final symbol table.  The
.B \-\^\^\-x
flag inhibits this default.  The 
.B \-\^\^\-x 
switch should not be used
in conjunction with the 
.B \-r 
switch.
.TP
.B \-C
Prevent the macro preprocessor from removing C style comments 
found in the source.  Such comments are 
.B always 
removed from Pascal programs.
.TP
.BR \-D\^ \f2name\=def\fP
.br
.ns
.TP
.BR \-D\^ \f2name\fP
Define the
.I name
to the preprocessor,
as if by
\f2#define\fP.  (There should be no blanks between the 
.B D 
and the
symbol to be defined.)
If no definition is given,
the name is defined as ``1''.
.TP
.B \-E
Run only the macro preprocessor
on the named C, Pascal and FORTRAN source
and send the result to the
standard output.
.TP
.BR \-I\^ \f2dir\fP
Look in directory
.I dir
for missing
.I #include
files.
Include files
whose names are surrounded by double quotes and
do not begin with `/' are always
first sought in the directory
of the input file,
then in directories named in
.I \-I
options,
then in
\f2/usr/include\fP.
Include files with names beginning with `/' are treated as absolute paths.
The directory of the input file is not used as a search path for
include files whose names are surrounded by pointed brackets.
(There should be no blanks between the directory name and the switch.)
.TP
.B \-L
Produce a FORTRAN listing of each FORTRAN source file.
FORTRAN listings have the
suffix
.I .l .
.TP
.BR \-O\^ \f2xx\fP
Invoke an
object-code improver on each C file.
.I xx
are the options to
\f2c2\fP.
Possible options are 
.B S 
(perform stack optimizations), 
.B P 
(remove
stackprobes), 
.B K 
(omit kernel optimizations).  Use of these
options is not recommended for the standard compilation environment.
(There should be no blanks between the switch and the options.)
.TP
.B \-P
Run only the macro preprocessor
on the named C, FORTRAN, and Pascal files,
and place the results on 
.I "file.i" .
.TP
.B \-S
Compile the named C files, leaving the
C assembly language output in files suffixed
.I .s .
.TP
.BR \-U\^ \f2name\fP
Remove any initial definition of
\f2name\fP. (There should be no blanks between U and the
name to be undefined.)
.TP
.B \-Zf
Cause
instructions for the floating-point accelerator to be generated.
Use of this
switch on systems which do NOT have the floating-point accelerator installed
will cause a run-time abort.  
Programs which expect to use the floating point accelerator must be
both compiled and loaded with 
.B \-Zf .
.TP
.B \-Zg
Load the program with the special files and libraries necessary for
IRIS graphics programs.  When this switch is used, the Graphics Library
.B "\-lgl"
and the appropriate math library 
is given by default.  
Special files must be loaded for using graphics with each 
source language.  Hence, 
.I cc
must be able to determine the combination of languages involved
in the link step.
If the compilation line specified 
.I f77,
a FORTRAN source file (with the extension 
.IR .f\^\^ ) 
.B or 
the
switch 
.B \-ZF 
is given, 
.I cc 
assumes that FORTRAN routines are present. In this case, 
the program is also loaded with
the FORTRAN graphics interface library
.B "\-lfgl" .
If the compilation line specified 
.I pc,
a Pascal source file (with the extension 
.IR .p ) 
.B or 
the switch 
.B \-ZP 
is given,
.I cc 
assumes that Pascal routines are present.  The program is
loaded with the special Pascal jump table (\f2/usr/lib/pjmptbl.o\fP).
.TP
.BR \-Zi\^ \f2filename\fP
Use the file named
.I filename
as the run-time startup, rather than the standard C run-time startup.
This may be useful for generating stand-alone programs.
(There should be no blanks between the filename and the switch.)
.TP
.B \-Zq
Time all subprocesses, and report these times on
.I stdout
at the end of the compilation.
.TP
.B \-Zr
Load the program for the remote graphics environment.  
If the source contains FORTRAN or \f2f77\fP has
been invoked,
the FORTRAN remote Graphics Library will be loaded, otherwise the
C remote Graphics Library will be loaded.
As does loading  the standard Graphics Library, 
loading the remote Graphics Library
automatically causes the math library
to be loaded.
If the program is a C program, the directory 
.I "/usr/include/rgl"
will be searched prior to 
.I "/usr/include"
for graphics header files.
.TP
.B \-Zv
Turn on
.I verbose
mode. In verbose mode,
the C compiler
.I ccom
will give additional diagnostics.
This includes such things as flagging any use of the C type
.I double,
and complaining about too many register declarations.
.TP
.B \-Zz
Print a trace of all
.I exec()
calls.
.TP
.B \-ZA
Pass the remainder of the string to
\f2as\fP.
Thus, the
.I cc
switch
.B \-ZA\^\-q
will pass \f2as\fP the switch
\f3\-q\fP.
.TP
.B \-ZC
Pass the remainder of the string to
\f2ccom\fP.
Thus, the
.I cc
switch
.B \-ZC\^\-v
will pass \f2ccom\fP the switch
\f3\-v\fP.
.TP
.B \-ZF
Pass the remainder of the string to the
FORTRAN compiler front-end 
.I fortran.
Thus, the
.I cc
switch
.B \-ZF\^\+d
will pass 
.I fortran
the switch
\f3\+d\fP.  This switch (with or without a switch to pass to
the FORTRAN front-end) also informs 
.I cc 
that FORTRAN files were present in the compilation.  
.TP
.B \-ZN
Pass the \f3\-N\fP switch to \f2cpp\fP(1).  This switch causes 
\f2cpp\fP(1) to 
\f3NOT\f1 look in 
.I /usr/include 
for include files.
.TP
.B \-ZP
Pass the remainder of the string to the
Pascal compiler front-end 
.I pascal.
Thus, the
.I cc
switch
.B \-ZP\^\+d
will pass 
.I pascal
the switch
\f3\+d\fP.  This switch (with or without a switch to pass to
the Pascal front-end) also informs 
.I cc 
that Pascal files were present in the compilation.  
.I cc
cannot determine this unless it sees a 
.I .p 
file or the name
.I pc
is used.
.TP
.B \-ZR\0\f2libroot\fP
Pass the \f2\-R libroot\fP switch to 
the loader (\f2ld\fP(1)).  This causes it to 
use the directory \f2libroot\fP as the
root of the tree for its search to find libraries specified by the \f3\-l\f2x\f1
method.  Relative to this library root, \f2ld\fP will successively
search for lib\f2x\fP.a
in \f2lib\fP, \f2usr/lib\fP, and \f2usr/local/lib\fP.  If no 
\f3\-ZR\fP switch
is given, the loader will use \f2/\fP as its default \f2libroot\fP.
.PP
Other flags are passed to \f2ld\fP.
The files may consist of any mix of C, object, FORTRAN, assembler,
binary or library files.
The files are passed to
.I ld,
if opted, after rearranging according to the file type,
to produce an executable program named
.I a.out
or that specified by the
.B \-o
option.  Files of unknown type (i.e., with an extension other
than \f2.c\fP, \f2.f\fP, \f2.o\fP, \f2.a\fP, \f2.p\fP,
or \f2.s\fP) are given to \f2ld\fP as if they had been previously
loaded (i.e., are in \f2a.out\fP format). The order of files of unknown type
in the load step is indeterminate.
.SH FILES
.TS
;
l l.
file.c	C source file
file.f	FORTRAN source file
file.p	Pascal source file
file.o	binary (relocatable) file
file.s	assembly file
a.out	executable file
/lib/ccom	C compiler
/lib/cpp	C preprocessor
/lib/crt0.o	run time startup
/lib/libc.a	C library
/usr/lib/libf.a	FORTRAN library
/usr/lib/libp.a	FORTRAN and Pascal library
/usr/lib/fortran20	FORTRAN front-end
/usr/lib/pascal20	Pascal front-end
/usr/lib/jcode20	FORTRAN code-generator
/usr/lib/jlinker	FORTRAN pre-linker
/bin/as20	68020 assembler
/bin/ld	linking loader
/usr/include	default include directory
/usr/lib/pjmptbl.o	Pascal graphics jump table and C string converter
.TE
.SH "SEE ALSO"
\f2IRIS Workstation Guide\fP, 
Appendices D and E.
.br
\f2IRIS Workstation Guide, Series 2000\fP, Appendices C and D.
.br
B. W. Kernighan and D. M. Ritchie,
\f2The C Programming Language\fP,
Prentice-Hall,
1978
.br
B. W. Kernighan,
.I "Programming in C\(ema Tutorial"
.br
D. M. Ritchie,
.I "C Reference Manual"
.br
.I "SVS FORTRAN Reference Manual"
.br
.I "SVS Pascal Reference Manual"
.br
.I "As20 Reference Manual" ,
Appendix L, 
.I "IRIS Workstation, Guide, Series 2000"
.br
as20(1),
ccom(1),
cpp(1),
ld(1),
extcentry(1),
mkf2c(1),
a.out(5)
.SH BUGS
Three bugs are currently outstanding in the C compiler system.  The first
bug is the result of the compiler running out of temporary registers when
compiling an expression.  This has been seen to occur in an expression such as
.I "junk[c].i += a"
and in certain bitfield assignment expressions
in a function which contains many register variables.  The compiler aborts
with the message
``expression causes compiler loop, try simplifying''.
Rather than to reserve an additional register for the compiler's internal use,
it has been left to the user to alleviate this problem by reducing the 
number of data registers being
used in this instance to five or fewer.  
.PP
The second bug occurs when using the optimizer 
.I c2.
In certain situations, the optimizer gets confused as to the boundary between
functions when optimizing functions which are declared as 
.I static.
This can result in optimizing away necessary register save/restore code at
function entry and exit.  
Although the problem occurs rarely even in conjunction with such declarations,
users are currently warned against declaring
functions as 
.I static
when using the optimizer. 
.PP
The third bug occurs when passing an autoincremented (or autodecremented)
bit field to a function, as in
.I "foo(a.i++),"
where 
.I i 
is a bitfield element of structure 
.I foo.
In some cases, the compiler will autoincrement the bitfield correctly,
but pass the incorrect value to \f2foo\fP.  The value may have little or
no relationship to the true value of
.I "a.i"
either before or after autoincrementing.
.PP
If the variable is a bitfield, the compiler may also 
complain about assigning enumeration constants
to variables of that type.
The complaint is in the form of a 
warning, and the correct code is generated.
.SH DIAGNOSTICS
The diagnostics produced by C, FORTRAN, and Pascal are intended to be
self-explanatory.
Occasional messages may be produced by the assembler
or loader.
e to \f2foo\fP.  The value mayu_man/man1/cedit.1w                                                                                    644      53     311         1420  3543644675   7413                                                                                                                                                                                                                                                                                                                                                                      .TH CEDIT 1W
.SH NAME
cedit \- edit colors on the screen
.SH SYNOPSIS
.B cedit
.SH DESCRIPTION
The frame buffer of the IRIS contains values which are translated into
RGB values by a color map. 
.I cedit
changes the mapping of any color index.
Three sliders are displayed, along with a sample patch of the color 
being edited.  A click of the left button outside the screen area of 
.I cedit
picks up a color index to be edited.  The sliders indicate
the red, green, and blue components of the current color.  The color
can be changed by clicking down on a slider, and adjusting the position
of the control.
.SH SEE ALSO
showmap(1W)
.SH BUGS
If another process changes the color entry being edited, the sliders
of 
.I cedit 
do not indicate the correct positions for that color index.
along with a sample patch of the color 
being edited.  A click of the left button outside the screen area of 
.I cedit
picks up a color index to be edited.  The sliders indicate
the red, green, and blue components of the current color.  Theu_man/man1/ci.1                                                                                        664    1776     311        17647  3541106362   6630                                                                                                                                                                                                                                                                                                                                                                      .TH CI 1
.SH NAME
ci \- check in RCS revisions
.SH SYNOPSIS
.B ci
[ options ]
file ...
.SH DESCRIPTION
.I Ci
stores new revisions into RCS files.
Each file name ending in `,v' is taken to be an RCS file, all others
are assumed to be working files containing new revisions.
\f2Ci\f1 deposits the contents of each working file
into the corresponding RCS file.
.PP
Pairs of RCS files and working files may be specified in 3 ways (see also the
example section of \f2co\f1 (1)).
.PP
1) Both the RCS file and the working file are given. The RCS file name is of
the form \f2path1/workfile\f1,v
and the working file name is of the form
\f2path2/workfile\f1, where 
\f2path1/\f1 and
\f2path2/\f1 are (possibly different or empty) paths and
\f2workfile\f1 is a file name.
.PP
2) Only the RCS file is given. 
Then the working file is assumed to be in the current
directory and its name is derived from the name of the RCS file
by removing \f2path1/\f1 and the suffix `,v'.
.PP
3) Only the working file is given. 
Then the name of the RCS file is derived from the name of the working file
by removing \f2path2/\f1
and appending the suffix `,v'.
.PP
If the RCS file is omitted or specified without a path, then \f2ci\f1
looks for the RCS file first in the directory ./RCS and then in the current
directory. 
.PP
For \f2ci\f1 to work, the caller's login must be on the access list,
except if the access list is empty or the caller is the superuser or the
owner of the file.
To append a new revision to an existing branch, the tip revision on
that branch must be locked by the caller. Otherwise, only a 
new branch can be created. This restriction is not enforced
for the owner of the file, unless locking is set to \f2strict\f1
(see \f2rcs\f1 (1)).
A lock held by someone else may be broken with the \f2rcs\f1 command.
.PP
Normally, \f2ci\f1 checks whether the revision to be deposited is different
from the preceding one. If it is not different, \f2ci\f1
either aborts the deposit (if \f3\-q\f1 is given) or asks whether to abort
(if \f3\-q\f1 is omitted). A deposit can be forced with the \f3\-f\f1 option.
.PP
For each revision deposited, \f2ci\f1 prompts for a log message.
The log message should summarize the change and must be terminated with
a line containing a single `.' or a control-D.
If several files are checked in, \f2ci\f1 asks whether to reuse the
previous log message.
If the standard input is not a terminal, \f2ci\f1 suppresses the prompt 
and uses the same log message for all files.
See also \f3\-m\f1.
.PP
The number of the deposited revision can be given by any of the options
\f3\-r\f1, \f3\-f\f1, \f3\-k\f1, \f3\-l\f1, \f3\-u\f1, or \f3\-q\f1 
(see \f3\-r\f1).
.PP
If the RCS file does not exist, \f2ci\f1 creates it and
deposits the contents of the working file as the initial revision
(default number: 1.1).
The access list is initialized to empty.
Instead of the log message, \f2ci\f1 requests descriptive text (see
\f3\-t\f1 below).
.TP 10
.B \-r\f1[\f2rev\f1] 
assigns the revision number \f2rev\f1 
to the checked-in revision, releases the corresponding lock, and
deletes the working file. This is also the default.
.PP
If \f2rev\f1 is omitted, \f2ci\f1 derives the new revision number from
the caller's last lock. If the caller has locked the tip revision of a branch,
the new revision is appended to that branch. The new revision number is obtained
by incrementing the tip revision number.
If the caller locked a non-tip revision, a new branch is started at
that revision by incrementing the highest branch number at that revision.
The default initial branch and level numbers are 1.
If the caller holds no lock, but he is the owner of the file and locking
is not set to \f2strict\f1, then the revision is appended to the trunk.
.PP
If \f2rev\f1 indicates a revision number, it must be higher than the latest
one on the branch to which \f2rev\f1 belongs, or must start a new branch.
.PP
If \f2rev\f1 indicates a branch instead of a revision,
the new revision is appended to that branch. The level number is obtained
by incrementing the tip revision number of that branch.
If \f2rev\f1 indicates a non-existing branch,
that branch is created with the initial revision numbered \f2rev.1\f1.
.PP
Exception: On the trunk, revisions can be appended to the end, but
not inserted.
.TP 10
.B \-f\f1[\f2rev\f1]
forces a deposit; the new revision is deposited even it is not different
from the preceding one.
.TP 10
.B \-k\f1[\f2rev\f1]
searches the working file for keyword values to determine its revision number, 
creation date, author, and state (see \f2co\f1 (1)), and assigns these 
values to the deposited revision, rather than computing them locally.
A revision number given by a command option overrides the number
in the working file.
This option is useful for software distribution. A revision that is sent to
several sites should be checked in with the \f3\-k\f1 option at these sites to 
preserve its original number, date, author, and state. 
.TP 10
.B \-l\f1[\f2rev\f1]
works like \f3\-r\f1, except it performs an additional \f2co\f3 \-l\f1 for the
deposited revision. Thus, the deposited revision is immediately
checked out again and locked.
This is useful for saving a revision although one wants to continue 
editing it after the checkin.
.TP 10
.B \-u\f1[\f2rev\f1]
works like \f3\-l\f1, except that the deposited revision is not locked.
This is useful if one wants to process (e.g., compile) the revision
immediately after checkin.
.TP 10
.B \-q\f1[\f2rev\f1] 
quiet mode; diagnostic output is not printed.
A revision that is not different from the preceding one is not deposited,
unless \f3\-f\f1 is given.
.TP 10
.BI \-m "msg"
uses the string \f2msg\f1 as the log message for all revisions checked in.
.TP 10
.BI \-n "name"
assigns the symbolic name \f2name\f1 to the number of the checked-in revision.
\f2ci\f1 prints an error message if \f2name\f1 is already assigned to another
number.
.TP 10
.BI \-N "name"
same as \f3\-n\f1, except that it overrides a previous assignment of \f2name\f1.
.TP
.BI \-s "state"
sets the state of the checked-in revision to the identifier \f2state\f1.
The default is \f2Exp\f1.
.TP
.B \-t\f1[\f2txtfile\f1]
writes descriptive text into the RCS file (deletes the existing text).
If \f2txtfile\f1 is omitted, 
\f2ci\f1 prompts the user for text supplied from the standard input,
terminated with a line containing a single `.' or \s-2CTRL-d\s0.
Otherwise, the descriptive text is copied from the file \f2txtfile\f1.
During initialization, descriptive text is requested
even if \f3\-t\f1 is not given.
The prompt is suppressed if standard input is not a terminal.
.SH DIAGNOSTICS
For each revision,
\f2ci\f1 prints the RCS file, the working file, and the number
of both the deposited and the preceding revision.
The exit status always refers to the last file checked in,
and is 0 if the operation was successful, 1 otherwise.
.SH "FILE MODES"
An RCS file created by \f2ci\f1 inherits the read and execute permissions
from the working file. If the RCS file exists already, \f2ci\f1
preserves its read and execute permissions.
\f2ci\f1 always turns off all write permissions of RCS files. 
.SH FILES
The caller of the command
must have read/write permission for the directories containing
the RCS file and the working file, and read permission for the RCS file itself.
A number of temporary files are created.
A semaphore file is created in the directory containing the RCS file.
\f2ci\f1 always creates a new RCS file and unlinks the old one.
This strategy makes links to RCS files useless.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.1 $
; Release Date:
.VL $Date: 89/03/27 16:19:38 $
\&.
.sp 0
Copyright \(co 1982 by Walter F. Tichy.
.SH SEE ALSO
co (1), ident(1), rcs (1), rcsdiff (1), rcsintro (1), rcsmerge (1), 
rlog (1), rcsfile (5)
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \f2Proceedings of the 6th International Conference on Software
Engineering\f1, IEEE, Tokyo, Sept. 1982.

: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.u_man/man1/clock.1w                                                                                    644      53     311          244  3543644675   7401                                                                                                                                                                                                                                                                                                                                                                      .TH CLOCK 1W
.SH NAME
clock \- display the current time of day 
.SH SYNOPSIS
.B clock
.SH DESCRIPTION
clock displays a simple graphical (analog) clock in a window.
 (1), rcsintro (1), rcsmerge (1), 
rlog (1), rcsfile (5)
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \f2Proceedings of the 6th International Conference on Software
Engineering\f1, IEEE, Tokyo, Sept. 1982.

: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907./doc/vol1/u_man/man1     u_man/man1/co.1                                                                                        664    1776     311        24461  3541111132   6615                                                                                                                                                                                                                                                                                                                                                                      .TH CO 1
.SH NAME
co \- check out RCS revisions
.SH SYNOPSIS
.B co
[\  options\ ] file ...
.SH DESCRIPTION
.I co
retrieves revisions from RCS files.
Each file name ending in `,v' is taken to be an RCS file.
All other files
are assumed to be working files.
\f2co\f1 retrieves a revision from each RCS file and stores it into
the corresponding working file.
.PP
Pairs of RCS files and working files may be specified in 3 ways (see also the
example section).
.PP
1) Both the RCS file and the working file are given. The RCS file name is of
the form \f2path1/workfile\f1,v
and the working file name is of the form
\f2path2/workfile\f1, where
\f2path1/\f1 and
\f2path2/\f1 are (possibly different or empty) paths and
\f2workfile\f1 is a file name.
.PP
2) Only the RCS file is given. Then the working file is created in the current
directory and its name is derived from the name of the RCS file
by removing \f2path1/\f1 and the suffix `,v'.
.PP
3) Only the working file is given.
Then the name of the RCS file is derived from the name of the working file
by removing \f2path2/\f1
and appending the suffix `,v'.
.PP
If the RCS file is omitted or specified without a path, then \f2co\f1
looks for the RCS file first in the directory \&./RCS and then in the current
directory.
.PP
Revisions of an RCS file may be checked out locked or unlocked. Locking a
revision prevents overlapping updates. A revision checked out for reading or
processing (e.g., compiling) need not be locked. A revision checked out
for editing and later checkin must normally be locked. Locking a revision
currently locked by another user fails. (A lock may be broken with
the \f2rcs\f1 (1) command.)
\f2co\f1 with locking requires the caller to be on the access list of
the RCS file, unless he is the owner of the
file or the superuser, or the access list is empty.
\f2co\f1 without locking is not subject to accesslist restrictions.
.PP
A revision is selected by number,
checkin date/time,
author, or state. If none of these options
are specified, the latest revision
on the trunk is retrieved.
When the options
are applied in combination, the latest revision
that satisfies all of them is retrieved.
The options for date/time, author, and 
state retrieve a revision on the \f2selected
branch\f1. The selected branch is either 
derived from the revision number (if given),
or is the highest branch on the trunk.
A revision number may be attached
to one of the options
\f3\-l\f1, \f3\-p\f1, \f3\-q\f1, or \f3\-r\f1.
.PP
A \f2co\f1 command applied to an RCS
file with no revisions creates a zero-length file.
\f2co\f1 always performs keyword substitution (see below).
.PP
.TP 11
.B \-l\f1[\f2rev\f1]
locks the checked out revision for the caller.
If omitted, the checked out revision is not locked.
See option \f3\-r\f1 for handling of the revision number \f2rev\f1.
.TP 11
.B \-p\f1[\f2rev\f1]
prints the retrieved revision on the std. output rather than storing it
in the working file.
This option is useful when \f2co\f1
is part of a pipe.
.TP 11
.B \-q\f1[\f2rev\f1]
quiet mode; diagnostics are not printed.
.TP 11
.BI \-d "date"
retrieves the latest revision on the selected branch whose checkin date/time is less than or equal to \f2date\f1.
The date and time may be given in free format and are converted to local time.
Examples of formats for \f2date\f1:
.nf
.PP
\f222-April-1982, 17:20-CDT,
2:25 AM, Dec. 29, 1983,
Tue-PDT, 1981, 4pm Jul 21\f1         \f1(free format),
\f2Fri, April 16 15:52:25 EST 1982 \f1(output of ctime).
.fi
.PP
Most fields in the date and time may be defaulted.
\f2co\f1 determines the defaults in the order year, month, day,
hour, minute, and second (most to least significant). At least one of these
fields must be provided. For omitted fields that are of higher significance
than the highest provided field,
the current values are assumed. For all other omitted fields,
the lowest possible values are assumed.
For example, the date "20, 10:30" defaults to
10:30:00 of the 20th of the current month and current year.
The date/time must be quoted if it contains spaces.
.TP 11
.B \-r\f1[\f2rev\f1]
retrieves the latest revision whose number is less than or equal to \f2rev\f1.
If \f2rev\f1 indicates a branch rather than a revision,
the latest revision on that branch is retrieved.
\f2Rev\f1 is composed of one or more numeric or symbolic fields
separated by `.'. The numeric equivalent of a symbolic field
is specified with the \f3\-n\f1 option of the commands \f2ci\f1 and \f2rcs\f1.
.TP 11
.BI \-s "state"
retrieves the latest revision on the selected branch whose state is set to \f2state\f1.
.TP 11
.B \-w\f1[\f2login\f1]
retrieves the latest revision on the selected branch which was checked in
by the user with login name \f2login\f1. If the argument \f2login\f1 is
omitted, the caller's login is assumed.
.TP 11
.B \-j\f2joinlist\f1
generates a new revision which is the join of the revisions on \f2joinlist\f1.
\f2Joinlist\f1 is a comma-separated list of pairs of the form
\f2rev2:rev3\f1, where \f2rev2\f1 and \f2rev3\f1 are (symbolic or numeric)
revision numbers.
For the initial such pair, \f2rev1\f1 denotes the revision selected
by the options \f3\-l\f1, ..., \f3\-w\f1. For all other pairs, \f2rev1\f1
denotes the revision generated by the previous pair. (Thus, the output
of one join becomes the input to the next.)
.PP
For each pair, \f2co\f1 joins revisions \f2rev1\f1 and \f2rev3\f1
with respect to \f2rev2\f1.
This means that all changes that transform
\f2rev2\f1 into \f2rev1\f1 are applied to a copy of \f2rev3\f1.
This is particularly useful if \f2rev1\f1
and \f2rev3\f1 are the ends of two branches that have \f2rev2\f1 as a common
ancestor. If \f2rev1\f1 < \f2rev2\f1 < \f2rev3\f1 on the same branch,
joining generates a new revision which is like \f2rev3\f1, but with all
changes that lead from \f2rev1\f1 to \f2rev2\f1 undone.
If changes from \f2rev2\f1 to \f2rev1\f1 overlap with changes from
\f2rev2\f1 to \f2rev3\f1, \f2co\f1 prints a warning and includes the
overlapping sections, delimited by the lines \f2<<<<<<<\ rev1,
=======\f1, and \f2>>>>>>>\ rev3\f1.
.PP
For the initial pair, \f2rev2\f1 may be omitted. The default is the common
ancestor.
If any of the arguments indicate branches, the latest revisions
on those branches are assumed. If the option \f3\-l\f1 is present,
the initial \f2rev1\f1 is locked.
.SH "KEYWORD SUBSTITUTION"
Strings of the form \f2$keyword$\f1 and \f2$keyword:...$\f1 embedded in
the text are replaced
with strings of the form \f2$keyword:\ value\ $\f1,
where \f2keyword\f1 and \f2value\f1 are pairs listed below.
Keywords may be embedded in literal strings
or comments to identify a revision.
.PP
Initially, the user enters strings of the form \f2$keyword$\f1.
On checkout, \f2co\f1 replaces these strings with strings of the form
\f2$keyword:\ value\ $\f1. If a revision containing strings of the latter form
is checked back in, the value fields will be replaced during the next
checkout.
Thus, the keyword values are automatically updated on checkout.
.PP
Keywords and their corresponding values:
.TP 13
$\&Author$
The login name of the user who checked in the revision.
\&. \.TP
\&. \$\&Class$
\&. \Prog, Def, Doc, or Test, depending on the class assigned to the file
\&. \with the \f3-c\f1 option of the \f2rcs\f1 command.
.TP
$\&Date$
The date and time the revision was checked in.
.TP
$\&Header$
A standard header containing the RCS file name, the
revision number, the date, the author, and the state.
.TP
$\&Locker$
The login name of the user who locked the revision (empty if not locked).
.TP
$\&Log$
The log message supplied during checkin, preceded by a header
containing the RCS file name, the revision number, the author, and the date.
Existing log messages are NOT replaced.
Instead, the new log message is inserted after \f2$\&Log:...$\f1.
This is useful for
accumulating a complete change log in a source file.
.TP
$\&Revision$
The revision number assigned to the revision.
.TP
$\&Source$
The full pathname of the RCS file.
.TP
$\&State$
The state assigned to the revision with \f2rcs\f3 \-s\f1 or \f2ci\f3 \-s\f1.
.SH DIAGNOSTICS
The RCS file name, the working file name,
and the revision number retrieved are
written to the diagnostic output.
The exit status always refers to the last file checked out,
and is 0 if the operation was successful, 1 otherwise.
.SH EXAMPLES
Suppose the current directory contains a subdirectory `RCS' with an RCS file
`io.c,v'. Then all of the following commands retrieve the latest
revision from `RCS/io.c,v' and store it into `io.c'.
.nf
.sp
        co  io.c;    co RCS/io.c,v;    co  io.c,v;
        co  io.c  RCS/io.c,v;    co  io.c  io.c,v;
        co  RCS/io.c,v  io.c;    co  io.c,v  io.c;
.fi
.SH "FILE MODES"
The working file inherits the read and execute permissions from the RCS
file. In addition, the owner write permission is turned on, unless the file
is checked out unlocked and locking is set to \f2strict\f1 (see
\f2rcs\f1 (1)).
.PP
If a file with the name of the working file exists already and has write
permission, \f2co\f1 aborts the checkout if \f3\-q\f1 is given, or asks
whether to abort if \f3\-q\f1 is not given. If the existing working file is
not writable, it is deleted before the checkout.
.SH FILES
The caller of the command must have write permission in the working
directory, read permission for the RCS file, and either read permission
(for reading) or read/write permission (for locking) in the directory which
contains the RCS file.
.PP
A number of temporary files are created.
A semaphore file is created in the directory of the RCS file
to prevent simultaneous update.
.SH IDENTIFICATION
.de VL
\\$2
..
Author: Walter F. Tichy,
Purdue University, West Lafayette, IN, 47907.
.sp 0
Revision Number:
.VL $Revision: 1.1 $
; Release Date:
.VL $Date: 89/03/27 16:19:38 $
\&.
.sp 0
Copyright \(co 1982 by Walter F. Tichy.
.SH SEE ALSO
ci (1), ident(1), rcs (1), rcsdiff (1), rcsintro (1), rcsmerge (1), rlog (1), rcsfile (5)
.sp 0
Walter F. Tichy, "Design, Implementation, and Evaluation of a Revision Control
System," in \f2Proceedings of the 6th International Conference on Software
Engineering\f1, IEEE, Tokyo, Sept. 1982.
.SH LIMITATIONS
The option \f3\-d\f1 gets confused in some circumstances,
and accepts no date before 1970.
There is no way to suppress the expansion of keywords, except
by writing them differently. In nroff and troff, this is done by embedding the
null-character `\\&' into the keyword.
.SH BUGS
The option \f3\-j\f1 does not work for
files that contain lines with a single `.'.
Revision Control
System," in \f2Proceedings of the 6th International Conference on Software
Engineering\f1, IEEE, Tokyo, Sept. 1982.
.SH LIMITATIONS
The option \f3\-d\f1 gets confused in some circumstances,
u_man/man1/cp.1                                                                                        664    1776     311         5623  3535372366   6622                                                                                                                                                                                                                                                                                                                                                                      .TH CP 1
.SH NAME
cp, ln, mv \- copy, link or move files
.SH SYNOPSIS
.B cp
[
.B \-r
] file1 ... target
.br
.BR ln [
.B \-s 
] file1 [ file2 ...] target
.br
.B mv
file1 [ file2 ...] target
.SH DESCRIPTION
.I file1\^
is copied (linked, moved) to
.IR target .
Under no circumstance can
.I file1\^
and
.I target\^
be the same (take care when using
.IR sh\^ (1)
metacharacters).
If
.I target\^
is a directory, then one or more
files are copied (linked, moved) to that directory.
.PP
If the
.B \-r
option is specified with
.I cp\^
and any of the source files are directories,
.I cp\^
copies each subtree rooted at that name; in this case
the target must be a directory.
.PP
If
.I mv\^
determines that the mode of
.I target\^
forbids writing, it will
print the mode (see
.IR chmod\^ (2))
and read the standard input for one line
(if the standard input is a terminal).
If the line begins with
.BR y ,
the move takes place; if not,
.I mv\^
exits.
.PP
Both
.I mv\^
and 
.I ln\^
will allow
.I file1\^
to be a directory. With 
.IR mv\^ ,
the directory rename
will occur only if the two directories
have the same parent.
With
.IR ln\^ ,
.I file1\^ 
can be a directory when using the
.B \-s
option (see below).
.PP
.@@
A link is a directory entry referring to a file;
one file
(together with its size, all its protection
information, etc.)
may have several links to it.
There are two kinds of links:  hard links and symbolic links.
.PP
By default
.I ln
makes hard links.
A hard link to a file is indistinguishable
from the original directory entry;
any changes to a file are effectively
independent of the name used to reference
the file.  Hard links may not span file systems and may 
not refer to directories.
.PP
With the
.B \-s
option
.I ln
creates symbolic links. 
A symbolic link is a special kind of file whose contents are
the name of another file
(see
.IR symlink (2)).
A symbolic link contains the name of the file to which it is linked.
Most system calls,
including
.IR open (2),
.IR stat (2),
and
.IR access (2),
substitute these contents
when the name of a symbolic link occurs in a pathname.
This process is known as ``following'' symbolic links.
.IR Link (2),
.IR lstat (2),
.IR readlink (2),
.IR symlink (2),
and
.IR unlink (2)
also do this substitution,
except on the last component of the pathname.
Thus, they are said to "not follow" symbolic links.
Symbolic links may span file systems and may refer to directories.
Note that
.I cp
``follows'' symbolic links,
while
.I mv
and
.I ln
do "not follow" symbolic links.
.SH EXAMPLE
.IP
cp alpha beta gamma /roxanne
.PP
places copies of the three files in the directory
.BR /roxanne .
.SH SEE ALSO
cpio(1),
ls(1),
rm(1),
chmod(2),
symlink(2).
.SH BUGS
If
.I file1\^
and
.I target\^
lie on different file systems,
.I mv\^
must copy the file and delete the original.
In this case the owner name becomes
that of the copying process and any
linking relationship with other files
is lost.
.\"	@(#)cp.1	5.1 of 10/27/83
symbolic links,
while
.I mv
and
.I ln
do "not follow" symbolic links.
.SH EXAMPLE
.IP
cp alpha beta gamma /rou_man/man1/cpio.1                                                                                      664    1776     311        10352  3525461320   7151                                                                                                                                                                                                                                                                                                                                                                      .TH CPIO 1
.SH NAME
cpio \- copy file archives in and out
.SH SYNOPSIS
.B cpio
.BR \-o\0 [
.BR #aBchHLv\0 ]
[ name-list ]
.PP
.B cpio
.B \-i
[
.BR #BcdhHLmrtuvfsSb6\0 ]
[ patterns ]
.PP
.B cpio
.B \-p
[
.B adHLlmruv
] directory
.SH DESCRIPTION
.B Cpio \-o
(copy out)
uses the
.I name-list
arguments, or
reads the standard input to obtain a list of pathnames
and copies those files onto the
standard output (or to the device 
.BR /dev/rmt# )
together with pathname and status information.
.PP
.B Cpio \-i
(copy in)
extracts files from the
standard input (or from the device 
.BR /dev/rmt# )
which is assumed to be the product of a previous
.BR "cpio \-o" .
Only files with names that match
.I patterns\^
are selected.
.I Patterns\^
are given in the name-generating notation of
.IR sh\^ (1).
In
.IR patterns ,
meta-characters
.BR ? ,
.BR \(** ,
and
.BR [ \|.\|.\|. ]
match the slash
.B /
character.
Multiple
.I patterns\^
may be specified and
if no
.I patterns\^
are specified, the default for
.I patterns\^
is
.BR \(**
(i.e., select all files).
The extracted files are conditionally created and copied
into the current directory tree
based upon the options described below.
.PP
.B Cpio \-p
(pass)
reads the standard input to obtain a list of path names
of files that are conditionally created and copied
into the destination
.I directory\^
tree based upon the options described below.
.PP
The meanings of the available options are:
.PP
.PD 0
.TP "\w'\f3m\f1\ \ 'u"
.B #
Use 
.B /dev/rmt# 
as input (for
.BR \-i )
or output (for
.BR \-o ).
Note: 6 has another meaning described below.
.TP
.B a
Reset access times of input files after they have been copied.
.TP
.B B
Input/output is to be blocked 5,120 bytes to the record
(does not apply to the
.I pass\^
option; meaningful only with data directed to or from
.BR /dev/rmt? ).
.TP
.B c
Write
.I header\^
information in
.SM ASCII
character form for portability.
.TP
.B d
.I Directories\^
are to be created as needed.
.TP
.B H
Don't follow symbolic links.
This option is meaningful only with the
.B o
or
.B p
option.
Symbolic links, if any, are copied out as such.
This is the default.
.TP
.B h
Similar to
.B B
option, but block input/output to 250K bytes.
This option is only useful for streaming tape drive
operation.
.TP
.B L
Follow symbolic links.
This option is meaningful only with the
.B o
or
.B p
option.
If symbolic links are encountered,
the referenced files,
rather than the symbolic links themselves,
are copied out.
.TP
.B r
Interactively
.I rename\^
files.
If the user types a null line, the
file is skipped.
.TP
.B t
Print a
.I table of contents\^
of the input.
No files are created.
.TP
.B u
Copy
.I unconditionally\^
(normally, an older file will not replace a newer file with the same name).
.TP
.B v
.IR Verbose :
causes a list of file
names to be printed.
When used with
the
.B t
option,
the table of contents looks like the output of an
.B ls\ \|\-l
command
(see
.IR ls\^ (1)).
.TP
.B l
Whenever possible, link files rather than copying them.
Usable only with
the
.B \-p
option.
.TP
.B m
Retain previous file modification time.
This option is ineffective on directories that are being copied.
.TP
.B f
Copy in all files except those in
.IR patterns .
.TP
.B s
Swap bytes.
Use only with the
.B \-i
option.
.TP
.B S
Swap halfwords.
Use only with the
.B \-i
option.
.TP
.B b
Swap both bytes and halfwords.
Use only with the
.B \-i
option.
.TP
.B 6
Process an old (i.e.,
.SM UNIX
System
.I Sixth\^
Edition format)
file.
Only useful with
.B \-i
(copy in).
.PD
.SH EXAMPLE
.IP
ls \|\(bv \|cpio \|\-o \|>/dev/mt0
.br
or
.br
cpio \|\-o0 \|.
.PP
copies the contents of a directory into an archive;
.IP
cd \|olddir
.br
find
.B \|.\|
\-depth \-print \|\(bv \|cpio \|\-pdl \|newdir
.PP
duplicates a directory hierarchy.
.PP
The trivial case
``find
.B \|.\|
\-depth \-print \|\(bv \|cpio \|\-oB \|>/dev/rmt0''
can be handled more efficiently by:
.IP
find
.B \|.\|
\-cpio \|/dev/rmt0
.SH SEE ALSO
ar(1), find(1), symlink(2), cpio(4).
.SH BUGS
Pathnames are restricted to 128 characters.
If there are too many unique linked files,
the program runs out of
memory to keep track of them
and, thereafter, linking information is lost.
Only the superuser can copy special files.
The
.B -B
and
.B -h
options do not work with certain magnetic tape drives.
.\"	@(#)cpio.1	5.1 of 10/27/83
 \-print \|\(bv \|cpio \|\-oB \|>/dev/rmt0''
can be handled more efficiently by:
.IP
find
.B \|.\|
\-cpio \|/dev/rmt0
.SH SEE ALSO
ar(1), find(1), symlink(2), cpio(4).
.SH BUGS
Pathnames are restricted to 128 characters.
If there are too many unique linked files,
the program ruu_man/man1/cpp.1j                                                                                      664    1776     311        16271  3536637226   7175                                                                                                                                                                                                                                                                                                                                                                      .TH CPP 1
.SH NAME
cpp \- the C language preprocessor
.SH SYNOPSIS
.B /lib/cpp 
[ option ...  ] [ ifile [ ofile ] ]
.SH DESCRIPTION
.PP
.I cpp\^
is the C language preprocessor which is invoked as the
first pass of any C compilation using the
.IR cc\^ (1)
command.  Thus the output of
.I cpp\^
is designed to be in a form acceptable as input
to the next pass of the C compiler.
As the C language evolves,
.I cpp\^
and the rest of the C compilation package will be
modified to follow these changes.
Therefore, the use of
.I cpp\^
other than in this framework is not suggested.
The preferred way to invoke
.I cpp\^
is through the
.IR cc\^ (1)
command since the functionality of
.I cpp\^
may someday be moved elsewhere.  See
.IR m4\^ (1)
for a general macro processor.
.PP
.I cpp\^
optionally accepts two file names as arguments.
.I ifile\^
and
.I ofile\^
are respectively the input and output
for the preprocessor.  They default to standard input
and standard output if not supplied.
.PP
The following \f2options\fP to
.I cpp\^
are recognized:
.TP "\w'\f3\-I\f2dir\f1\ \ 'u"
.B \-P
Preprocess the input without producing the line control
information used by the next pass of the C compiler.
.TP
.B \-C
By default,
.I cpp\^
strips C-style comments.  If the
.B \-C
option is specified, all comments (except those found on
.I cpp\^
directive lines)
are passed along.
.TP
.B \-N
Do not look in \f2/usr/include\fP by default when searching for missing 
include files.
.TP
.BI \-U\^ name\^
Remove any initial definition of
.IR name ,
where
.I name\^
is a reserved symbol
that is predefined by the particular preprocessor.
The current list of these possibly reserved symbols includes:
.PD 0
.RS 8
.TP "\w'\s-1UNIX\s+1 System variant:\ \ 'u"
operating system:
gcos, ibm, unix, vms
.TP
hardware:
interdata, m68000, os, pdp11, tss, vax
.PP
The symbol sgi is also a reserved symbol.
.RE
.TP "\w'\f3\-I\f2dir\f1\ \ 'u"
.BI \-D\^ name\^
.PD 0
.TP
.BI \-D\^ name\=def\^
Define
.I name\^
as if by a
.B #define
directive.  If no
.I \=def\^
is given,
.I name\^
is defined as 1.
.PD
.TP
.BI \-I\^ dir\^
Change the algorithm for searching for
.I #include
files
whose names do not begin with \f3/\fP
to look in
.I dir\^
before looking in the directories on the standard list.
Thus,
.I #include
files whose names are enclosed in \f3"\|"\fP
will be searched for
first in the directory of the
.I ifile\^
argument,
then in directories named in 
.B \-I
options,
and last in directories on a standard list.
For
.I #include
files whose names are enclosed in
.BR <> ,
the directory of the
.I ifile\^
argument is not searched.
.TP
.B \-p
The input source is Pascal source.  
.I cpp 
will strip C-style comments from the source, will
ignore anything within Pascal-style comments, and will 
not
put out blank lines for 
.I cpp 
directives found in included files.
Pascal programs may then include a file of macros and not alter
the line numbers in the original source.  When the
.B "\-p"
flag is used, 
.I cpp 
does not output line number directives.
.PP
Two special names are understood by
.IR cpp .
The name
.B _\^\^_\s-1LINE\s+1_\^\^_
is defined as the current line number (as a decimal integer) as known by
.IR cpp ,
and
.B _\^\^_\s-1FILE\s+1_\^\^_
is defined as the current file name (as a C string) as known by
.IR cpp .
They can be used anywhere (including in macros) just as any
other defined name.
.PP
All
.I cpp\^
directives start with lines begun by
.BR # .
The directives are:
.TP "\w'\f3\-I\f2dir\f1\ 'u"
.BI #define " name" " " token-string
Replace subsequent instances of
.I name\^
with
.IR token-string .
.TP
\f3#define\f2 name\f3(\f2 arg\f3, ...,\f2 arg\f3 )\f2 token-string\f1
Notice that there can be no space between
.I name\^
and the
.BR ( .
Replace subsequent instances of
.I name\^
followed by a
.BR ( ,
a list of comma separated tokens, and a
.B )
by
.I token-string\^
where each occurrence of an
.I arg\^
in the
.I token-string\^
is replaced by the corresponding token in the comma separated list.
.TP
.BI #undef " name"
Cause the definition of
.I name\^
(if any) to be forgotten from now on.
.TP
\f3#include\f2 ``filename\^''
.PD 0
.TP
.BI #include " " < filename >
Include at this point the contents of
.I filename\^
(which will then be run through
.IR cpp\^ ).
When the
.BI < filename >
notation is used,
.I filename\^
is only searched for in the standard places.
See the
.B \-I
option above for more detail.
.PD
.TP
\f3#line\f2 integer-constant ``filename\^''
Causes
.I cpp\^
to generate line control information for the next pass of the
C compiler.
.I integer-constant\^
is the line number of the next line
and
.I filename\^
is the file where it comes from.
If \f2``filename\^''\f1 is not given, the current file name is unchanged.
.TP
.B #endif
.br
Ends a section of lines begun by a test directive
.RB ( #if ,
.BR #ifdef ,
or
.BR #ifndef ).
Each test directive must have a matching
.BR #endif .
.TP
.BI #ifdef " name"
The lines following will appear in the output if and only if
.I name\^
has been the subject of a previous
.B #define
without being the subject of an intervening
.BR #undef .
.TP
.BI #ifndef " name"
The lines following will not appear in the output if and only if
.I name\^
has been the subject of a previous
.B #define
without being the subject of an intervening
.BR #undef .
.TP
.BI #if " constant-expression"
Lines following will appear in the output if and only if the
.I constant-expression\^
evaluates to non-zero.
All binary non-assignment C operators, the
.B ?:
operator, the unary
.BR \(mi ,
.BR ! ,
and
.B ~
operators are all legal in
.IR constant-expression .
The precedence of the operators is the same as defined by the C language.
There is also a unary operator
.BR defined ,
which can be used in
.I constant-expression\^
in these two forms:
.BI defined " " ("name")
or
.BI defined " name" .
This allows the utility of
.BR #ifdef " and " #ifndef
in a
.B #if
directive.
Only these operators, integer constants, and names which
are known by
.I cpp\^
should be used in
.IR constant-expression .
In particular, the
.I sizeof
operator is not available.
.TP
.B #else
Reverses the notion of the test directive which
matches this directive.  If lines previous to
this directive are ignored, the following lines
will appear in the output,
and vice versa.
.PP
The test directives and the possible
.B #else
directives can be nested.
.SH EXAMPLE
.RS .3i
/lib/cpp \-P \-D\s-1XYZ\s+1 \-D\s-1MYFILE\s+1=myfile \-I../include myprog.c myprog.i
.RE
.PP
would preprocess ``myprog.c''
writing to output file ``myprog.i'',
deleting output line numbers
.RB ( \-P 
), and
defining symbol
.SM XYZ
to be null,
symbol
.SM MYFILE
to be ``myfile''
and using include files from
.IR ../include .
.SH FILES
.TP "\w'/usr/include\ \ \ \ 'u"
/usr/include
standard directory for
.I #include
files
.SH SEE ALSO
cc(1), m4(1).
.SH DIAGNOSTICS
.PP
The error messages produced by
.I cpp\^
are intended to be self-explanatory.  The line number and filename
where the error occurred are printed along with the diagnostic.
.SH NOTES
When newline characters were found in argument lists for macros
to be expanded, previous versions of
.I cpp\^
put out the newlines as they were found and expanded.
The current version of
.I cpp\^
replaces these newlines with blanks to alleviate problems that the
previous versions had when this occurred.
.\"	@(#)cpp.1	5.1 of 11/7/83
 error messages produced by
.I cpp\^
are intended to be self-explanatory.  The line number and filename
where the error occurred are printed along with the diagnostic.
.SH NOTES
When newline characters were found in argument lists for macros
to be expanded, previous versions of
.I cpp\^
put out the newlines as they were foundu_man/man1/cxref.1                                                                                     664    1776     311         2612  3525461323   7311                                                                                                                                                                                                                                                                                                                                                                      .TH CXREF 1
.SH NAME
cxref \- generate C program cross reference
.SH SYNOPSIS
.B cxref
\&[ options ]
files
.SH DESCRIPTION
.I Cxref\^
analyzes a collection of C files
and attempts to build a cross reference table.
.I Cxref\^
utilizes a special version of
.I cpp\^
to include
.BR #define 'd
information in its symbol table.
It produces a listing on standard output of all symbols (auto, static,
and global) in each file separately, or with the
.B \-c
option, in combination.
Each symbol 
contains an asterisk (\(**) before the declaring reference.
.PP
In addition to the
.BR \-D \*S,
.B \-I
and
.B \-U
options (which are identical to their interpretation by
.IR cc\^ (1)),
the following \f2options\fP are interpreted by
.IR cxref\^ :
.TP "\w'\f3\-o \f2file\f1\ \ 'u"
.B \-c
Print a combined cross-reference of all input files.
.TP
.BI \-w num
Width option which formats output no wider than 
.I num (decimal) columns.
This option will default to 80 if 
.I num is not specified or is less than 51.
.TP
.BI \-o " file"
Direct output to named \f2file\fP.
.TP
.B \-s
Operate silently; does not print input file names.
.TP
.BR \-t
Format listing for 80-column width.
.SH FILES
.TP \w'/usr/lib/xcpp\ \ \ \ 'u
/usr/lib/xcpp
special version of C-preprocessor.
.SH SEE ALSO
cc(1).
.SH DIAGNOSTICS
Error messages are unusually cryptic, but usually mean
that you can't compile these files, anyway.
.\"	@(#)cxref.1	5.1 of 10/27/83
) columns.
This option will default to 80 if 
.I num is not specified or is less than 51.
.TP
.BI \-o " file"
Direct ou_man/man1/date.1                                                                                      664    1776     311         5306  3525461330   7120                                                                                                                                                                                                                                                                                                                                                                      .TH DATE 1
.SH NAME
date \- print and set the date
.SH SYNOPSIS
.B date
[ mmddhhmm[.ss][yy] ]
[ \f3+\fPformat ]
.SH DESCRIPTION
If no argument is given,
or if the argument begins with \f3+\fP,
the current date and time are printed.
Otherwise, the current date is set.
The first
.I mm\^
is the month number;\f1
.I dd\^
is the day number in the month;\f1
.I hh\^
is the hour number (24 hour system);\f1
the second
.I mm\^
is the minute number;\f1
.I ss\^
is the second number, which must be preceded with a period, and is optional;\f1
.I yy\^
is the last 2 digits of the year number and is optional.
For example:
.PP
.RS
date\| 10080045.17
.RE
.PP
sets the date to Oct 8, 12:45:17 \s-1AM\s+1.
The current year is the default if no year is mentioned.
The system operates in \s-1GMT\s0.
.I Date\^
takes care of the conversion to and from
local standard and daylight time.
.PP
If the argument begins with \f3+\fP,
the output of
.I date\^
is under the control of the user.
The format for the output is similar to that of
the first argument to
.IR printf (3S).
All output fields are of fixed size (zero padded
if necessary).
Each field descriptor is preceded by \f3%\fP
and will be replaced in the output by
its corresponding value.
A single \f3%\fP is encoded by \f3%%\fP.
All other
characters are copied to the output without change.
The string is always terminated with a new-line character.
.PP
Field Descriptors:
.RS
.PD 0
.TP 5
.B  n
insert a new-line character
.TP 5
.B  t
insert a tab character
.TP 5
.B  m
month of year \- 01 to 12
.TP 5
.B  d
day of month \- 01 to 31
.TP 5
.B  y
last 2 digits of year \- 00 to 99
.TP 5
.B D
date as mm/dd/yy
.TP 5
.B  H
hour \- 00 to 23
.TP 5
.B  M
minute \- 00 to 59
.TP 5
.B  S
second \- 00 to 59
.TP 5
.B T
time as \s-1HH:MM:SS\s+1
.TP 5
.B  j
day of year \- 001 to 366
.TP 5
.B  w
day of week \- Sunday = 0
.TP 5
.B  a
abbreviated weekday \- Sun to Sat
.TP 5
.B  h
abbreviated month \- Jan to Dec
.TP 5
.B  r
time in
.SM AM/PM 
notation
.TP 5
.B  z
abbreviated time-zone, lower-case
.TP 5
.B  Z
abbreviated time-zone, upper-case
.RE
.ne 8
.SH EXAMPLE
.RS
date\| `+DATE: %m/%d/%y%nTIME: %H:%M:%S\'
.RE
.PP
would have generated as output:
.PP
.RS
DATE: 08/01/76
.br
TIME: 14:45:05
.RE
.PP
.SH DIAGNOSTICS
.TP "\w'\f2bad\ format\ character\ \ \fP'u"
.I No permission\^
if
you aren't the super-user and you try to change the date;
.TP
.I bad conversion\^
if the date set is syntactically incorrect;
.TP
.I bad format character\^
if the field
descriptor is not recognizable.
.SH FILES
/dev/kmem
.SH WARNING
It is a bad practice to change the date while the system is
running multi-user.
.\"	@(#)date.1	5.2 of 5/18/82
.\"	$Source: /d2/3.7/src/man/RCS/fixes.man,v $
.\"	@(#)$Revision: 1.1 $
.\"	$Date: 89/03/27 16:19:38 $
P "\w'\f2bad\ format\ character\ \ \fP'u"
.I No permission\^
if
you aren't the super-user and you try to change the date;
.TP
.I bad conversion\^
if the date set is syntactically incorrect;
.TP
.I bad format character\^
if the field
descriptor is not recognizable.
.SH FILES
/dev/kmem
.SH WARNING
It is a bad practu_man/man1/dbx.1                                                                                       664    1776     311        45321  3541103732   6776                                                                                                                                                                                                                                                                                                                                                                      .ds dB \f2dbx\f1
.ds DB \f2Dbx\f1
.TH DBX 1 
.UC 4
.SH NAME
dbx \- debugger
.SH SYNOPSIS
.B dbx
[\ 
.B \-r
\ ] [\ 
.B \-i
\ ] [\ 
.BR \-I\0 dir
\ ] [\  
.BR \-c\0 file
\ ] [\ objfile\ ]
.SH DESCRIPTION
\*(DB is a tool for source level debugging and execution of
programs under UNIX.
\f2Objfile\f1 is an object file produced by a compiler
with the appropriate flag (usually \f3\-g\f1)
specified to produce symbol information in the object file.
Currently, only \f2cc\f1(1)
produces the appropriate source information.
The machine level facilities of \*(dB
can be used on any program.
.PP
The object file contains a symbol table that includes the name of the
all the source files translated by the compiler to create it.
These source files are available for perusal while using the debugger.
.PP
If the file ``.dbxinit'' exists in the current directory, then the
debugger commands in it are executed.
If a ``.dbxinit'' is not in the current directory,
\*(dB checks for it in the user's home directory.
.PP
The command line options and their meanings are:
.nr In 8
.in +\n(Inn
.ta \n(Inn
.sp 1
.ti -\n(Inn
\&\f3\-r\f1	\c
Execute \f2objfile\f1 immediately.
If it terminates successfully, \*(dB exits.
Otherwise, the reason for termination will be reported
and the user offered the option of entering the debugger
or letting the program fault.
When \f3\-r\f1 is specified
and standard input is not a terminal, \f2\*(DB\f1 will read from \f2/dev/tty\f1.
.sp 1
.ti -\n(Inn
\&\f3\-i\f1	\c
Force \*(dB to act as though standard input is a terminal.
.sp 1
.ti -\n(Inn
\&\f3\-I\f1 \f2dir\f1	\c
Add \f2dir\f1 to the list of directories
that are searched when looking for a source file.
Normally \*(dB looks for source files in the current directory
and in the directory where \f2objfile\f1 is located.
The directory search path can also be set with the \f3use\f1 command.
.sp 1
.ti -\n(Inn
\&\f3\-c\f1 \f2file\f1	\c
Execute the \*(dB commands in the \f2file\f1 before
reading from standard input.
.in -\n(Inn
.sp 1
.PP
Unless \f3\-r\f1 is specified, \*(dB just prompts and waits for a command.
.sp 1
.ne 8
.B "Execution and Tracing Commands"
.sp 1
.TP
\f3run\f1 [\f2args\f1] [\f3<\f1 \f2filename\f1] [\f3>\f1 \f2filename\f1]
.ns
.TP
\f3rerun\f1 [\f2args\f1] [\f3<\f1 \f2filename\f1] [\f3>\f1 \f2filename\f1]
Start executing \f2objfile\f1, passing \f2args\f1 as command line arguments;
\f3<\f1 or \f3>\f1 can be used to redirect input or output in the usual manner.
When \f3rerun\f1 is used without any arguments,
the previous
argument list is passed to the program;
otherwise it is identical to \f3run\f1.
If \f2objfile\f1 has been written since the last time the symbolic information
was read in, \*(dB will read in the new information.
.TP
\f3trace\f1 [\f3in\f1 \f2procedure/function\f1] [\f3if\f1 \f2condition\f1]
.ns
.TP
\f3trace\f1 \f2source-line-number\f1 [\f3if\f1 \f2condition\f1]
.ns
.TP
\f3trace\f1 \f2procedure/function\f1 [\f3in\f1 \f2procedure/function\f1] [\f3if\f1 \f2condition\f1]
.ns
.TP
\f3trace\f1 \f2expression\f1 \f3at\f1 \f2source-line-number\f1 [\f3if\f1 \f2condition\f1]
.ns
.TP
\f3trace\f1 \f2variable\f1 [\f3in\f1 \f2procedure/function\f1] [\f3if\f1 \f2condition\f1]
Have tracing information printed when the program is executed.
A number is associated with the command that is used
to turn the tracing off (see the \f3delete\f1 command).
.sp 1
The first argument describes what is to be traced.
If it is a \f2source-line-number\f1, then the line is printed
immediately prior to being executed.
Source line numbers in a file other than the current one
must be preceded by the name of the file in quotes and a colon, e.g., 
"mumble.p":17.
.sp 1
If the argument is a procedure or function name then
every time it is called, information is printed telling
what routine called it, from what source line it was called,
and what parameters were passed to it.
In addition, its return is noted, and if it is a function
then the value it is returning is also printed.
.sp 1
If the argument is an \f2expression\f1 with an \f3at\f1 clause,
then the value of the expression is printed whenever the
identified source line is reached.
.sp 1
If the argument is a variable, then the name and value of the variable
are printed whenever it changes.
During this form of tracing, execution is substantially slower.
.sp 1
If no argument is specified, then all source lines are printed
before they are executed.
Execution is substantially slower during this form of tracing.
.sp 1
The clause ``\f3in\f1 \f2procedure/function\f1'' restricts tracing information
to be printed only while executing inside the given procedure
or function.
.sp 1
\f2Condition\f1 is a boolean expression and is
evaluated prior to printing the tracing information;
if it is false, then the information is not printed.
.br
.ne 10
.IP "\f3stop\f1 \f3if\f1 \f2condition\f1"
.ns
.IP "\f3stop\f1 \f3at\f1 \f2source-line-number\f1 [\f3if\f1 \f2condition\f1]"
.ns
.IP "\f3stop\f1 \f3in\f1 \f2procedure/function\f1 [\f3if\f1 \f2condition\f1]"
.ns
.IP "\f3stop\f1 \f2variable\f1 [\f3if\f1 \f2condition\f1]"
Stop execution when the given line is reached, procedure or function
called, variable changed, or condition true.
.IP "\f3status\f1 [\f3>\f1 \f2filename\f1]"
Print out the currently active \f3trace\f1 and \f3stop\f1 commands.
.IP "\f3delete\f1 \f2command-number\f1 ..."
The traces or stops corresponding to the given numbers are removed.
The numbers associated with traces and stops are printed by
the \f3status\f1 command.
.IP "\f3catch\f1 \f2number\f1"
.ns
.IP "\f3catch\f1 \f2signal-name\f1"
.ns
.IP "\f3ignore\f1 \f2number\f1"
.ns
.IP "\f3ignore\f1 \f2signal-name\f1"
Start or stop trapping a signal before it is sent
to the program.
This is useful when a program being debugged
handles signals such as interrupts.
A signal may be specified by number or by a name
(e.g., SIGINT).
Signal names are case insensitive and the ``SIG'' prefix is optional.
By default, all signals are trapped except SIGCLD,
SIGALRM and SIGKILL.
.IP "\f3cont\f1 \f2integer\f1"
.ns
.IP "\f3cont\f1 \f2signal-name\f1"
Continue execution from where it stopped.
If a signal is specified, the process continues as though
it received the signal.
Otherwise, the process is continued as though it had not been stopped.
.PP
Execution cannot be continued if the process has ``finished''.
This is called the standard procedure ``exit''.
\f2\*(DB\f1 does not allow the process to exit, thereby
letting the user examine the program state.
.IP \f3step\f1
Execute one source line.
.IP \f3next\f1
Execute up to the next source line.
The difference between \f3next\f1 and \f3step\f1 is that
if the line contains a call to a procedure or function
the \f3step\f1 command will stop at the beginning of that
block, while the \f3next\f1 command will not.
.IP "\f3return\f1 [\f2procedure\f1]"
Continue until a return to \f2procedure\f1 is executed, or
until the current procedure returns if none is specified.
.IP "\f3call\f1 \f2procedure(parameters)\f1"
Execute the object code associated with the named procedure or function.
.sp 1
.br
.ne 8v
.PP
.B Printing Variables and Expressions
.sp 1
.PP
Names are resolved first using the static scope of the current function.
If the name is not defined in the static scope, then the dynamic scope 
is searched to resolve the name.
If static and dynamic searches do not yield a result,
an arbitrary symbol is chosen and
the message ``[using\ \f2qualified\ name\f1]'' is printed.
The name resolution procedure may be overridden by qualifying an identifier
with a block name, e.g., ``\f2module\f1.\f2variable\f1''.
All source files in C are treated as modules. Thus, to specify the block name
(\f2module\f1), use the file name without the 
``.c'' extension.
.PP
Expressions are specified with an approximately
common subset of C and Pascal syntax.
Indirection can be denoted using either a prefix ``*'' or
a postfix ``^''.
Array expressions are subscripted by brackets (``[ ]'').
The field reference operator (``.'') can be used with pointers
as well as records, making the C operator ``\->'' unnecessary
(although it is supported).
.PP
Types of expressions are checked;
the type of an expression may be overridden
by using ``\f2type-name\f1(\f2expression\f1)''.
\f2Type-name\f1 must be a simple single-word type (i.e., char, short)
or a typedef'd type.  It may \f2not\f1 be a complex type (such as 'char *').
When there is no corresponding named type,
the special construct ``&\f2type-name\f1'' and ``$$\f2tag-name\f1''
can be used to represent a pointer to a named type or C structure tag.
For example: 
.sp 1
.br
.nf
.in +0.5i
struct first_s { int i,j,k; } fs;
struct second_s { short i0,i1,j0,j1,k0,k1;} ss;
typedef struct first_s *first_p;
typedef struct second_s *second_p;
first_p fp;
second_p sp;
.in
.fi
.sp 1
With the type information above, it is possible 
to 'cast' a pointer to struct first_s to a pointer to
struct second_s by:
.br
.in +1i
assign fp=first_p(&ss)
.br
.in
or
.br
.in +1i
assign fp=first_p(sp)
.br
.in
The following assignments, however, are illegal:
.br
.nf
.in +1i
assign fp=sp
assign fp=&ss
.br
.fi
.in
.sp 1
.IP "\f3assign\f1 \f2variable\f1 \f3=\f1 \f2expression\f1"
Assign the value of the expression to the variable.
.IP "\f3dump\f1 [\f2procedure\fR] [\f3>\f1 \f2filename\f1]"
Print the names and values of variables in the given procedure.
If no procedure name is specified, print the values of the variables
in the current procedure.
If the procedure given is ``.'', then the all active variables
are dumped.
.IP "\f3print\f1 \f2expression\f1 [\f3,\f1 \f2expression\f1 ...]"
Print out the values of the expressions.
.IP "\f3whatis\f1 \f2name\f1"
Print the declaration of the given name, which may be qualified
with block names as indicated above.
.IP "\f3which\f1 \f2identifier\f1"
Print the full qualification of the given identifer, i.e., 
the outer blocks that the identifier is associated with.
.IP "\f3up\f1 [\f2count\f1]"
.ns
.IP "\f3down\f1 [\f2count\f1]"
Move the current function, which is used for resolving names,
up or down the stack \f2count\f1 levels.
The default \f2count\f1 is 1.
.IP \f3where\f1
Print out a list of the active procedures and functions.
.IP "\f3whereis\f1 \f2identifier\f1"
Print the full qualification of all the symbols whose
name matches the given identifier.
The order in which the symbols are printed is not meaningful.
.sp 1
.br
.ne 8v
.PP
.B Accessing Source Files
.IP "\f3edit\f1 [\f2filename\f1]"
.ns
.IP "\f3edit\f1 \f2procedure/function-name\f1"
Invoke an editor on \f2filename\f1. If no file name is specified,
the current source file is used.
If a \f2procedure\f1 or \f2function\f1 name is specified,
the editor is invoked for the file that contains it.
The editor that is invoked depends on which editor is specified
as the default by the installation.
To override the default editor, set the environment variable,
EDITOR, to the name of the desired editor.
.IP "\f3file\f1 [\f2filename\f1]"
Change the current source file name to \f2filename\f1.
If none is specified then the current source file name is printed.
.IP "\f3func\f1 [\f2procedure/function\f1]"
Change the current function.
If no function name is specified, then print the current function.
Changing the current function implicitly changes the current source file
to the file that contains the function; it also changes the current scope
used for name resolution.
.IP "\f3list\f1 [\f2source-line-number\f1 [\f3,\f1 \f2source-line-number\f1]]"
.ns
.IP "\f3list\f1 \f2procedure/function\f1"
List the lines in the current source file from the first line number to
the second line number, inclusive.
If a line range is not specified, the next 10 lines in the current 
file are listed.
If the name of a procedure or function is given,
lines \f2n-k\f1 to \f2n+k\f1 are listed where \f2n\f1 is the first statement
in the procedure or function and \f2k\f1 is a value set by 
the \f3set$listwindow\f1 command (see below).
.IP "\f3use\f1 \f2directory-list\f1"
When looking for source files, set the list of directories to be searched.
.sp 1
.br
.ne 8v
.PP
.B Command Aliases and Variables
.sp 1
.TP
\f3alias\f1 \f2name\f1 \f2name\f1
.ns
.TP
\f3alias\f1 \f2name\f1 ``\f2string\f1''
.ns
.TP
\f3alias\f1 \f2name\f1 (\f2parameters\f1) ``\f2string\f1''
When commands are processed,
\*(dB
first checks to see if the word
is an alias for either a command or a string.
If it is an alias, then \*(dB treats the input as though
the corresponding string (with values substituted for any parameters)
had been entered.
For example,
to define an alias ``rr'' for the command ``rerun'',
one can say
.sp 1
.in +8n
alias rr rerun
.in -8n
.sp 1
To define an alias called ``b'' that sets a stop at a particular line
one can say
.sp 1
.in +8n
alias b(x) ``stop at x''
.in -8n
.sp 1
Subsequently, the command ``b(12)'' will expand to ``stop at 12''.
.need 5
.TP
\f3set\f1 \f2name\f1 [= \f2expression\f1]
The \f3set\f1 command defines values for debugger variables.
The names of these variables cannot conflict with names in the program
being debugged, and are expanded to the corresponding expression
within other commands.
The following variables have a special meaning:
.sp 1
.in +8n
.ti -5n
$frame
.br
Setting this variable to an address causes \*(dB to use the stack frame
pointed to by the address for
doing stack traces and accessing local variables.
.sp 1
.ti -5n
$hexchars
.ti -5n
$hexints
.ti -5n
$hexoffsets
.ti -5n
$hexstrings
.br
When set, \*(dB prints out
out characters, integers, offsets from registers, or character pointers
, respectively, in hexadecimal.
.sp 1
.ti -5n
$listwindow
.br
The value of this variable specifies the number
of lines to list around a function or when the \f3list\f1 command
is given without any parameters.
The default value is 10.
.sp 1
.ti -5n
$mapaddrs
.br
Setting (unsetting) this variable causes \*(dB to start (stop)
mapping addresses.
.in -8n
.TP
\f3unalias\f1 \f2name\f1
Remove the alias with the given name.
.TP
\f3unset\f1 \f2name\f1
Delete the debugger variable associated with \f2name\f1.
.sp 1
.br
.ne 8v
.PP
.B Machine Level Commands
.sp 1
.TP
\f3tracei\f1 [\f2address\f1] [\f3if\f1 \f2cond\f1]
.ns
.TP
\f3tracei\f1 [\f2variable\f1] [\f3at\f1 \f2address\f1] [\f3if\f1 \f2cond\f1]
.ns
.TP
\f3stopi\f1 [\f2address\f1] [\f3if\f1 \f2cond\f1]
.ns
.TP
\f3stopi\f1 [\f3at\f1] [\f2address\f1] [\f3if\f1 \f2cond\f1]
Turn on tracing or set a stop using a machine instruction address.
.TP
\f3stepi\f1
.ns
.TP
\f3nexti\f1
Single step as in \f3step\f1 or \f3next\f1, but do a single instruction
rather than source line.
.TP
\f2address\f1\f3, \f1\f2address\f1\f3/\f1 [\f2mode\f1]
.ns
.TP
\f2address\f1 \f3/\f1 [\f2count\f1] [\f2mode\f1]
Print the contents of memory starting at the first \f2address\f1
and continuing up to the second \f2address\f1 or until \f2count\f1 items are printed.
If the address is ``.'', the address following the one
printed most recently is used.
The \f2mode\f1 specifies how memory is to be printed;
if it is omitted the previous mode specified is used.
The initial mode is ``X''.
The following modes are supported:
.nr In 5
.in +\n(Inn
.ta \n(Inn
.sp 1
.ti -\n(Inn
\&\f3i\f1	\c
print the machine instruction
.ti -\n(Inn
\&\f3d\f1	\c
print a short word in decimal
.ti -\n(Inn
\&\f3D\f1	\c
print a long word in decimal
.ti -\n(Inn
\&\f3o\f1	\c
print a short word in octal
.ti -\n(Inn
\&\f3O\f1	\c
print a long word in octal
.ti -\n(Inn
\&\f3x\f1	\c
print a short word in hexadecimal
.ti -\n(Inn
\&\f3X\f1	\c
print a long word in hexadecimal
.ti -\n(Inn
\&\f3b\f1	\c
print a byte in octal
.ti -\n(Inn
\&\f3c\f1	\c
print a byte as a character
.ti -\n(Inn
\&\f3s\f1	\c
print a string of characters terminated by a null byte
.ti -\n(Inn
\&\f3f\f1	\c
print a single precision real number
.ti -\n(Inn
\&\f3g\f1	\c
print a double precision real number
.in -\n(Inn
.sp 1
.PP
Symbolic addresses are specified by preceding the name with an ``&''.
Addresses may be expressions made up of other addresses and
the operators ``\+'', ``\-'', and indirection (unary ``*'').
.PP
Machine registers are denoted by ``$dN'' 
and ``$aN'', where N is the number of the register.  Machine registers
may be displayed with the \f3print\f1 command and assigned to with the
\f3assign\f1 command.  They may not be used as objects in machine level
commands.
.sp 1
.br
.ne 8v
.PP
.B Miscellaneous Commands
.sp 1
.IP \f3help\f1
Print out a synopsis of \*(dB commands.
.IP "\f3quit\f1"
Exit \*(dB.
.IP "\f3sh\f1 \f2command-line\f1"
Pass the command line to the shell for execution.
The SHELL environment variable determines which shell is used.
.TP
\f3source\f1 \f2filename\f1
Read \*(dB commands from the given \f2filename\f1.
.SH FILES
.nr In 20
.in +\n(Inn
.ta \n(Inn
.sp 1
.ti -\n(Inn
\&a.out	\c
object file
.ti -\n(Inn
\&\&.dbxinit	\c
initial commands
.SH SEE ALSO
cc(1)
.SH COMMENTS
\f2\*(DB\f1 suffers from a ``multiple include'' malady.
If you have a program consisting of a number of object files
and each is built from source files that include header files,
the symbolic information for the header files is replicated in
each object file.
Since about one debugger start-up is done for each link,
having the linker (
.IR ld (1)) re-organize the symbol information
would not save much time, though it would reduce some of the
disk space used.
.PP
This problem is an artifact of the unrestricted semantics
of #include's in C.  For example, an include file can contain
static declarations that are separate entities for each file
in which they are included.
.SH BUGS
Assigning strings of characters to character pointers overwrites
the character pointer (and other data in the vicinity) with the string.
.PP
The use of pseudo-casts in assignments is limited.  \*(DB seems
to understand many more combinations of the pseudo-casts in 
\f3print\f1 commands that it does in \f3assign\f1 commands.  With
reference to the example previously given under the heading
``Printing Variables and Expressions'', the following commands work:
.br
.sp 1
.nf
.in +.5i
print $$second_s(fp^)
print &$$second_s(fp^)
print $$second_s(fs)
.br
.fi
.sp 1
.in
However, the following command fails:
.br
.nf
.sp 1
.in +.5i
assign sp=&$$second_s(fs)
.br
.fi
.in
.sp 1
.PP
If given the command \f3list \f2func\f1,
where \f2func\f1 is an entrypoint for which debugging information is
not available (e.g. an assembly-language routine), \*(dB will 
reset the line number to the beginning of the current file.
.PP
If you edit one of the program's 
source files while in \*(dB (i.e., with the
\f3edit\f1 command), remake it through the editor, return to \*(dB
and \f3rerun\f1 the program, \*(dB aborts with an internal error.
However, if the program is edited through \*(dB and then remade by
invoking a shell from \*(dB itself (with the \f3sh\f1 command),
a subsequent \f3rerun\f1 does not cause this behavior.
.PP 
When tracing, it is very difficult to get \*(dB to respond to 
an interrupt, and the program can run away.
.PP
If a function has been invoked in the current call chain which has failed
to do a link (e.g., an assembly-language routine), \*(dB will drop
the previous function in the call chain from a stack 
trace (given by the \f3where\f1 command).
edited through \*(dB and then remade by
invoking a shell from \*(dB itself (with the \f3sh\f1 command),
a subsequent \f3rerun\f1 does not cause this behavior.
.PP 
When tracing, it is very difficult to get \*(dB to respond to 
an interrupt, and the program can run away.
.PP
If a function has been invoku_man/man1/dog.1d                                                                                      664    1776     311        12621  3540723226   7140                                                                                                                                                                                                                                                                                                                                                                      .TH DOG 1D
.SH NAME
dog \- cooperative or competitive flight simulator and airshow generator
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/dog 
[\ 
.B \-i 
infile
\ ] [\ 
.B \-o 
outfile\ ]
.in
.ad
.hy
.SH DESCRIPTION
.PP
The 
.I dog
demonstration program
is an enhanced version of the
.IR flight (1D)
demonstration program for use on multiple IRIS workstation systems.
Each IRIS determines the position of its aircraft several times a second, 
broadcasts the plane's location and orientation to the other IRIS systems
running
.IR dog ,
and listens to the other planes' locations.
All known planes in the current field of view are displayed on all systems.
.PP
If neither 
.BR \-i nor 
.B \-o 
is selected, the broadcast medium is the Ethernet.
Otherwise, the media are the specified files.
Ethernet is assumed for the combat described below.
For the file options, see
.I Airshow Option.
.PP
Pilots may cooperate by attempting formation aerobatics or compete by trying
to shoot each other down.
The coordinates of projectiles are included in the Ethernet packets, hits are
detected, and scoring is maintained.
.SH Weapons
.PP
Fighters are armed with rockets, sidewinders, and cannon.  
The number of rockets and sidewinders available on each type of fighter are
indicated on the help display. Landings replenish missiles as well as fuel.
The number of missiles replenished depends on the quality of the
landing (see
.IR flight (1D).
Ammunition for the cannon is inexhaustible.
.PP
Each weapon has a different kill radius. Weapons detonate themselves when
they are within their kill radius of a plane other than the one they came
from.  All planes within the kill radius of an exploding weapon are
destroyed.
.PP
The
.I q
key fires a rocket.
Rockets have about ten seconds of fuel and follow ballistic paths after the
fuel is exhausted.  They explode when they strike the ground, come within
range of an aircraft (except the one they came from), or are destroyed by 
their owner.  Rockets have the largest kill radius of all the weapons.
.PP
The
.I w
key fires a sidewinder.
Sidewinders are like rockets but track, or steer themselves towards, other
aircraft if they are ``locked on''.
Sidewinders are locked on if they are fired while a target aircraft is
in the orange tracking rectangle or if locked on with the 
.I t 
key.
The
.I t
key
identifies the target and locks a sidewinder onto the target for one second 
without firing the weapon.  This is useful for identifying other planes as
friend or foe. Sidewinders will not lock on aircraft lower than 150 feet, but
once they are locked on, they will track a plane below 150 feet.
Sidewinders stop tracking and follow ballistic paths when they run out of
fuel. The Cessna 150 does not generate enough heat to attract sidewinders.
A good pilot can usually outmaneuver a sidewinder unless his plane is
traveling slowly with a heavy load.  Sidewinders have a smaller kill radius
than rockets.
.PP
The
.I e
key fires a cannon round.
The cannon has a limited range\(emeach cannon shell exists for only one
second. Cannons have the smallest kill radius.
.PP
The
.I r
key destroys the current missile.  Any aircraft in range of the explosion
is destroyed. Each aircraft can have only one projectile in the air at a time.
Thus, you can destroy missiles that have missed their targets allowing new
ones to be fired.
In
.IR flight ,
or in
.I dog
with no competition, strafing the airport can be good practice for the real
thing.
.SH Scoring
.PP
.I dog
keeps track of victories and defeats.
A pilot scores a ``won'' when a projectile fired by his plane destroys another
aircraft.  A pilot scores a ``lost'' when his aircraft is destroyed by a
projectile or crashes.
.PP
Each pilot's score is displayed on his instrument panel.
The scores of all the current players are shown to each new player when he
joins the game and when he reincarnates himself after destruction.
.PP
When a player joins the game, an announcement is broadcast to all players.
Messages are also broadcast whenever a player quits, destroys another plane,
or is destroyed.
.SH Airshow Option
The 
.B -o 
option
will record the path of your aircraft on 
.I outfile
rather than broadcasting it to the network.
.PP
The 
.B -i
option
replays a recorded flight.
You will be in another aircraft, able to join the other recorded
planes in formation or shoot at, but not destroy them.
.PP
Specifying both
the
.B -i
and
.B -o
options
replays a recorded flight and produces an
.I outfile
containing your aircraft's path as well as the other planes' paths.
.I infile
and
.I outfile
cannot be the same file.
Repeated use of the command can make formations of many aircraft.
.SH SEE ALSO
flight(1D), radar(1D), shadow(1D)
.SH AUTHOR
.PP
Gary Tarolli
.SH NOTES
.PP
Various kinds of cheating are possible, e.g., temporarily selecting the
night display to better see a distant opponent's exhaust.
Some scrupulous pilots avoid operations not possible in real aircraft.
Others use every trick possible.
.PP
The Cessna 150 and B-747 have 20mm cannon.
This is inaccurate but amusing in the C-150 (the 747 is much too sluggish).
Try taking off in the C-150 and flying around the runway, picking off
opponents as they appear.  Since the Cessna does not attract
sidewinders, it has a chance to survive.
If you make a mistake and take off in the 747, you are dogmeat.
.SH BUGS
.PP
The cannon ammunition should be finite and the cannon
should overheat and jam if used too often.
.PP
.I dog
core dumps if more than 15 planes join the game.
0 and B-747 have 20mm cannon.
This is inaccurate but amusing in the C-150 (the 747 is much too sluggish).
Try tu_man/man1/du.1                                                                                        664    1776     311         2770  3536642561   6626                                                                                                                                                                                                                                                                                                                                                                      .TH DU 1
.SH NAME
du \- summarize disk usage
.SH SYNOPSIS
.B du
[
.B \-Lars
] [ names ]
.SH DESCRIPTION
.I du\^
gives the number of kbytes
(one kbyte equals 1024 bytes)
contained in all files,
directories within
each directory and files
specified by
the
.I names\^
argument.  It also recursively searches directories within each directory.
The count does not include indirect blocks.
If
.I names\^
is missing,
the current directory, 
.BR . , 
is used.
.PP
The optional argument
.B \-s
causes only the grand total
(for each
of the specified
.IR names )
to be given.
The optional argument
.B \-a
causes an entry to be generated
for each file.
Absence of either causes an entry to be generated for
each directory only.
.PP
.I du\^
is normally silent about directories that cannot be read,
files that cannot be opened, etc.
The
.B \-r
option will cause
.I du\^
to generate messages in such instances.
.PP
The optional argument
.B \-L
causes symbolic links to be followed
(by default they are not followed).
.PP
A file with two or more links is only counted once.
.SH EXAMPLE
.IP
du dir1 dir2
.PP
produces a count of the number of kbytes in each of the directories.
In order to see how many kbytes are in each file, the 
.B \-a
option must be used.
.SH BUGS
If the
.B \-a
option is not used,
non-directories
given as arguments
are not listed.
.PP
If there are too many distinct linked files,
.I du\^
will count the excess files more than once.
.PP
Files with holes (holey files) are counted incorrectly.
.\"	@(#)du.1	5.1 of 10/27/83
th two ou_man/man1/ex.1                                                                                        664    1776     311         7667  3525461300   6630                                                                                                                                                                                                                                                                                                                                                                      .TH EX 1
.SH NAME
ex, edit \- text editor
.SH SYNOPSIS
.B ex
[
.B \-
] [
.B \-v
] [
.B \-t 
tag
] [
.B \-r
] [
.BR \+command
]
name ...
.br
.B edit
[
ex options
]
.SH DESCRIPTION
.I Ex\^
is the root of a family of editors:
.IR edit ,
.I ex\^
and
.IR vi .
.I Ex\^
is a superset of
.IR edit ,
with the most notable extension being a display editing facility.
Display based editing is the focus of
.IR vi .
.PP
If you have not used
.IR ed ,
or are a casual user, you will find that the editor
.I edit\^
is convenient for you.
It avoids some of the complexities of
.I ex\^
used mostly by systems programmers and persons very familiar with
.IR ed .
.PP
If you have a \s-2CRT\s0 terminal, you may wish to use a display
based editor; in this case
see
.IR vi\^ (1),
which is a command which focuses on the display editing portion of
.IR ex .
.PP
The following options are recognized:
.TP
.B \-
suppresses all interactive-user feedback, as when processing editor
scripts in command files.
.TP "\w'\f3\-v\f1\ \ 'u"
.B \-v
Equivalent to using
.I vi\^
rather than 
.IR ex .
.TP
.B \-t
Equivalent to an initial
.I tag\^
command, editing the file containing the
.I tag\^
and positioning the editor at its definition.
.TP
.B \-r
Used in recovering after an editor or system crash, retrieving
the last saved version of the named file.  If no file is
specified, a list of saved files will be reported.
.TP
.BI + command
Indicates that the editor should begin by executing the
specified command.  If
.I command\^
is omitted, then it defaults to $, positioning
the editor at the last line of the first file initially.
Other useful commands here are scanning patterns of the form
/pat or line numbers, e.g., +100 to start at line 100.
.PP
.I Name\^
arguments indicate files to be edited.
.SS Documentation
The document,
.IR "Edit: A tutorial\^",
provides a comprehensive introduction to
.I edit\^
assuming no previous knowledge of computers or the \s-2UNIX\s0 system.
.PP
The
.I "Ex Reference Manual\^"
is a comprehensive and complete manual for the command mode features
of
.IR ex ,
but you cannot learn to use the editor by reading it.
For an introduction to
more advanced forms of editing using the command mode of
.IR ex ,
see the editing documents written by Brian Kernighan for the editor
.IR ed ;
the material in the introductory and advanced documents works also with
.IR ex .
.PP
.I "An Introduction to Display Editing with Vi\^"
introduces the display editor
.I vi\^
and provides reference material on
.IR vi .
In addition, the
.I "Vi Quick Reference\^"
card summarizes the commands
of
.I vi\^
in a useful, functional way, and is useful with the
.IR Introduction .
.SH FILES
.PD 0
.TP "\w'/usr/lib/ex3.6preserve\ \ \ \ 'u"
/usr/lib/ex3.7strings
error messages
.TP
/usr/lib/ex3.6recover
recover command
.TP
/usr/lib/ex3.6preserve
preserve command
.TP
/etc/termcap
describes capabilities of terminals
.TP
\&~/.exrc
editor startup command file, user- created in home directory
.TP
/tmp/EX\f2nnnnn\f1
editor temporary
.TP
/tmp/Rx\f2nnnnn\f1
named buffer temporary
.TP
/usr/preserve
preservation directory
.TP
/usr/lib/tags
standard editor tag file
.PD
.SH EXAMPLE
.IP
ex text
.PP
would invoke the editor with the file named "text".  
.SH SEE ALSO
awk(1),
ed(1),
grep(1),
sed(1),
vi(1)
.SH BUGS
The
.I undo\^
command causes all marks to be lost on lines changed and then restored
if the marked lines were changed.
.PP
.I Undo\^
never clears the buffer modified condition.
.PP
The
.I z\^
command prints a number of logical rather than physical lines.
More than a screen full of output may result if long lines are present.
.PP
File input/output errors don't print a name if the command line "\f3\-\f1"
option is used.
.PP
There is no easy way to do a single scan ignoring case.
.PP
The editor does not warn if text is placed in named buffers and not used
before exiting the editor.
.PP
Null characters are discarded in input files, and cannot appear in resultant
files.
.SH AUTHOR
William Joy and Mark Horton.
.\"	@(#)ex.1	5.1 of 11/18/83
er than physical lines.
More than a screen full of output may result if lu_man/man1/explain.1                                                                                   644    1776     311           42  3543643200   7567                                                                                                                                                                                                                                                                                                                                                                      .so /usr/man/u_man/man1/diction.1
put/output errors don't print a name if the command line "\f3\-\f1"
option is used.
.PP
There is no easy way to do a single scan ignoring case.
.PP
The editor does not warn if text is placed in named buffers and not used
before exiting the editor.
.PP
Null characters are discarded in input files, and cannot appear in resultant
files.
.SH AUTHOR
William Joy and Mark Horton.
.\"	@(#)ex.1	5.1 of 11/18/83
er than physical lines.
More than a screen full /doc/vol1/u_man/man1     u_man/man1/find.1                                                                                      664    1776     311        12423  3525461335   7146                                                                                                                                                                                                                                                                                                                                                                      .TH FIND 1
.SH NAME
find \- find files
.SH SYNOPSIS
.B find
path-name-list  expression
.SH DESCRIPTION
.I Find\^
recursively descends
the directory hierarchy for
each path name in the
.I path-name-list\^
(i.e., one or more path names)
seeking files that match a boolean
.I expression\^
written in the primaries given below.
By default, symbolic links are not followed (see
.B \-follow
below).
In the descriptions, the argument
.I n\^
is used as a decimal integer
where
.BI + n\^
means more than
.IR n ,
.BI \- n\^
means less than
.I n\^
and
.I n\^
means exactly
.IR n .
.TP "\w'\f3\-group \f2gname\^\fP\ \ 'u"
.BI \-name " file\^"
True if
.I file\^
matches the current file name.
Normal shell
argument syntax may be used if escaped (watch out for
.BR [ ", "
.BR ? " and "
.BR \(** ).
.TP
.BI \-perm " onum\^"
True if the file permission flags
exactly
match the
octal number
.I onum\^
(see
.IR chmod\^ (1)).
If
.I onum\^
is prefixed by a minus sign,
more flag bits (017777, see
.IR stat\^ (2))
become significant and
the flags are compared:
.sp \n(PDu
.RS 10m
(flags&onum)==onum
.RE
.sp \n(PDu
.TP
.BI \-type " c\^"
True if the type of the file
is
.IR c ,
where
.I c\^
is
.BR b ,
.BR c ,
.BR d ,
.BR p ,
.BR l ,
or
.B f
for
block special file, character special file,
directory, fifo (a.k.a named pipe), symbolic link, or plain file.
.TP
.BI \-links " n\^"
True if the file has
.I n\^
links.
.TP
.BI \-user " uname\^"
True if the file belongs to the user
.IR uname .
If
.I uname\^
is numeric and does not appear as a login name in the
.B /etc/passwd
file, it is taken as a user \s-1ID\s0.
.TP
.BI \-group " gname\^"
True if the file belongs to the group
.IR gname .
If 
.I gname\^
is numeric and does not appear in the
.B /etc/group
file, it is taken as a group \s-1ID\s0.
.TP
.BI \-size " n" [ck]
True if the file is
.I n\^
blocks long (512 bytes per block).
If
.I n
is followed by a
.BR c ,
the size is in characters.
If
.I n
is followed by a
.BR k ,
the size is in kilobytes.
.TP
.BI \-atime " n\^"
True if the file has been accessed in
.I n\^
days.
.TP
.BI \-mtime " n\^"
True if the file has been modified in
.I n\^
days.
.TP
.BI \-ctime " n\^"
True if the file has been changed in
.I n\^
days.
.TP
.BI \-inum " n\^"
True if the file has inode
.I n\^.
.TP
.BI \-exec " cmd\^"
True if the executed
.I cmd\^
returns
a zero value as exit status.
The end of
.I cmd\^
must be punctuated by an escaped or quoted
semicolon.
Occurrences of
.B {}
are replaced by the
current path name, even if they are part of a longer word.
Shell meta-characters may be used.
The
.B SHELL
environment variable, if present, is used to select a shell.
.TP
.BI \-ok " cmd\^"
Like
.B \-exec
except that the generated command line is printed
with a question mark first,
and is executed only if the user responds
by typing
.BR y .
.TP
.B  \-print
Always true;
causes the current path name to be printed.
.TP
.BI \-cpio " device\^"
Write the current file on
.I device\^
in
.IR cpio\^ (4)
format (5120 byte records).
.TP
.BI \-newer " file\^"
True if
the current file has been modified more recently than the argument
.IR file .
The
.B \-newer
primary may only be used once.
.TP
.BI \-anewer " file\^"
True if
the current file has been accessed more recently than the argument
.IR file .
The
.B \-anewer
primary may only be used once.
.TP
.BI \-cnewer " file\^"
True if
the current file had its status changed more recently than 
that of argument 
.IR file 
(see 
.IR chmod (1)).
The
.B \-cnewer
primary may only be used once.
.TP
.B \-depth
Always true; causes descent of the directory hierarchy to be
done so that all entries in a directory are acted on before the
directory itself.  This can be useful when 
.I find
is used with 
.IR cpio (1)
to transfer files that are contained in directories without
write permission.
.TP
.B \-follow
Always true; causes
.I find
to follow symbolic links
(see
.IR symlink (2)).
.TP
.BR (\0 expression
.B \0)
True if the parenthesized expression is true (parentheses are
special to the shell and must be escaped).
.PP
The primaries may be combined using the following operators (in order
of decreasing precedence):
.TP
1)
The negation of a primary (
.B ! 
is the unary 
.I not
operator).
.TP
2)
Concatentation of primaries (the 
.I and
operation is implied by the juxtaposition of two primaries).
.TP
3)
Alternation of primaries (
.B \-o
is the 
.I or
operator)

.SH EXAMPLES
.IP
find / -perm 755 -exec ls "{}" ";"
.PP
will find all files, starting with the root directory, on which
the permission levels have been set to 755 (see
.IR chmod\^ (1)).
.PP
With 
.B \-exec
and a command such as
.IR ls ,
it is often necessary to escape the "{}" that stores
the current pathname under investigation by putting it
in double quotes.  It is
.B always
necessary to escape the semicolon at the end of an
.B \-exec
sequence.
.PP
Note again that it is also necessary to escape
parentheses
" \\( "
and
" \\) "
used for grouping primaries, by means of a backslash.
.IP
find  /  \\( \-name a.out \-o \-name \(fm\(**.o\(fm \\)
\-atime +7 \-exec rm {} \\;
.PP
removes all files named "a.out" or "\(**.o" that
have not been accessed for a week.
.SH FILES
/etc/passwd
.br
/etc/group
.SH "SEE ALSO"
chmod(1), cpio(1), sh(1), test(1), stat(2), symlink(2), cpio(4), fs(4).
.\"	@(#)find.1	5.1 of 11/8/83
.\" $Source: /d2/3.7/src/man/RCS/fixes.man,v $
.\" @(#)$Revision: 1.1 $
.\" $Date: 89/03/27 16:19:38 $
es
" \\( "
and
" \\) "
used for grouping primaries, by means of a backslash.
.IP
find  /  \\( \-name a.out \-o \-name \(fm\(**.o\(fm \\)
\-atime +7 \-exec rm {} \\;
.PP
removes all files named "a.out" or "\(**.o" that
have not been accesu_man/man1/flight.1d                                                                                   664    1776     311        23225  3540723314   7644                                                                                                                                                                                                                                                                                                                                                                      .TH FLIGHT 1D
.SH NAME
flight \- simulate the flight of any of several aircraft
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/flight
.in
.ad
.hy
.SH DESCRIPTION
.PP
One large viewport shows the world; several smaller ones simulate
instruments.
The world is shown from the cockpit of an aircraft or from a control tower.
The mouse and keyboard control the aircraft and its environment.
.SH Starting Up
.I flight
provides two pages of help information.
The first help page briefly describes the program.
To freeze the action at any time and display the first page, type
.IR h .
Read the first page and press any key to continue.
The second page offers descriptions of five aircraft: one two-place trainer
(Cessna 150), one heavy transport (Boeing 747), and three fighters.
.PP
Type
.I 1
to select the Cessna 150.
The view you see is from the cockpit of the Cessna.
Type 
.I d
to see the Cessna from the control tower.
Type 
.I x
a few times for a closer view.
Type 
.I d
to return to the cockpit and strike
.I s
three or four times to advance the throttle.
The aircraft will start to taxi towards the runway.
Type
.I F
twice to raise the flaps \(em Cessnas normally take off that way.
When the plane is almost on the runway, tap the right mouse button five or
six times to apply right rudder.
The plane will start to turn right.
The left mouse button moves the rudder one increment to the left;
the center one sets the rudder to zero.
Move the mouse till the cursor is centered on the bottom edge of the
windshield and tap 
.I s
until the thrust indicator shows all blue.
When the airspeed indicator passes 50 knots, move the mouse smoothly toward
you. The cursor should be in the upper center of the horizon indicator.
When the rate-of-climb indicator shows blue, you are flying! Congratulations!
.PP
Now turn around and land.
.SH Flight Controls
.PP
.I flight
is controlled by the mouse, the mouse buttons, and the keyboard.  The mouse
holds the primary flight controls.
.PP
.I rightmouse
and
.I leftmouse
move the rudder one increment to the right and left, respectively.
.I middlemouse
centers it.
The rudder position is shown by a small red triangle at the lower edge of
the artificial horizon.
The rudder is used primarily to maneuver the aircraft on the ground.
Airborne turns are made, as in real aircraft, by coordinated application of
aileron and elevator.
.PP
The mouse X and Y valuators control the ailerons and elevator, emulating a
control stick.
Left-right motion controls roll; forward-back motion controls pitch.
The stick position is indicated by a square white cursor.
Both controls are at their neutral position when the cursor is centered at the
bottom of the windshield.
Stick position for level flight is slightly below center.
.PP
The 
.I s
key increases the throttle setting; the
.I a 
key decreases it.
The left bar indicator shows the throttle setting as a percentage of full
power.
Reverse thrust is available and shown in red.
Thrust goes to zero when the plane climbs through 50,000 feet and the engine
flames out.
It can be restored by descending and applying throttle.
Thrust also goes to zero when fuel goes to zero.
Fuel can be restored only by making a safe landing.
.PP
Secondary flight controls include the landing gear, flaps, and spoilers.
To raise or lower the landing gear, type
.IR l .
To increase or decrease the flaps, type
.I f
or
.IR F .
To increase or decrease the spoilers, type
.I c
or 
.IR C .
Flap and spoiler ranges are determined by the aircraft.
The Cessna has no spoilers and its gear is down and welded.
.PP
The landing gear has two functions: to protect the fuselage from the ground
and to add drag.
You may lower the gear to slow the plane down and make handling
easier.
.PP
Flaps and gear are structurally unsound at high speeds.
They fall off if you exceed approximately 400 knots while they are deployed.
Missing flaps make good landings difficult.
Missing gear makes a good landing impossible.
.PP
Flaps increase lift, increase drag, and decrease stall speed.
Takeoffs are normally made with partial flaps; landings are made 
with full flaps.
.PP
Spoilers decrease lift and increase drag dramatically.
They are most useful in dissipating excess altitude without increasing speed.
While spoilers are deployed, it is difficult to recover from a stall.
.SH Display Controls
.PP
Several controls allow the viewer to alter his view of the world.
.PP
The
.I left\-arrow
and 
.I right\-arrow 
keys rotate the pilot's point of view 90 degrees to the left or right
respectively.
The viewing angle (front, left, rear, or right) is displayed on the
windshield.
The keys are useful for looking around, but remember to set the view back to
the front for any but the simplest flying.
.PP
The
.I d
key switches the viewpoint from the cockpit to the control tower or back.
The control tower always looks toward the plane.
The
.I x
key
decreases the tower's field of view, effectively magnifying the aircraft.
The
.I z
key
increases the field of view.
If there is doubt as to whether the view observed is from the cockpit or the
tower, observe the center of the window: an orange cross marks the cockpit
view.
.PP
The
.I n
key
changes the time of day from daylight to night or back.
There is an interesting city NNW of the airport.
.bp
.SH Instruments
.PP
This section describes the instruments on the panel from left to right.
In the bar indicators, blue denotes a positive value and red a negative
value.
.PP
The 
.I thrust
indicator shows thrust as a percentage of full throttle.
Reverse thrust is possible only on the ground and is used for braking.
.PP
The
.I airspeed
indicator is calibrated from 0-1000 knots.
(100 knots is about 118 miles per hour.)
Negative airspeeds can happen during such acrobatic maneuvers as hammerhead
stalls. Since wind is not simulated, airspeed \(== groundspeed.
The numeric display at the bottom of the band displays the exact speed.
.PP
The 
.I climb
indicator shows rate of climb in feet per minute.
Note that the fighters (in normal operation) and the civil planes (usually
while crashing) can exceed the 10,000 fpm maximum rate displayed.
The numeric display at the bottom of the band displays the exact climb rate.
.PP
The
.I G\-meter
indicates vertical acceleration.
Each aircraft has maximum stress limits. If they are exceeded, the
attitude indicator shows the message ``G-LIMIT.''
.PP
The 
.I artificial horizon
helps orient the plane when the real horizon is not visible.
The triangular indicator at the bottom edge shows the rudder position.
If the maximum angle of attack is exceeded, a ``WING-STALL'' message is
displayed and a warning bell sounds.  The more severe the wing stall,
the less control you have over your plane.  Very severe stalls may throw
your plane into a violent spin.
.PP
The 
.I heading
meter displays a combination compass and radar screen.  The compass rotates
and indicates your heading.  Your plane's location is always at the center
of the radar screen. The radar screen shows the positions of the
runway and planes that are within a few miles of your aircraft.
The blue line indicates the position of the runway.  
In
.IR dog (1D)
other planes are shown on the
.I heading
meter as red blobs if they are above you or green blobs if they are below you.
.PP
The 
.I fuel
gauge shows remaining fuel as a percentage of a full tank.
To reduce fuel consumption to zero (for tests only) type
.IR ~.
This is considered cheating in normal flight.
.SH Landings and Crashes
.PP
A good landing is a landing on the runway, with gear down, a descent rate of
less than 600 fpm, and wings level.
Good landings are rewarded with scores from 0 - 100 points.  Points are
subtracted from a perfect score of 100 based on touchdown location, descent
rate, roll, heading, and drift.
For every point scored, fuel on board is increased by 1% of total capacity
until your tank is full.  For every ten points scored you 
receive a missile up to the plane's limit.
.PP
Landings with the gear up, descent rate, roll, or drift too high, but
not disastrous, count as crash landings.
You can keep flying, but get no more fuel nor ordnance.
.PP
Landings off the runway are ``crashed into the swamps'' landings.
Landings with excessive descent rate, roll, or drift are ``EXPLODED ON
IMPACT'' landings.  In either case,
all you can do is look at the wreckage from the tower or restart the game.
.SH Restarts
.PP
Your plane is destroyed if it crashes, taxis too far off the
runway, raises the gear while on the ground, or is shot down.
After your plane is destroyed,
.IR r ,
.IR R ,
or
.I u
reincarnates your plane and restarts the game at the second help page.
You then choose which type of plane you want to fly.
.PP
The
.I r
key
restarts you at the original starting location.
The
.I R
key
restarts you at the south end of the runway.
The
.I u
key
reincarnates your aircraft at a random location in the sky
with randomly low airspeed.
Hit the throttle and dive to build up flying speed.
These different restart options are included to make it easier to restart in
intense
.I dog
combat.
Without them, some pilots simply hang around the runway and blast new planes
as they appear.
.SH Weapons
See
.IR dog (1D)
for a complete description of weaponry.
.SH Weight
.I flight
models aircraft weight accurately.
Ordnance and fuel have substantial weight. As you fire weapons
and burn fuel, your plane becomes lighter and more maneuverable.
.SH SEE ALSO
dog(1D), radar(1D), shadow(1D)
.SH AUTHOR
.PP
Gary Tarolli
.SH NOTES
.PP
.I flight
and its offspring are continually being improved.
There is a significant creative spurt before each major trade show.
Improvements may be documented in the program's help display before
this document is updated.
.PP
The Cessna is too difficult to bring out of a stall.
.SH HARDWARE CONFIGURATION
12 bitplanes and 1.5 Megabytes of memory are required to run
.I flight.
ur plane becomes lighter and more maneuverable.
.SH SEE ALSO
dog(1D), radar(1D), shadow(1D)
.SH AUTHOR
.PP
Gary Tarolli
.SH NOTES
.PP
.I flight
and its offspring are continually being improved.
There is a significant creative spurt before each major trade show.
Improvements may be documented in the program's help display before
this document is updated.
.PP
Theu_man/man1/flow.1d                                                                                     664    1776     311         2651  3525522575   7327                                                                                                                                                                                                                                                                                                                                                                      .TH FLOW 1D
.SH NAME
flow \- display of complex scientific data base
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/flow  
.br
.BR /usr/people/mexdemos/flow    \0\0(GL2 only)
.in
.ad
.hy
.SH DESCRIPTION
.PP
.I Flow
displays about 20,000 data points and a few vectors.
The data is a three-dimensional display of the values of the Navier-Stokes
equations for turbulent fluid flow in a channel.
The calculation was done at NASA-Ames on, of all things, the Illiac-IV.
.PP
Simple mouse motions control the display.
Press LEFTMOUSE, move the cursor, and release the button to redraw the image
with new altitude and azimuth.
Use MIDDLEMOUSE to control distance and twist.
RIGHTMOUSE starts a sequence of many short twists.
Any keyboard key switches the display from single-buffer mode (the initial
state) to double-buffer mode or back.  Use ESC to exit from the
program.
.SH "DISPLAY OPTIONS (GL2 only)"
.PP
Upon entry into the program,
.I flow
is set for NTSC or high resolution output, depending on the currently
selected monitor.
The display monitor can be altered during program execution by
pressing the proper control character.
.sp
.sp
	Key 		Display Monitor
.sp
	CTRL-a		60 HZ monitor
.br
	CTRL-b		30 HZ monitor
.br 
	CTRL-c		NTSC (RS-170A) display
.br
	CTRL-d		PAL (European Video) display
.sp
.SH "WINDOW MANAGER (GL2 only)"
.PP
The window manager version of flow runs only under the
60 Hz display options.
.SH AUTHOR
.PP
Phil Gustafson and Herb Kuta
et for NTSC or high resolution output, depending on the currently
selected monitor.
Theu_man/man1/gamma.1w                                                                                    644      53     311         2221  3543644676   7406                                                                                                                                                                                                                                                                                                                                                                      .TH GAMMA 1W
.SH NAME
gamma \- set the gamma correction value for mapping colors
.SH SYNOPSIS
.B gamma 
newgamma
.SH DESCRIPTION
The luminous intensity displayed by the monitor is a power function
of the input drive voltage.  When a color index is mapped
using 
.I mapcolor(index,r,g,b), 
the red, green, and blue drive
voltages are specified using a range of 0 to 255.  However, it is
wrong to assume that a color with 
.I r,
.I g, 
and 
.I b 
components
of 128 is a 50 percent grey.  On the monitor this grey
will appear considerably darker because the luminous intensity
is not linearly related to drive voltage.  
.I /usr/people/gifts/mextools/portlib
provides 
the function 
.I gammapcolor(i,r,g,b)
to correct for the non-linearity
of the display.  The gamma correction value is stored in
.I ~/.gamma . 
This value will be used by the 
.I gammapcolor 
function.
.I gamma
followed by a floating point argument sets the gamma
correction value.
.I gamma
with no arguments prints the current gamma correction
value.  
See pages 594-597 of Foley and Van Dam, \f2Fundamentals of Interactive
Computer Graphics\f1, for a discussion of gamma correction.
.SH FILES
~/.gamma
rovides 
the function 
.I gammapcolor(i,r,g,b)
to correct for the non-linearity
of the display.  The gamma correction value is stored in
.I ~/.gamma . 
This value will be used by the 
.I gammapcolor 
function.
.I gamma
followed by a floating point argument sets the gamma
correction value.
.I gamma
with no arguments prints the current gamma correction
value.  
See pu_man/man1/heme.1d                                                                                     664    1776     311         5564  3525522602   7273                                                                                                                                                                                                                                                                                                                                                                      .TH HEME 1D
.SH NAME
heme \- depthcued display of the Cytochrome P450 protein molecule
.SH SYNOPSIS
.nf
.B /usr/people/demos/heme  
.PP
.B /usr/people/mexdemos/heme 
.fi
.SH DESCRIPTION
.PP
Dr. Tom Poulos and Prof. Joseph Kraut of the University of California at 
San Diego have constructed a computer model of
the Cytochrome P450 molecule to aid in their research into the structure
of this enzyme. Computer graphics help in
comparing electron density maps to the proposed protein structure by
moving the hypothetical structure into regions of high electron density.
Proximity of atoms provides information regarding chemical
interaction.
.PP
.I Heme
displays the Cytochrome protein with control of viewing transformations
via pop-up menu selections. Also, display of various parts of the protein 
molecule can be toggled on and off.  When all portions are displayed,
the molecular model is comprised of 1022 points and 549 vectors.
.PP
Pop up the menu by holding down the CENTER mouse button. Menu selections are
are toggled by placing the cursor atop the menu selection and pressing the
LEFT mouse button. The menu disappears when the CENTER mouse button is 
released.
.sp
.sp
	Left 	Function
.br
	Menu
.sp
	5	Amino acids that interact with the heme group.
.br
	4 	Backbone of P450, connecting alpha-carbons of amino acid 
		subunits.
.br 
	3	Electron density contour around the iron atom.                      	
.br
	2 	Van der Waal surface of the heme group.
.br
	1 	The heme group, the subunit which accepts and donates 
		electrons.
.sp
.fi
.PP
The right menu is a series of glyphs which specify the transformations
affecting the molecule.  From top to bottom, the first six menu 
buttons enable rotation around the x, y and z axes.  The next six menu
buttons enable translation in the x, y and z directions.  The
next two menu buttons scale the molecule (larger or smaller).  The
next to last button is the bungalow icon, which resets the initial
position of the molecule.  (Return to home.  Get it?)  The
stop sign is, of course, the exit.
.PP
The depth cueing uses 32 intensities per color.  
The initial display is designed to emphasize the central structure of the
model.
If the model is translated far enough away to be completely visible, the depth
cueing will render it virtually invisible.
To see the whole model, scale it down and translate it forward
until the perspective, Z-clipping,
and depth cueing give an attractive image.
.sp
.fi
.SH FILES
.sp
.fi
.br
.ta w'/hemelib/heme[1-5]\ \ \ 'u
./hemelib/heme	control program
.br
./hemelib/heme[1-5]	data files
.sp
.sp
.fi
.SH "WINDOW MANAGER"
.PP
There is a window manager version of heme.
A special option with the window manager, turned on and off by typing
.I m,
continues the motion of the molecule, even when the window is deattached.
.SH "HARDWARE CONFIGURATION"
A minimum configuration of 16 bitplanes and 1.5 Megabytes of memory
is required to run
.I heme.

 give an attractive image.
.sp
.fi
.SH FILES
.sp
.fi
.br
.ta w'/hemelib/heme[1-5]\ \ \ 'u
./hemelib/heme	control program
.br
./hemelib/heme[u_man/man1/indxbib.1                                                                                   664    1776     311           42  3543624771   7564                                                                                                                                                                                                                                                                                                                                                                      .so /usr/man/u_man/man1/lookbib.1
INDOW MANAGER"
.PP
There is a window manager version of heme.
A special option with the window manager, turned on and off by typing
.I m,
continues the motion of the molecule, even when the window is deattached.
.SH "HARDWARE CONFIGURATION"
A minimum configuration of 16 bitplanes and 1.5 Megabytes of memory
is required to run
.I heme.

 give an attractive image.
.sp
.fi
.SH FILES
.sp
.fi
.br
.ta w'/hemelib/heme[1-5]\ \ \ 'u
./hemelib/heme	control pr/doc/vol1/u_man/man1     u_man/man1/interp.1d                                                                                   664    1776     311           46  3543651622   7611                                                                                                                                                                                                                                                                                                                                                                      .so /usr/man/u_man/man1/colordemos.1d
W MANAGER"
.PP
There is a window manager version of heme.
A special option with the window manager, turned on and off by typing
.I m,
continues the motion of the molecule, even when the window is deattached.
.SH "HARDWARE CONFIGURATION"
A minimum configuration of 16 bitplanes and 1.5 Megabytes of memory
is required to run
.I heme.

 give an attractive image.
.sp
.fi
.SH FILES
.sp
.fi
.br
.ta w'/hemelib/heme[1-5]\ \ \ 'u
./hemelib/heme	control pr/doc/vol1/u_man/man1     u_man/man1/iset.1w                                                                                     644      53     311         1267  3543644677   7302                                                                                                                                                                                                                                                                                                                                                                      .TH ISET 1W
.SH NAME
iset \- change the type field of an image file
.SH SYNOPSIS
.B iset 
newtype imagefiles
.SH DESCRIPTION
.I iset
sets the type field in a 
.I imagefiles. 
The type field is used by programs
like 
.I paste
to display the image using the correct part of the
default color map.
.I newtype
may be 
.I normal,
.I dithered,
or
.I screen.
.I normal
means the image is displayed in black and white;
.I dithered
means it is displayed using the colors in the dithered color map;
.I screen
means the image file represents screen pixels.
In the last case, 
.I paste
does no translation.
Example image files may be found in \f2/usr/people/gifts/mextools/images\f1.
.SH SEE ALSO
paste(1W)
 field is used by programs
like 
.I paste
to display the image using the correct part of the
default color map.
.I newtype
may be 
.I normal,
.I dithered,
or
.I screen.
.I normal
means the image is displayed in black and white;
.I dithered
means it is displayed using the colors in the dithered color map;
.I screen
means the imau_man/man1/istat.1w                                                                                    644      53     311          733  3543644677   7437                                                                                                                                                                                                                                                                                                                                                                      .TH ISTAT 1W
.SH NAME
istat \- provide information about an image file
.SH SYNOPSIS
.B istat 
imagefile
.SH DESCRIPTION
.I
istat
gives information about an 
.I imagefile, 
including 
the number of bytes per pixel in the image, the 
number of dimensions, the 
.I x,
.I y,
and 
.I z 
dimensions, the 
.I min
and 
.I
max 
pixel values, and
the 
.I
type 
of the image.
Example image files may be found in \f2/usr/people/gifts/mextools/images\f1.
.SH SEE ALSO
iset(1W),
paste(1W)
ed color map/doc/vol1/u_man/man1     u_man/man1/jet.1d                                                                                      664    1776     311         5135  3525522606   7135                                                                                                                                                                                                                                                                                                                                                                      .TH JET 1D
.SH NAME
jet \- depthcued wireframe model of a jet fighter 
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/jet  
.PP
.BR /usr/people/mexdemos/jet \0\0(GL2 only)
.in
.ad
.hy
.SH DESCRIPTION
.PP
.I Jet 
displays a wireframe model of a jet airplane.  The image includes
660 vectors and can be displayed with constant intensity or depth
cueing.
Operator controls adjust the viewing position and enable or disable depth
cuing.
.PP
The standalone version
uses as many colors as it can find on the system, upwards of 4000 different
intensities can be available depending upon the configuration of the system.
This is admittedly overkill.
The standard window manager version of jet is depth cued using
32 gamma corrected shades of red.  
.PP
Most of the user interface is through the mouse and its buttons.
The mouse buttons control rotation about the x, y and z axes and
viewer distance.
Unless otherwise noted, the x-movement of the mouse is a significant
valuator when holding down the mouse button.
.sp
.sp
.nf
	Mouse buttons		Function
.sp
	left			rotation about x-axis through mouse x-motion
.br
	middle			rotation about y-axis through mouse x-motion
.br
	right 			rotation about z-axis through mouse x-motion
.br
	left & middle 		translate object through mouse x & y motion 
.br
	left & right 		zoom back
.br
	middle & right		zoom forward
.br
    	all			quit the program
.sp
.fi
The operator also uses some keyboard keys to control the jet.
.sp
.sp
.nf
	Keyboard		Function
.br
	ENTER			turn depth cueing on and off
.br
	m			turn constant rotation on and off
.br
	up arrow		dramatically increase range of depth cueing
.br
	right arrow		increase range of depth cueing
.br
	down arrow		dramatically decrease range of depth cueing
.br
	left arrow		decrease range of depth cueing
.br
	ESC			quit the program
.sp
.fi
.SH "DISPLAY OPTIONS (GL2 only)"
.PP
Upon entry into the program,
.I jet
is set for NTSC or high resolution output, depending on the currently
selected monitor.
The display monitor can be altered during program execution by
pressing the proper control character.
.nf
.sp
.sp
	Key 		Display Monitor
.sp
	CTRL-a		60 HZ monitor
.br
	CTRL-b		30 HZ monitor
.br 
	CTRL-c		NTSC (RS-170A) display
.br
	CTRL-d		PAL (European Video) display
.fi
.sp
.SH "WINDOW MANAGER (GL2 only)"
.PP
There is a window manager version of jet which runs without the
aforementioned display options.
If the jet is in constant motion, it stays in motion, even if
the window is detached.  The arrow keys (up, down, left and right)
are not used in the window manager version of jet, because
the window manager version uses a fixed, abridged color ramp
for depth cueing.
br
	CTRL-b		30 HZ monitor
.br 
	CTRL-c		NTSC (RS-170A) display
.br
	CTRL-d		PAL (European Video) display
.fi
.sp
.SH "WINDOW MANAGER (GL2 only)"
.PP
There is a window manager version of jet which runs without the
aforementioned display options.
If the jet is in constant motion, it stays in motion, even if
the window is detached.  The arrow keys (up, down, left and right)
are not used in the window manager version ofu_man/man1/last.1                                                                                      664    1776     311         3364  3534705455   7161                                                                                                                                                                                                                                                                                                                                                                      .TH LAST 1
.SH NAME
last \- indicate last logins of users and teletypes
.SH SYNOPSIS
.B last
[
name ...
] [
tty ...
]
.SH DESCRIPTION
.I last\^
will look back in the
.I wtmp\^
file which records all logins and logouts for information about
a user, a teletype [terminal] or any group of users and teletypes.
Arguments specify names of users or teletypes of interest.
Names of teletypes may be given fully or abbreviated.
The following two examples produce the same result:
.in +.25i
last 0
.br
last tty0
.in -.25i
If multiple arguments are given, the information which applies
to any of the arguments is printed.  For example, 
.in +.25i
last root console
.in -.25i
would list all of ``root's'' sessions as well as all sessions
on the console terminal.
.PP
.I last\^
reports the sessions of the specified users and teletypes,
most recent first, indicating start times, 
duration, and teletype for each. 
If the session is still continuing or was cut short by a reboot,
.I last\^
so indicates.
.SH EXAMPLE
.IP
last reboot
.PP
will give an indication of mean time between reboots of the system.
.PP
.I last\^
with no arguments prints a record of all logins and logouts, in
reverse order.
Since
.I last\^
can generate a great deal of output, piping it through 
.IR more\^ (1) 
for screen viewing is advised.
.PP
If
.I last\^
is interrupted with a \s-2BREAK\s0, 
it indicates how far the search has progressed
in
.IR wtmp .
If interrupted with a quit signal
(generated by a \s-2CTRL\-\e\s0),
.I last\^
exits and dumps core.
.PP
\s-2CTRL\-d\s0 (EOF) signal does nothing.
Therefore exit gracefully from
.I last\^
with a \s-2BREAK\s0 or \s-2SHIFT\-DELETE\s0 signal.
.SH FILES
.ta \w'/etc/wtmp\ \ \ \ \ 'u
/etc/wtmp	login data base
.SH AUTHOR
Howard Katseff
.\"	@(#)last.1	5.1 of 11/16/83
(1) 
for screen viewing is advised.
.PP
If
.I last\^
is interrupted with a \s-2BREAK\s0, 
it indicates how far the search has progressed
in
.IR wtmp .
If interrupted with a quit signal
(generated by a \s-2CTRL\-\e\s0),
.I last\^
exits and dumps core.
.PP
\s-2CTRL\-d\su_man/man1/ld.1j                                                                                       664    1776     311        16732  3541070410   6772                                                                                                                                                                                                                                                                                                                                                                      .TH LD 1
.SH NAME
ld \- link editor
.SH SYNOPSIS
.B ld
[\ options\ ] file ...
.SH DESCRIPTION
.I ld
combines several
object programs into one, resolves external
references, and searches libraries.
In the simplest case several object
.I files
are given, and
.I ld
combines them, producing
an object module which can be either executed or
become the input for a further
.I ld
run.
(In the latter case, the
.B \-r
option must be given
to preserve the relocation bits.)
The output of
.I ld
is left on
.IR a.out .
This file is made executable
only if no errors occurred during the load.
.PP
The argument routines are concatenated in the order
specified.  The entry point of the output is the
beginning of the first routine (unless the
.B \-e
option is specified).
.PP
If any argument is a library, it is searched exactly once
at the point it is encountered in the argument list.
Only those routines defining an unresolved external
reference are loaded.
If a routine from a library
references another routine in the library,
and the library has not been processed by
.IR ranlib (1),
the referenced routine must appear after the
referencing routine in the library.
Thus, the order of programs within libraries
may be important.
The first member of a library
should be a file named `\_\^\^\_.SYMDEF',
which is understood to be a dictionary for the library as produced by
.IR ranlib ;
the dictionary is searched iteratively to satisfy as many references as
possible.
.PP
The symbols 
.IR \_etext , 
.I \_edata
and
.IR \_end
(
.IR etext ,
.I edata 
and
.I end
in C)
are reserved, and if referred to,
are set to the first location above the program,
the first location above initialized data,
and the first location above all data respectively.
It is erroneous to define these symbols.
.PP
.I ld
understands several options.
Except for
.BR \-l ,
they should appear before the file names.
.TP 8
.B \-A
This option specifies incremental loading, i.e., 
linking is to be done in a manner so that the resulting object
may be read into an already executing program.
The next argument is the name of a file whose symbol table will be
taken as a basis on which to define additional symbols.
Only newly linked material will be entered into the text and
data portions of
.IR a.out ,
but the new symbol table will reflect
every symbol defined before and after the incremental load.
This argument must appear before any other object file in the argument list.
The
.B \-T
option may be used as well, and will be taken to mean that the
newly linked segment will commence at the corresponding address
(which must be a multiple of 1024).
The default value is the old value of _end.
.TP
.B \-D
Take the next argument as a hexadecimal number and pad the data segment
with zero bytes to the indicated length.
.TP
.B \-d
Force definition of common storage
even if the
.B \-r
flag is present.
.TP
.B \-e
The following argument is taken to be the
name of the entry point of the loaded
program; location 0x1000 is the default.
As U\s-2NIX\s+2 will only currently recognize programs which begin
execution at 0x1000 or 0x2000, the use of
.B \-e
is limited to the standalone environment.
.TP 
.BI \-l\^ x
This
option is an abbreviation for a library of the name 
.RI `lib x .a`.
.I ld
will look for the library first in the directory
.I lib,
then in
\f2usr/lib\fP, and finally in \f2usr/local/lib\fP relative
to the root of the library tree.  The root of the library
tree defaults to \f2/\fP, but may be set using the \f3\-ZR\fP
switch.
The string
.I x
may be more than one letter.
A library is searched when its name is encountered,
so the placement of a
.B  \-l
is significant.
.TP
.B \-M
Produce a primitive load map, listing the names of the files
which will be loaded.
.TP
.B \-N
Do not make the text portion read only or sharable.  (Use ``magic number'' 
0407.)
.TP
.B \-n
Arrange (by giving the output file a 0410 ``magic number'') that
when the output file is executed,
the text portion will be read-only and shared
among all users executing the file.
This involves moving the data areas up to the first
possible 1024 byte boundary following the
end of the text.
.TP
.B \-o
The
.I name
argument following
.B \-o
is used as the name of the
.I ld
output file, instead of
.BR a.out .
.TP
.B \-R\0\f2libroot\fP
Use \f2libroot\fP as the root of the
search path for libraries.  With respect to this root, the directories
\f2lib\fP, \f2usr/lib\fP, and \f2usr/local/lib\fP are searched to satisfy
libraries which are indicated by the 
.BI \-l\^ x
method.
.TP
.B \-r
Generate relocation bits in the output file
so that it can be the subject of another
.I ld
run.
This flag also prevents final definitions from being
given to common symbols,
and suppresses the `undefined symbol' diagnostics.
.TP
.B \-S
`Strip' the output by removing all symbols except locals and globals.
.TP
.B \-s
`Strip' the output, that is, remove the symbol table
and relocation bits to save space (but impair the
usefulness of the debuggers).
This information can also be removed by
.IR strip (1).
.TP
.B \-T
The next argument is a hexadecimal number which sets the text segment origin.
The default origin is 0x1000.  (See
.B \-e
notes.)
.TP
.B \-t
(``trace'')  Print the name of each file as it is processed.
.TP
.B \-u
Take the following argument as a symbol and enter
it as undefined in the symbol table.  This is useful
for loading wholly from a library, since initially the symbol
table is empty and an unresolved reference is needed
to force the loading of the first routine.
.TP
.B \-X
Save local symbols
except for those whose names begin with `L'.
This option is used by
.IR cc (1)
to discard internally-generated labels while
retaining symbols local to routines.
NOTE: see the BUGS section.
.TP
.B \-x
Do not preserve local
(non-.globl) symbols in the output symbol table; only enter
external symbols.
This option saves some space in the output file.
.TP
.BI \-y sym
Indicate each file in which
.I sym
appears, its type and whether the file defines or references it.
Many such options may be given to trace many symbols.
(It is usually necessary to begin
.I sym
with an `_', as external C, FORTRAN and Pascal variables begin
with underscores.)
.TP
.B \-z
Make the file ``demand paged''.  Therefore, each page of
the process is not loaded until it is referenced.  Files
which are not demand paged are entirely loaded before program
execution begins.  Files which are demand paged have
a 1024 byte header followed by
a text and data segment each of which have size a multiple of 1024 bytes
(being padded out with nulls in the file if necessary).
With this format the first few BSS segment symbols may actually appear
(from the output of
.IR size (1))
to live in the data segment;
this to avoid wasting the space resulting from data segment size roundup.
.SH FILES
.ta \w'/usr/local/lib</lib*.a\ \ 'u
/lib/lib*.a	libraries
.br
/usr/lib/lib*.a	more libraries
.br
/usr/local/lib/lib*.a	still more libraries
.br
a.out	output file
.SH "SEE ALSO"
as(1), ar(1), cc(1), ranlib(1), size(1), strip(1)
.SH BUGS
There is no way to force data to be page aligned.
.PP
When the
.B "\-r"
switch is used to preserve relocation bits,
.I ld
gets the relocation commands table out of sync with the symbol table
if
.B "\-x"
is given without
.BR "\-X" .
Thus one should not use
.B \-X
with
.BR \-r .
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/08/15  13:32:18  robinf
.\" Review comments incorporated for Turbo option--1st review
.\" Revision 1.1  85/07/29  21:18:58  robinf
.\" Cosmetic changes
.\" Revision 1.0  85/07/25  17:22:04  robinf
.\" Initial revision
d to preserve relocation bits,
.I ld
gu_man/man1/loadav.1w                                                                                   644      53     311          413  3543644677   7554                                                                                                                                                                                                                                                                                                                                                                      .TH LOADAV 1W
.SH NAME
loadav \- graphically display the system load average
.SH SYNOPSIS
.B loadav
.SH DESCRIPTION
.I loadav 
displays the system load average using bars of color.
The three bars represent the load average over the last
ten, three, and one minutes.

2:18  robinf
.\" Review comments incorporated for Turbo option--1st review
.\" Revision 1.1  85/07/29  21:18:58  robinf
.\" Cosmetic changes
.\" Revision 1.0  85/07/25  17:22:04  robinf
.\" Initial revision
d to preserve/doc/vol1/u_man/man1     u_man/man1/loadmap.1w                                                                                  644      53     311          351  3543644700   7707                                                                                                                                                                                                                                                                                                                                                                      .TH LOADMAP 1W
.SH NAME
loadmap \- load a part of the color map from a file
.SH SYNOPSIS
.B loadmap 
filename
.SH DESCRIPTION
.I loadmap
loads the color map from the specified file,
.I filename.
.SH SEE ALSO
makemap(1W),
savemap(1W)
ast
ten, three, and one minutes.

2:18  robinf
.\" Review comments incorporated for Turbo option--1st review
.\" Revision 1.1  85/07/29  21:18:58  robinf
.\" Cosmetic changes
.\" Revision 1.0  85/07/25  17:22:04  robinf
.\" Initial revision
d to preserve/doc/vol1/u_man/man1     u_man/man1/ls.1                                                                                        664    1776     311        14351  3540723534   6645                                                                                                                                                                                                                                                                                                                                                                      .TH LS 1
.SH NAME
ls \- list contents of directory (enhanced Berkeley version)
.SH SYNOPSIS
.B ls
[
.B \-1ACFHLRTabcdfgilmnoqrstux
] name ...
.SH DESCRIPTION
For each directory argument,
.I ls\^
lists the contents of the directory;
for each file argument,
.I ls\^
repeats the file name(s) and any other information
requested with the
.I ls\^
options.
The output is sorted alphabetically by default.
When no argument is given, the current directory is listed.
When several arguments are given,
the arguments are first sorted appropriately,
but file arguments appear
before directories and their contents.
.PP
There are three major listing formats.
The format chosen depends on whether the output is going
to a terminal, and may also be controlled by option flags.
The default format for a terminal is to list the contents of directories
in multi-column format, with the entries sorted down the columns.
(Files which are not the contents of a directory being interpreted
are always sorted across the page rather than down the page in columns.
This is because the individual file names may be arbitrarily long.)
Files are listed first, and each directory being listed is labeled
with its pathname, when two or more directory listings are
requested.
If the standard output is not a terminal, the default format is to
list one entry per line.
Finally, there is a stream output format in which files are listed
across the page, separated by commas.
The
.B \-m
flag enables this format.
.PP
There are numerous options:
.TP "\w'\f3\-F\f1\|\ \ 'u"
.B  \-l
List in long format, giving mode, number of links, owner, group,
size in bytes, and time of last modification
for each file.
(See below.)
If the file is a special file, the size field will contain
the major and minor device numbers.
.TP
.B  \-t
Sort by time modified (latest first) instead of
by name.
.TP
.B  \-a
List all entries, except
entries starting with a dot (.).
.TP
.B  \-s
Give size in kbytes (one kbytes equals 1024 bytes),
not including indirect blocks, for each entry.
.TP
.B  \-d
If argument is a directory, list only its name, not
its contents (usually used with
.B \-l
to get status
on directory).
.TP
.B  \-L
If the file is a symbolic link, list the file that the
link references.
.TP
.B  \-H
If the file is a symbolic link, list the link itself.
.TP
.B  \-r
Reverse the order of sort to get reverse alphabetic
or oldest first as appropriate.
.TP
.B  \-u
Use time of last access (use) instead of last
modification for sorting
.RB ( \-t )
or printing
.RB ( \-l ).
.TP
.B  \-c
Use time of last status change for sorting
.RB ( \-t )
or printing
.RB ( \-l )
(see 
.IR stat\^ (2)).
.TP
.B  \-i
Print i-number in first column
of the report for each file listed.
.TP
.B  \-f
Force each argument to be interpreted as a directory
and list the name found in each slot.
This option turns off
.BR \-l ,\  \-t ,\  \-s ,
and
.BR \-r ,
and
turns on
.BR \-a ;
the entries are printed in the order that they 
appear in the directory.
.TP
.B  \-g
Do not give owner 
.SM ID
in long listing.
.TP
.B  \-o
Do not give group 
.SM ID
in long listing
.TP
.B  \-m
Force stream output format.
.TP
.B  \-1
Force one entry per line output format, e.g., to a terminal.
.TP
.B  \-C
Force multi-column output, e.g., to a file or a pipe.
.TP
.B  \-q
Force printing of non-graphic characters in file names as
the character `?'; this normally happens only if the output device is
a terminal.
.TP
.B  \-b
Force printing of non-graphic characters to be in the `\eddd'
notation, in octal.
.TP
.B  \-x
Force columnar printing to be sorted across rather than
down the page.
If the last character of the name the program is invoked
with is an `x' (for example, by linking 
.I /bin/ls 
to 
.IR /bin/lx ), 
this option 
is the default.
.TP
.B  \-F
Cause directories to be marked with a trailing ``/'', executable
files to be marked with a trailing ``\(**'', symbolic links to be
marked with a trailing ``@'', and network symbolic links to be
marked with a trailing ``!'';
If the last character of the name the program is invoked
with is a `f' (for example, by linking 
.I /bin/ls
to
.IR /bin/lf ), 
this option is the default.
.TP
.B  \-p
Cause directories to be marked with a trailing `/'.
.TP
.B  \-R
Recursively list subdirectories encountered.
.TP
.B  \-T
Causes long listings to include seconds in the time.
.PP
The mode printed under the
.B \-l
(long) option contains eleven characters
which are interpreted
as follows:
.PP
.ti 4em
The first character is:
.RS .3i
.TP "\w'\f3m\f1\|\ \ 'u"
.B d
if the entry is a directory;
.PD 0
.TP
.B b
if the entry is a block-type special file;
.TP
.B c
if the entry is a character-type special file;
.TP
.B p
if the entry is a named pipe;
.TP
.B l
if the entry is a symbolic link;
.TP
.B \-
if the entry is a plain file.
.PD
.PP
The next nine characters are interpreted
as three sets of three bits each.
The first set refers to owner permissions;
the next to permissions to others in the same user-group;
and the last to all others.
Within each set the three characters indicate
permission respectively to read, to write, or to
execute the file as a program.
For a directory, ``execute'' permission is interpreted
to mean permission to search the directory
for a specified file.
The permissions are indicated as follows:
.TP "\w'\f3m\f1\|\ \ 'u"
.B  r
if the file is readable;
.PD 0
.TP
.B w
if the file is writable;
.TP
.B x
if the file is executable;
.TP
.B \-
if the indicated permission is not granted.
.PD
.PP
The group-execute permission character is given
as
.B s
if the file has set-group-\s-1ID\s+1 mode;
likewise the user-execute permission character is given
as
.B s
if the file has set-user-\s-1ID\s+1 mode.
.PP
The last character of the mode (normally `x' or `\-') is 
.B t
if the 1000 bit of the mode is on.
See
.IR chmod\^ (1)
for further information on file permissions and modes.
.RE
.PP
When the sizes of the files in a directory
are listed, a total count of kbytes,
not including indirect blocks is printed.
.PP
The name of the file that a symbolic link points to is
also listed (unless the 
.B \-L 
flag is also given).
.SH EXAMPLE
.TP \w'ls\ \ \ 'u
ls
lists the contents of the current directory in multi-column format.
.SH FILES
.ta \w'/etc/passwd\ \ \ \ \ 'u
/etc/passwd	to get user \s-1ID\s+1s for 
ls \-l.
.br
/etc/group	to get group \s-1ID\s+1s for
ls \-l.
.\"	@(#)ls.1	5.1 of 11/16/83

.PP
When the sizes of the files in a directory
are listed, a total count of kbytes,
not including indirect blocks is printed.
.PP
The name of the file that a symbolic link points to is
also listed (unless the 
.B \-L 
flag is also given).
.SH EXAMPLE
.TP \w'ls\ \ \ 'u
ls
lists u_man/man1/mag.1w                                                                                      644      53     311         1102  3543644700   7051                                                                                                                                                                                                                                                                                                                                                                      .TH MAG 1W
.SH NAME
mag \- magnify pixels on the screen
.SH SYNOPSIS
.B mag 
factor
.SH DESCRIPTION
.I mag 
magnifies the pixels of anything on the screen.
The region to be magnified is selected by pointing to the
region and pressing the left mouse button.
Pressing the middle mouse button inside the port changes
the amount of magnification using the \f2x\f1 position of the mouse.  
Pressing the middle mouse button outside the port turns the grid on and off.
.I factor
is an integer that specifies the initial magnification.
The minimum magnification is by a factor of two.

IS
.B mag 
factor
.SH DESCRIPTION
.I mag 
magnifies the pixels of anything on the screen.
The region to be magnified is selected by pointing to the
region and pressing the left mouse button.
Pressing the middle mouse button inside the port changes
the amount of magnification using the \f2x\f1 position of the mouse.  
Pressing the middle mouse button outside the port turns the grid on and off.
.I factor
is an integer that specifies the initialu_man/man1/makemap.1w                                                                                  644      53     311         2001  3543644701   7720                                                                                                                                                                                                                                                                                                                                                                      .TH MAKEMAP 1W
.SH NAME
makemap \- make the default color map
.SH SYNOPSIS
.B makemap
.SH DESCRIPTION
The frame buffer of the IRIS contains values which are translated into
RGB values by a color map. The default map is created by
.I makemap.
.I makemap 
maps the lowest eight colors in the color map
to the default eight colors
in the Graphics Library.  It then reads color
mapping commands from a file in your
home directory called 
.I ~/.desktop.  
Color mapping commands contain 
the numbers of colors to be mapped and 
red, green, and blue values.
If 
.I ~/.desktop
is not found, 
.I makemap
uses default values.
.I makemap 
then maps 
a gray scale, followed by an ordered color map for
dithering.  If there are more than eight planes,
a random color map is made from colors 64 to 127, and
another ramp is made from 128 to 255, followed by 
another ordered color map.  Finally,
the remaining colors are mapped to red.  
.SH SEE ALSO
loadmap(1W,
randmap(1W),
savedesktop(1W),
showmap(1W),
startup(1W)
.SH FILES
~/.desktop
pped and 
red, green, and blue values.
If 
.I ~/.desktop
is not found, 
.I makemap
uses default values.
.I makemap 
then maps 
a gray scale, followed by an ordered color map for
dithering.  If there are more than eight planes,
a random color map is made from colors 64 to 127, and
another ramp is made from 128 to 255, followed by 
another ordered color map.  Finally,
the remaining colors are mapped to red.  
.SH SEE ALSO
loadmap(1W,
randmap(1W),
savedesktop(1W),
showmap(1W),
startup(1W)
.SH FILES
~/.desktopu_man/man1/mkc2f.1                                                                                     664    1776     311           40  3543617710   7140                                                                                                                                                                                                                                                                                                                                                                      .so /usr/man/u_man/man1/mkf2c.1
values.
If 
.I ~/.desktop
is not found, 
.I makemap
uses default values.
.I makemap 
then maps 
a gray scale, followed by an ordered color map for
dithering.  If there are more than eight planes,
a random color map is made from colors 64 to 127, and
another ramp is made from 128 to 255, followed by 
another ordered color map.  Finally,
the remaining colors are mapped to red.  
.SH SEE ALSO
loadmap(1W,
randmap(1W),
savedesktop(1W),
showmap(1W),
startup/doc/vol1/u_man/man1     u_man/man1/more.1                                                                                      664    1776     311        15342  3540724116   7167                                                                                                                                                                                                                                                                                                                                                                      .TH MORE 1
.SH NAME
more, page \- file perusal filter for crt viewing
.SH SYNOPSIS
.B more
[
.BR \-cdf\^lsu n
]
[
.BR \+ linenumber
.BR |\0\+/ pattern
]
[\ name ...\ ]
.PP
.B page
[
.BR \-cdf\^lsu n
]
[
.BR \+ linenumber
.BR |\0\+/ pattern
]
[\ name ...\ ]
.SH DESCRIPTION
.I more\^
is a filter which allows examination of a continuous text
one screenful at a time on a 
.SM CRT
terminal.
It normally pauses after each screenful, printing ``--More--''
at the bottom of the screen.
.PP
If the user then types a carriage return, one more line is displayed.
If the user hits a space,
another screenful is displayed.
If a space is preceded by an integer, that number of lines is printed.
If the user hits
.B d
or control-D,
11 more lines are displayed (a ``scroll'').
.PP
.I more\^
looks in the file
.I /etc/termcap
to determine terminal characteristics
and to determine the default window size.
On a terminal capable of displaying 24 lines,
the default window size is 22 lines.
.PP
If
.I more\^
is reading from a file, rather than a pipe, then a percentage is displayed
along with the ``--More--'' prompt.
This gives the fraction of the file (in characters, not lines) that has been
read so far.
.PP
The
following options are available:
.TP "\w'\f3\-n\f1\|\ \ 'u"
.I \-n
Integer size (in lines) of the window which
.I more\^
will use instead of the default.
.TP
.B \-c
.I more
will draw each page by beginning at the top of the screen
and erasing each line just before it draws it.  Redrawing the screen
in this manner,
avoids scrolling the screen, making it easier to read while
.I more
is writing.  This option will be ignored if the terminal does
not have the ability to clear to the end of the line.
.TP
.B \-d
At the end of each screenful, causes 
.I more\^
to prompt the user with the message ``Hit
space to continue, Rubout to abort''.
.TP
.B \-f
Causes
.I more\^
to count logical, rather than screen lines.
That is, long lines are not folded.  This option is
recommended if 
.I nroff\|
output is being piped through
.IR ul ,
since the latter may generate escape sequences.
These escape sequences contain characters which would 
ordinarily occupy screen positions, but which do not print when they
are sent to the terminal as part of an escape sequence.  Thus, 
.I more\^
may think that lines are longer than they actually are,
and fold lines erroneously.
.TP
.B \-l
Causes
.I more\^
not to treat control-L (form feed) specially.
If this option is not given,
.I more\^
will pause after any line that contains a control-L, as if the end of a
screenful had been reached.
Also, if a file begins with a form feed, the screen will be cleared
before the file is printed.
.TP
.B \-s
Squeeze multiple blank lines from the output, producing only one blank
line.  This option is especially helpful when viewing 
.I nroff
output.  This option maximizes the useful information presented on 
the screen.
.TP
.B \-u
Normally,
.I more
will handle underlining such as produced by
.I nroff
in a manner appropriate to the particular terminal.  If the terminal
can perform underlining or has a standout mode, 
.I more
will output appropriate escape sequences to enable underlining
or stand-out mode for underlined information in the source file.  
The 
.B \-u 
option suppresses this processing.
.TP
.B +\f2linenumber\f1
Causes
.I more\^
to start up at \f2linenumber\fP
.TP
.B +/\f2pattern\fP
Causes
.I more\^
to start up two lines before the line containing the
regular expression \f2pattern\fP.
.PP
If the program is invoked as
.I page
then the screen is cleared before each screenful is printed
(but only if a full screenful is being printed), and 
.IR k \- 1
rather than 
.IR k \- 2
lines are printed in each screenful, where
.I k
is the number of lines in the terminal display.
.PP
Once inside
.IR more ,
other sequences may be typed when
.I more\^
pauses.  The sequences and their effects are as follows
(\f2i\|\fP is an optional integer
argument, defaulting to 1) :
.TP "\w'\f3\-n\f1\|\ \ 'u"
\f2i\|\fPz
Same as typing a space except that \f2i\|\fP, if present, becomes the new
window size.
.TP
\f2i\|\fPs
Skip \f2i\|\fP lines and print a screenful of lines
.TP
\f2i\|\fPf
Skip \f2i\|\fP screenfuls and print a screenful of lines
.TP
\f2i\|\fPn
Skip to the \f2i\|\fP-th next file given in the command line
(skips to last file if n doesn't make sense)
.TP
\f2i\|\fPp
Skip to the \f2i\|\fP-th previous file given in the command line.
If this command is given in the middle of printing out a
file, then
.I more\^
goes back to the beginning of the file. If \f2i\|\fP doesn't make sense,
.I more\^
skips back to the first file.
If
.I more\^
is not reading from a file, the bell is rung and nothing else happens.
.TP 
q or Q
Exit from more.
.TP
\f2i\|/expr\fP
Search for the \f2i\|\fP-th occurrence of the regular expression \f2expr\fP.
If there are less than \f2i\|\fP occurrences of \f2expr\fP
and the input is a file (rather than a pipe),
then the position in the file remains unchanged.
Otherwise, a screenful is displayed, starting two lines before the place
where the expression was found.
The user's erase and kill characters may be used to edit the regular
expression.
Erasing back past the first column cancels the search command.
.TP 
\&\f3'\f1
(single quote) Go to the point from which the last search started.
If no search has been performed in the current file, this command
goes back to the beginning of the file.
.TP 
\f3!\f2command\f1
Invoke a shell 
with \f2command\fP. 
.PP
The commands take effect immediately, i.e., it is not necessary to
type a carriage return.
Up to the time when the command character itself is given,
the user may hit the line kill character to cancel the numerical
argument being formed.
In addition, the user may hit the erase character to redisplay the
``--More--(xx%)'' message.
.PP
At any time when output is being sent to the terminal, the user can
hit the quit key (normally control\-\\).
.I More\^
will stop sending output, and will display the usual ``--More--''
prompt.
The user may then enter one of the above commands in the normal manner.
Unfortunately, some output is lost when this is done, due to the
fact that any characters waiting in the terminal's output queue
are flushed when the quit signal occurs.
.PP
The terminal is set to
.I noecho\^
mode by this program so that the output can be continuous.
Thus, what you type does not show on your terminal, except for the `/' and `!'
commands.
.PP
If the standard output is not a terminal, then
.I more\^
acts just like
.IR cat (1),
except that a header is printed before each file (if there is
more than one).
.SH EXAMPLE
.IP
nroff \-ms +2 doc.n | more
.PP
would show the 
.I nroff\|
output on the terminal screen.
.SH FILES
.ta \w'/usr/lib/more.help\ \ \ \ 'u
/etc/termcap		terminal data base
.br
/usr/lib/more.help	help file
.DT
.SH AUTHOR
Eric Shienbrood
.\"	@(#)more.1	5.1 of 11/16/83
s not show on your terminal, except for the `/' and `!'
commands.
.PP
If the standard output is not a terminal, then
.I more\^
acts just like
.IR cat (1),
except that a header is printed before each file (if there is
more than one).
.SH EXAMPLE
.IP
nroff \-ms +2 doc.n | more
.PP
would u_man/man1/mt.1                                                                                        664    1776     311         4360  3543651054   6626                                                                                                                                                                                                                                                                                                                                                                      .TH MT 1
.SH NAME
mt \- magnetic tape manipulating program
.SH SYNOPSIS
.B mt
[
.B \-t
.BR /dev/ tapename
]
command
[ count ]
.SH DESCRIPTION
.I mt\^
is used to give commands to the magnetic tape drives.
By default,
.I mt
performs the requested operation with the Quarter Inch Cartridge
tape drive. Normally the operations are performed once.
Operations may be performed multiple times by specifying
.IR count .
.PP
To use the Half Inch tape drive the
.B \-t
.BR /dev/tapename
is used to specify which tape device to use.
.PP
The default tape device uses the no-rewind device.
No filemark is written to the no-rewind device on close.
.PP
The available commands are listed below.  Only as many
characters as are required to uniquely identify a command
need be specified.
.RS
.TP
.B eof
Write 
.I count
end-of-file marks at the current position on the tape.
.TP
.B fsf
Forward space
.I count
files.
.TP
.B fsr
Forward space 
.I count
records. This operation will have little real effect with the
Quarter Inch Cartridge tape drive.
.TP
.B bsf
Backspace
.I count
files. This operation will have no effect with the
Quarter Inch Cartridge tape drive.
.TP
.B bsr
Backspace 
.I count
records. This operation will have no effect with the
Quarter Inch Cartridge tape drive.
.TP
.B rewind
Rewind the tape
.RI ( Count
is ignored.)
.TP
.B status
Print status information about the tape unit.
.RI ( Count
is ignored.)
.TP
.B blksize
Print the default block size to be used by tar.
.TP
.B retension
Retension the Quarter Inch Cartridge installed in the drive.
This does not effect the Half Inch tape drive.
.RI ( Count
is ignored.)
.TP
.B erase
Erase the Quarter Inch Cartridge installed in the drive.
This does not effect the Half Inch tape drive.
.RI ( Count
is ignored.)
.TP
.B help
Print command usage information about the command.
.RI ( Count
is ignored.)
.RE
.PP
.I mt\^
returns a 0 exit status when the operations were successful,
a 1 if a command was unrecognized,
and a 2 if a operation failed.
.I mt\^
without any arguments defaults to
.BR help .
.SH FILES
.br
/dev/rmt1	Raw magnetic Quarter Inch Cartridge Tape drive
.br
/dev/rmt2	No rewind Quarter Inch Cartridge Tape drive
.br
/dev/rmt3	Raw magnetic Half Inch tape drive
.br
/dev/rmt4	No-rewind Half Inch tape drive
.SH "SEE ALSO"
mtio(4)
 command usage information about the command.
.RI ( Count
is ignored.)
.RE
.PP
.I mt\^
returns a 0 exit status when the operations were successful,
a 1 if a command was unrecognized,
and a 2 if a operation failed.
.I mt\^
without any arguments defaults to
.BR help .
.SH Fu_man/man1/page.1                                                                                      664    1776     311           37  3543615105   7054                                                                                                                                                                                                                                                                                                                                                                      .so /usr/man/u_man/man1/more.1
 Quarter Inch Cartridge Tape drive
.br
/dev/rmt2	No rewind Quarter Inch Cartridge Tape drive
.br
/dev/rmt3	Raw magnetic Half Inch tape drive
.br
/dev/rmt4	No-rewind Half Inch tape drive
.SH "SEE ALSO"
mtio(4)
 command usage information about the command.
.RI ( Count
is ignored.)
.RE
.PP
.I mt\^
returns a 0 exit status when the operations were successful,
a 1 if a command was unrecognized,
and a 2 if a operation failed.
.I mt\^
without any arguments def/doc/vol1/u_man/man1     u_man/man1/paste.1w                                                                                    644      53     311         1104  3543644702   7425                                                                                                                                                                                                                                                                                                                                                                      .TH PASTE 1W
.SH NAME
paste \- display an image file on the screen 
.SH SYNOPSIS
.B paste 
imagefile
.SH DESCRIPTION
.I paste 
displays the specified 
.I imagefile 
on the screen.  The input image
may be a black and white image, a dithered image, or a screen image.
.I paste 
uses the type field in the header of the image file to display 
the image in the correct part of the color map. 
Example image files may be found in \f2/usr/people/gifts/mextools/images\f1.
.SH BUGS
The name 
.I paste
interferes with the U\s-2NIX\s+2 System V utility.
.SH SEE ALSO
iset(1W), makemap(1W)
.SH SYNOPSIS
.B paste 
imagefile
.SH DESCRIPTION
.I paste 
displays the specified 
.I imagefile 
on the screen.  The input image
may be a black and white image, a dithered image, or a screen image.
.I paste 
uses the type field in the header of the image file to display 
the image in the correct part of the color map. 
Example image files may be found in \f2/usr/people/gifts/mextools/images\f1.
.SH BUGS
The name 
.I paste
interferes with thu_man/man1/prof.1                                                                                      664    1776     311         3744  3525522565   7165                                                                                                                                                                                                                                                                                                                                                                      .TH PROF 1
.SH NAME
prof \- display profile data
.SH SYNOPSIS
.B prof
[
.B \-a
] [
.B \-l
] [
.B \-n
] [
.B \-z
] [
.B \-s
] [
.B \-v
[
.BI \- low
[
.BI \- high
] ] ]
.br
.in +.5i 
[
.I a.out
[
.I mon.out
\&... ] ]
.in -.5i
.SH DESCRIPTION
.I Prof
interprets the file
produced by the
\f2monitor\f1(3C)
subroutine.
Under default modes,
the symbol table in the
named object file
.I (a.out
default)
is read and correlated with the
profile file
.I (mon.out
default).
For each external symbol, the percentage
of time spent executing between that symbol
and the next
is printed (in decreasing order),
together with the number of times that routine was called
and the number of milliseconds per call.
If more than one profile file is specified,
the output represents the sum of the profiles.
.PP
In order for the number of calls to a routine to be tallied,
the
.B \-p
option of
.I cc
must have been given when the file containing the
routine was compiled.
This option also arranges for the
profile file to be produced automatically.
.PP
Options are:
.TP
.B \-a
all symbols are reported rather than
just external symbols.
.TP
.B \-l
the output is sorted by symbol value.
.TP
.B \-n
the output is sorted by number of calls
.TP
.B \-s
a summary profile file is produced in
.I mon.sum.
This is really only useful
when more than one profile file is specified.
.TP
.B \-v
all printing is suppressed
and a graphic version of the profile
is produced
on the standard output for display by the
.IR tplot (1G)
filters.
When plotting, the numbers
.I low
and 
.I high,
by default 0 and 100, may be given to cause a selected
percentage of the profile to be plotted
with accordingly higher resolution.
.TP
.B \-z
routines which have zero usage (as indicated by call counts
and accumulated time) are nevertheless printed in the output.
.SH FILES
.ta \w'mon.out\ \ \ \ 'u
mon.out	for profile
.br
a.out		for namelist
.br
mon.sum	for summary profile
.SH "SEE ALSO"
monitor(3C), profil(2), cc(1), tplot(1G)
.SH BUGS
Beware of quantization errors.
otting, the numbers
.I low
au_man/man1/radar.1d                                                                                    664    1776     311         3734  3540731163   7444                                                                                                                                                                                                                                                                                                                                                                      .TH RADAR 1D
.SH NAME
radar \- flight controller's view of the Ethernet dogfight.
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/radar
[
.B \-i
infile]
.in
.ad
.hy
.SH DESCRIPTION
.PP
The 
.I radar 
demo allows passive observation of the
.IR dog\^(1D)
environment.
The 
.I radar
operator sees a simulated radar screen showing the location, aircraft type,
speed, direction, and altitude of each aircraft in the game.
A message facility allows the 
.I radar
operator to send messages to the pilots.
.PP
The program asks your name and broadcasts it to the 
.I dog
world.
The initial display is a help menu.
Any key starts the program.
At any time when using the demo, the
.I h
key
brings back the help page.
.PP
The 
.I z
and 
.I x
keys increase and decrease the field of view.
The
.I arrow
keys move the point of view one square in the indicated direction.
.PP
The right mouse button allows the mouse valuators to drag the image.
Press the left or middle mouse button for a prompt to send a
message to the plane nearest the cursor or the whole world respectively.
.SH Display
The display shows a stylized view of the 
.I dog
runway environment.
Each aircraft's position is represented by an isosceles triangle pointed
in the direction of the plane's heading.
The vector from the front of the triangle shows its course and speed.
The trail of dots shows where the plane has been for the past 16
seconds.
Each plane has an ID block including the name of the pilot, the type of
aircraft, the airspeed in knots, the sign of the rate of climb, and the
altitude in hundreds of feet.
Sidewinders are shown as red blobs.
Rockets are orange, cannon shells yellow.
.SH Airshow Option
The
.B -i
option
reads the aircraft positions from 
.IR infile .
.I infile
should be created by 
using
the
.BR -o 
option to 
.IR dog\^ (1D).
This allows passive observation of the ``airshow'' recorded in 
.IR infile .
Broadcast messages are not of much use in this mode.
.SH SEE ALSO
dog(1D), flight(1D), shadow(1D)
.SH AUTHOR
.PP
Gary Tarolli
 the sign of the rate of climb, and u_man/man1/randmap.1w                                                                                  644      53     311         1065  3543644703   7742                                                                                                                                                                                                                                                                                                                                                                      .TH RANDMAP 1W
.SH NAME
randmap \- randomize a section of the color map
.SH SYNOPSIS
.B randmap 
seed p1 p2
.SH DESCRIPTION
If there are less than eight bitplanes, 
.I randmap 
ramdomizes colors 16 to 31 if no argument is given.  If there are 
more than eight bitplanes and no argument is given, it 
randomizes colors 128 to 255.  
.I randmap
can also be given a seed and a range of colors to randomize.  
.I seed 
is an integer used to generate random colors.
.I p1 
and 
.I p2 
specify
a range of color indexes to randomize.
.SH SEE ALSO
makemap(1W),
showmap(1W)
n of the color map
.SH SYNOPSIS
.B randmap 
seed p1 p2
.SH DESCRIPTION
If there are less than eight bitplanes, 
.I randmap 
ramdomizes colors 16 to 31 if no argument is given.  If there are 
more than eight bitplanes and no argument is given, it 
randomizes colors 128 to 255.  
.I randmap
can also be given a seed and a range of colors to randomize.  
.I seed 
is an integer used to generate random colors.
.I p1 
and 
.I p2 
specify
a range of color indexesu_man/man1/ratfor.1                                                                                    664    1776     311         3346  3525522551   7505                                                                                                                                                                                                                                                                                                                                                                      .TH RATFOR 1
.SH NAME
ratfor \- rational Fortran dialect
.SH SYNOPSIS
.B ratfor
[ option ... ]
[ filename ... ]
.SH DESCRIPTION
.I Ratfor
converts a rational dialect of Fortran into ordinary irrational Fortran.
.I Ratfor
provides control flow constructs essentially identical to those in C:
.TP
statement grouping:
.nf
{ statement; statement; statement }
.TP
decision-making:
if (condition) statement [ else statement ]
.br
switch (integer value) {
	case integer:	statement
	...
	[ default: ]	statement
}
.TP
loops:
while (condition) statement
for (expression; condition; expression) statement
do limits statement
repeat statement [ until (condition) ]
break
next
.LP
and some syntactic sugar to make programs easier to read and write:
.TP
free form input:
multiple statements/line; automatic continuation
.TP
comments:
# this is a comment
.TP
translation of relationals:
>, >=, etc., become .GT., .GE., etc.
.TP
return expression to caller from function:
return (expression)
.TP
define:
define name replacement
.TP
include:
include filename
.LP
'fi
The option
.B "\-h"
causes quoted strings to be turned into
.B 27H
constructs.
The
.B "\-C"
option copies comments to the output and attempts to format them neatly.
Normally, continuation lines are marked with an
.B "&"
in column 1; the option
.I "\-6x"
makes the continuation character
.I x
and places it in column 6.
.I Ratfor\^
is best used with
.IR f77 (1).
.SH "SEE ALSO"
efl(1), f77(1).
.br
B. W. Kernighan and P. J. Plauger,
.IR "Software Tools" ,
Addison-Wesley, 1976.
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.3  85/08/06  16:08:22  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.2  85/02/04  19:58:20  bob
.\" Edited to conform to System V.
.\" 
 with an
.B "&"
in column 1; the option
.I "\-6x"
makes the continuation character
.I x
and places it in column 6.
.I Ratfor\^
is best used with
.IR f77 (1).
.SH "SEE ALSO"
efl(1), f77(1).
.br
B. W. Kernighan and P. J. Plauger,
.IR "Software Tools" ,
Addison-Wesley, 1976.
.\" @(#)$u_man/man1/rm.1                                                                                        664    1776     311         5144  3525522555   6630                                                                                                                                                                                                                                                                                                                                                                      .TH RM 1 
.SH NAME
rm, rmdir  \- remove files or directories
.SH SYNOPSIS
.B rm
[
.B \-fri
] ... [
.B \-
] file ...
.PP
.B rmdir
dir ...
.SH DESCRIPTION
.I Rm\^
removes the entries for one or more
files
from a directory.
If an entry was the last link to the file, the file
is destroyed.
Removal of a file requires write permission in its directory,
but neither read nor write permission on the file itself.
.PP
If a file has no write permission
and the standard input is a terminal,
its permissions are printed and a line is read from
the standard input.
If that line begins with \f3y\fP the file is deleted,
otherwise the file remains.
No questions are asked
when the
.B \-f
option is given
or if the standard input is not a terminal.
.PP
If a designated file is a directory,
an error comment is printed unless the optional
argument
.B \-r
has been used.
In that case,
.I rm\^
recursively deletes the
entire contents of the specified directory,
and the directory itself.
Symbolic links are not followed.
.PP
If the
.B \-i
(interactive) option is in effect,
.I rm\^
asks whether to delete each file,
and, under
.BR \-r ,
whether to examine each directory.
.PP
.I Rm\^
accepts flags as separate or combined arguments.
An argument consisting solely of
.B \-
will cause
.I rm\^
to treat any occurrence of a \- in a following argument as part of a file name.
.PP
.I Rmdir\^
removes entries for the named directories,
which must be empty.
.SH EXAMPLES
.IP
rm \-r dirname
.PP
will remove the entire contents of the named directory and
all subdirectories, and
finally the directory itself, with no questions asked.
.IP
rm \-ri dirname
.br
rm \-r \-i dirname
.PP
will recursively and interactively remove the tree rooted at
.IR dirname .
.IP
rm \-i \- \-f
.PP
will interactively remove the tree rooted at
.IR \-f .
.SH SEE ALSO
link(1m), unlink(2).
.SH DIAGNOSTICS
Generally self-explanatory.
Exit status is non-zero if an attempt to remove a file fails and the
.B \-f
flag is not supplied.
It is forbidden to remove the file \f3..\fP merely to avoid the
antisocial consequences of inadvertently doing something like:
.IP
.I "rm \-r .\(**"
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.6  85/08/06  16:08:26  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.5  85/06/17  15:48:13  robinf
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.4  85/06/17  15:47:29  robinf
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.3  85/05/15  15:10:06  robinf
.\" Updates for GL2-W2.3 and GL1-W2.2
.\" 
.\" Revision 1.2  84/11/13  12:06:23  bob
.\" Documented new allowable syntax, also exit codes.
.\" 
 rm.1,v 1.6 85/08/06 16:08:26 robinf Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.6  85/08/06  16:08:26  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.5  85/06/17  15:48:13  robinf
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.4  85/06/17  15:47:29  robinf
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.3  85/05/15  15:10:06  robinf
.\" Updates for GL2-W2.3 and GL1-W2.2
.\" 
.u_man/man1/savedesktop.1w                                                                              644      53     311          505  3543644703  10626                                                                                                                                                                                                                                                                                                                                                                      .TH SAVEDESKTOP 1W
.SH NAME
savedesktop \- saves colors in 
.I~/.desktop
.SH SYNOPSIS
.B savedesktop
.SH DESCRIPTION
\f2savedesktop\f1 saves colors in indexes 0 and 7-15 for use as text, 
border, and background colors.  The color assignments are used by
.I makemap.
.SH SEE ALSO
showmap(1W),
makemap(1W)
.SH FILES
~/.desktop
" 
.\" Revision 1.4  85/06/17  15:47:29  robinf
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.3  85/05/15  15:10:06  robinf
.\" Updates for GL2/doc/vol1/u_man/man1     u_man/man1/savemap.1w                                                                                  644      53     311          565  3543644704   7741                                                                                                                                                                                                                                                                                                                                                                      .TH SAVEMAP 1W
.SH NAME
savemap \- save a range of the color map
.SH SYNOPSIS
.B savemap 
filename 
.B -r 
p1 p2
.SH DESCRIPTION
.I
savemap
saves the color map range from 
.I p1 
to 
.I p2 
in the named file. 
.I p1 
and 
.I p2 
are indexes
into the color map.  The colors are saved in a file that can later
be loaded with
.I
loadmap.
.SH SEE ALSO
loadmap(1W),
makemap(1W)
.\" Cosmetic changes for GL2-2.3 and GL1-2.3
.\" 
.\" Revision 1.3  85/05/15  15:10:06  robinf
.\" Updates for GL2/doc/vol1/u_man/man1     u_man/man1/shadow.1d                                                                                   664    1776     311         2450  3540731063   7631                                                                                                                                                                                                                                                                                                                                                                      .TH SHADOW 1D
.SH NAME
shadow \- full-screen armchair pilot's view of the dogfight.
.SH SYNOPSIS
.nh
.na
.B /usr/people/demos/shadow 
[
.B -i
infile]
.in
.ad
.hy
.SH DESCRIPTION
.PP
The 
.I shadow 
demo allows passive observation of the 
.I dog
environment.
The 
.I shadow
operator sees a full-screen view of the world from a selected aircraft or
of a selected aircraft from the control tower.
.PP
The program asks your name and broadcasts it to the 
.I dog
world.
The initial display is a help menu.
Any key starts the program.
At any time during the operation of the demo, the
.I h
key
brings back the help page.
.PP
The 
.I d
key toggles the view from the cockpit to the control tower.
The
.I z
and 
.I x
keys
increase and decrease the field of view in the tower view.
The
.I arrow
keys select front, right, left, and rear cockpit views as in
.IR flight .
The
.I n
key
toggles between day and night views.
.PP
The
.I t
key advances your view to the next of several aircraft that may be in the
environment.
.PP
.SH Airshow Option
The
.B -i
option
reads the aircraft positions from 
.IR infile .
.I infile
should be created by 
using the
.BR -o 
option to
.IR dog (1D).
This allows passive observation of the ``airshow'' recorded in 
.IR infile .
.SH SEE ALSO
dog(1D), flight(1D), radar(1D)
.SH AUTHOR
.PP
Gary Tarolli
t, left, and rear cockpit views as in
.IR flight .
The
.I n
key
toggles between day and night views.
.PP
The
.I t
key advances your view to the next of several aircraft that may be in the
environment.
.PP
.SH Airshowu_man/man1/showmap.1w                                                                                  644      53     311          536  3543644705   7762                                                                                                                                                                                                                                                                                                                                                                      .TH SHOWMAP 1W
.SH NAME
showmap \- display the contents of the color map
.SH SYNOPSIS
.B showmap
.SH DESCRIPTION
The frame buffer of the IRIS contains values which are translated into
RGB values by a color map. 
.I showmap
displays a square filled with patches of color, one for each color index.
.SH SEE ALSO
cedit(1W),
makemap(1W),
savedesktop(1W)

.I n
key
toggles between day and night views.
.PP
The
.I t
key advances your view to the next of several aircraft that may be in the
env/doc/vol1/u_man/man1     u_man/man1/showpie.1w                                                                                  644      53     311          542  3543644706   7760                                                                                                                                                                                                                                                                                                                                                                      .TH SHOWPIE 1W
.SH NAME
showpie \- show the division of a window into rectangles
.SH SYNOPSIS
.B showpie 
color
.SH DESCRIPTION
A window is divided into a set of rectangles by the window manager.
.I showpie 
shows the decomposition of its window into rectangles.
If 
.I color
is specified, the outlines of the rectangles are
displayed using
that color.

n
key
toggles between day and night views.
.PP
The
.I t
key advances your view to the next of several aircraft that may be in the
env/doc/vol1/u_man/man1     u_man/man1/showramp.1d                                                                                 644    1776     311         1320  3543647063  10206                                                                                                                                                                                                                                                                                                                                                                      .TH SHOWRAMP 1D
.SH NAME
showramp \- interactive color ramp
.SH SYNOPSIS
.B /usr/people/mexdemos/showramp  
.SH DESCRIPTION
.PP
.I showramp
is an interactive window with three Gouraud-shaded rectangles.
The rectangles are smoothly colored using adjacent 
color indices which form a color ramp in the
colormap.
.PP
Select the 
.I showramp 
window.
Move the cursor to the lower color (usually on
.IR showmap )
press and release the left mouse button.
Move the cursor to the high color and repeat.
Move the cursor to
.I showramp
and press and release the middle mouse button.
.I showramp
now displays the range of colors in the three 
rectangles.
.SH "SEE ALSO"
showmap(1W), cedit(1W), interp(1D)
.SH AUTHOR
Henry Moreton

ectangles are smoothly colored using adjacent 
color indices which form a color ramp in the
colormap.
.PP
Select the 
.I showramp 
window.
Move the cursor to the lower color (usually on
.IR showmap )
press and release the left mouse button.
Move the cursor to the high color and repeat.
Move the cursor tu_man/man1/shrink.1w                                                                                   644      53     311          557  3543644707   7607                                                                                                                                                                                                                                                                                                                                                                      .TH SHRINK 1W
.SH NAME
shrink \- shrink an image
.SH SYNOPSIS
.B shrink 
shrinkfactor imagein imageout
.SH DESCRIPTION
.I
shrink
uses pixel averaging to shrink the image in 
.I imagein
by a factor of
.I shrinkfactor.
.I shrinkfactor
must be an integer value.  Since pixel averaging is used,
peculiar results can be expected from
shrinking screen or dithered images.

he lower color (usually on
.IR showmap )
press and release the left mouse button.
Move the cursor to the high color and /doc/vol1/u_man/man1     u_man/man1/shuttle.1d                                                                                  664    1776     311         3230  3525522612  10032                                                                                                                                                                                                                                                                                                                                                                      .TH SHUTTLE 1D
.SH NAME
shuttle \- depthcued wireframe model of the space shuttle
.SH SYNOPSIS
.nf
.B /usr/people/demos/shuttle  
.PP
.B /usr/people/mexdemos/shuttle
.fi
.SH DESCRIPTION
.PP
.I Shuttle 
is a PATRAN model of NASA's space shuttle.
The main body (white) is composed of 625 quadrilaterals and 66 triangles.
The doors (red) are drawn with 96 vectors each.
.sp
The shuttle is intensity depth cued.  32 different intensities of red 
and white are used to shade both the standalone and window manager versions
of the model.  
.sp
The mouse buttons 
control rotation about the x, y and z axes, viewer distance, and z-clipping.
Unless otherwise noted, only the x-movement of the mouse is a significant
valuator when holding down a mouse button.  
Any key toggles opening & closing motion of the bay doors on the shuttle.
The space bar is a good key to use to open and close the doors.
.sp
.nf
	Mouse buttons		Function
.sp
	left			rotation about x-axis through mouse x-motion
.br
	middle			rotation about y-axis through mouse x-motion
.br
	right 			rotation about z-axis through mouse x-motion
.br
	left & middle 		translate object through mouse x & y motion 
.br
	left & right 		translate back
.br
     	middle & right		translate forward
.br
    	all			move near z-clipping plane via mouse x-motion
.sp
.fi
The operator also uses some keyboard keys to control the shuttle.
.sp
.sp
.nf
	Keyboard		Function
.sp
	space bar		start or stop movement of doors
.br
	ENTER			turn depthcueing on and off
.br
	ESC			quit the program
.sp
.fi
.sp
.SH "WINDOW MANAGER"
.PP
There is a window manager version of shuttle.
The cargo bay doors do \f3not\f1 stay in motion when
the window is detached.
 right 		translate back
.br
     	middle & right		translate forward
.br
    	all			move near z-clipping plane via mouse x-motion
.sp
.fi
The operator also uses some keyboard keys to control the shuttle.
.sp
.sp
.nf
	Keyboard		Function
.sp
	space bar		start or stop movement of doors
.br
	ENTER			turn depthcueing on and off
.br
	ESC			quit the program
.sp
.fi
u_man/man1/startup.1w                                                                                  644      53     311          435  3543644710  10000                                                                                                                                                                                                                                                                                                                                                                      .TH STARTUP 1W
.SH NAME
startup	\- start the window manager
.SH SYNOPSIS
.B startup
.SH DESCRIPTION
.I startup 
starts the window manager, and 
invokes
.I makemap 
and 
.I texback.
.I texback
is invoked using texture pattern 4 for the background.
.SH SEE ALSO
makemap(1W),
texback(1W)
.fi
The operator also uses some keyboard keys to control the shuttle.
.sp
.sp
.nf
	Keyboard		Function
.sp
	space bar		start or stop movement of doors
.br
	ENTER			turn depthcueing on and off
.br
	ESC			/doc/vol1/u_man/man1     u_man/man1/surfcar.1d                                                                                  644    1776     311         5551  3543632665  10027                                                                                                                                                                                                                                                                                                                                                                      .TH SURFCAR 1D
.SH NAME
surfcar, surfegg \- surface editor and rendering driver
.SH SYNOPSIS
.B /usr/people/mexdemos/surfcar  
.br
.B /usr/people/mexdemos/surfegg
.SH DESCRIPTION
.PP
.I surfcar and
.I surfegg
are interactive bicubic patch editors.
It allows the user to manipulate the locations and numbers of basis points
defining a bicubic B-spline surface. 
The user can also establish planes of symmetry, manipulate the splined object
for study from various points of view, and send the basis points to a second
program that draws smooth-shaded, z-buffered objects.
.PP
The default data base specifies a surface shape more or less resembling an
automobile or egg carton.
.PP
The simplest use of the program allows you to edit the displayed surface by
manipulating its basis points.
The program takes a while to start up.
It displays a wait cursor until it does.
.PP
The program uses screen buttons and cursor glyphs.
In the initial state,  the cursor is shaped like the mouse.
LEFTMOUSE gives a stylized arrow in the 'X' direction, MIDDLEMOUSE
one in 'Y', and RIGHTMOUSE one in 'Z'.
The mouse can be used to pick a basis point, select an axis, and move the
point along that axis.
Any basis point can be picked either at its ``real'' location in space
or at its projection on any of the index surfaces.
.PP
The rightmost five screen buttons help edit the surface.
The leftmost two help view it.
.PP
The leftmost screen window shows three mutually perpendicular
axes.
If an axis is selected by the cursor, RIGHTMOUSE will rotate the surface about
that axis.
The index planes will stay still while the surface rotates ninety degrees
around the axis selected.
.PP
The stylishly bloodshot eye allows rotation of the object and the index
planes.
LEFTMOUSE allows rotation of the surface alone.
RIGHTMOUSE returns it to its original spot.
RIGHTMOUSE allows rotation of the object and axes.
Pressing  
RIGHTMOUSE again gets out of the rotate mode and leaves the display at its new
position.
LEFTMOUSE, while the object is in rotate mode, transmits the current
surface to the surface rendering demonstration program, 
.IR zshadecar (1D).
.PP
Use the five screen buttons on the lower right to make more modifications
to the surface.
Each of the three rightmost buttons 
(the cubes with slices down the middle) selects
a plane of symmetry 
across the surface.
Only two planes of symmetry can be relevant for any orientation of the object.
Attempts to select the impossible plane will not be accepted and will blink
an error cursor.
The remaining two buttons double the number of basis points in the image
along the axes indicated.
More points allow a more complicated surface.
.SH "WINDOW MANAGER"
.PP
Versions for use with and without the window manager are supplied.
The version with the window manager is the only one that communicates
directly
with
.IR zshadecar (1D).
.SH "SEE ALSO"
zshadecar(1D)
.SH AUTHOR
Henry Moreton

ntation of the object.
Attempts to select the impossible plane will not be accepted and will blink
an error cursor.
The remaining two buttons double thu_man/man1/t3279.1                                                                                     664    1776     311         1022  3543641317   6767                                                                                                                                                                                                                                                                                                                                                                      .TH T3279 1
.SH NAME
t3279 \- IBM 3270 terminal emulator
.SH SYNOPSIS
.B t3279
.SH DESCRIPTION
The t3279 program (1) presents a 22-item menu to allow the user to 
(2) emulate a 3278/9 terminal, (3) execute mainframe program remote graphics,
(4) send a binary file from mainframe to IRIS or IRIS to mainframe.
The menu items (5) and (6) are used for Geometry Link hardware diagnosis.
Items (7) and greater are useful for application development.
.SH FILES
.ta \w'/dev/pxd   'u
/dev/pxd	Geometry Link device
.SH SEE ALSO
wsiris(1).
ME
t3279 \- IBM 3270 terminal emulator
.SH SYNOPSIS
.B t3279
.SH DESCRIPTION
The t3279 program (1) presents a 22-item menu to allow the user to 
(2) emulate a 3278/9 terminal, (3) execute mainframe program remote graphics,
(4) send a binary file from mainframe to IRIS or IRIS to mainframe.
The menu items (5) and (6) are used for Geometry Link hardware diagnosis.
Items (7) and greater are useful for application development.
.SH FILES
.ta \w'/dev/pxd   'u
/dev/pxd	Geometry Link device
.SH SEu_man/man1/tar.1                                                                                       664    1776     311        22751  3540731746   7024                                                                                                                                                                                                                                                                                                                                                                      .TH TAR 1
.SH NAME
tar \- tape archiver
.SH SYNOPSIS
.B tar
key [ name ... ]
.SH DESCRIPTION
.fi
.PP
.I tar
saves and restores multiple files on a single file (usually a magnetic
tape, but it can be any file).
The 
.I key
argument controlls
.IR tar 's
actions.
The
.I key
is a string of characters containing at most one function letter and possibly
one or more function modifiers.  Other arguments to
.I tar
are file or directory names specifying which files to dump or restore.
In all cases, appearance of a directory name refers (recursively) to
the files and  subdirectories of that directory.
These files are dumped to tape in alphabetical order.
.PP
A
.I tar
archive is a stream of 512-byte header structures
which may be followed by file data rounded up to the next
512-byte boundary.
The end of the archive is signaled by two header structures
beginning with null bytes.
.\"	When
.\"	.I tar
.\"	has seen the end of the archive, it will do up to two more
.\"	reads in search of the real end-of-file so that on magnetic
.\"	tapes, the tape will be positioned after the file mark, i.e.
.\"	at the beginning of the next tape file, if any.
.PP
The function portion of the key is specified by one of the following letters:
.TP 8
.B  r
Write the named files on the end of the tape. The
.B c
function implies this option. Do not use this option with cartridge tapes.
.TP 8
.B  x
Extract the named files from the tape.  If a named file
matches a directory whose contents had been written onto the tape, this
directory is (recursively) extracted.  The owner, modification time, and mode
are restored (if possible).  If no file argument is given, the entire content
of the tape is extracted.  Note that if multiple entries specifying the same
file are on the tape, the last entry overwrites all earlier entries.
.TP 8
.B  X
For each file to be extracted,
if it is identical to the file in the corresponding
position in the comparison tree, link the existing file
to the new file.
Otherwise, extract the new file as a separate new file.
.B X
is like 
.B x 
but also takes the next argument
as the root of a directory tree for comparison.
.TP 8
.B  t
List the names of the specified files each time they occur on
the tape.  If no file argument is given, list all of the names on the tape.
.TP 8
.B  u
Add the named files to the tape if either they are not
already there or have been modified since last copied to the tape.
.TP 8
.B  c
Create a new tape; writing starts at the beginning of the tape
instead of after the last file.  This command implies the
.BR r 
option.
.TP 8
.B  C
Compare files on tape against existing files.
For each specified file, print a line with a key
character followed by the file name.
.nf
.ta +4m,+2m
	L	linked to an earlier file on the tape
	S	symbolic link
	B	block special file
	C	character special file
	P	named pipe
	?	can't read the disk file, so can't compare
	>	disk file doesn't exist
	=	files compare
	!	files don't compare
.fi
.PP
In addition to the letter
which selects the function desired the following characters may be used:
.TP 8
.B  d
On output, 
.I tar 
normally places information specifying owner and modes
of directories in the archive.  Former versions of 
.IR tar , 
when encountering
this information print error messages of the form:
.br
	``<name>/: cannot create''.
.br
This option suppresses the printing of the directory information.
This option implies the \f3D\f1 option.
.TP 8
.B  D
On output, 
.I tar 
normally places information specifying the owner, modes,
and device numbers
of character and block special files and named pipes (
.I fifos
) in
the archive.
Former versions of 
.IR tar , 
when encountering
this information create an ordinary file of the same name whose contents
is the device number, in binary.
This option suppresses the special file information.
.TP 8
.B  p
This option restores files to their original modes,
ignoring the present
.IR umask (2).
Setuid and sticky information
are also restored to the super-user.
.TP 10
\f3\&0\f1, \f3\&1\f1, \f3\&2\f1, \f3\&3\f1, \f3\&4\f1, \f3\&5\f1, \f3\&6\f1, \f3\&7\f1, \f3\&8\f1, \f3\&9\f1
.br
This modifier selects an alternate drive on which the tape is mounted.
The default is 
.IR /dev/rmt1 .
.TP 10
.B  v
Normally
.I tar
does its work silently.  The
.B v
(verbose) option make
.I tar
print the name of each file it treats preceded by the function
letter.  With the
.B t
function, the verbose option
gives more information about the tape entries than just their names.
.TP 10
.B  w
.I tar
prints the action to be taken followed by file name, then
waits for user confirmation. If a word beginning with `y'
is given, the action is done.  Any other input means do not do it.
.TP 10
.B f
.I tar
uses the next argument as the name of the archive instead of
.IR /dev/rmt1 . 
If the name of the file is `-', tar writes to standard output or
reads from standard input (whichever is appropriate). Thus,
.I tar
can be used as the head or tail of a filter chain.
To move hierarchies, use the command
.sp .5
.ti +.5i
cd fromdir;\0tar cBf \- . | (cd todir; tar xBf \-)

To move hierarchies across systems, use:

.ti +.5i
xx system 'cd fromdir;\0tar cBf \- .' | (cd todir; tar xBf \-)

To backup a hierarchy to a remote tape drive, use:

.ti +.5i
tar cBf \- fromdir | xx system 'dd ibs=10k obs=200k \\
.br
.ti +.5i
of=/dev/rmt1'

To extract from a remote tape, use:

.ti +.5i
xx system 'dd ibs=200k obs=10k if=/dev/rmt1' | tar xBf \-

The
.I xx
command merges standard output with standard error.  If there are any
error messages, they will cause the second
.I tar
to fail. 
Due to an attempt to write a record (the error message) 
whose size is not a multiple of 512, a write
error occurs.
This problem can be avoided 
by using the Bourne shell's capability to redirect just
standard error on the remote system with the command:

.ti +.5i
xx system 'cd fromdir;\0/bin/sh \-c "tar cBf \- . \\
.br
.ti +.5i
2>/dev/console"' | tar xBf \- 
.TP 10
.B b
.I tar
uses the next argument as the blocking factor for tape records. The
default is 400 for the cartridge tape, 1 for standard input
and standard output,
and 20 otherwise.
.\" This option should only be used with raw magnetic
.\" tape archives (See
.\" .B f
.\" above) or the default tape device.
If the tape was written with a blocking factor that
does not exceed the default for that device (20 or 400), 
the block size is determined automatically
when reading a tape.
Use the default blocking factor with a cartridge tape.
Due to the blocking algorithm, 
a tar tape created by writing to the standard output should be read from
standard input. 
.TP 10
.B l
If it cannot resolve all of the links to the
files dumped, 
.I tar 
prints error messages.  If 
.B l 
is not specified, no error messages are printed.
.TP 10
.B m
Do not restore the modification times.  The modification time
will be the time of extraction.
.TP 10
.B e
Force
.I tar
to continue reading past tape errors.
.TP 10
.B L
Force
.I tar
to follow symbolic links as if they were normal files or
directories.
.\"	Normally,
.\"	.I tar
.\"	does not follow symbolic links.
.TP 10
.B B
Force input and output blocking to 20 blocks per record.  This option
allows 
.I tar
to work across a communications channel where the blocking may not
be maintained.
.TP 10
.B R
When extracting from tape, ignore leading slashes on file names,
i.e., extract all files relative to the current directory.
.TP 10
.B U
For each file extracted, unlink existing file (if any).
.TP 10
.B o
Do not \f2chown\f1 (or \f2chgrp\f1) files.
.\" .TP 10
.\" .B V
.\" Variable blocking; the last tape block will not be filled to the blocking
.\" size.
.TP 10
.B a
Reset access times of input files after they have been copied to the archive.
.TP 10
.B q
Turn on debugging and extra error diagnostics.
Supplying this flag multiple times increases debugging level.
.PP
If a file name is preceded by
.BR \-C ,
then
.I tar
will perform a
.IR chdir (2)
to that file name.  This allows multiple directories not
related by a close common parent to be archived using short
relative path names.  For example, to archive files from 
.I /usr/include
and from 
.IR /etc , 
one might use
.PP
.ti +0.5i
tar c \-C /usr include \-C / etc
.\"	.PP
.\"	Previous restrictions dealing with
.\"	.IR tar 's
.\"	inability to properly handle blocked archives have been lifted.
.\"	on Berkeley systems thanks to an enhanced magnetic tape driver.
.PP
If a file name of
.B \-
is given on the command line when making an archive then
.I tar
will read its standard input for a list of files to back up,
one per line; the list is terminated by an EOF.
For example, to back up all files that have changed in the last week,
one might use
.PP
.ti +0.5i
find / \-mtime \-7 \-print | tar ca \-
.SH FILES
/dev/rmt?
.br
/tmp/tar*
.SH DIAGNOSTICS
Error messages about bad key characters and tape read/write errors.
.PP
Error messages if enough memory is not available to hold the link tables.
.SH BUGS
There is no way to ask for the
.IR n \-th
occurrence of a file.
.PP
The system must be rebooted after hard tape errors.
.PP
The
.B u
option can be slow.
.PP
File name length is limited to 100 characters.
.\"	.br
.\"	There is no way to selectively follow symbolic links.
.PP
The data for a file with multiple links is output to
tape with the first link encountered.   Thus, an attempt
to extract a subsequent link by itself will not have the
desired result.
.PP
The cartridge tape drive always reads and writes 512\-byte records.
Each tape must be created from scratch.  Files may not be appended, and
archives cannot be spread over multiple tapes.
.\" $Source: /d2/3.7/src/man/RCS/fixes.man,v $
.\" @(#)$Revision: 1.1 $
.\" $Date: 89/03/27 16:19:38 $
tively follow symbolic u_man/man1/texback.1w                                                                                  644      53     311          514  3543644710   7715                                                                                                                                                                                                                                                                                                                                                                      .TH TEXBACK 1
.SH NAME
texback \- generate a textured background texture
.SH SYNOPSIS
.B texback 
number
.SH DESCRIPTION
.I texback 
generates a textured background for the window manager.
.I number 
is an integer from 1 to 16 which selects a texture 
pattern; larger numbers
produce unpredictable results.
.SH SEE ALSO
startup(1W)
, and
archives cannot be spread over multiple tapes.
.\" $Source: /d2/3.7/src/man/RCS/fixes.man,v $
.\" @(#)$Revision: 1.1 $
.\" $Date: 85/08/15 13:32:32 /doc/vol1/u_man/man1.SH NAME
text \- dragging & scrolling of pixel text                
.SH SYNOPSIS
.nf
.B /usr/people/demos/text
.fi
.SH DESCRIPTION
.PP
Raster text is put under mouse control for fast dragging and scrolling
operation.
Besides showing the speed at which the IRIS can drag characters 
on the screen, it also
shows
the fine clipping of characters at viewport boundaries. 
.sp
.sp
	Mouse buttons		Function
.sp
	left			drag text in x & y via mouse x,y-motion 
.br
	right 			scroll text up & down via mouse y-motion   
.sp
.fi
To exit, press all three mouse buttons simultaneously.
.SH HARDWARE CONFIGURATION
A minimum configuration of 8 bitplanes is required
to run this demonstration program.
r fast dragging and scrolling
operation.
Besides showing the speed at which the IRIS can drag characters 
on the screen, it also
shows
the fine clipping of characters at viewport boundaries. 
.sp
.sp
	Mouse buttons		Function
.sp
	left			drag text in x & y via mouse x,y-motion 
.br
	right 			scroll text up & down via mouse u_man/man1/tset.1                                                                                      664    1776     311        15153  3525522530   7203                                                                                                                                                                                                                                                                                                                                                                      .TH TSET 1
.SH NAME
tset \- terminal dependent initialization
.SH SYNOPSIS
.B tset
[
options
]
.br
.SH DESCRIPTION
.I Tset\^
causes terminal dependent processing such as setting
erase and kill characters, setting or resetting delays,
and the like.
It first determines the
.I type\^
of terminal involved, names for which are specified by the
.B /etc/termcap
data base, and then
does necessary initializations and mode settings.
In the case where no argument types are specified,
.I tset\^
simply reads the terminal type out of the environment variable 
.SM TERM
and re-initializes the terminal.  The rest of this manual concerns
itself with type initialization, done typically once at login, and options
used at initialization time to determine the terminal type and set up
terminal modes.
.PP
When used in a startup script
"\&.profile"
(for
.IR sh\^ (1)
users) or
"\&.login"
(for
.IR csh\^ (1)
users), it is desirable to give information about the types of terminal
usually used, for terminals which are connected to the computer through
a modem.
These ports are initially identified as being
.I dialup\^
or
.I plugboard\^
or
.I arpanet\^
etc.
To specify
what terminal type is usually used on these ports,
.B \-m
is followed by the appropriate port type identifier,
an optional baud-rate specification,
and the terminal type to be used if the mapping conditions are satisfied.
If more than one mapping is specified, the first applicable mapping prevails.
A missing type identifier matches all identifiers.
.PP
Baud rates are specified as with
.IR stty\^ (1),
and are compared with the
speed of the diagnostic output (which is almost always the control terminal).
The baud rate test may be any combination of:
.BR > ,
.BR = ,
.BR < ,
\f3@\f1,
and
.BR \^! ;
\f3@\f1
is a synonym for
.B =
and
.B !
inverts the sense of the test.  To avoid problems with metacharacters, it
is best to place the entire argument to
.B \-m
within \'\^\' characters; users of
.IR csh\^ (1)
must also put a "\e" before any "!" used here.
.PP
Thus
.IP
tset \-m \'dialup\s-2>\s0300:adm3a\' \-m dialup:dw2
.LP
causes the terminal type to be set to an
.I adm3a\^
if the port in use is a dialup at a speed greater than 300 baud;
to a 
.I dw2\^
if the port is (otherwise) a dialup (i.e., at 300 baud or less).
If the
.I type\^
above begins with a question mark,
the user is asked if the user really wants that type.
A null response means to use that type;
otherwise, another type can be entered which will be used instead.
For other ports the port type will be taken from the
.B /etc/ttytype
file or a final, default
.I type\^
option may be given on the command line not preceded by a
.BR \-m .
A ttytype may be preceded with a question mark in
.B /etc/ttytype
for prompting (this is an enhancement over standard \f2tset\fP).
.PP
It is often desirable to return the terminal type, as specified by the
.B \-m
options, and information about the terminal
to a shell's environment.  This can be done using the
.B \-s
option; using the Bourne shell,
.IR sh\^ (1):
.IP "" 5
eval \`tset \-s options ... \`
.PP
or using the C shell,
.IR csh\^ (1):
.IP
tset -s options ... > tset$$
.br
source tset$$
.br
rm tset$$
.P
or:
.IP
.nf
.ta \w'unsetenv\ 'u,+\w'TERMCAP\ 'u
unsetenv	TERMCAP
set	noglob	tmp=(`tset -S -Q`)
setenv	TERM	"$tmp[1]"
setenv	TERMCAP	"$tmp[2]"
unset	tmp	noglob
.fi
.PP
These commands cause
.I tset\^
to generate as output a sequence of shell commands which place the variables
.SM TERM
and 
.SM TERMCAP
in the environment; see
.IR environ\^ (5).
.PP
Once the terminal type is known,
.I tset\^
engages in terminal mode setting.
This normally involves sending an initialization sequence to the
terminal and setting the single character erase (and optionally
the line-kill (full line erase)) characters.
.PP
On terminals that can backspace but not overstrike
(such as a \s-2CRT\s0),
and when the erase character is the default erase character
(``#'' on standard systems),
the erase character is changed to a Control-H
(backspace).
.PP
Other options are:
.TP "\w'\f3\-Q\f1\|\ \ 'u"
.B \-e
set the erase character to be the named character
.I c\^
on all terminals,
the default being the backspace character on the terminal, usually ^H.
.TP
.B \-k
is similar to
.B \-e
but for the line kill character rather than the erase character;
.I c\^
defaults to ^X (for purely historical reasons); ^U is the preferred setting.
No kill processing is done if
.B \-k
is not specified.
.TP
.B \-I
suppresses outputting terminal initialization strings.
.TP
.B \-Q
suppresses printing the
``Erase set to'' and ``Kill set to'' messages.
.TP
.B \-S
Outputs the strings to be assigned to
.SM TERM
and 
.SM TERMCAP
in the environment rather than commands for a shell.
.SH EXAMPLES
A typical 
.I csh\^
"\&.login" file using 
.I tset\^
would be:
.IP
set noglob
.br
set term = (`tset -e -S -r -d?h19`)
.br
setenv TERM "$term[1]"
.br
setenv TERMCAP "$term[2]"
.br
unset term noglob
.PP
This ".login" sets the environment variables 
.SM TERM
and
.SM TERMCAP
for the user's
current terminal according to the file 
.BR /etc/ttytype .
If the
terminal line is a dialup line, the user is prompted for
the proper terminal type.
.PP
.I Reset\^
may be used to return the user's terminal to a usable state after
being accidentally set by an interrupted process to unusual modes.
.SH FILES
.ta \w'/etc/ttytype\ \ \ \ \ 'u
/etc/ttytype	terminal id to type map database
.br
/etc/termcap	terminal capability database
.DT
.SH SEE\ ALSO
csh(1), reset(1), sh(1), stty(1), environ(4), ttytype(4), termcap(5).
.SH BUGS
Should be merged with
.IR stty\^ (1).
.PP
.I Reset\^ 
doesn't set tabs properly; it can't intuit personal choices for interrupt
and line kill characters, so it leaves these the old 
.SM UNIX
standards ^? (delete) for interrupt and @ for line kill.
.PP
It could well be argued that the shell should be responsible for insuring
that the terminal remains in a sane state; this would eliminate the
need for this program.
.SH NOTES
For compatibility with earlier versions of
.IR tset ,
a number of flags are accepted whose use is discouraged:
.TP "\w'\f3\-d \f1type\ \ \ 'u"
\f3\-d\f1 type
equivalent to
.B \-m
dialup:type
.TP
\f3\-p\f1 type
equivalent to
.B \-m
plugboard:type
.TP
\f3\-a\f1 type
equivalent to
.B \-m
arpanet:type
.TP
\f3\-E\f1 c
Sets the erase character to
.I c\^
only if the terminal can backspace.
.TP
\f3\-\f1
prints the terminal type on the standard output
.TP
\f3\-r\f1
prints the terminal type on the diagnostic output.
.SH AUTHOR
Eric Allman
.\"	@(#)tset.1	5.2 of 3/29/84
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/08/06  16:08:01  robinf
.\" Cosmetic changes
.\" 
.\" Revision 1.1  85/06/21  17:05:09  robinf
.\" Update for GL2-2.3
.\" 
.B \-m
arpanet:type
.TP
\f3\-E\f1 c
Sets the erase character to
.I c\^
only if the terminal can backspace.
.TP
\f3\-\f1
prints the terminal type on the standard output
.TP
\f3\-r\f1
prints the terminal type on the diagnostic output.
.SH AUTHOR
Eric Allman
.\"	@(#)tset.1	5.2 of 3/29/84
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/08/06  16:08:01 u_man/man1/vis.1w                                                                                      644      53     311          332  3543644711   7074                                                                                                                                                                                                                                                                                                                                                                      .TH VIS 1W
.SH NAME
vis \- copy a file to the screen
.SH SYNOPSIS
.B vis 
file
.SH DESCRIPTION
.I vis 
copies bytes from the specified file to pixels on the screen.
The color indexes used are in the range 256 to 511.

\f3\-\f1
prints the terminal type on the standard output
.TP
\f3\-r\f1
prints the terminal type on the diagnostic output.
.SH AUTHOR
Eric Allman
.\"	@(#)tset.1	5.2 of 3/29/84
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision/doc/vol1/u_man/man1     u_man/man1/worms.1w                                                                                    644      53     311          455  3543644712   7451                                                                                                                                                                                                                                                                                                                                                                      .TH WORMS 1W
.SH NAME
worms \- U\s-2NIX\s+2 worms running on the IRIS
.SH SYNOPSIS
.B worms
.SH DESCRIPTION
.I worms 
is the U\s-2NIX\s+2 worms program ported to run on the IRIS.  
The middle mouse button makes 
worms that sleep for a second after moving, and the left mouse button makes 
fat worms.

erminal type on the diagnostic output.
.SH AUTHOR
Eric Allman
.\"	@(#)tset.1	5.2 of 3/29/84
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision/doc/vol1/u_man/man1     u_man/man1/wsiris.1                                                                                    664    1776     311        30453  3526530351   7545                                                                                                                                                                                                                                                                                                                                                                      .TH WSIRIS 1
.SH NAME
wsiris \- emulate an IRIS terminal on an IRIS workstation
.SH SYNOPSIS
.B wsiris
[\ options\ ] [\ hostname\ ]
.SH DESCRIPTION
.PP
.I Wsiris\^
allows a workstation to emulate an IRIS terminal communicating
with the remote host
.IR hostname\^ .
Series 1000 workstations will emulate series 1000 terminals, and
series 2000 workstations will emulate series 2000 terminals.
Communications to the remote system can be 
via a full- or half-duplex serial line,
using an
.SM IEEE-488
bus, or
via Ethernet using
.SM XNS
or
.SM IP/TCP
procotols.
The special
.IR hostname s
`serial' and `ieee488' 
are used to select the the serial line or the IEEE-488 bus,
respectively.
When the remote machine does not allow logins
over the
.SM IEEE-488
bus,
when an
.SM IEEE-488
device is being used on the
.SM IRIS
and when
.I hostname\^ 
is `serial', the login is done over a serial
line and the
.SM IEEE-488
bus is used for graphics only.
If no
.I hostname\^
argument is given,
.I wsiris\^
prompts for one.
The contents of a file
.nh
.I `.wsirisrc'\^
.hy
in your home directory, if there is one, are used as additional arguments.
They are parsed before those arguments specified on the command line.
.PP
The options are:
.TP "\w'\f3\-s\fP \f2speed\fP   'u"
.BI \-d " n"
Debugging option.  Multiple 
.B \-d
options can be given.
The legal values for 
.I n
are:
.RS "\w'\f3\-s\fP \f2speed\fP   'u+0.3i" 
.TP 
1
Generate a logfile of the communication between the workstation and the host.
What the logfile contains is described below.
.TP
2
Have the
.I receive\^
process (see below)
not catch 
.SM SIGBUS
or
.SM SIGSEGV
signals 
(see
.IR signal (2)),
but allow it to core dump.
.RE 1
.TP
.BI \-e " c"
Set the escape character from the default `~' to
.IR c\^ .
Lines beginning with the escape character are given special treatment
(see below).
If
.I c\^
is 
.BR none ,
there will be no escape character.
.TP
.B \-f
Don't read
.IR ~/.wsirisrc
for additional arguments.
.TP
.B \-h
Use half-duplex serial communications.  The default is full-duplex.
.TP
.B \-i
When using Ethernet communications, an
.SM XNS
connection to
.I hostname\^
is attempted first.
If that fails, a connection using
.SM IP/TCP
is then attempted.
Giving the
.B \-i
option causes an
.SM IP/TCP
connection to be tried first.
.TP
.BI \-l " line\^"
Use device
.I line\^
for the serial connection.
.I Line\^
must begin with either `/dev/' or `tty'.
The default 
.I line\^
is `/dev/ttyd2' (port 3).
.TP
.B \-p
Print textport output even when the textport has been turned off.
By default, after the receipt of a
.I tpoff 
command from the remote system, all textport output is thrown away until a
.I tpon 
is received.  (See the \f2IRIS User's Guide\fP for information on
.I tpoff
and
.IR tpon .)
The 
.B \-p
option inhibits this, and characters written to the textport will appear
when it is turned on again.
.TP
.BI \-s " speed\^"
Use
.I speed\^
baud for serial communications.
See
.IR stty (1)
for the allowed values.
The default on Series 1000 workstations is 9600 baud.
The default on Series 2000 workstations is read from the configuration
switches.
See Appendix A of the
.I IRIS Workstation Guide
for the meanings of the configuration switch settings.
.TP
.B \-x
Enable local
.SM XON/XOFF
flow control.
Normally when read from the standard input the characters 
.SM XON (CTRL/Q)
and
.SM XOFF (CTRL/S)
are sent to the remote system.
Spcifying this option causes them to be used locally to stop and 
restart the display of text.
When using serial communications,
this option also enables the use of
these characters by the serial driver of the
.SM IRIS
for automatic flow control of data being received from the host.
This automatic flow control is normally disabled as it 
will not work correctly if there are two independent
sources of these characters.
.TP 
.B \-y
If using serial communications, interpret
.SM XON
and
.SM XOFF
characters from the remote host
as output flow control commands.
By default, they are treated are ordinary data.
.\" This flag must NOT be given if fast serial communications are to be used.
.TP
.BI \-z " n"
Special instructions.  Multiple 
.B \-z 
options can be given.
The legal values for 
.I n
are:
.RS "\w'\f3\-s\fP \f2speed\fP   'u+0.3i" 
.TP 
1
Interpret 
.I ginit 
commands as 
.IR gbegin 's.
(See the \f2IRIS User's Guide\fP for information on 
.I ginit
and 
.IR gbegin .)
This instruction is ignored on Series 1000 workstations.
.TP
2
Execute a 
.I ginit\^
immediately upon startup.
This is useful when
.I wsiris\^
has had to be restarted and the remote program is still sending
graphics commands.
.TP
3
When attempting a connection
using Ethernet communications, only try one network protocol instead
of both.
.SM IP/TCP
is tried if the
.B \-i
flag is given, and
.SM XNS
if it isn't.
.TP
4
Emulate a Tektronics 4010 (series 2000 workstations only).
.RE 1
.PP
After making the remote connection,
.I wsiris\^
runs as two processes:
.I receive\^
and
.IR transmit .
The
.I transmit\^
process reads data from the standard input and,
except for lines beginning with the escape character,
passes them to the remote system.  
The
.I receive\^
process accepts data from the remote system,
interpreting graphics commands and
passing textport characters to the standard output.
Sometimes more than two processes are run.
In half-duplex mode, the 
.I receive\^
process accepts its input from a pipe which is written to
by the 
.I transmit\^
process and by a third process
which does the reading of data from the remote system.
When using the 
.SM IEEE-488
bus and a serial line together, the
.I receive\^
process also reads from a pipe, but there are two processes which
write to it:  one reads the serial line and the other reads the
.SM IEEE-488
device.
Closing the remote connection, e.g. by logging out, will cause all 
.I wsiris
processes to exit.
.PP
When the escape character `~'
appears at the beginning of a line (i.e., the previous character
was a
.SM RETURN
or a \s-1NEWLINE\s0),
the
.I transmit\^
process makes the following interpretations:
.RS
.TP "\w'\f3~%S\f2speed\f1  'u"
.B ~~
Send a single `~'.
.TP
.B ~.
Force
.I wsiris
to exit.
Ethernet connections are closed, but serial connections
may remain open.
.TP
.B ~!
Escape to an interactive shell on the local system.
The value of the environment variable 
.SM SHELL
determines which shell is executed.
If 
.I wsiris
finds the environment variable
.SM CMDNAME
is set, this local shell will have it set to:
.br
	\f3wsiris:\f2hostname\f1
.br
This is useful for altering shell prompts so that you are
aware that you are in a sub-shell.
Exiting the shell returns you to the remote host, or to the
.SM IRIS,
if the connection has been closed.
.TP
.BR ~ \s-2BREAK\s0
If using serial communications, send a break character.
.TP
.BI ~%M n
Set the monitor type to
.IR n .
The meanings of
.I n
are:
.in +.5i
0	60 Hz
.br
1	30 Hz
.br
2	NSTC or PAL
.br
.in
This is ignored on Series 1000 workstations.
.TP
.B ~%P
Toggle the value of the 
.B \-p 
option.
.TP
.B ~%R
Reset the display by forcing a
.I ginit\^
and a
.I tpon\^
to be executed.
This will load the default color map and turn on the textport which
should make something visible.
If the window manager 
.IR mex (1G)
is running, the color map will be further
restored by executing any `mapcolor'
commands found its configuration file,
.IR ~/.mexrc .
.TP
.BI ~%S speed
Change the serial communications baud rate to
.IR speed .
The same values are accepted as with the
.B \-s
option.
.TP
.B ~%T
Textport toggle.
Turn on the textport if it is off, and off if it is on.
When turned off, the textport does not automatically disappear.
Hence, if it appears that the remote system is not echoing input
and it should be (especially after interrupting a graphics program),
the textport may in fact be off.
Use this command to turn it back on.
.TP
.B ~%U
Unlock the keyboard.
Whenever the 
.SM IRIS
is accepting graphics commands, the
.I receive\^
process locks the keyboard, and input from it is thrown away.
Use this command to force characters through to the remote system,
such as the interrupt character to kill the remote program.
The keyboard will be locked again at the next switch back into graphics mode.
.TP
.B ~%X
Toggle the value of the 
.B \-x 
option.
.RE
.PP
The escape character can be changed from `~' with the
.B \-e
option.
If
.B \-e none
is given, there is no escape character and none of the above
interpretations occur.
In this case, note that there is no way to force
.I wsiris
to exit.
.PP
.SM IRIS 
terminals suffer from the problem of having textport output interfere
with graphics.
If something is printed within a graphics program, either
the textport pops up and destroys the image, or the textport
and the graphics viewport must be carefully arranged so that there is no
interference.
This problem is eliminated when using
.I wsiris\^
under the window manager.
All graphics are sent to a separate window distinct from the textport.
Without the window manager, this problem can still be eliminated
by invoking 
.I wsiris\^
from an
.SM ASCII
terminal connected to one of the other serial ports instead of from
the console.
When this is done, the 
.SM ASCII
terminal is used for textport input and output, and the graphics
appear unchanged on the console.
Note that the Graphics Library keyboard device will still be the
console keyboard.
.PP
If the remote program queues the keyboard,
all keystrokes will normally end up in the event queue.
To divert them to 
.IR wsiris ,
in order to, for example,
give it one of the `~' commands described above, hold the 
.SM SETUP
key down while typing.
The events from individually queued keyboard keys are also not
placed in the queue while
.SM SETUP
is down.
.PP
The logfile created by the 
.B \-d 1
option is written to `\s-1LOGFILE\s0.0' in the current directory.
Graphics commands and data are interpreted and written to the logfile as
a command name and a series of arguments.  The arguments are shown as
.IR type = value ,
where
.I type\^
is a single character representing the type of argument:
.nf
.br
.in +1i
.ta 0.2i,0.5i
a,	A	array
b,	B	byte (8 bits)
c,	C	character string
f,	F	float (32 bits)
l,	L	long (32 bits)
s,	S	short (16 bits)
o		logical (8 bits)
O		logical (32 bits)
.in
.fi
If the character is capitalized, then the
the argument was sent by the 
.SM IRIS,
otherwise it was sent by the remote system.
The
.I value\^
of array types is always `array'.
.SH FILES
.ta 1.5i
~/.wsirisrc	file containing default arguments
.br
~/.mexrc	window manager configuration file
.br
/dev/ttyd?	serial devices
.br
/dev/ib1	IEEE-488 device

.SH "SEE ALSO"
.na
kill(1), mex(1G), ps(1), reset(1), stty(1), signal(2).
.br
.I IRIS User's Guide
.br
.I IRIS Workstation Guide
.ad
.SH BUGS
.I Wsiris\^
is only as robust as any other workstation graphics program.
In particular, if the remote program tells it to execute
a graphics command without having first sent it a
.IR ginit , 
the
.I receive\^
process will core dump.
Normally, this causes the
.I transmit\^
process to be killed, but in some cases it
may still be active, happily accepting keyboard input
which should be going to the shell.
Should this happen, execute
.IR ps (1)
on another terminal to find its process number and
.IR kill (1)
it.
If half-duplex serial communications were being used, there will
be two processes to kill.
You may also have to use 
.IR reset (1)
to put the terminal back into a sensible state 
(for directions, see
.IR reset (1)).
.PP
When using serial communications at speeds above 4800 baud,
characters may be dropped if there is screen activity, e.g. listing
a file, on another terminal.
The problem can occur with
both directly and network connected terminals.
There is no way to recover from this other than to restart the
remote program.
.PP
It is not possible to login to the remote machine using only
.SM IEEE-488.
The serial line must be used as well \- use `serial' for
.IR hostname\^ .
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.8  85/06/17  15:17:05  robinf
.\" Update for GL1-2.3 and GL2-2.3
.\" 
.\" Revision 1.7  85/06/05  13:19:42  robinf
.\" Third update for GL2-W2.3 and GL1-W2.2
.\" 
.\" Revision 1.6  85/05/23  16:46:45  robinf
.\" Further update for GL1-2.2 and GL2-2.3
.\" 
.\" Revision 1.4  84/12/16  00:55:52  bob
.\" Fixed .tr error.
.\" 
.\" Revision 1.3  84/12/14  10:58:03  bob
.\" Re-wrote portions.
.\" 
.\" Revision 1.2  84/12/14  10:07:18  bob
.\" Made minor style change.
.\" 
.\" Revision 1.1  84/12/11  13:38:41  bob
.\" Initial revision
.\" 




.\" Update for GL1-2.3 and GL2-2.3
.\" 
.\" Revision 1.7  85/06/05  13:19:42  robinf
.\" Third update for GL2-W2.3 and GL1-W2.2
.\" 
.\" Revision 1.6  85/05/23  16:46:45  robinf
.\" Further update for GL1-2.2 and u_man/man1/xcp.1c                                                                                      664    1776     311         5154  3531703407   7142                                                                                                                                                                                                                                                                                                                                                                      .TH XCP 1C
.SH NAME
xcp \- remote file copy
.SH SYNOPSIS
\f3xcp\f1 [ \f3\-Lrv\f1 ] file1 file2
.br
\f3xcp\f1 [ \f3\-Lrv\f1 ] file ... directory
.SH DESCRIPTION
\f2Xcp\f1 copies files between machines.
\f2File1\f1 is copied to \f2file2\f1 or \f2file\f1 is copied to 
\f2directory/file\f1.
.PP
Each \f2file\f1 or \f2directory\f1
argument is either a remote file name of the
form \f2rhost:path\f1,
or a local file name.
( If the file name contains a :, put a ./ before the
file name to specify a file in the current directory.  
For example, to send the file x:, use the command:  
xcp ./x: remote:x:)
.PP
The login name of the user sending a file over the network
must be recognized by the remote machine or
\f2rhost\f1 may take the form \f2rhost.rname\f1
to use \f2rname\f1 rather
than the current login name on the remote host.
\f2Xcp\f1 does not prompt for passwords;
your current local login name must exist on
\f2rhost\f1 and allow remote command execution
via \f2xlogin\f1(1).
If \f2path\f1 is not a full path name,
it is interpreted relative to
your login directory on \f2rhost\f1.
A \f2path\f1 on a remote host may be quoted (using \e, ", or \(aa)
so that the metacharacters are interpreted remotely.
\f2Xcp\f1 handles third party copies,
where neither source nor target files
are on the current machine.
.PP
If the argument \f3\-r\f1
is specified and any of the source files are directories,
\f2xcp\f1 copies each subtree rooted at that name;
in this case the destination must be a directory.
.PP
The \f3\-v\f1 option causes the file name to be printed as each file is copied.
.PP
The 
\f3\-L\f1 option causes symbolic links to be followed.
Normally symbolic links are transferred as such.
.SH FILES
/bin/xx
.SH "SEE ALSO"
cp(1), xlogin(1C), xx(1C)
.SH BUGS
\f2Xcp\fP doesn't detect all cases where the target of a copy might
be a file in cases where only a directory should be legal.
.PP
\f2Xcp\fP is confused by any output generated by commands in a
\f2\&.login\f1, \f2\&.profile\f1, or \f2\&.cshrc\f1 file on the remote host.
.PP
When copying with -r,
links within a subtree are not preserved.
.PP
Long file names (>950 bytes) may cause trouble.
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.5  85/05/15  15:10:21  robinf
.\" Updates for GL2-W2.3 and GL1-W2.2
.\" 
.\" Revision 1.4  85/05/09  14:58:29  robinf
.\" Resolve SCR 122
.\" 
.\" Revision 1.3  85/05/03  19:19:41  robinf
.\" Updates from 2000 Series Workstation Guide, Version 1.0
.\" 
.\" Revision 1.0  85/05/03  12:58:26  robinf
.\" Initial Revision
.\" Revision 1.2  85/02/25  12:51:30  bob
.\" Incorporated -v documented on jesse version.
.\" 
.\" @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\" $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.5  85/05/15  15:10:21  robinf
.\" Updates for GL2-W2.3 and GL1-W2.2
.\" 
.\" Revision 1.4  85/05/09  14:58:29  robinf
.\" Resolve SCR 122
.\" 
.\" Revision 1.3  85/05/03  19:19:41  robinf
.\" Updates from 2000 Series Workstation Guide, Version 1.0
.\" 
.\" Revision 1.0  85/05/03  12:58:26  robinf
.\" Initiu_man/man1/xlogin.1c                                                                                   664    1776     311         3765  3535446416   7666                                                                                                                                                                                                                                                                                                                                                                      .TH XLOGIN 1C
.SH NAME
xlogin \- remote login
.SH SYNOPSIS
\f3xlogin\f1 [ 
.B \-tx 
] rhost
.SH DESCRIPTION
\f2xlogin\f1 connects your terminal
on the current local host system
to the remote host system \f2rhost\f1.
.PP
All echoing takes place at the remote site,
so that (except for delays)
\f2xlogin\f1 is transparent.
Flow control using \s-2CTRL-s\s0 and \s-2CTRL-q\s0
and flushing of input and output
on interrupts are handled on the remote machine.
To make the flow control function occur on the calling
machine, use the 
.B \-x 
flag.  While remotely logged in,
you can use the command, \f2~x\f1, to change
the location of flow control between the
local and remote machines (see below).
.PP
After making the remote connection,
.I xlogin\^
runs as two processes:
the
.I transmit\^
process reads data from the standard input and,
except for lines beginning with `~',
passes them to the remote system;
the
.I receive\^
process accepts data from the remote system,
passing text characters to the standard output.
Closing the remote connection, e.g. by logging out, will cause both
.I xlogin
processes to exit.
.PP
When special characters appear at the beginning of a line
the
.I transmit\^
process 
makes the following interpretations:
.TP
.B ~.
Force
.I xlogin
to exit.
.TP
.B ~!
Escape to an interactive shell on the local system.
The value of the environment variable 
.SM SHELL
determines which shell is executed.
If 
.I xlogin
finds the environment variable
.SM CMDNAME
is set, this local shell will have it set to:
.br
	\f3xlogin:\f2hostname\f1
.br
This is useful for altering shell prompts so that you are
aware that you are in a sub-shell.
Exiting the shell returns you to the remote host.
.TP
.B ~x
Switch location of flow control between remote and local machine 
while logged in remotely.
.TP
.B ~~
Send a single `~'.
.PP
If you specify the 
.B \-t
process the 
.I transmit\^
option does not interpret the characters as stated above.
.SH SEE ALSO
xcp(1C),
xx(1C)
.SH BUGS
More terminal characteristics should be propagated.
r
	\f3xlogiu_man/man1/xx.1c                                                                                       664    1776     311         4006  3535446760   7014                                                                                                                                                                                                                                                                                                                                                                      .TH XX 1C
.SH NAME
xx \- remote shell
.SH SYNOPSIS
.B xx
[\ 
.B \-x
\ ] host command
.SH DESCRIPTION
.I xx
connects to the specified
.I host,
and executes the specified
.I command.
.I xx
copies its standard input to the remote command, the standard
output of the remote command to its standard output, and the
standard error of the remote command to its standard error.
Interrupt, quit and terminate signals are propagated to the remote
command;
.I xx
normally terminates when the remote command does.
.PP
All echoing takes place at the remote site, so that (except for
delays)
.I xlogin
is transparent.  To make the flow control function on the calling
machine, use the 
.B \-x 
flag.  Flow control,  using 
\s-2CTRL-s\s0 and \s-2CTRL-q\s0, 
and flushing input and output on interrupts are handled properly.
.PP
The remote login name must be equivalent (in the sense of
.IR sh (1))
to the originating account; no provision
is made for specifying a password with a command.
.PP
If you omit
.I command,
.I xx 
host C shell is executed.
.PP
Shell metacharacters which are not quoted are interpreted
on the local machine, while quoted metacharacters are interpreted on
the remote machine.
Thus the command
.sp
.nf
.in +0.5i
xx otherhost cat remotefile >> localfile
.in
.fi
.sp
appends the remote file
.I remotefile
to the local file
.I localfile,
while
.sp
.nf
.in +0.5i
xx otherhost cat remotefile ">>" otherremotefile
.in
.fi
.sp
appends
.I remotefile
to
.I otherremotefile.
.SH SEE ALSO
sgboot(1M), sgbounce(1M), xnsd(1M), utmp(3N), xcmd(3N), xconnect(3N),
xnsfile(3N), xnsioctl(3N), xnslib(3N), xnswrite(3N), 
xlogin(1C),
xcp(1C)
.SH BUGS
If you are using
.IR csh (1)
and put an
.IR xx (1C)
in the background without redirecting its input
away from the terminal, it will block even if no reads
are posted by the remote command.
.PP
You cannot run an interactive command
(like
.IR vi (1));
use
.IR xlogin .
.PP
Stop signals stop the local
.I xx
process only;
this is arguably wrong,
but currently hard to fix for reasons
too complicated to explain here.
 xconnect(3N),
xnsfile(3N), xnsioctl(3N), xnslib(3N), xnswrite(3N), 
xlogin(1C),
xcp(1C)
.SH BUGS
If you are using
.IR csh (1)
and put an
.IR xx (1C)
in the background without redirecting its input
away from the terminal, it will block even if no reads
are posted by the remote command.
.PP
You cannot run an interactive command
(like
.IR vi (1));
use
.IR xlogin .
.PP
Stop signals stop the local
.I xx
process only;
this is arguably wrong,
but currently hard to fix for reasons
too complicated to explain u_man/man1/zshadecar.1d                                                                                644    1776     311         3031  3543635112  10303                                                                                                                                                                                                                                                                                                                                                                      .TH ZSHADECAR 1D
.SH NAME
zshadecar, zshadeabstract, zshadeegg, zshadejet \- shading and z-buffering demo
.SH SYNOPSIS
.B /usr/people/mexdemos/zshadecar
.br
.B /usr/people/mexdemos/zshadeabstract
.br
.B /usr/people/mexdeoms/zshadeegg
.br
.B /usr/people/mexdeoms/zshadejet
.SH DESCRIPTION
.PP
These programs demonstrate advanced graphics features of the Series 2000 
IRIS:  
cubic patches, depth cuing, z-buffering and Gouraud shading.  The objects
are formed of bi-cubic patches.
.PP
The first image to appear is a grey scale chart, representing the gamma
corrected color map.  
The next image is of lines connecting the basis points of the object.
From these basis points a cubic patch is derived, 
first shown as an array of points.
.PP
.sp
Menu selections for invoking the various display modes are made by pressing one
of the following keys:
.ta \w'Key\ \ \ 'u
.in +.5i
.nf
.na
Key	Function
d	turn on depth cuing
p	draw point display
s	draw as splines
w	original wireframe
z	z-buffer and Gouraud shaded version
.in -.5i
To rotate the image, move the mouse in the X direction only.

	LEFT mouse button rotates the car in X
	MIDDLE mouse button rotates the car in Y
	RIGHT mouse button rotates the car in Z
.fi
.ad
.PP
The usual way to display 
a program
is to rotate the wire frame or point
surface interactively to the desired position and then smooth shade and
z-buffer it. 
.PP
.sp 2
.SH HARDWARE CONFIGURATION
A minimum configuration of 32 bitplanes, 1.5 Megabytes of memory, and
Z-clipping is required.
.SH SEE ALSO
surfcar(1D)
.SH AUTHOR
Henry Moreton
 the mouse in the X direction only.

	LEFT mouse button rotates the car in X
	MIDDLE mouse button rotates the car in Y
	RIGHT mouse button rotates the car in Z
.fi
.ad
.PP
The usual way to display 
a program
is to rotate the wire frame or point
surface interactively to the desired position and then smooth shade and
z-buffer it. 
.PP
.sp 2
.SH HARDWARE CONFIGURATION
A minimum configuration of 32 bitplanes, 1.5 Megabytes of memory, and
Z-clipping is required.
.SH SEE ALSO
surfcar(1D)
u_man/man2/intro.2                                                                                     664    1776     311        66572  3537070625   7402                                                                                                                                                                                                                                                                                                                                                                      .TH INTRO 2
.de {n
.HP
\\$1  \\$2  \\$3
.br
..
.SH NAME
intro \- introduction to system calls and error numbers
.SH SYNOPSIS
.B #include \|<errno.h>
.SH DESCRIPTION
This section
describes all of the system calls.
Most of these calls have one or more error returns.
An error condition is indicated by an otherwise
impossible returned value.
This is almost always \-1;
the individual descriptions specify the details.
An error number is also made available
in the external variable
.IR errno .
.I errno\^
is not cleared on successful calls, so it should be tested only
after an error has been indicated.
.PP
There is a table of messages associated with each error, 
and a routine for printing the message; see
.IR perror\^ (3).
All of the possible error numbers
are not listed in each system call description because many
errors are possible for most of the calls.
The following is a complete list of the error numbers and
their names as defined in
.BR <errno.h> .
.{n 1 \s-1EPERM\s+1 "Not owner"
Typically this error indicates
an attempt to modify a file in some way forbidden
except to its owner or super-user.
It is also returned for attempts
by ordinary users to do things
allowed only to the super-user.
.{n 2 \s-1ENOENT\s+1 "No such file or directory"
This error occurs when a file name is specified
and the file should exist but doesn't, or when one
of the directories in a path name does not exist.
.{n 3 \s-1ESRCH\s+1 "No such process"
No process can be found corresponding to that specified by
.I pid\^
in
.I kill\^
or
.IR ptrace .
.{n 4 \s-1EINTR\s+1 "Interrupted system call"
An asynchronous signal (such as interrupt or quit),
which the user has elected to catch,
occurred during a system call.
If execution is resumed
after processing the signal,
it will appear as if the interrupted system call
returned this error condition.
.{n 5 \s-1EIO\s+1 "I/O error"
Some physical I/O error.
This error may in some cases occur
on a call following the one to which it actually applies.
.{n 6 \s-1ENXIO\s+1 "No such device or address"
I/O on a special file refers to a subdevice which does not
exist,
or beyond the limits of the device.
It may also occur when, for example, a tape drive
is not on-line or no disk pack is loaded on a drive.
.{n 7 \s-1E2BIG\s+1 "Arg list too long"
An argument list longer than 5,120 bytes
is presented to a member of the
.I exec\^
family.
.{n 8 \s-1ENOEXEC\s+1 "Exec format error"
A request is made to execute a file
which, although it has the appropriate permissions,
does not start with a valid magic number (see
.IR a.out\^ (4)).
.{n 9 \s-1EBADF\s+1 "Bad file number"
Either a file descriptor refers to no
open file,
or a read (respectively write) request is made to
a file which is open only for writing (respectively reading).
.{n 10 \s-1ECHILD\s+1 "No child processes"
A
.IR wait
was executed by a process that had no existing or unwaited-for child processes.
.{n 11 \s-1EAGAIN\s+1 "No more processes"
A
.IR fork
failed because the system's process table is full
or the user is not allowed to create any more
processes.
.{n 12 \s-1ENOMEM\s+1 "Not enough space"
During an
.IR exec ,
.IR brk ,
or
.IR sbrk ,
a program asks for more space than the system is able to supply.
This is not a temporary condition; the maximum space size
is a system parameter.
The error may also occur if the arrangement
of text, data, and stack segments
requires too many segmentation registers, or
if there is not enough swap space during a
.IR fork .
.{n 13 \s-1EACCES\s+1 "Permission denied"
An attempt was made to access a file in a way forbidden
by the protection system.
.{n 14 \s-1EFAULT\s+1 "Bad address"
The system encountered a hardware fault in attempting to
use an argument of a system call.
.{n 15 \s-1ENOTBLK\s+1 "Block device required"
A non-block file was mentioned where a block device was required,
e.g., in
.IR mount .
.{n 16 \s-1EBUSY\s+1 "Mount device busy"
An attempt to mount a device that was already mounted or
an attempt was made to dismount a device
on which there is an active file
(open file, current directory, mounted-on file, active text segment).
It will also occur if an attempt is made to enable accounting when it is
already enabled.
.bp
.{n 17 \s-1EEXIST\s+1 "File exists"
An existing file was mentioned in an inappropriate context,
e.g.,
.IR link .
.{n 18 \s-1EXDEV\s+1 "Cross-device link"
A link to a file on another device
was attempted.
.{n 19 \s-1ENODEV\s+1 "No such device"
An attempt was made to apply an inappropriate
system call to a device;
e.g., read a write-only device.
.{n 20 \s-1ENOTDIR\s+1 "Not a directory"
A non-directory was specified where a directory
is required,
for example in a path prefix or
as an argument to
.IR chdir\^ (2).
.{n 21 \s-1EISDIR\s+1 "Is a directory"
An attempt to write on a directory.
.{n 22 \s-1EINVAL\s+1 "Invalid argument"
Some invalid argument (e.g., dismounting a non-mounted device;
mentioning an undefined signal in
.IR signal ,
or
.IR kill ;
reading or writing a file for which
.I lseek\^
has generated a negative pointer).
Also set by the math functions described in the (3M) entries
of this manual.
.{n 23 \s-1ENFILE\s+1 "File table overflow"
The system's table of open files is full,
and temporarily no more
.I opens\^
can be accepted.
.{n 24 \s-1EMFILE\s+1 "Too many open files"
No process may have more than 20 file descriptors open at a time.
.{n 25 \s-1ENOTTY\s+1 "Not a typewriter"
The file mentioned in
.I stty\^
or
.I gtty\^
is not a terminal or one of the other devices to which these calls apply.
.{n 26 \s-1ETXTBSY\s+1 "Text file busy"
An attempt to execute a pure-procedure
program which is currently open for writing
(or reading).
Also an attempt to open for writing a pure-procedure
program that is being executed.
.{n 27 \s-1EFBIG\s+1 "File too large"
The size of a file exceeded the maximum
file size (1,082,201,088 bytes) or
.SM ULIMIT\*S;
see
.IR ulimit\^ (2).
.{n 28 \s-1ENOSPC\s+1 "No space left on device"
During a
.I write\^
to an ordinary file,
there is no free space left on the device.
.{n 29 \s-1ESPIPE\s+1 "Illegal seek"
An
.I lseek\^
was issued to a pipe.
This error should also be issued for other non-seekable devices.
.bp
.{n 30 \s-1EROFS\s+1 "Read-only file system"
An attempt to modify a file or directory
was made
on a device mounted read-only.
.{n 31 \s-1EMLINK\s+1 "Too many links"
An attempt to make more than the maximum number of links (1000) to a file.
.{n 32 \s-1EPIPE\s+1 "Broken pipe"
A write on a pipe for which there is no process
to read the data.
This condition normally generates a signal;
the error is returned if the signal is ignored.
.{n 33 \s-1EDOM\s+1 "Math argument"
The argument of a function in the math package (3M)
is out of the domain of the function.
.{n 34 \s-1ERANGE\s+1 "Result too large"
The value of a function in the math package (3M)
is not representable within machine precision.
.{n 35 \s-1EWOULDBLOCK\s+1 "Operation would block"
An operation which would cause a process to block was attempted
on an object in non-blocking mode (see 
.IR ioctl\^ (2)).
.{n 36 \s-1EINPROGRESS\s+1 "Operation now in progress"
An operation which takes a long time to complete (such as a
.IR connect\^ (2))
was attempted on a non-blocking object (see
.IR ioctl\^ (2)).
.{n 37 \s-1EALREADY\s+1 "Operation already in progress"
An operation was attempted on a non-blocking object which
already had an operation in progress.
.{n 38 \s-1ENOTSOCK\s+1 "Socket operation on non-socket"
.{n 39 \s-1EDESTADDRREQ\s+1 "Destination address required"
A required address was omitted from an operation on a socket.
.{n 40 \s-1EMSSIZE\s+1 "Message too long"
A message sent on a socket was larger than the internal message buffer.
.{n 41 \s-1EPROTOTYPE\s+1 "Protocol wrong type for socket"
A protocol was specified which does not support the semantics of the
socket type requested.  For example, you cannot use the 
.SM ARPA 
Internet
.SM UDP 
protocol with type SOCK_STREAM.
.{n 42 \s-1ENOPROTOOPT\s+1 "Bad protocol option"
A bad option was specified in a 
.IR getsockopt\^ (2)
or
.IR setsockopt\^ (2)
call.
.{n 43 \s-1EPROTONOSUPPORT\s+1 "Protocol not supported"
The protocol has not been configured into the system or no
implementation for it exists.
.{n 44 \s-1ESOCKTNOSUPPORT\s+1 "Socket type not supported"
The support for the socket type has not been configured into the system
or no implementation exists.
.{n 45 \s-1EOPNOTSUPP\s+1 "Operation not supported on socket"
For example, trying to \f2accept\^\fP a connection on a datagram socket.
.{n 46 \s-1EPFNOSUPPORT\s+1 "Protocol family not supported"
The protocol family has not been configured into the system
or no implementation exists.
.{n 47 \s-1EAFNOSUPPORT\s+1 "Address family not supported by protocol family"
An address incompatible with the requested protocol was used.
For example, you shouldn't necessarily expect to be able to use 
.SM PUP
Internet addresses with 
.SM ARPA
Internet protocols.
.{n 48 \s-1EADDRINUSE\s+1 "Address already in use"
Only one usage of each address is normally permitted.
.{n 49 \s-1EADDRNOTAVAIL\s+1 "Can't assign requested address"
Normally results from an attempt to create a socket with an
address not on this machine.
.{n 50 \s-1ENETDOWN\s+1 "Network is down"
A socket operation encountered a dead network.
.{n 51 \s-1ENETUNREACH\s+1 "Network is unreachable"
A socket operation was attempted to an unreachable network.
.{n 52 \s-1ENETRESET\s+1 "Network dropped connection on reset"
The host you were connected to crashed and rebooted.
.{n 53 \s-1ECONNABORTED\s+1 "Software caused connection abort"
A connection abort was caused internal to your host machine.
.{n 54 \s-1ECONNRESET\s+1 "Connection reset by peer"
A connection was forcibly closed by a peer.  This normally results
from a peer executing a
.IR shutdown\^ (2) 
call.
.{n 55 \s-1ENOBUFS\s+1 "No buffer space available"
An operation on a socket or pipe performed because the system 
lacked sufficient buffer space.
.{n 56 \s-1EISCONN\s+1 "Socket is already connected"
A 
.I connect
request was made on an already connected socket; or a
.I sendto
or 
.I sendmsg
request on a connected socket specified a destination other than the
connected party.
.{n 57 \s-1ENOTCONN\s+1 "Socket is not connected"
A request to send or receive data was disallowed because the socket 
was not connected.
.{n 58 \s-1ESHUTDOWN\s+1 "Can't send after socket shutdown"
A request to send data was disallowed because the socket had already
been shut down with a previous
.IR shutdown\^ (2)
call.
.{n 59 \s-1ETOOMANYREFS\s+1 "Too many references: can't splice"
.{n 60 \s-1ETIMEDOUT\s+1 "Connection timed out"
A 
.I connect
request failed because the connected party did not properly respond
after a period of time. (The timeout period is dependent on the
communication protocol.)
.{n 61 \s-1ECONNREFUSED\s+1 "Connection refused"
No connection could be made because the target machine actively
refused it.
.{n 62 \s-1ELOOP\s+1 "Too many levels of symbolic links"
A path name lookup involved more than 8 symbolic links.
.{n 63 \s-1ENAMETOOLONG\s+1 "File name too long"
A component of a path name exceeded 255 characters, or an entire
path name exceeded 1023 characters.
.{n 64 \s-1EHOSTDOWN\s+1 "Host is down"
.{n 65 \s-1EHOSTUNREACH\s+1 "No route to host"
.{n 66 \f2unused\f1
.{n 67 \f2unused\f1
.{n 68 \f2unused\f1
.{n 69 \f2unused\f1
.{n 70 \s-1ENOMSG\s+1 "No message of desired type"
An attempt was made to receive a message of a type that
does not exist on the specified message queue; see
.IR msgop\^ (2).
.{n 71 \s-1EIDRM\s+1 "Identifier removed"
This error is returned to processes that resume execution due to the
removal of an identifier from the file system's name space (see
.IR msgctl\^ (2),
.IR semctl\^ (2),
.IR shmctl\^ (2).
.{n 72 \s-1ETOOBIG\s+1 "Program too large to map"
Hardware restrictions prohibit the program from running.
.{n 73 \s-1ETEXTABLEFULL\s+1 "Text table is full"
A internal table in the kernel has filled up; try again later.
.{n 74 \s-1EINODETABLEFULL\s+1 "Inode table is full"
A internal table in the kernel has filled up; try again later.
.{n 75 \s-1ENOFPA\s+1 "No fpa to run program"
No floating point accelerator board is installed.
.{n 76 \s-1EOUTOFSWAP\s+1 "Not enough swap space to fork"
.{n 77 \s-1ESWAPTOOSMALL\s+1 "Swap area is smaller than program"
.{n 78 \s-1EGRBUSY\s+1 "Graphics already in use"
This message only applies to IRIS Series 1000 
workstations running Graphics Library 1 (GL1).
.{n 79 \s-1ENOGR\s+1 "No graphics hardware present"
.SH "DEFINITIONS"
.SS "Process \s-1ID\s+1"
Each active process in the system is uniquely identified by a
positive integer called a process
.SM ID\*S.
The range of this
.SM ID
is from 0 to 30,000.
.SS "Parent Process \s-1ID\s+1"
A new process is created by a currently active
process; see
.IR fork\^ (2).
The parent process
.SM ID
of a process is the process
.SM ID
of its creator.
.SS "Process Group \s-1ID\s+1"
Each active process is a member of a process group that is
identified by a positive integer called the process group
.SM ID\*S.
This
.SM ID
is the process
.SM ID
of the group leader.
This grouping permits the signaling of related processes; see
.IR kill\^ (2).
.SS "Tty Group \s-1ID\s+1"
Each active process can be a member of a terminal group that
is identified by a positive integer called the tty group
.SM ID\*S.
This grouping is used to terminate a group of related process upon termination
of one of the processes in the group; see
.IR exit\^ (2)
and
.IR signal\^ (2).
.SS "Real User \s-1ID\s+1 and Real Group \s-1ID\s+1"
Each user allowed on the system is 
identified by a positive integer called a real user
.SM ID\*S.
.PP
Each user is also a member of a group.
The group is identified by a positive integer called the real group
.SM ID\*S.
.PP
An active process has a real user
.SM ID
and real group
.SM ID
that are set to the real user
.SM ID
and real group
.SM ID\*S,
respectively, of the user responsible for the creation of the process.
.SS "Effective User \s-1ID\s+1 and Effective Group \s-1ID\s+1"
An active process has an effective user
.SM ID
and an effective group
.SM ID
that are used to determine file access permissions (see below).
The effective
user
.SM ID
and effective group
.SM ID
are equal to the process's real user
.SM ID
and real group
.SM ID
respectively, unless the process
or one of its ancestors evolved from a file that had the set-user-\s-1ID\s+1
bit or set-group
.SM ID
bit set; see
.IR exec\^ (2).
.SS Super-user
A process is recognized as a
.I super-user\^
process and is granted special privileges if its effective user
.SM ID
is 0.
.SS "Special Processes"
The processes with a process
.SM ID
of 0 and a process
.SM ID
of 1 are special processes and are referred to as
.IR proc0\^ " and " proc1 .
.PP
.I proc0\^
is the scheduler.
.I proc1\^
is the initialization process 
.RI ( init ).
.I proc1
is the ancestor of every other
process in the system and is used to control the process structure.
.SS "File Name"
Names consisting of 1 to 14 characters may be used to name an ordinary file,
special file or directory.
.PP
These characters may be selected from the set of all character values
excluding \e0 (null) and the
.SM ASCII
code for
.B /
(slash).
.PP
Note that it is generally unwise to use
.BR "*" ,
.BR "?" ,
.BR "[" ,
or
.B "]"
as part of file names because of the special meaning attached to these
characters by the shell.
See
.IR sh\^ (1).
Although permitted, it is advisable to avoid the use of unprintable
characters in file names.
.SS "Path Name and Path Prefix"
A path name is a null-terminated character string
starting with an optional slash
.RB ( / ),
followed by
zero or more directory names separated by slashes, optionally followed
by a file name.
.PP
More precisely, a path name is a null-terminated character string
constructed as follows:
.PP
.RS .3i
<path-name>::=<file-name>\^\^|\^\^<path-prefix><file-name>\^|\^\^/
.br
<path-prefix>::=<rtprefix>\^\^|\^\^/<rtprefix>
.br
<rtprefix>::=<dirname>/\^\^|\^\^<rtprefix><dirname>/
.RE
.PP
where <file-name> is a string of 1 to 14
characters other than the
.SM ASCII
slash and null, and
<dirname> is a string of 1 to 14 characters
(other than the
.SM ASCII
slash and null)
that names a directory.
.PP
If a path name begins with a slash, the path search begins at the
.I root\^
directory.
Otherwise, the search begins from the current working directory.
.PP
A slash by itself names the root directory.
.PP
Unless specifically stated otherwise,
the null path name is treated as if it named
a non-existent file.
.SS Directory.
.PP
Directory entries are called links.
By convention, a directory contains at least two links,
.B  .
and
.BR .. ,
referred to as
.I dot\^
and
.I dot-dot\^
respectively.
Dot refers to the directory itself and dot-dot refers to its parent
directory.
.SS "Root Directory and Current Working Directory."
Each process has associated with it a concept of a root directory and
a current working directory for the purpose of resolving path name searches.
A process's root directory need not be the root directory of the root
file system.
.SS "File Access Permissions."
.PP
Read, write, and execute/search permissions on a file are
granted to a process if one or more of the following is true:
.RS .3i
.PP
The process's effective user
.SM ID
is super-user.
.PP
The process's effective user
.SM ID
matches the user
.SM ID
of the owner of the file
and the appropriate access bit of the
``owner'' portion (0700) of the file mode is set.
.PP
The process's effective user
.SM ID
does not match the user
.SM ID
of the owner of the file,
and the process's effective group
.SM ID
matches the group of the file and
the appropriate access bit of the ``group'' portion
(070) of the file mode is set.
.PP
The process's effective user
.SM ID
does not match the user
.SM ID
of the owner of the file,
and the process's effective group
.SM ID
does not match the group
.SM ID
of the file,
and the appropriate access bit of the ``other'' portion (07) of the
file mode is set.
.RE
.PP
Otherwise, the corresponding permissions are denied.
.SS "Message Queue Identifier"
A message queue identifier (\f2msqid\fP) is a unique positive integer
created by a
.IR msgget\^ (2)
system call.
Each \f2msqid\fP has a message queue and a data structure associated with it.
The data structure is referred to as
.I msqid_ds\^
and contains the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'ipc_perm msg_perm\ \ 'u
.nf
struct	ipc_perm msg_perm;	/\(** operation permission struct \(**/
ushort	msg_qnum;	/\(** number of msgs on q \(**/
ushort	msg_qbytes;	/\(** max number of bytes on q \(**/
ushort	msg_lspid;	/\(** pid of last msgsnd operation \(**/
ushort	msg_lrpid;	/\(** pid of last msgrcv operation \(**/
time_t	msg_stime;	/\(** last msgsnd time \(**/
time_t	msg_rtime;	/\(** last msgrcv time \(**/
time_t	msg_ctime;	/\(** last change time \(**/
		/\(** Times measured in secs since \(**/
		/\(** 00:00:00 \s-1GMT\s+1, Jan. 1, 1970 \(**/
.fi
.RE
.PP
.I msg_perm
is a \f2ipc_perm\fP structure that
specifies the message operation permission (see below).
This structure includes the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'semzcnt;\ \ \ \ 'u
.nf
ushort	cuid;	/\(** creator user id \(**/
ushort	cgid;	/\(** creator group id \(**/
ushort	uid;	/\(** user id \(**/
ushort	gid;	/\(** group id \(**/
ushort	mode;	/\(** r/w permission \(**/
.fi
.RE
.PP
.I msg_qnum
is the number of messages currently on the queue.
.I msg_qbytes
is the maximum number of bytes allowed on the queue.
.I msg_lspid
is the process id of the last process that performed a
.I msgsnd\^ 
operation.
.I msg_lrpid
is the process id of the last process that performed a
.I msgrcv\^
operation.
.I msg_stime
is the time of the last
.I msgsnd\^
operation,
.I msg_rtime
is the time of the last
.I msgrcv\^
operation, and
.I msg_ctime
is the time of the last
.IR msgctl\^ (2)
operation that changed a member of the above structure.
.SS "Message Operation Permissions"
In the
.IR msgop\^ (2)
and 
.IR msgctl\^ (2)
system call descriptions, the permission required
for an operation is given as ``{token}'', where ``token'' is the type
of permission needed interpreted as follows:
.PP
.RS
.PD 0
.TP \w'00400\ \ \ \ 'u
00400
Read by user
.TP
00200
Write by user
.TP
00060
Read, Write by group
.TP
00006
Read, Write by others
.RE
.PD
.PP
Read and Write permissions on a \f2msqid\fP are
granted to a process if one or more of the following is true:
.RS .3i
.PP
The process's effective user
.SM ID
is super-user.
.PP
The process's effective user
.SM ID
matches
.I msg_perm.[c]uid
in the data structure associated with
.I msqid\^
and the appropriate bit of the
``user'' portion (0600) of
.I msg_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I msg_perm.[c]uid
and the process's effective group
.SM ID
matches
.I msg_perm.[c]gid
and the appropriate bit of the ``group'' portion
(060) of
.I msg_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I msg_perm.[c]uid
and the process's effective group
.SM ID
does not match
.I msg_perm.[c]gid
and the appropriate bit of the ``other'' portion (06) of
.I msg_perm.mode
is set.
.RE
.PP
Otherwise, the corresponding permissions are denied.
.SS "Semaphore Identifier"
A semaphore identifier (\f2semid\f1) is a unique positive integer created by a
.IR semget\^ (2)
system call.
Each \f2semid\f1 has a set of semaphores and a data structure associated
with it.
The data structure is referred to as
.I semid_ds\^
and contains the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'ipc_perm msg_perm\ \ 'u
.nf
struct	ipc_perm sem_perm;	/\(** operation permission struct \(**/
ushort	sem_nsems;	/\(** number of sems in set \(**/
time_t	sem_otime;	/\(** last operation time \(**/
time_t	sem_ctime;	/\(** last change time \(**/
		/\(** Times measured in secs since \(**/
		/\(** 00:00:00 \s-1GMT\s+1, Jan. 1, 1970 \(**/
.fi
.RE
.PP
.I sem_perm
is a \f2ipc_perm\fP structure that
specifies the semaphore operation permission (see below).
This structure includes the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'semzcnt;\ \ \ \ 'u
.nf
ushort	cuid;	/\(** creator user id \(**/
ushort	cgid;	/\(** creator group id \(**/
ushort	uid;	/\(** user id \(**/
ushort	gid;	/\(** group id \(**/
ushort	mode;	/\(** r/a permission \(**/
.fi
.RE
.PP
The value of
.I sem_nsems
is equal to the number of semaphores in the set.
Each semaphore in the set is referenced by a positive integer
referred to as a
.IR sem_num .
\f2sem_num\f1 values run sequentially from 0 to the value of \f2sem_nsems\f1 minus 1.
.I sem_otime
is the time of the last
.IR semop\^ (2)
operation, and
.I sem_ctime
is the time of the last
.IR semctl\^ (2)
operation that changed a member of the above structure.
.PP
A semaphore is a data structure that contains the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'semzcnt;\ \ \ \ 'u
.nf
ushort	semval;	/\(** semaphore value \(**/
short	sempid;	/\(** pid of last operation  \(**/
ushort	semncnt;	/\(** # awaiting semval > cval \(**/
ushort	semzcnt;	/\(** # awaiting semval = 0 \(**/
.fi
.RE
.PP
.I semval
is a non-negative integer.
.I sempid
is equal to the process
.SM ID
of the last process that performed a semaphore operation on this semaphore.
.I semncnt
is a count of the number of processes that are currently suspended
awaiting this semaphore's \f2semval\f1 to become greater than its current
value.
.I semzcnt
is a count of the number of processes that are currently suspended
awaiting this semaphore's \f2semval\f1 to become zero.
.SS "Semaphore Operation Permissions"
In the
.IR semop\^ (2)
and 
.IR semctl\^ (2)
system call descriptions, the permission required
for an operation is given as ``{token}'', where ``token'' is the type
of permission needed interpreted as follows:
.PP
.RS
.PD 0
.TP \w'00400\ \ \ \ 'u
00400
Read by user
.TP
00200
Alter by user
.TP
00060
Read, Alter by group
.TP
00006
Read, Alter by others
.RE
.PD
.PP
Read and Alter permissions on a \f2semid\f1 are
granted to a process if one or more of the following is true:
.RS .3i
.PP
The process's effective user
.SM ID
is super-user.
.PP
The process's effective user
.SM ID
matches
.I sem_perm.[c]uid
in the data structure associated with
.I semid\^
and the appropriate bit of the
``user'' portion (0600) of
.I sem_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I sem_perm.[c]uid
and the process's effective group
.SM ID
matches
.I sem_perm.[c]gid
and the appropriate bit of the ``group'' portion
(060) of
.I sem_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I sem_perm.[c]uid
and the process's effective group
.SM ID
does not match
.I sem_perm.[c]gid
and the appropriate bit of the ``other'' portion (06) of
.I sem_perm.mode
is set.
.RE
.PP
Otherwise, the corresponding permissions are denied.
.SS "Shared Memory Identifier"
A shared memory identifier (\f2shmid\f1) is a unique positive integer
created by a
.IR shmget\^ (2)
system call.
Each \f2shmid\f1 has a segment of memory (referred to as a shared memory
segment)
and a data structure associated with it.
The data structure is referred to as
.I shmid_ds\^
and contains the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'ipc_perm msg_perm\ \ 'u
.nf
struct	ipc_perm shm_perm;	/\(** operation permission struct \(**/
int	shm_segsz;	/\(** size of segment \(**/
ushort	shm_cpid;	/\(** creator pid \(**/
ushort	shm_lpid;	/\(** pid of last operation \(**/
short	shm_nattch;	/\(** number of current attaches \(**/
time_t	shm_atime;	/\(** last attach time \(**/
time_t	shm_dtime;	/\(** last detach time \(**/
time_t	shm_ctime;	/\(** last change time \(**/
		/\(** Times measured in secs since \(**/
		/\(** 00:00:00 \s-1GMT\s+1, Jan. 1, 1970 \(**/
.fi
.RE
.PP
.I shm_perm
is a \f2ipc_perm\f1 structure that
specifies the shared memory operation permission (see below).
This structure includes the following members:
.PP
.RS .3i
.ta \w'ushort\ \ 'u +\w'semzcnt;\ \ \ \ 'u
.nf
ushort	cuid;	/\(** creator user id \(**/
ushort	cgid;	/\(** creator group id \(**/
ushort	uid;	/\(** user id \(**/
ushort	gid;	/\(** group id \(**/
ushort	mode;	/\(** r/w permission \(**/
.fi
.RE
.PP
.I shm_segsz
specifies the size of the shared memory segment.
.I shm_cpid
is the process id of the process that created the shared memory identifier.
.I shm_lpid
is the process id of the last process that performed a
.IR shmop\^ (2)
operation.
.I shm_nattch
is the number of processes that currently have this segment attached.
.I shm_atime
is the time of the last
.I shmat\^
operation,
.I shm_dtime
is the time of the last
.I shmdt\^
operation,
and
.I shm_ctime
is the time of the last
.IR shmctl\^ (2)
operation that changed one of the members of the above structure.
.SS "Shared Memory Operation Permissions"
In the
.IR shmop\^ (2)
and 
.IR shmctl\^ (2)
system call descriptions, the permission required
for an operation is given as ``{token}'', where ``token'' is the type
of permission needed interpreted as follows:
.PP
.RS
.PD 0
.TP \w'00400\ \ \ \ 'u
00400
Read by user
.TP
00200
Write by user
.TP
00060
Read, Write by group
.TP
00006
Read, Write by others
.RE
.PD
.PP
Read and Write permissions on a \f2shmid\f1 are
granted to a process if one or more of the following is true:
.RS .3i
.PP
The process's effective user
.SM ID
is super-user.
.PP
The process's effective user
.SM ID
matches
.I shm_perm.[c]uid
in the data structure associated with
.I shmid\^
and the appropriate bit of the
``user'' portion (0600) of
.I shm_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I shm_perm.[c]uid
and the process's effective group
.SM ID
matches
.I shm_perm.[c]gid
and the appropriate bit of the ``group'' portion
(060) of
.I shm_perm.mode
is set.
.PP
The process's effective user
.SM ID
does not match
.I shm_perm.[c]uid
and the process's effective group
.SM ID
does not match
.I shm_perm.[c]gid
and the appropriate bit of the ``other'' portion (06) of
.I shm_perm.mode
is set.
.RE
.PP
Otherwise, the corresponding permissions are denied.
.SH SEE ALSO
intro(3).
.\"	@(#)intro.2	5.2 of 3/8/84
shm_perm.[c]uid
and the process's effective group
.SM ID
matches
.I shm_perm.[c]gid
and the appropriate bit of the ``group'' portion
(u_man/man2/signal.2                                                                                    664    1776     311        21214  3525525756   7513                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH SIGNAL 2
.SH NAME
signal \- specify what to do upon receipt of a signal
.SH SYNOPSIS
.B #include <sys/signal.h>
.PP
.B int (\(**signal (sig, func))(\^\^)
.br
.B int sig;
.br
.B int (\(**func)(\^\^);
.SH DESCRIPTION
.I Signal\^
allows the calling process to choose one of three ways
in which it is possible to handle the receipt of a specific signal.
.I Sig\^
specifies the signal and
.I func\^
specifies the choice.
.PP
.I Sig\^
can be assigned any one of the following except
.BR \s-1SIGKILL\s+1 : 
.TS
center;
lB l l.
\s-1SIGHUP\s+1	\01	hangup
\s-1SIGINT\s+1	\02	interrupt
\s-1SIGQUIT\s+1	\03*	quit
\s-1SIGILL\s+1	\04*	illegal instruction (not reset when caught)
\s-1SIGTRAP\s+1	\05*	trace trap (not reset when caught)
\s-1SIGIOT\s+1	\06*	\s-1IOT\s0 instruction
\s-1SIGEMT\s+1	\07*	\s-1EMT\s0 instruction
\s-1SIGFPE\s+1	\08*	floating point exception
\s-1SIGKILL\s+1	\09	kill (cannot be caught or ignored)
\s-1SIGBUS\s+1	10*	bus error
\s-1SIGSEGV\s+1	11*	segmentation violation
\s-1SIGSYS\s+1	12*	bad argument to system call
\s-1SIGPIPE\s+1	13	write on a pipe with no one to read it
\s-1SIGALRM\s+1	14	alarm clock
\s-1SIGTERM\s+1	15	software termination signal
\s-1SIGUSR1\s+1	16	user defined signal 1
\s-1SIGUSR2\s+1	17	user defined signal 2
\s-1SIGCLD\s+1	18	death of a child (see \f2\s-1WARNING\s+1\f1 below)
\s-1SIGPWR\s+1	19	power fail (see \f2\s-1WARNING\s+1\f1 below)
.sp .5
.T&
l s s.
See below for the significance of the asterisk ( \(** ) in the above list.
.TE
.PP
.I Func\^
is assigned one of three values:
.BR \s-1SIG_DFL\s+1 ,
.BR \s-1SIG_IGN\s+1 ,
or a
.IR "function address" .
The actions prescribed by these values of are as follows: 
.PP
.SM
.B SIG_DFL
\&\-  terminate process upon receipt of a signal
.RS .3i
Upon receipt of the signal
.IR sig ,
the receiving process is to be terminated with the following consequences:
.RS .3i
.PP
All of the receiving process's open file descriptors will be closed.
.PP
If the parent process of the receiving process is executing a
.IR wait ,
it will be notified of the
termination of the receiving process and the terminating signal's number
will be made available to the parent process; see
.IR wait (2).
.PP
If the parent process of the receiving process is not executing a
.IR wait ,
the receiving process will be transformed into a zombie process (see
.IR exit (2)
for definition of zombie process).
.PP
The parent process
.SM ID
of each of the receiving process's existing
child processes and zombie processes will be set to 1.
This means the initialization process (see
.IR intro (2))
inherits each of these processes.
.PP
Each attached shared memory segment is detached and the value of
.B shm_nattach
in the data structure associated with its shared memory identifier
is decremented by 1.
.PP
For each semaphore for which the receiving process has set a semadj value (see
.IR semop (2)),
that semadj value is added to the semval of the specified semaphore.
.PP
If the process has a process, text, or data lock, an
.I unlock\^
is performed (see
.IR plock (2)).
.PP
An accounting record will be written on the accounting file if the system's 
accounting routine is enabled; see
.IR acct (2).
.PP
If the receiving process's process
.SM ID\*S,
tty group
.SM ID\*S,
and process group
.SM ID
are equal,
the signal
.B
.SM SIGHUP
will be sent to all of the processes that have a process group
.SM ID
equal to the process group
.SM ID
of the receiving process.
.PP
A `core image' will be made in
the current working directory of the receiving
process if
.I sig\^
is one for which an asterisk appears in the above list
.I and
the following conditions are met:
.RS .3i
.PP
The effective user
.SM ID
and the real user
.SM ID
of the receiving 
process are equal.
.PP
An ordinary file named
.B core
exists and is writable or can be created.
If the file must be created, it will have the following properties:
.RS .3i
.PP
a mode of 0666 modified by the file creation mask
.RI (see  " umask" (2))
.PP
a file owner
.SM ID
that is the same as the effective user
.SM ID
of the receiving process
.PP
a file group
.SM ID
that is the same as the effective group
.SM ID
of the receiving process
.RE
.RE
.RE
.RE
.PP
.SM
.B SIG_IGN
\&\-  ignore signal
.RS .3i
The signal 
.I sig\^
is to be ignored.
.PP
Note: the signal
.B
.SM SIGKILL
cannot be ignored.
.RE
.PP
.I function address\^
\&\-  catch signal
.RS .3i
Upon receipt of the signal
.IR sig ,
the receiving process is to execute the signal-catching function pointed to by
.IR func .
The signal number
.I sig\^
will be passed as the only argument to the signal-catching function.
Before entering the signal-catching function, the value of
.I func\^
for the caught signal will be set to
.SM
.B SIG_DFL
unless the signal is
.SM
.BR SIGILL ,
.SM
.BR SIGTRAP ", or"
.SM
.BR SIGPWR .
.PP
Upon return from the signal-catching function, the receiving process will
resume execution at the point it was interrupted.
.PP
When a signal that is to be caught occurs during a 
.IR read ", a"  " write" ,
.RI an " open" ", or an " ioctl\^
system call on a slow device (like a terminal; but not a file), during a
.IR pause
system call, or during a
.I wait\^
system call that does not return immediately due to the existence of a
previously stopped or zombie
process, the signal-catching function will be executed and then the
interrupted system call will return a \-1 to the calling process with
.I errno\^
set to
.SM EINTR\*S.
.PP
Note: the signal
.B
.SM SIGKILL
cannot be caught.
.RE
.PP
A call to
.I signal\^
cancels a pending signal
.I sig\^
except for a pending
.B \s-1SIGKILL\s+1
signal.
.PP
.I Signal\^
will fail if one or more of the following are true:
.IP "" .3i
.I Sig\^
is an illegal signal number, including
.SM
.BR SIGKILL .
.SM
\%[EINVAL]
.IP
.I Func\^
points to an illegal address.
.SM
\%[EFAULT]
.SH RETURN VALUE
Upon successful completion,
.I signal\^
returns the previous value of
.I func\^
for the specified signal
.IR sig .
Otherwise, a value of \-1 is returned and
.I errno\^
is set to indicate the error.
.SH SEE ALSO
kill(1), kill(2), pause(2), ptrace(2), wait(2), setjmp(3C).
.SH WARNING
Two other signals that behave differently than the signals described above
exist in this release of the system; they are:
.PP
.RS
.nf
.ta \w'SIGMMMM 'u +\w'15\(**  'u
.BR \s-1SIGCLD\s+1 "	18	death of a child (reset when caught)"
.BR \s-1SIGPWR\s+1 "	19	power fail (not reset when caught)"
.fi
.RE
.PP
There is no guarantee that, in future releases of the
.SM UNIX
System,
these signals will continue to behave as described below;
they are included only for compatibility with other versions of the
.SM UNIX
System.
Their use in new programs is strongly discouraged.
.PP
For these signals,
.I func\^
is assigned one of three values:
.BR \s-1SIG_DFL\s+1 ,
.BR \s-1SIG_IGN\s+1 ,
or a
.IR "function address"  .
The actions prescribed by these values of are as follows: 
.PP
.SM
.B SIG_DFL
- ignore signal
.RS .3i
The signal is to be ignored.
.RE
.PP
.SM
.B SIG_IGN
- ignore signal
.RS .3i
The signal is to be ignored.
Also, if
.I sig\^
is
.SM
.BR SIGCLD ,
the calling process's child processes will not create zombie processes when
they terminate; see
.IR exit (2).
.RE
.PP
.I function address\^
- catch signal
.RS .3i
If the signal is
.SM
.BR SIGPWR ,
the action to be taken is the same as that described above for
.I func\^
equal to
.IR "function address" .
The same is true if the signal is
.SM
.B SIGCLD
except, that while the process is executing the signal-catching function
any received
.SM
.B SIGCLD
signals will be queued and the signal-catching function will be continually
reentered until the queue is empty.
.RE
.PP
The
.SM
.B SIGCLD
affects two other system calls 
.RI ( wait "(2), and " exit (2))
in the following ways:
.ta w'\f2wait\f1 \ \ 'u
.TP 
.I wait\^
If the
.I func\^
value of
.SM
.B SIGCLD
is set to
.SM
.B SIG_IGN
and a
.I wait\^
is executed, the
.I wait\^
will block until all of the calling process's child processes terminate;
it will then return a value of \-1 with
.I errno\^
set to
.SM ECHILD.
.ta w'\f2wait\f1 \ \ 'u
.TP 
.I exit\^
If in the exiting process's parent process the
.I func\^
value of
.SM
.B SIGCLD
is set to
.SM
.BR SIG_IGN ,
the exiting process will not create a zombie process.
.PP
When processing a pipeline, the shell
makes the last process in the pipeline the parent of the proceeding processes.
A process that may be piped into in this manner (and thus become the parent
of other processes) should take care not to set
.SM
.B SIGCLD
to be caught.
.SH BUGS
.PP
If a repeated signal arrives before the last one can be reset, there
is no chance to catch it.
.PP
The type specification of the routine and its
.I func
argument are problematical.
.PP
The symbols
.I sighnd
and
.I sigtrap
are globally defined symbols used by 
.IR signal (2)
and are reserved words.
.DT
.\"	@(#)signal.2	5.1 of 11/16/83
processes.
A process that may be piped into in this manner (and thus become the parent
of other processes) should take care not to set
.SM
.B SIGCLD
to be caught.
.SH BUGS
.PP
If a repeated signal arrives before the last one can be reset, there
is no chance to catch it.
.PP
The type specification of the routine and its
.I func
argument are problematical.
.PP
The symbolsu_man/man2/symlink.2                                                                                   664    1776     311         2166  3525523531   7676                                                                                                                                                                                                                                                                                                                                                                      .TH SYMLINK 2 
.UC 4
.SH NAME
symlink \- make symbolic link to a file
.SH SYNOPSIS
.B symlink 
(name1, name2)
.PP
.B char 
*name1, *name2;
.SH DESCRIPTION
A symbolic link
.I name2
is created to
.IR name1
(
.I name2 
is the name of the
file created, 
.I name1 
is the string
used in creating the symbolic link).
Either name may be an arbitrary path name; the files need not
be on the same file system.
.SH "RETURN VALUE
Upon successful completion, a zero value is returned.
If an error occurs, the error code is stored in \fIerrno\fP
and a \-1 value is returned.
.SH "ERRORS
The symbolic link is made unless on or more of the
following are true:
.TP 15
[ENOTDIR]
A component of the \fIname2\fP prefix is not a directory.
.TP 15
[EEXIST]
\fIName2\fP already exists.
.TP 15
[EACCES]
A component of the \fIname2\fP path prefix denies search permission.
.TP 15
[EROFS]
The file \fIname2\fP would reside on a read-only file system.
.TP 15
[EFAULT]
.I Name1
or
.I name2
points outside the process's allocated address space.
.TP 15
[ELOOP]
Too may symbolic links were encountered in translating the pathname.
.SH "SEE ALSO"
link(2), ln(1), unlink(2)
wing are true:
.TP 15
[ENOTDIR]
A component of the \fIname2\fP prefix is not a directory.
.TP 15
[EEXIST]
\fIName2\fP already exists.
.TP 15
[EACCES]
A component of the \fIname2\fP path prefix denies search permission.
.TP 15
[EROFS]
The file \fIname2\fP would reside on a read-only file system.
.TP 15
[EFAULT]
.I Name1
or
.I name2
points outside the process's allocated address space.
.TP 15
u_man/man3/byteorder.3n                                                                                664    1776     311         1527  3534706237  10375                                                                                                                                                                                                                                                                                                                                                                      .TH BYTEORDER 3N
.SH NAME
htonl, htons, ntohl, ntohs \- convert values between host and network byte order
.SH SYNOPSIS
.nf
.B #include <sys/types.h>
.B #include <net/in.h>
.PP
.B netlong = htonl(hostlong);
.B u_long netlong, hostlong;
.PP
.B netshort = htons(hostshort);
.B u_short netshort, hostshort;
.PP
.B hostlong = ntohl(netlong);
.B u_long hostlong, netlong;
.PP
.B hostshort = ntohs(netshort);
.B u_short hostshort, netshort;
.fi
.SH DESCRIPTION
These routines convert 16- and 32-bit quantities between network
byte order and host byte order.  On machines where the native byte
order is the same as network byte order,
these routines are null macros in the include file
.RI < net/in.h >.
.PP
These routines are frequently used to convert Internet
addresses and ports returned by
.IR rhost (3n)
to native byte order.
.SH "SEE ALSO"
.IR rhost (3n)
long hostlong, netlong;
.PP
.B hostshort = ntohs(netshort);
.B u_short hostshort, netshort;
.fi
.SH DESCRIPTION
These routines convert 16- and 32-bit quantities between u_man/man3/fopen.3s                                                                                    664    1776     311         5705  3536704477   7522                                                                                                                                                                                                                                                                                                                                                                      .TH FOPEN 3S 
.SH NAME
fopen, freopen, fdopen \- open a stream
.SH SYNOPSIS
.B #include <stdio.h>
.PP
.SM
.B FILE
.B \(**fopen (filename, type)
.br
.B char \(**filename, \(**type;
.PP
.SM
.B FILE
.B \(**freopen (filename, type, stream)
.br
.B char \(**filename, \(**type;
.br
.SM
.B FILE
.B \(**stream;
.PP
.SM
.B FILE
.B \(**fdopen (fildes, type)
.br
.B int fildes;
.br
.B char \(**type;
.SH DESCRIPTION
.I fopen\^
opens the file named by
.I filename\^
and associates a
.I stream\^
with it.
.I fopen\^
returns a pointer to the
.SM FILE
structure associated with
the
.IR stream .
.PP
.I filename\^
points to a character string that contains
the name of the file to be opened.
.PP
.I type\^
is a character string having one of the following values:
.PP
.RS .3i
.ta \w'"w+"\ \ \ 'u
.nf
\f3r\f1	open for reading
\f3w\f1	truncate or create for writing
\f3a\f1	append; open for writing at end of file, or create for writing
\f3r+\f1	open for update (reading and writing)
\f3w+\f1	truncate or create for update
\f3a+\f1	append; open or create for update at end-of-file
.fi
.RE
.PP
.I freopen\^
substitutes the named file in place
of the open
.IR stream .
The original
.I stream\^
is closed,
regardless of whether the open
ultimately succeeds.
.I freopen\^
returns a pointer to the
.SM FILE
structure associated with
.IR stream .
.PP
.I freopen\^
is typically used to attach the preopened
.I streams\^
associated with
.IR stdin ,
.I stdout
and
.IR stderr
to other files.
.PP
.I fdopen\^
associates a
.I stream\^
with a file descriptor obtained from
.IR open ,
.IR dup ,
.IR creat ,
or
.IR pipe\^ (2),
which will open files but not return pointers to a
.SM FILE 
structure 
.I stream\^
which are necessary input for many of the section 3S library routines.
The
.I type\^
of
.I stream\^
must agree with the mode of the open file.
.PP
When a file is opened for update, both input and output may be
done on the resulting
.IR stream .
However, output may not be directly followed by input without an
intervening
.I fseek\^
or
.IR rewind ,
and input may not be directly followed by output without an
intervening
.IR fseek ,
.IR rewind ,
or an input operation which encounters end-of-file.
.PP
When a file is opened for append (i.e., when
.I type\^
is `a' or `a+'), it is impossible to overwrite information
already in the file.
.I fseek\^
may be used to reposition the file pointer to any position
in the file, but when output is written
to the file the current file pointer is disregarded.
All output is written at the end of the file and causes the file
pointer to be repositioned at the end of the output.  If two separate
processes open the same file for append, each process may write freely
to the file without fear of destroying output being written by the
other.  The output from the two processes will be intermixed in the
file in the order in which it is written.
.SH "SEE ALSO"
open(2),
fclose(3S).
.SH DIAGNOSTICS
.I fopen\^
and 
.I freopen\^
return a
.SM NULL
pointer on failure.
.\"	@(#)fopen.3s	5.1 of 10/25/83
t the end of the file and causes the file
pointer to be repu_man/man3/intro.3                                                                                     664    1776     311         6572  3540734144   7353                                                                                                                                                                                                                                                                                                                                                                      .TH INTRO 3
.SH NAME
intro \- introduction to subroutines and libraries
.SH SYNOPSIS
.B #include <stdio.h>
.PP
.B #include <math.h>
.PP
.B #include <device.h>
.PP
.B #include <get.h>
.PP
.B #include <gl.h>
.SH DESCRIPTION
This section describes functions found
in various libraries, other than those functions
that directly invoke U\s-2NIX\s+2
system primitives,
which are described in Section\ 2 of this volume.
Certain major collections are identified by a
letter after the section number:
.PP
.PD 0
.TP \w'(3M)\ \ 'u
(3C)
These functions, together with those of Section\ 2 and those
marked (3S), constitute the Standard C Library
.IR libc ,
which is automatically loaded by the C compiler,
.IR cc\^ (1).
The link editor
.IR ld\^ (1)
searches this library under the
.B \-lc
option.
Declarations for some of these functions may be obtained
from
.I #include
files indicated on the appropriate pages.
.TP
(3G)
These functions constitute the IRIS Graphics Library which are documented
in the 
.IR "IRIS User's Guide" .
If the 
.B \-Zg 
flag is specified, the C compiler searches this library.
Declarations for these functions may be obtained from the 
.I #include
file
.IR <gl.h> ,
.IR <device.h> ,
and
.I <get.h>
define other constants used by the Graphics Library.
.TP
(3M)
These functions constitute the Math Library,
.IR libm .
They are not automatically loaded by the C compiler,
.IR cc ;
however, the link editor searches this library under the
.B \-lm
option.
Declarations for these functions may be obtained from
the
.I #include
file
.IR <math.h> .
.TP
(3N)
These functions constitute the internet network library.
.TP
(3S)
These functions constitute the
``standard
.SM I/O
package''
(see
.IR stdio\^ (3S)).
These functions are in the library
.IR libc ,
already mentioned.
Declarations for these functions may be obtained from
the
.I #include
file
.IR <stdio.h> .
.TP
(3X)
Various
specialized libraries.
The files in which these libraries are found are given
on the appropriate pages.
.SH DEFINITIONS
A
.I character\^
is any bit pattern able to fit into a byte on the machine.
The
.I null character\^
is a character with value 0,
represented in the C language as '\e0'.
A
.I character array\^
is a sequence of characters.
A
.I "null-terminated character array\^"
is a sequence of
characters, the last of which is the
.IR "null character" .
A
.I string\^
is a designation for a
.IR "null-terminated character array" .
The
.I "null string"
is a character array containing only the null character.
A
.SM
NULL
pointer is the value that is obtained by casting
.B 0
into a pointer.
The C language guarantees that this value will not match
that of any legitimate pointer, so many functions that
return pointers return it to indicate an error.
.SM
NULL
is defined as
.B 0
in
.IR <stdio.h> ;
the user can include his own definition if he is
not using
.IR <stdio.h> .
.SH FILES
/lib/libc.a
.br
/lib/libm.a
.br
/usr/lib/libgl.a
.SH SEE ALSO
\f2IRIS User's Guide\fP
.br
\f2IRIS Workstation Guide\fP
.br
ar(1),
cc(1),
ld(1),
nm(1),
intro(2),
stdio(3S).
.SH DIAGNOSTICS
Functions in the Math Library (3M) may return
the conventional values
.B 0
or
.SM
.B HUGE
(the largest single-precision floating-point number)
when the function is undefined for the
given arguments or when the value is not representable.
In these cases, the external variable
.I errno\^
(see
.IR intro\^ (2))
is set to the value
.SM EDOM
or
.SM ERANGE\*S.
.\"	@(#)intro.3	5.1 of 11/15/83
2IRIS User's Guide\fP
.br
\f2IRIS Workstation Guide\fP
.br
ar(1),
cc(1),
ld(1),
nm(1),
intro(2),
stdio(3S).
.SH DIAGNOSTICS
Functions u_man/man3/socket.3n                                                                                   664    1776     311        12470  3536651751   7707                                                                                                                                                                                                                                                                                                                                                                      .TH SOCKET 3N
.SH NAME
socket \- create an endpoint for communication
.SH SYNOPSIS
.B #include <sys/socket.h>
.sp
.B s = socket(type, pf, addr, options);
.br
.B int s, type;
.br
.B struct sockproto *pf;
.br
.B struct sockaddr *addr;
.br
.B int options;
.SH DESCRIPTION
.I Socket
creates a communication endpoint and returns a descriptor,
much like a file descriptor.  The socket has a             
.I type
which defines the semantics for communication.  Currently
defined types are: SOCK_STREAM, for sequenced, reliable,
two-way connection based streams with an out-of-band mechanism;
SOCK_DGRAM, for datagrams, connectionless, unreliable messages of
a fixed (typically small) maximum length; SOCK_RAW, for
access to internal network interfaces.
SOCK_RAW is only accessible by the super-user and
is not described here.
.PP
.I pf
causes a specific protocol to be used with the socket.
(Currently only one protocol supports each socket
type.)
.PP
The
.I addr
parameter specifies the socket address.  A socket
address is a discriminated union 16 bytes long.
The first two bytes indicate the format of remaining bytes.
.PP
The only variant to this rule is an Internet address (sockaddr_in).
The first field of this variable type is AF_INET (this address is 
part of the Internet Address Family) which is defined 
in <
.IR sys/socket.h >.
.PP
The second and third fields are a 16-bit socket number
(see <
.IR net/in.h > 
for lists of well-known sockets) and a 32-bit
Internet host address.
The socket number and host address are in network byte order.
.PP
If no socket address is specified, the system assigns 
one.  It does this at connection
time to simplify the routing decisions required of the connected
socket.
If the socket number is omitted,
a unique socket number is supplied.
The socket numbers 0 through IPPORT_RESERVED-1
are reserved for the super-user.
.PP
The procedure
.IR rhost (3N)
may be used to convert host names to Internet addresses.
.PP
Sockets of type SOCK_STREAM are full-duplex byte streams, similar
to two-way pipes.  Typically a stream is created via  
.I socket
and connected to another socket via a call to
.I connect
or
.I accept.
Then a sequence of
.I read
and
.I write
calls exchanges data.  Finally,
.IR close (2)
terminates the connection.
.PP
A typical sequence is
.sp
.RS
.RS
.RS
CLIENT         SERVER
.sp
socket()       socket()
.br
connect()      accept()
.br
write()        read()
.br
read()         write()
   .             .
.br
   .             .
.br
close()
.RE
.RE
.RE
.PP
Out-of-band data may also be transmitted as described below.
.PP
Sockets of the type SOCK_STREAM insure that data
is not lost or duplicated.  If a piece of data (for which the
peer protocol has buffer space) cannot be successfully transmitted
within a reasonable length of time (1 minute), then
the connection is considered broken and calls indicate an error with
\-1 returns.  ETIMEDOUT is the specific code in the global variable errno.
.PP
The protocols optionally keep sockets ``warm'' by forcing transmissions
roughly every minute in the absence of other activity.
An error is flagged if no response can be elicited on an otherwise
idle connection for an extended period (5 minutes).
A SIGPIPE signal is raised if a process \f2write\fPs on a broken
stream.  This causes naive processes, which do not handle the signal,
to exit.
.PP
SOCK_DGRAM sockets send datagrams to correspondents
named in
.IR send (3N)
calls.  It is also possible to receive datagrams at such a socket
with
.IR receive (3N).
.PP
A typical sequence is
.sp
.RS
.RS
.RS
SENDER        RECEIVER
.sp
.br
s=socket()    s=socket()
.br
    .             .
.br
    .             .
.br
send(s)       receive(f)
.br
    .             .
.br
    .             .
.br
receive(f)    send(s)
.RE
.RE
.RE
.PP
.I connect
may be used with datagram sockets
to fix the receipient/sender for furture communication.
Once a datagram has been connected,
.I read
may be used in place of
.I send,
and
.I write
may be used in place of
.I receive.
.PP
The subroutine
.IR socketaddr(3N)
can be used to determine the address of a socket.
.PP
The socket options are OR-ed together in
.I options:
.TP 5
SO_ACCEPTCONN
must be used with SOCK_STREAM sockets 
which accept connections.  Only sockets which indicate SO_ACCEPTCONN
as a creation parameter may 
.IR accept (3N),
and such sockets may not 
.IR connect (3N).
.TP 5
SO_DONTLINGER
allows
.IR close (2)
operations on a socket to finish immediately.  Otherwise
the system will block a process waiting for data to drain
(or return EWOULDBLOCK if the socket is marked NONBLOCKING)
when a 
.I close 
is attempted.  See the SIOCSLINGER ioctl below also.
.TP 5
SO_KEEPALIVE
causes ``keep alive'' to be used to time-out dead connections.
If this option is not specified then timing out dead connections
is the responsibility of the user process.
.PP
General ioctl's which apply to sockets are:
.TP 5
SIOCDONE
indicates the user has finished receiving (if the integer parameter is 0),
sending (if the integer parameter is 1) or both (if the parameter is 2)
on the indicated socket.
This indicates an end-of-file in a SOCK_STREAM
if reading input.
.TP 5
SIOCSLINGER
sets the linger time in seconds. 
This is currently only partially implemented: linger time is either 0 or 
infinite
(if non-zero).
.TP 5
SIOCGLINGER
returns the current linger time.
.SH SEE ALSO
accept(3N), connect(3N), receive(3N), send(3N), socketaddr(3N), inet(7)
he user has finished receiving (if the integer parameter is 0),
sending (if the integer parameter is 1) or both (if the parameter is 2)
on the indicated socket.
This indicates an end-of-file in a SOCKu_man/man4/bellfs.4                                                                                    664    1776     311        14640  3536706070   7506                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH BELLFS 4
.SH NAME
Bell file system \- format of Bell file system volume
.SH SYNOPSIS
.B #include <sys/param.h>
.br
.B #include <sys/filsys.h>
.br
.SH DESCRIPTION
Every Bell file system
(formerly known as ``the''
U\s-2NIX\s+2
System V
file system)
storage volume
has a common format for certain vital information.
Every such volume is divided into a certain number
of 512 byte long sectors.
Sector 0 is unused and is available to contain
a bootstrap program or other information.
.PP
Sector 1 is the
.IR super-block .
The format of a super-block is:
.PP
.ps 10
.vs 12
.nf
/*
*	Structure of the super-block
*/
.fi
.TS
center;
l l l l.
struct	filsys{	\&	\&
\&	ushort	s_isize;	/* size in blocks of i-list */
\&	daddr_t	s_fsize;	/* size in blocks of entire volume */
\&	short	s_nfree;	/* number of addresses in s_free */
\&	daddr_t	s_free[NICFREE];	/* free block list */
\&	short	s_ninode;	/* number of i-nodes in s_inode */
\&	ino_t	s_inode[NICINOD];	/* free i-node list */
\&	char	s_flock;	/* lock during free list manipulation */
\&	char	s_ilock;	/* lock during i-list manipulation */
\&	char  	s_fmod; 	/* super block modified flag */
\&	char	s_ronly;	/* mounted read-only flag */
\&	time_t	s_time; 	/* last super block update */
\&	short	s_dinfo[4];	/* device information */
\&	daddr_t	s_tfree;	/* total free blocks*/
\&	ino_t	s_tinode;	/* total free inodes */
\&	char	s_fname[6];	/* file system name */
\&	char	s_fpack[6];	/* file system pack name */
\&	long	s_fill[14];	/* ADJUST to make sizeof filsys be 512 */
\&	ino_t	s_lasti;	/* start place for circular search */
\&	ino_t	s_nbehind;	/* est # free inodes before s_lasti */
\&	long	s_magic;	/* magic number to indicate new file system */
\&	long	s_type;	/* type of new file system */
};
.TE
.sp
.TS
center;
l l l l.
#define	FsMAGIC	0xfd187e20	/* s_magic number */

#define	Fs1b	1	/* 512 byte block */
#define	Fs2b	2	/* 1024 byte block */
#define	Fs4b	4	/* 2048 byte block */
.TE
.ps 12
.vs 14
.PP
.I s_type\^
indicates the file system type.
Currently,
two types of file systems are supported:
the original 512-byte oriented and the new improved 1024-byte oriented.
.I s_magic\^
is used to distinguish the original 512-byte oriented file systems
from the newer file systems.
If this field is not equal to the magic number,
.IR Fs\s-1MAGIC\s+1 ,
the type is assumed to be
.IR Fs1b ,
otherwise the
.I s_type\^
field is used.
In the following description, a block is then
determined by the type.
For the original 512-byte oriented file system, a block
is 512 bytes.
For the 1024-byte oriented file system, a block is 1024 bytes or
two sectors.
The operating system takes care of all conversions from
logical block numbers to physical sector numbers.
.PP
.I s_isize\^
is the address of the first data block after the i-list;
the i-list starts just after the super-block, namely in block 2;
thus the i-list is \f2s_isize\^\fP\-2 blocks long.
.I s_fsize\^
is the first block not potentially available for allocation
to a file.
These numbers are used by the system to
check for bad block numbers;
if an ``impossible'' block number is allocated from the free list
or is freed,
a diagnostic is written on the on-line console.
Moreover, the free array is cleared, so as to prevent further
allocation from a presumably corrupted free list.
.PP
The free list for each volume is maintained as
follows.
The
.I s_free\^
array contains, in
.IR s_free [1],
\&.\|.\|.,
.IR s_free [ s_nfree \-1],
up to 49 numbers of free blocks.
.IR s_free [0]
is the block number of the head
of a chain of blocks constituting the free list.
The first long in each free-chain block is the number
(up to 50) of free-block numbers listed in the
next 50 longs of this chain member.
The first of these 50 blocks is the link to the
next member of the chain.
To allocate a block:
decrement
.IR s_nfree ,
and the new block is
.IR s_free [ s_nfree ].
If the new block number is 0,
there are no blocks left, so give an error.
If
.I s_nfree\^
became 0,
read in the block named by the new block number,
replace
.I s_nfree\^
by its first word,
and copy the block numbers in the next 50 longs into the
.I s_free\^
array.
To free a block, check if
.I s_nfree\^
is 50; if so,
copy
.I s_nfree\^
and the
.I s_free\^
array into it,
write it out, and set
.I s_nfree\^
to 0.
In any event set
.IR s_free [ s_nfree ]
to the freed block's number and
increment
.IR s_nfree .
.PP
.I s_tfree\^
is the total free blocks available in the file system.
.PP
.I s_ninode\^
is the number of free i-numbers in the
.I s_inode\^
array.
To allocate an i-node:
if
.I s_ninode\^
is greater than 0,
decrement it and return
.IR s_inode [ s_ninode ].
If it was 0, read the i-list
and place the numbers of all free inodes
(up to 100) into the
.I s_inode\^
array,
then try again.
To free an i-node,
provided
.I s_ninode\^
is less than 100,
place its number into
.IR s_inode [ s_ninode ]
and increment
.IR s_ninode .
If
.I s_ninode\^
is already 100, do not bother to enter the freed i-node into any table.
This list of i-nodes is only to speed
up the allocation process; the information
as to whether the inode is really free
or not is maintained in the inode itself.
.PP
.I s_tinode\^
is the total free inodes available in the file system.
.PP
.I s_flock\^
and
.I s_ilock\^
are flags maintained in the core
copy of the file system
while it is mounted
and their values on disk are immaterial.
The value of
.I s_fmod\^
on disk is likewise immaterial;
it is used as a flag to indicate that the super-block has
changed and should be copied to
the disk during the next periodic update of file
system information.
.PP
.I s_ronly\^
is a read-only flag to indicate write-protection.
.PP
.I s_time\^
is the last time the super-block of the file system was changed,
and is
the number of seconds that have elapsed
since
00:00 Jan. 1, 1970 (\s-1GMT\s+1).
During a reboot, the
.I s_time\^
of the super-block for the root file system
is used to set the system's idea of the time.
.PP
.I s_fname\^
is the name of the file system and
.I s_fpack\^
is the name of the pack.
.PP
I-numbers begin at 1, and the storage for i-nodes
begins in block 2.
Also, i-nodes are 64 bytes long.
I-node 1 is reserved for future use.
I-node 2 is reserved for the root directory of the file
system, but no other i-number has a built-in
meaning.
Each i-node represents one file.
For the format of an inode and its flags, see
.IR inode (4).
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/filsys.h
.br
/usr/include/sys/stat.h
.SH SEE ALSO
fsck(1M), mkfs(1M), inode(4), fs(4).
.\"	@(#)fs.4	5.1 of 11/16/83
umbers begin at 1, and the storage for i-nodes
begins in block 2.
Also, i-nodes are 64 bytes lonu_man/man4/bellinode.4                                                                                 664    1776     311         5626  3536706712  10163                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH BELLINODE 4
.SH NAME
bellinode \- format of a Bell file system inode
.SH SYNOPSIS
.B #include <sys/param.h>
.br
.B #include <sys/inode.h>
.SH DESCRIPTION
An
.I inode
under the Bell file system
(formerly known as ``the''
U\s-2NIX\s+2
System V
file system)
has the following structure.
.PP
.nf
.in +.3i
/*
 * Bell style file system inode as it appears on disk.  The 40 bytes of
 * addressing information is divided into 13 3-byte addresses.  The Bell
 * inode is 64 bytes long.
 */
struct	dinode {
	ushort	di_mode;		/* type and access permissions */
	short	di_nlink;    		/* number of links */
	ushort	di_uid;      		/* owner's user id number */
	ushort	di_gid;      		/* group's group id number */
	off_t	di_size;     		/* number of bytes in file */
	char  	di_addr[40];		/* disk block addresses */
	time_t	di_atime;		/* time of last access (to contents) */
	time_t	di_mtime;		/* of last modification (of contents) */
	time_t	di_ctime;		/* of last modification to inode */
};
.in -.3i
.fi
.LP
The types
.IR ushort ,
.IR off_t ,
and
.I time_t
are defined in
.IR types (5).
.PP
.I di_mode
contains the type of the file
(plain file, directory, etc),
and its read, write, and execute permissions
for the file's owner, group, and public.
.I di_nlink
contains the number of links to the inode.
Correctly formed directories have
a minimum of two links:
a link in the directory's parent
and the `.' link in the directory itself.
Additional links may be caused by `..' links from subdirectories.
.I di_uid
and
.I di_gid
contain the user id and group id of the file
(used to determine which set of access permissions apply:
owner, group, or public).
.I di_size
contains the length of the file in bytes.
.PP
.I di_atime
is the time of last access to the file's contents.
.I di_mtime
is the time of last modification of the file's contents.
.I di_ctime
is the time of last modification of the inode,
as opposed to the contents of the file it represents.
These times are in given in seconds since
the beginning of 1970 GMT.
.PP
.I "di_addr[0 .. 38]"
is a packed array of
13
3-byte numbers.
If the inode is not a block or character special inode,
the first
10
are volume block addresses of the file's first 10 data blocks.
Next is
the address of a
single indirect block
containing block addresses,
followed by the address of a
double indirect block
containing addresses of single indirect blocks,
followed by the address of a
triple indirect block
containing addresses of double indirect blocks.
If 0 appears as a direct or indirect block address,
the corresponding block is read by the system as all zeros.
.PP
If the inode is a block or character special inode,
only the first number is used,
as a number identifying the device.
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/types.h
.br
/usr/include/sys/inode.h
.br
/usr/include/sys/ino.h
.br
/usr/include/sys/stat.h
.SH SEE ALSO
stat(2), inode(4), fs(4), bellfs(4), types(5).
.\"	@(#)inode.4	5.1 of 10/15/83
addresses of double indirect blocks.
If 0 appears as a direct or indirect block address,
the correspondingu_man/man4/efs.4                                                                                       664    1776     311        10137  3540734215   7006                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH EFS 4
.SH NAME
Extent file system \- layout of the Extent file system
.SH SYNOPSIS
.B #include <sys/param.h>
.br
.B #include <sys/fs.h>
.SH DESCRIPTION
Every Extent file system storage volume
has a common format for certain vital information.
Every such volume is divided into a certain number
of 512 byte long sectors, also called
.I basic
.IR blocks .
Basic block 0 is unused and is available to contain
a bootstrap program or other information.
.PP
Basic block 1 is the
.IR super-block .
The format of an Extent file system super-block is:
.PP
.nf
.in +.3i
/*
 * Structure of the super-block for the Extent file system
 */
struct	efs {
	/*
	 * This portion is read off the volume
	 */
	long	fs_size;		/* size of file system, in sectors */
	long	fs_firstcg;	/* bb offset to first cg */
	long	fs_cgfsize;	/* size of cylinder group in bb's */
	short	fs_cgisize;	/* bb's in inodes per cylinder group */
	short	fs_sectors;	/* sectors per track */
	short	fs_heads;	/* heads per cylinder */
	short	fs_ncg;		/* # of groups in file system */
	short	fs_dirty;	/* fs needs to be fsck'd */
	time_t	fs_time;		/* last super-block update */
	char	fs_fname[6];	/* file system name */
	char	fs_fpack[6];	/* file system pack name */
	long	fs_magic;	/* magic number */
	long	fs_prealloc;	/* a good file system pre-alloc size */
	long	fs_bmsize;	/* size of bitmap in bytes */
	long	fs_tfree;		/* total free data blocks */
	long	fs_tinode;	/* total free inodes */
	char	fs_spare[100];	/* space for expansion */
	long	fs_checksum;	/* checksum of volume portion of fs */
	/*
	 * The remainder of this structure, defined fully in <sys/fs.h>
	 * is used by the operating system only.
	 */
};

#define	EFS_MAGIC	0x041755

.in -.3i
.fi
.LP
Note that the struct efs that is defined in
.I <sys/fs.h>
contains more fields.  The extra fields are used internally by the
operating system, and are not discussed here.
.I fs_size
holds the size in basic blocks of the file system.  This variable is
filled in when the file system is first created with
.IR mkfs (1M).
.PP
.I fs_firstcg
contains the basic block offset to the first
.I cylinder group.
There are
.I fs_ncg
cylinder groups contained in the file system.  Each cylinder group
is composed of
.I fs_cgfsize
basic blocks, of which
.I fs_cgisize
basic blocks are used for inodes.
.PP
.IR fs_sectors ,
and
.I fs_heads
are used to specify the geometry of the underlying disk containing
the file system.
.PP
.I fs_dirty
is a flag which indicates if the file system needs to be checked
by the
.IR fsck (1M)
program.  The
.I fs_time
field contains the time stamp of when the file system was last
modified.
.I fs_name
holds the
.I name
of the file system (where it is mounted, more or less) while 
.I fs_fpack
contains which volume this file system is.  The
.I fs_fpack
field is singularly useless, but is provided for utility compatibility.
.I fs_magic
is used to tag the superblock of the file system as an Extent file system.
.I fs_prealloc
is sometimes used by the allocator for pre-allocation during file writing
and should indicate a particularly good pre-allocation for the given
file system.
The
.I fs_bmsize
field contains, in bytes, the size of the data block bitmap.  The
data block bitmap is used for data block allocation.  Each one in the
bitmap indicates a free block.
.I fs_tfree
and
.I fs_tinode
contain the total free blocks and inodes, respectively.
The
.I fs_spare
field is reserved for future use.  Lastly, the
.I fs_checksum
variable holds a checksum of the above fields (not including itself).
.PP
During the
.IR mount (1m)
of the file system, the
.I fs_dirty
and
.I fs_checksum
fields are examined.  If
.I fs_dirty
is non-zero, or the
.I fs_checksum
variable does not match the systems computed checksum, then the file system
must be cleaned with
.I fsck 
before it can be mounted.  If the file system is the
.I root
partition, then this check is ignored, as it is necessary to be able
to run 
.I fsck 
on a dirty
.I root
from a dirty
.IR root .
For the format of an inode and its flags, see
.IR inode (4).
.SH FILES
/usr/include/sys/fs.h
.br
/usr/include/sys/stat.h
.SH SEE ALSO
fsck(1M), mkfs(1M), inode(4).
.\"	@(#)fs.4	5.1 of 11/16/83
 or the
.I fs_checksum
variable does not match the systems computed checksum, then the file system
must be cleaned with
.I fsck 
before it can be mounted.  If the file system is the
.I root
partition, then this check is ignored, as it is necessary to be able
to run 
.I fsck 
on a dirty
.I root
from a dirty
.IR root .
For the format of an inode and its flags, see
.IR inode (4).
.SH FILES
/usr/include/sys/fs.h
.br
/u_man/man4/efsinode.4                                                                                  664    1776     311         7352  3537104204  10005                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH EFSINODE 4
.SH NAME
efsinode \- format of an extent file system inode
.SH SYNOPSIS
.B #include <sys/param.h>
.br
.B #include <sys/inode.h>
.SH DESCRIPTION
An
.I inode
under the Extent file system has the following structure.
.PP
.nf
.in +.3i
#define	EFS_DIRECTEXTENTS	12

/*
 * Extent based file system inode as it appears on disk.
 * The efs inode is 128 bytes long.
 */
struct	efs_dinode {
	ushort	di_mode;		/* type and access permissions */
	short	di_nlink;    		/* number of links */
	ushort	di_uid;      		/* owner's user id number */
	ushort	di_gid;      		/* group's group id number */
	off_t	di_size;     		/* number of bytes in file */
	time_t	di_atime;		/* time of last access (to contents) */
	time_t	di_mtime;		/* of last modification (of contents) */
	time_t	di_ctime;		/* of last modification to inode */
	time_t	di_etime;		/* time last extended */
	short	di_numextents;		/* # of extents */
	short	di_unused;		/* UNUSED */
	union {
		extent	di_extents[EFS_DIRECTEXTENTS];
		dev_t	di_dev;		/* device for IFCHR/IFBLK */
	} di_u;
};
.fi
.in -.3i
.LP
The types
.IR ushort ,
.IR off_t ,
.IR time_t ,
and
.I dev_t
are defined in
.IR types (5).
The
.I extent
type is defined as follows.
.PP
.nf
.in +.3i
/*
 * Extent descriptor structure used in Extent file system inodes.
 * There are two kinds of extents descriptors:  direct and indirect.
 *
 * A direct extent descriptor maps a logical segment of its file to
 * to a physical segment (i.e., extent)  on the volume.  The physical
 * segment is characterized by a starting address and a length, both
 * in basic blocks.  The direct extent descriptor as used here contains
 * a logical file offset, also in basic blocks.
 *
 * An indirect extent descriptor maps a file to an array of direct
 * extent descriptors on the volume.
 */
typedef struct	extent {
unsigned int	ex_magic:8,		/* magic #, must be 0 */
		ex_bn:24,		/* bb # on volume */
		ex_length:8,		/* length of this extent in bb's */
		ex_offset:24;		/* logical file offset in bb's */
} extent;
.fi
.in -.3i
.LP
.I di_mode
contains the type of the file
(plain file, directory, etc),
and its read, write, and execute permissions
for the file's owner, group, and public.
.I di_nlink
contains the number of links to the inode.
Correctly formed directories have
a minimum of two links:
a link in the directory's parent
and the `.' link in the directory itself.
Additional links may be caused by `..' links from subdirectories.
.I di_uid
and
.I di_gid
contain the user id and group id of the file
(used to determine which set of access permissions apply:
owner, group, or public).
.I di_size
contains the length of the file in bytes.
.PP
.I di_atime
is the time of last access to the file's contents.
.I di_mtime
is the time of last modification of the file's contents.
.I di_ctime
is the time of last modification of the inode,
as opposed to the contents of the file it represents.
.I di_etime
is the time of last
.I extension
of the file.
These times are given in seconds since
the beginning of 1970 GMT.
.PP
.I di_numextents
is the number of extents claimed by the file.
If less than or equal to
.I EFS_DIRECTEXTENTS
then the extent descriptors appear directly in the inode as
.IR "di_u.di_extents[0 .. di_numextents-1]" .
Otherwise,
.IR "di_u.di_extents[0]"
is an
.IR "indirect extent" ,
i.e.,
a descriptor for
an extent which contains the
.I di_numextent
extent descriptors for the file's data.
There is at most one indirect extent.
.PP
If the inode is a block or character special inode,
.I "di_u.di_numexents"
is 0,
and
.I "di_u.di_dev"
contains a
number
identifying the device.
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/types.h
.br
/usr/include/sys/inode.h
.br
/usr/include/sys/stat.h
.SH SEE ALSO
stat(2), inode(4), fs(4), efs(4), types(5).
.\"	@(#)inode.4	5.1 of 10/15/83
tent" ,
i.e.,
a descriptor for
an extent which contains the
.I di_numextent
extent descriptors for the file's data.
There is at most one indirect extent.
.PP
If the inode is a block or character special inode,
.I "di_u.di_numexents"
is 0,
and
.I "di_u.di_dev"
contains a
number
u_man/man4/fs.4                                                                                        664    1776     311         5005  3536712564   6627                                                                                                                                                                                                                                                                                                                                                                      .TH FS 4
.SH NAME
file system - format of system volumes
.SH SYNOPSIS
# include <sys/param.h>
.br
# include <sys/fs.h>
.br
# include <sys/inode.h>
.br
.SH DESCRIPTION
A file system is a discipline imposed by the 
U\s-2NIX\s+2 
operating system
on a block-structured device,
for the purpose of implementing the
U\f-2NIX\f+2 abstraction of a file.
Currently two types of file system are supported:  the Bell file system
(formerly known as `the'
U\s-2NIX\s+2
System V
file system; see
.IR bellfs (4)),
and the Extent file system
(see
.IR efs(4)).
Their common features are:
.TP "\w'\(bu\ \ 'u"
\(bu
A \f2boot block\f1 at byte address 0.
.TP "\w'\(bu\ \ 'u"
\(bu
A \f2super block\f1 at byte address 512,
containing such information as the number
of blocks and the number of inodes contained
in the file system.
.TP "\w'\(bu\ \ 'u"
\(bu
A static division of the remaining file system
space into \f2inodes\f1 and \f2data\f1,
determined when the file system is created.
.TP "\w'\(bu\ \ 'u"
\(bu
One \f2inode\f1 per file,
containing
its access permissions,
the number of references (directory entries) to the file,
its owner,
its logical size,
its times of last use and modification,
and a list designating the blocks
containing its data.
.TP "\w'\(bu\ \ 'u"
\(bu
A \f2free list\f1 designating blocks available for
allocation to files.
.PP
Their main differences are:
.TP "\w'\(bu\ \ 'u"
\(bu
Free list organization.
The Bell file system represents the free list as a
chain of
.IR "free blocks" ,
each of which contains some number of block numbers,
the last of which is the next block in the chain.
The Extent file system represents the free list as
a bit map with a `1' for each free block.
.TP "\w'\(bu\ \ 'u"
\(bu
Inode data block list.
The Bell file system represents the block list as
a list of block numbers,
appearing in the inode itself and in multiply indirect blocks.
The Extent file system represents the block list as
a list of extents
(i.e., a logical offset, and a disk block number and a length).
The list appears in the inode itself if the number of extents is small,
otherwise it appears in a single indirect extent.
.TP "\w'\(bu\ \ 'u"
\(bu
Inode position.
The Bell file system has a single inode region
followed by a single data region.
The Extent file system has some number of
.IR cylinder\0 groups ,
each of which consists of an inode region followed by a data region.
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/fs.h
.br
/usr/include/sys/inode.h
.br
/usr/include/sys/stat.h
.SH "SEE ALSO"
bellfs(4), efs(4), fsck(1M), mkfs(1M), inode(4)
er of extents is small,
otherwise it appears in a single indirect extent.
.TP "\w'\(bu\ \ 'u"
\(bu
Inode position.
The Bell file system has a single inode region
followed by a single data region.
The Extent file system has some number of
.IR cylinder\0 groups ,
each of which consists of an inode region followed by a data region.
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/fs.h
.br
/usr/include/sys/inode.h
.br
/usr/include/sys/stat.h
.SH "SEE ALSO"
bellfs(4), efs(4), fsck(1M), mkfs(1M), inodu_man/man4/inode.4                                                                                     664    1776     311         4227  3536715066   7322                                                                                                                                                                                                                                                                                                                                                                      '\" t
.TH INODE 4
.SH NAME
inode \- format of an inode
.SH SYNOPSIS
.B #include <sys/param.h>
.br
.B #include <sys/inode.h>
.SH DESCRIPTION
An
.I inode
is the volume data structure used by a file system
to implement the abstraction of a
U\s-2NIX\s0
file.
(This is not to be confused with the
.I in-core inode
used by the
U\s-2NIX\s0
kernel to manage files in use.)
The size and exact layout of an
.I inode
depends on the type of file system
(e.g., Bell file system or Extent file system).
The size and layout of a Bell file system
.I inode
is described in
.IR bellinode (4).
The size and layout of an Extent file system
.I inode
is described in
.IR efsinode (4).
.PP
Generally,
an
.I inode
contains the type
(e.g., plain file, directory, symbolic link, or device file)
of the file;
its owner, group, and public access permissions;
the owner and group id numbers;
its size in bytes;
the number of links (directory references) to the file;
and the times of last access and last modification to the file.
These times are given in seconds since
the beginning of 1970 GMT.
In addition,
there is
a file system type-dependent representation of
the list of data blocks claimed by the file.
.PP
.nf
.in +.3i
/*
 * This information occurs at the start of all inodes
 * independent of file system type.
 */
struct	icommon {
	ushort	ic_mode;		/* type and access permissions */
	short	ic_nlink;    		/* number of links */
	ushort	ic_uid;      		/* owner's user id number */
	ushort	ic_gid;      		/* group's group id number */
	off_t	ic_size;     		/* number of bytes in file */
};

/*
 * This information occurs somewhere in all inodes,
 * but its location varies according to file system type.
 */
struct itimes {
	time_t	ic_atime;		/* time of last access (to contents) */
	time_t	ic_mtime;		/* of last modification (of contents) */
	time_t	ic_ctime;		/* of last modification to inode */
};
.fi
.in -.3i
.LP
The types
.IR ushort ,
.IR off_t ,
and
.I time_t
are defined in
.IR types (5).
.PP
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/types.h
.br
/usr/include/sys/inode.h
.br
/usr/include/sys/stat.h
.SH SEE ALSO
bellinode(4), efsinode(4), stat(2), fs(4), types(5).
.\"	@(#)inode.4	5.1 of 10/15/83
struct itimes {
	time_t	ic_atime;		/* time of last access (to contents) */
	time_t	ic_mtime;		/* of last modification (of contents) */
	time_t	ic_ctime;		/* of last modification to inode */
};
.fi
.in -.3i
.LP
The types
.IR ushort ,
.IR off_t ,
and
.I time_t
are defined in
.IR types (5).
.PP
.SH FILES
/usr/include/sys/param.h
.br
/usr/include/sys/types.h
.br
u_man/man4/login.4                                                                                     664    1776     311         1155  3525525400   7316                                                                                                                                                                                                                                                                                                                                                                      .TH LOGIN 4
.SH NAME
login, cshrc \- setting up a C Shell environment
.SH DESCRIPTION
The file
.BR \&.login
is executed before a session begins.
The file
.BR \&.cshrc
is executed each time a shell is forked.
These files are useful for setting environment
variables and terminal modes.
If the file
.B /etc/cshrc
exists, it will be executed for every user before
.BR .login
is read.
.SH NOTE
The C Shell must be specified as the user's login shell
in the file \f2/etc/passwd\fP.
.SH FILES
~/.login
.br
/~/.cshrc
.br
/etc/cshrc
.SH SEE ALSO
csh(1), env(1), login(1), mail(1), stty(1),
su(1), passwd(4), environ(5), term(5).
s executed before a session begins.
The file
.BR \&.cshrc
is executed each time a shell is forked.
These files are useful for setting environment
variables and terminal modes.
If the file
.B /etc/cshrc
exists, it will be executed for every user before
.BR .login
is read.
.SH NOTE
The C Shell must be specified as the user's login shell
in the file \f2/etc/passwd\fP.
.SH FILES
~/.login
.br
/~/.cshrc
.bu_man/man5/en.5                                                                                        664    1776     311         3662  3525766430   6631                                                                                                                                                                                                                                                                                                                                                                      .TH ENVIRON 4 
.SH NAME
environ \- user environment
.SH SYNOPSIS
.B extern char **environ;
.SH DESCRIPTION
An array of strings called the 'environment' is
made available by
.IR exec (2)
when a process begins.
By convention these strings have the form
.RI ' name = value '.
The following names are used by various commands:
.TP "\w'\s-1LOGNAME\s+1\ \ 'u"
\s-1PATH\s+1
The sequence of directory prefixes that
.I sh, time,
.IR nice (1),
etc.,
apply in searching for a file known by an incomplete path name.
The prefixes are separated by ':'.
.br
.IR Login (1)
sets :
.PD 0
.TP
\&
.RS 2.5i
\s-1PATH\s+1=:/bin:/usr/bin
.RE
.PD
.TP
\s-1HOME\s+1
A user's login directory, set by
.IR login (1)
from the password file
.IR passwd (5).
.TP
\s-1TERM\s+1
The kind of terminal for which output is to be prepared.
This information is used by commands, such as
.I nroff,
.I more,
or
.I vi,
which may exploit special terminal capabilities.
See
\f2termcap\fP(5) and \f2tset\fP(1)
for a list of terminal types.
.TP
\s-1SHELL\s+1
The file name of the users login shell.
.TP
\s-1TERMCAP\s+1
The string describing the terminal in \s-1TERM\s+1,
or the name of the termcap file, see
.IR termcap (5).
.TP
\s-1EXINIT\s+1
A startup list of commands read by
.IR ex (1),
.IR edit,
and
.IR vi (1).
.TP
\s-1USER\s+1
The login name of the user.
.TP
\s-1LOGNAME\s+1
The login name of the user.
.TP
\s-1MAIL\s+1
The user's mailbox.
.TP
\s-1TZ\s+1
The user's time zone.
.PP
Further names may be placed in the environment by
the
.I export
command and 'name=value' arguments in
.IR sh (1),
or by the
.I setenv
command if you use
.IR csh (1).
Arguments may also be placed in the environment at the point of an
.IR exec (2).
It is unwise to conflict with
certain 
.IR sh (1)
variables that are frequently exported by
".profile" files:
\s-1MAIL, PS1, PS2, IFS\s+1.
.SH SEE ALSO
csh(1), ex(1), login(1), mail(1), sh(1), tset(1), exec(2),
system(3S), TZ(4), termcap(5), tty(7).
.\"	@(#)environ.4	5.1 of 10/23/83
e placed in the environment by
the
.I export
command and 'name=value' argumentu_man/man5/environ.5                                                                                   664    1776     311         3676  3526000670   7700                                                                                                                                                                                                                                                                                                                                                                      .TH ENVIRON 5 
.SH NAME
environ \- user environment
.SH SYNOPSIS
.B extern char **environ;
.SH DESCRIPTION
An array of strings called the ``environment'' is
made available by
.IR exec (2)
when a process begins.
By convention these strings have the form
name \= value .
The following names are used by various commands:
.TP "\w'\s-1LOGNAME\s+1\ \ 'u"
\s-1PATH\s+1
The sequence of directory prefixes that
.IR sh (1), 
.IR time (1),
.IR nice (1),
etc.,
apply in searching for a file known by an incomplete path name.
The prefixes are separated by ':'.
.br
.IR Login (1)
sets :
.PD 0
.TP
\&
.RS 2.5i
\s-1PATH\s+1=:/bin:/usr/bin
.RE
.PD
.TP
\s-1HOME\s+1
A user's login directory, set by
.IR login (1)
from the password file
.IR passwd (5).
.TP
\s-1TERM\s+1
The kind of terminal for which output is to be prepared.
This information is used by commands, such as
.I nroff,
.I more,
or
.I vi,
which may exploit special terminal capabilities.
See
\f2termcap\fP(5) and \f2tset\fP(1)
for a list of terminal types.
.TP
\s-1SHELL\s+1
The file name of the user's login shell.
.TP
\s-1TERMCAP\s+1
The string describing the terminal in \s-1TERM\s+1,
or the name of the termcap file, see
.IR termcap (5).
.TP
\s-1EXINIT\s+1
A startup list of commands read by
.IR ex (1),
.IR edit,
and
.IR vi (1).
.TP
\s-1USER\s+1
The login name of the user.
.TP
\s-1LOGNAME\s+1
The login name of the user.
.TP
\s-1MAIL\s+1
The user's mailbox.
.TP
\s-1TZ\s+1
The user's time zone.
.PP
Further names may be placed in the environment by
the
.I export
command and name\=value arguments in
.IR sh (1),
or by the
.I setenv
command if you use
.IR csh (1).
Arguments may also be placed in the environment at the point of an
.IR exec (2).
It is unwise to conflict with
certain 
.IR sh (1)
variables that are frequently exported by
``.profile'' files:
\s-1MAIL, PS1, PS2, IFS\s+1.
.SH SEE ALSO
csh(1), ex(1), login(1), mail(1), sh(1), tset(1), exec(2),
system(3S), TZ(4), termcap(5), tty(7).
.\"	@(#)environ.4	5.1 of 10/23/83
 placed in the environment by
the
.I export
command and name\=valua_man/man7/termio.7                                                                                    664    1776     311        53456  3525727500   7527                                                                                                                                                                                                                                                                                                                                                                      .TH TERMIO 7
.SH NAME
termio \- general terminal interface
.SH DESCRIPTION
.if t .ds ' \h@.05m@\s+4\v@.333m@\'\v@-.333m@\s-4\h@.05m@
.if n .ds ' '
.if t .ds ` \h@.05m@\s+4\v@.333m@\`\v@-.333m@\s-4\h@.05m@
.if n .ds ` `
.PP
This section describes both a particular special file
and the general nature of the terminal interface.
.PP
The file
.B /dev/tty
is, in each process, a synonym
for the control terminal associated with the process group of that process,
if any.
It is useful for programs or shell sequences that wish to
be sure of writing messages on the terminal
no matter how output has been redirected.
It can also be used for programs that demand the name of a file
for output, when typed output is desired
and it is tiresome to find out what terminal
is currently in use.
.PP
All of the asynchronous
communications ports use the
same general interface, no matter what
hardware is involved.
The remainder of this section discusses
the common features of this interface.
.PP
When a terminal file is opened,
it normally causes
the process to wait until a connection is established.
In practice, users' programs seldom open these
files; they are opened by
.I getty
and become a user's
standard input, output, and error files.
The very first terminal file opened
by the process group leader of a terminal
file not already associated with a process group
becomes the
.I "control terminal\^"
for that process group.
The control terminal plays a special
role in handling quit and interrupt signals, as discussed
below.
The control terminal is inherited by a child process during a
.IR fork (2).
A process can break this association by changing its
process group using
.IR setpgrp (2).
.PP
A terminal associated with one of these files ordinarily
operates in full-duplex mode.
Characters may be typed at any time,
even while output is occurring, and are only lost when the
system's character input buffers become completely
full, which is rare,
or when the user has accumulated the maximum allowed number of
input characters that have not yet been read by some program.
Currently, this limit is 256 characters.
When the input limit is reached, all the
saved characters are thrown away without notice.
.PP
Normally, terminal input is processed in units of lines.
A line is delimited by a new-line (\s-1ASCII\s+1
.SM LF\*S)
character, an end-of-file (\s-1ASCII\s+1
.SM EOT\*S)
character,
or an end-of-line character.
This means that a program attempting
to read will be suspended until an entire line has been
typed.
Also, no matter how many characters are requested
in the read call, at most one line will be returned.
It is not, however, necessary to read a whole line at
once; any number of characters may be
requested in a read, even one, without losing information.
.PP
During input, erase and kill processing is normally
done.
By default, the character
.B #
erases the
last character typed, except that it will not erase
beyond the beginning of the line.
By default, the character
\f3\@\f1
kills (deletes) the entire input line,
and optionally outputs a new-line character.
Both these
characters operate on a key-stroke basis, independently
of any backspacing or tabbing that may have been done.
Both the erase and kill characters
may be entered literally by preceding them with
the escape character
.RB ( \e ).
In this case the escape character is not read.
The erase and kill characters may be changed.
.PP
Certain characters have special functions on input.
These functions and their default character values
are summarized as follows:
.TP "\w'START\ \ \ 'u"
.SM INTR
(Rubout or
.SM ASCII
.SM DEL\*S)
generates an
.I interrupt\^
signal which is sent to all processes
with the associated control terminal.
Normally, each such process is forced to terminate,
but arrangements may be made either to
ignore the signal or to receive a
trap to an agreed-upon location;
see
.IR signal (2).
.TP
.SM QUIT
(Control-\(bv or
.SM ASCII
.SM FS\*S)
generates a
.I quit\^
signal.
Its treatment is identical to the interrupt signal
except that, unless a receiving process has
made other arrangements, it will not only be terminated
but a core image file
(called
.BR core )
will be created in the current working directory.
.TP
.SM ERASE
(#) erases the preceding character.
It will not erase beyond the start of a line,
as delimited by a
.SM NL\*S,
.SM EOF\*S,
.SM EOL\*S,
or
.SM EOL2
character.
.TP
.SM KILL
(@) deletes the entire line,
as delimited by a
.SM NL\*S,
.SM EOF\*S,
.SM EOL\*S,
or
.SM EOL2
character.
.TP
.SM EOF
(Control-d or
.SM ASCII
.SM EOT\*S)
may be used to generate an end-of-file
from a terminal.
When received, all the characters
waiting to be read are immediately passed to
the program, without waiting for a new-line,
and the
.SM EOF
is discarded.
Thus, if there are no characters waiting, which
is to say the
.SM EOF
occurred at the beginning of a line,
zero characters will be passed back,
which is the standard end-of-file indication.
.TP
.SM NL
(\s-1ASCII\s+1
.SM LF\*S)
is the normal line delimiter.
It can not be changed or escaped.
.TP
.SM EOL
(\s-1ASCII\s+1
.SM NUL\*S)
is an additional line delimiter, like
.SM NL\*S.
It is not normally used.
.TP
.SM EOL2
(disabled)
is an additional line delimiter, like
.SM EOL\*S.
It is not normally used.
.TP
.SM STOP
(Control-s or
.SM ASCII
.SM DC3\*S)
can be used to temporarily suspend output.
It is useful with
.SM CRT
terminals to prevent output from
disappearing before it can be read.
While output is suspended,
.SM STOP
characters are ignored and not read.
.TP
.SM START
(Control-q or
.SM ASCII
.SM DC1\*S)
is used to resume output which has been suspended by a
.SM STOP
character.
While output is not suspended,
.SM START
characters are ignored and not read.
The start/stop characters
can not be changed or escaped.
.PP
The character values for
.SM INTR\*S,
.SM QUIT\*S,
.SM ERASE\*S,
.SM KILL\*S,
.SM EOF\*S,
.SM EOL\*S,
and
.SM EOL2
may be changed to suit individual tastes.
The
.SM ERASE\*S,
.SM KILL\*S,
and
.SM EOF
characters may be escaped
by a preceding
.B \e
character,
in which case no special function is done.
.PP
When the carrier signal from the data-set drops, a
.I hangup\^
signal is sent to all processes
that have this terminal
as the control terminal.
Unless other arrangements have been made,
this signal causes the processes to terminate.
If the hangup signal is ignored, any subsequent read
returns with an end-of-file indication.
Thus programs that read a terminal and test for
end-of-file can terminate appropriately when
hung up on.
.PP
When one or more
characters are written, they are transmitted
to the terminal as soon as previously-written characters
have finished typing.
Input characters are echoed by putting them in the output queue
as they arrive.
If a process produces characters more rapidly than they can be typed,
it will be suspended when its output queue exceeds some limit.
When the queue has drained down to some threshold,
the program is resumed.
.PP
Several
.IR ioctl (2)
system calls apply to terminal files.
The primary calls use the following structure,
defined in
.BR <termio.h> :
.PP
.ta .6i 1.3i 1.8i 2.6i 3.5i
.RS .3i
.nf
#define	\s-1NCC\s+1	8
struct	termio {
	unsigned	short	c_iflag;	/\(** input modes \(**/
	unsigned	short	c_oflag;	/\(** output modes \(**/
	unsigned	short	c_cflag;	/\(** control modes \(**/
	unsigned	short	c_lflag;	/\(** local modes \(**/
	char			c_line;		/\(** line discipline \(**/
	unsigned	char	c_cc[\s-1NCC\s+1];	/\(** control chars \(**/
};
.fi
.RE
.PP
The special control characters are defined by the array
.IR c_cc .
The relative positions and initial values
for each function are as follows:
.RS .3i
.ta 4n 13n
.nf
0	\s-1INTR\s+1	\s-1DEL\s+1
1	\s-1QUIT\s+1	\s-1FS\s+1
2	\s-1ERASE\s+1	\f3#\fP
3	\s-1KILL\s+1	\f3@\fP
4	\s-1EOF\s+1	\s-1EOT\s+1
5	\s-1EOL\s+1	\s-1NUL\s+1
6	\s-1EOL2\s+1	disabled
7	reserved
.fi
.RE
.PP
The
.I c_iflag\^
field describes the basic terminal input control:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1IGNBRK\s+1	0000001	Ignore break condition.
\s-1BRKINT\s+1	0000002	Signal interrupt on break.
\s-1IGNPAR\s+1	0000004	Ignore characters with parity errors.
\s-1PARMRK\s+1	0000010	Mark parity errors.
\s-1INPCK\s+1	0000020	Enable input parity check.
\s-1ISTRIP\s+1	0000040	Strip character.
\s-1INLCR\s+1	0000100	Map \s-1NL\s+1 to \s-1CR\s+1 on input.
\s-1IGNCR\s+1	0000200	Ignore \s-1CR\s+1.
\s-1ICRNL\s+1	0000400	Map \s-1CR\s+1 to \s-1NL\s+1 on input.
\s-1IUCLC\s+1	0001000	Map upper-case to lower-case on input.
\s-1IXON\s+1	0002000	Enable start/stop output control.
\s-1IXANY\s+1	0004000	Enable any character to restart output.
\s-1IXOFF\s+1	0010000	Enable start/stop input control.
.fi
.RE
.PP
If
.SM IGNBRK
is set, the break condition
(a character framing error with data all zeros)
is ignored, that is, not put on the input queue
and therefore not read by any process.
Otherwise if
.SM BRKINT
is set,
the break condition will generate an
interrupt signal
and flush both the input and output queues.
If
.SM IGNPAR
is set,
characters with other framing and parity errors are ignored.
.PP
If
.SM PARMRK
is set,
a character with
a framing or parity error which is not ignored
is read as the three character sequence:
0377, 0, X,
where X is the data of the character received in error.
To avoid ambiguity in this case,
if
.SM ISTRIP
is not set,
a valid character of 0377 is read as 0377, 0377.
If
.SM PARMRK
is not set,
a framing or parity error which is not ignored
is read as the character \s-1NUL\s+1 (0).
.PP
If
.SM INPCK
is set,
input parity checking is enabled.
If
.SM INPCK
is not set,
input parity checking is disabled.
This allows output parity generation without
input parity errors.
.PP
If
.SM ISTRIP
is set,
valid input characters are first stripped to
7-bits,
otherwise all 8-bits are processed.
.PP
If
.SM INLCR
is set,
a received
.SM NL
character is translated into a
.SM CR
character.
If
.SM IGNCR
is set,
a received
.SM CR
character is ignored (not read).
Otherwise if
.SM ICRNL
is set,
a received
.SM CR
character is translated into a
.SM NL
character.
.PP
If
.SM IUCLC
is set,
a received upper-case alphabetic character is translated
into the corresponding lower-case character.
.PP
If
.SM IXON
is set,
start/stop output control is enabled.
A received
.SM STOP
character will suspend output
and a received
.SM START
character will restart output.
All start/stop characters are ignored and not read.
If
.SM IXANY
is set,
any input character
will restart output
which has been suspended.
.PP
If
.SM IXOFF
is set,
the system will transmit
.SM START/STOP
characters when the input queue is
nearly empty/full.
.PP
The initial input control value is
all bits clear.
.PP
The
.I c_oflag\^
field specifies the system treatment of output:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1OPOST\s+1	0000001	Postprocess output.
\s-1OLCUC\s+1	0000002	Map lower case to upper on output.
\s-1ONLCR\s+1	0000004	Map \s-1NL\s+1 to \s-1CR-NL\s+1 on output.
\s-1OCRNL\s+1	0000010	Map \s-1CR\s+1 to \s-1NL\s+1 on output.
\s-1ONOCR\s+1	0000020	No \s-1CR\s+1 output at column 0.
\s-1ONLRET\s+1	0000040	\s-1NL\s+1 performs \s-1CR\s+1 function.
\s-1OFILL\s+1	0000100	Use fill characters for delay.
\s-1OFDEL\s+1	0000200	Fill is \s-1DEL\s+1, else \s-1NUL\s+1.
\s-1NLDLY\s+1	0000400	Select new-line delays:
\s-1NL0\s+1	0
\s-1NL1\s+1	0000400
\s-1CRDLY\s+1	0003000	Select carriage-return delays:
\s-1CR0\s+1	0
\s-1CR1\s+1	0001000
\s-1CR2\s+1	0002000
\s-1CR3\s+1	0003000
\s-1TABDLY\s+1	0014000	Select horizontal-tab delays:
\s-1TAB0\s+1	0
\s-1TAB1\s+1	0004000
\s-1TAB2\s+1	0010000
\s-1TAB3\s+1	0014000	Expand tabs to spaces.
\s-1BSDLY\s+1	0020000	Select backspace delays:
\s-1BS0\s+1	0
\s-1BS1\s+1	0020000
\s-1VTDLY\s+1	0040000	Select vertical-tab delays:
\s-1VT0\s+1	0
\s-1VT1\s+1	0040000
\s-1FFDLY\s+1	0100000	Select form-feed delays:
\s-1FF0\s+1	0
\s-1FF1\s+1	0100000
.DT
.fi
.RE
.PP
If
.SM OPOST
is set,
output characters are post-processed
as indicated by the remaining flags,
otherwise characters are transmitted without change.
.PP
If
.SM OLCUC
is set,
a lower-case alphabetic character is transmitted as
the corresponding upper-case character.
This function is often used in conjunction with
.SM IUCLC\*S.
.PP
If
.SM ONLCR
is set,
the
.SM NL
character is transmitted as the
.SM CR-NL
character pair.
If
.SM OCRNL
is set,
the
.SM CR
character is transmitted as the
.SM NL
character.
If
.SM ONOCR
is set,
no
.SM CR
character is transmitted when at column 0 (first position).
If
.SM ONLRET
is set,
the
.SM NL
character is assumed to do the carriage-return function;
the column pointer will be set to 0 and the delays specified
for
.SM CR
will be used.
Otherwise the
.SM NL
character is assumed
to do just the line-feed function;
the column pointer will remain unchanged.
The column pointer is also set to 0 if the
.SM CR
character is actually transmitted.
.PP
The delay bits specify how long
transmission stops to allow for mechanical or other movement
when certain characters are sent to the terminal.
In all cases a value of 0 indicates no delay.
If
.SM OFILL
is set,
fill characters will be transmitted
for delay instead of a timed delay.
This is useful for high baud rate terminals
which need only a minimal delay.
If
.SM OFDEL
is set,
the fill character is
.SM DEL\*S,
otherwise
.SM NUL\*S.
.PP
If a form-feed or vertical-tab delay is specified,
it lasts for about 2 seconds.
.PP
New-line delay lasts about 0.10 seconds.
If
.SM ONLRET
is set, the carriage-return delays are
used instead of the new-line delays.
If
.SM OFILL
is set,
two fill characters will be transmitted.
.PP
Carriage-return delay type 1 is dependent on the current column
position,
type 2 is about 0.10 seconds,
and type 3 is about 0.15 seconds.
If
.SM OFILL
is set,
delay type 1 transmits two fill characters,
and type 2 four fill characters.
.PP
Horizontal-tab delay type 1 is dependent on the current
column position.
Type 2 is about 0.10 seconds.
Type 3 specifies that tabs are to be expanded into spaces.
If
.SM OFILL
is set,
two fill characters will be transmitted for any delay.
.PP
Backspace delay lasts about 0.05 seconds.
If
.SM OFILL
is set,
one fill character will be transmitted.
.PP
The actual delays depend on line speed and system load.
.PP
The initial output control value is
all bits clear.
.PP
The
.I c_cflag\^
field describes the hardware control of the terminal:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1CBAUD\s+1	0000017	Baud rate:
B0	0	Hang up
B50	0000001	50 baud
B75	0000002	75 baud
B110	0000003	110 baud
B134	0000004	134.5 baud
B150	0000005	150 baud
B200	0000006	200 baud*
B300	0000007	300 baud
B600	0000010	600 baud
B1200	0000011	1200 baud
B1800	0000012	1800 baud*
B2400	0000013	2400 baud
B4800	0000014	4800 baud
B9600	0000015	9600 baud
\s-1EXTA\s+1	0000016	19,200 baud
\s-1EXTB\s+1	0000017	External B*
\s-1CSIZE\s+1	0000060	Character size:
CS5	0	5 bits
CS6	0000020	6 bits
CS7	0000040	7 bits
CS8	0000060	8 bits
\s-1CSTOPB\s+1	0000100	Send two stop bits, else one.
\s-1CREAD\s+1	0000200	Enable receiver.
\s-1PARENB\s+1	0000400	Parity enable.
\s-1PARODD\s+1	0001000	Odd parity, else even.
\s-1HUPCL\s+1	0002000	Hang up on last close.
\s-1CLOCAL\s+1	0004000	Local line, else dial-up.
.sp
* These rates are not supported on the IRIS workstation.
.sp
.fi
.RE
.PP
The
.SM CBAUD
bits specify the baud rate.
The zero baud rate, B0, is used to hang up the connection.
If B0 is specified, the data-terminal-ready signal will not
be asserted.
Normally, this will disconnect the line.
For any particular hardware, impossible speed changes
are ignored.
.PP
The
.SM CSIZE
bits specify the character size in bits
for both transmission and reception.
This size does not include the parity bit, if any.
If
.SM CSTOPB
is set,
two stop bits are used,
otherwise one stop bit.
For example, at 110 baud, two stop bits are required.
.PP
If
.SM PARENB
is set,
parity generation and detection is enabled
and a parity bit is added to each character.
If parity is enabled,
the
.SM PARODD
flag specifies odd parity if set,
otherwise even parity is used.
.PP
If
.SM CREAD
is set,
the receiver is enabled.
Otherwise no characters will be received.
.PP
If
.SM HUPCL
is set,
the line will be disconnected
when the last process with the line open closes it or terminates.
That is, the data-terminal-ready signal will not be asserted.
.PP
If
.SM CLOCAL
is set,
the line is assumed to be a local, direct connection
with no modem control.
Otherwise modem control is assumed.
.PP
The initial hardware control value after open is
B300, CS8,
.SM CREAD\*S,
.SM HUPCL\*S.
.PP
The
.I c_lflag\^
field of the argument structure
is used by the line discipline to control terminal functions.
The basic line discipline (0) provides the following:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1ISIG\s+1	0000001	Enable signals.
\s-1ICANON\s+1	0000002	Canonical input (erase and kill processing).
\s-1XCASE\s+1	0000004	Canonical upper/lower presentation.
\s-1ECHO\s+1	0000010	Enable echo.
\s-1ECHOE\s+1	0000020	Echo erase character as \s-1BS-SP-BS\s+1.
\s-1ECHOK\s+1	0000040	Echo \s-1NL\s+1 after kill character.
\s-1ECHONL\s+1	0000100	Echo \s-1NL\s+1.
\s-1NOFLSH\s+1	0000200	Disable flush after interrupt or quit.
.DT
.fi
.RE
.PP
If
.SM ISIG
is set,
each input character is checked against the special
control characters
.SM INTR
and
.SM QUIT\*S.
If an input character matches one of these control characters,
the function associated with that character is performed.
If
.SM ISIG
is not set,
no checking is done.
Thus these special input functions
are possible only if
.SM ISIG
is set.
These functions may be disabled individually by changing
the value of the control character to
an unlikely or impossible value (e.g. 0377).
.PP
If
.SM ICANON
is set,
canonical processing is enabled.
This enables the erase and kill edit functions,
and the assembly of input characters into lines delimited by
.SM NL\*S,
.SM EOF\*S,
.SM EOL\*S,
and
.SM EOL2\*S.
If
.SM ICANON
is not set,
read requests are satisfied directly
from the input queue.
A read will not be satisfied
until at least
.SM MIN
characters have been received or
the timeout value
.SM TIME
has expired.
This allows fast bursts of input to be read
efficiently while still allowing single
character input.
The
.SM MIN
and
.SM TIME
values are stored in the
position for the
.SM EOF
and
.SM EOL
characters respectively.
The time value represents tenths of seconds.
.PP
If
.SM XCASE
is set,
and if
.SM ICANON
is set,
an upper-case letter is accepted on input by preceding
it with a
.B \e
character,
and is output preceded by a
.B \e
character.
In this mode, the following escape sequences are generated
on output and accepted on input:
.br
.ne 7
.TP
.nf
.ta .5i
.ti +.5i
for:	use:
\*`	\e\*'
\(bv	\e!
~	\e^
{	\e(
}	\e)
\e	\e\e
.fi
.PP
For example,
.B A
is input as
.BR \ea ,
.B \en
as
.BR \e\en ,
and
.B \eN
as
.BR \e\e\en .
.PP
If
.SM ECHO
is set,
characters are echoed as received.
.PP
When
.SM ICANON
is set,
the following echo functions are possible.
If
.SM ECHO
and
.SM ECHOE
are set,
the erase character is echoed as
.SM ASCII
.SM BS SP BS\*S,
which will clear the last character from a
.SM CRT
screen.
If
.SM ECHOE
is set and
.SM ECHO
is not set,
the erase character is echoed as
.SM ASCII
.SM SP BS\*S.
If
.SM ECHOK
is set,
the
.SM NL
character will be echoed after the
kill character to emphasize that the line
will be deleted.
Note that an escape character preceding
the erase or kill character removes any special function.
If
.SM ECHONL
is set,
the
.SM NL
character will be echoed even if
.SM ECHO
is not set.
This is useful for terminals
set to local echo (so-called half duplex).
Unless  escaped, the
.SM EOF
character  is not 
.bp
echoed.
Because
.SM EOT
is the default
.SM EOF
character,
this prevents terminals that respond to
.SM EOT
from hanging up.
.PP
If
.SM NOFLSH
is set,
the normal flush of the input and output queues
associated with the quit and interrupt characters
will not be done.
.PP
The initial line-discipline control value is
all bits clear.
.PP
The primary
.IR ioctl (2)
system calls have the form:
.PP
.RS .3i
ioctl \|(fildes, \|command, \|arg)
.br
struct \|termio \|\(**arg;
.RE
.PP
The commands using this form are:
.RS .3i
.TP "\w'TCSETAW\ \ \ 'u"
.SM TCGETA
Get the parameters associated with the terminal
and store in the
.I termio\^
structure referenced by
.BR arg .
.TP
.SM TCSETA
Set the parameters associated with the terminal
from the structure referenced by
.BR arg .
The change is immediate.
.TP
.SM TCSETAW
Wait for the output to drain before
setting the new parameters.
This form should be used when changing parameters
that will affect output.
.TP
.SM TCSETAF
Wait for the output to drain,
then flush the input queue and
set the new parameters.
.RE
.PP
Additional
.IR ioctl (2)
calls have the form:
.PP
.RS .3i
ioctl \|(fildes, \|command, \|arg)
.br
int \|arg;
.RE
.PP
The commands using this form are:
.RS .3i
.TP "\w'TCSETAW\ \ \ 'u"
.SM TCSBRK
Wait for the output to drain.
If
.I arg\^
is 0,
then send a break (zero bits for 0.25 seconds).
.TP
.SM TCXONC
Start/stop control.
If
.I arg\^
is 0, suspend output;
if 1, restart suspended output.
.TP
.SM TCFLSH
If
.I arg\^
is 0, flush the input queue;
if 1, flush the output queue;
if 2, flush both the input and output queues.
.TP
.SM FIONREAD
Return the number of characters
currently in a terminal's input buffer
into the integer pointer \(**arg.
.SM ICANNON
mode must be set for this option to work.
.TP
.SM TCBLKMD
Enable block mode, bypassing all line processing.  Currently implemented only
on serial line devices /dev/ttyd\(**.  When in block mode,
.IR read (2)
must be called with a 1024 byte buffer. This mode is
useful for efficient serial line communications at high baud rates.
.RE
.SH FILES
/dev/tty
.br
/dev/tty\(**
.br
/dev/console
.SH SEE ALSO
stty(1), ioctl(2).
.\"	@(#)termio.7	5.1 of 10/15/83
.\"  @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\"  $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/06/17  14:01:39  robinf
.\" Changes according to Herb Kuta
.\" 
.\" Revision 1.1  85/06/12  09:39:03  robinf
.\" Update for GL2-W2.3
.\" 
.\" Revision 1.0  85/05/02  11:18:37  robinf
.\" Initial Revision for Documentation/on 2/25/85 
.\" Bob Toxen documented EOL2 character as per SCR584

.\" Revision 1.2  85/02/25  16:41:42  bob
.\" Documented EOL2 character as per SCR 584.
.\" 
io.7	5.1 of 10/15/83
.\"  @(#)$Header: /d2/3.7/src/man/RCS/fixes.man,v 1.1 89/03/27 16:19:38 root Exp $
.\"  $Log:	fixes.man,v $
Revision 1.1  89/03/27  16:19:38  root
Initial check-in for 3.7

.\" Revision 1.2  85/06/17  14:01:39  robinf
.\" Changes according to Herb Kuta
.\" 
.\" Revision 1.1                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                al-tab delay is specified,
it lasts for about 2 seconds.
.PP
New-line delay lasts about 0.10 seconds.
If
.SM ONLRET
is set, the carriage-return delays are
used instead of the new-line delays.
If
.SM OFILL
is set,
two fill characters will be transmitted.
.PP
Carriage-return delay type 1 is dependent on the current column
position,
type 2 is about 0.10 seconds,
and type 3 is about 0.15 seconds.
If
.SM OFILL
is set,
delay type 1 transmits two fill characters,
and type 2 four fill characters.
.PP
Horizontal-tab delay type 1 is dependent on the current
column position.
Type 2 is about 0.10 seconds.
Type 3 specifies that tabs are to be expanded into spaces.
If
.SM OFILL
is set,
two fill characters will be transmitted for any delay.
.PP
Backspace delay lasts about 0.05 seconds.
If
.SM OFILL
is set,
one fill character will be transmitted.
.PP
The actual delays depend on line speed and system load.
.PP
The initial output control value is
all bits clear.
.PP
The
.I c_cflag\^
field describes the hardware control of the terminal:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1CBAUD\s+1	0000017	Baud rate:
B0	0	Hang up
B50	0000001	50 baud
B75	0000002	75 baud
B110	0000003	110 baud
B134	0000004	134.5 baud
B150	0000005	150 baud
B200	0000006	200 baud*
B300	0000007	300 baud
B600	0000010	600 baud
B1200	0000011	1200 baud
B1800	0000012	1800 baud*
B2400	0000013	2400 baud
B4800	0000014	4800 baud
B9600	0000015	9600 baud
\s-1EXTA\s+1	0000016	19,200 baud
\s-1EXTB\s+1	0000017	External B*
\s-1CSIZE\s+1	0000060	Character size:
CS5	0	5 bits
CS6	0000020	6 bits
CS7	0000040	7 bits
CS8	0000060	8 bits
\s-1CSTOPB\s+1	0000100	Send two stop bits, else one.
\s-1CREAD\s+1	0000200	Enable receiver.
\s-1PARENB\s+1	0000400	Parity enable.
\s-1PARODD\s+1	0001000	Odd parity, else even.
\s-1HUPCL\s+1	0002000	Hang up on last close.
\s-1CLOCAL\s+1	0004000	Local line, else dial-up.
.sp
* These rates are not supported on the IRIS workstation.
.sp
.fi
.RE
.PP
The
.SM CBAUD
bits specify the baud rate.
The zero baud rate, B0, is used to hang up the connection.
If B0 is specified, the data-terminal-ready signal will not
be asserted.
Normally, this will disconnect the line.
For any particular hardware, impossible speed changes
are ignored.
.PP
The
.SM CSIZE
bits specify the character size in bits
for both transmission and reception.
This size does not include the parity bit, if any.
If
.SM CSTOPB
is set,
two stop bits are used,
otherwise one stop bit.
For example, at 110 baud, two stop bits are required.
.PP
If
.SM PARENB
is set,
parity generation and detection is enabled
and a parity bit is added to each character.
If parity is enabled,
the
.SM PARODD
flag specifies odd parity if set,
otherwise even parity is used.
.PP
If
.SM CREAD
is set,
the receiver is enabled.
Otherwise no characters will be received.
.PP
If
.SM HUPCL
is set,
the line will be disconnected
when the last process with the line open closes it or terminates.
That is, the data-terminal-ready signal will not be asserted.
.PP
If
.SM CLOCAL
is set,
the line is assumed to be a local, direct connection
with no modem control.
Otherwise modem control is assumed.
.PP
The initial hardware control value after open is
B300, CS8,
.SM CREAD\*S,
.SM HUPCL\*S.
.PP
The
.I c_lflag\^
field of the argument structure
is used by the line discipline to control terminal functions.
The basic line discipline (0) provides the following:
.PP
.ta \w'MAXMAX\ \ 'u +\w'0100000\ \ 'u
.RS .3i
.nf
\s-1ISIG\s+1	0000001	Enable signals.
\s-1ICANON\s+1	0000002	Canonical input (erase and kill processing).
\s-1XCASE\s+1	0000004	Canonical 