/*
 *	percent - 
 *		Indicate percent done on time consuming operations.
 *
 *				Paul Haeberli - 1985
 *
 */
#include "gl.h"
#include "device.h"

#define NCURSORS	11

short curtab[NCURSORS][16] = {
    {0x7FFE, 0x4002, 0x2004, 0x300C, 
    0x2894, 0x2424, 0x2244, 0x2244, 
    0x2344, 0x23C4, 0x27E4, 0x2FF4, 
    0x3FFC, 0x3FFC, 0x4FF2, 0x7FFE},

    {0x7FFE, 0x43C2, 0x2184, 0x300C, 
    0x2814, 0x2424, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x27E4, 0x2FF4, 
    0x3FFC, 0x2FF4, 0x47E2, 0x7FFE},

    {0x7FFE, 0x47E2, 0x23C4, 0x308C, 
    0x2814, 0x2424, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x27E4, 0x2FF4, 
    0x3FFC, 0x27F4, 0x4182, 0x7FFE},

    {0x7FFE, 0x4FE2, 0x27C4, 0x318C, 
    0x2914, 0x2424, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x27E4, 0x2FF4, 
    0x37FC, 0x23F4, 0x4082, 0x7FFE},

    {0x7FFE, 0x4FF2, 0x27E4, 0x33CC, 
    0x2914, 0x2424, 0x2244, 0x2244, 
    0x2344, 0x23C4, 0x27E4, 0x2FF4, 
    0x37FC, 0x21C4, 0x4002, 0x7FFE},

    {0x7FFE, 0x4FFA, 0x27F4, 0x33EC, 
    0x2994, 0x2424, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x27E4, 0x2FF4, 
    0x37CC, 0x2084, 0x4002, 0x7FFE},

    {0x7FFE, 0x5FFA, 0x2FF4, 0x37EC, 
    0x2B94, 0x2424, 0x2244, 0x2244, 
    0x2344, 0x23C4, 0x27E4, 0x2FF4, 
    0x318C, 0x2004, 0x4002, 0x7FFE},

    {0x7FFE, 0x7FFE, 0x3FF4, 0x37EC, 
    0x2BD4, 0x2424, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x27E4, 0x2BD4, 
    0x300C, 0x2004, 0x4002, 0x7FFE},

    {0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
    0x2FD4, 0x2424, 0x2244, 0x2244, 
    0x2344, 0x23C4, 0x27E4, 0x2814, 
    0x300C, 0x2004, 0x4002, 0x7FFE},

    {0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
    0x2FF4, 0x26E4, 0x2244, 0x2244, 
    0x22C4, 0x23C4, 0x2424, 0x2814, 
    0x300C, 0x2004, 0x4002, 0x7FFE},

    {0x7FFE, 0x7FFE, 0x3FFC, 0x3FFC, 
    0x2FF4, 0x27E4, 0x23C4, 0x23C4, 
    0x2244, 0x2244, 0x2424, 0x2814, 
    0x300C, 0x2004, 0x4002, 0x7FFE},
};

static int curindex = -1;

percentdone(percent)
float percent;
{
    int index; 

    if (percent > 99.0) {
	setcursor(0,0xfff,0xfff);
	curindex = -1;
    } else {
	index = percent*NCURSORS/100.0;
	if (index<0)
	    index = 0;
	if (index>=NCURSORS)
	    index = NCURSORS-1;
	if (index != curindex) {
	    defcursor(20,curtab[index]);
	    curorigin(20,7,7);
	    setcursor(20,0xfff,0xfff);
	    curindex = index;
	}
    }
}

dosystem(name)
char *name;
{
    percentdone(30.0);
    system(name);
    percentdone(100.0);
}
