# define QUIRK

# define PROMSTATIC
# define INTERNAL	/* static */ /* due to a C optimizer bug */

# ifndef QUIRK
# define MAKEREADY(x)
# define MAKENOTREADY(x)
# endif  QUIRK

# include "pmII.h"
# define NBBY	8

# include "nx.h"
# define NSTATS	8
#include "Qglobals.h"
#include "Qdevices.h"
#include "Xns.h"	

# undef  DEBUG do_debug
# include "dprintf.h"


#define	NREADS	1		/* max buffers tied up waiting for input */

char nxpresent;			/* zero if interface not answering */
char	*PortA,			/* Virtual Address of Controller A port */
	*PortB;			/* Virtual Address of Controller B port */

char		*readdatabuf;	/* nxread's data buffer */
NxReply		*readreply;	/* nxread's reply message */
struct stats_reply *statsbuf;
struct request	*readrequest;
char		*writedatabuf;	/* nxwrite's data buffer		*/

long nxva;			/* virtual address of multibus area */
long nxpa;			/* physical address of multibus area */
long nxvseg;			/* upper 12 bits of nxva - used by HTOX */

struct mqueues *nxmq;		/* points to message queues */
struct msgbuf *lastrmp;		/* oldest read queue pointer */
struct physnet myaddr;		/* my physical network addr */

Xhost MyHostAddress;

short nx_loopback;


nxintr()
{
    register READ		rmp;
    register struct request	*request;

    *PortA = (char)1;				/* clear the interrupt     */

    while( (rmp = (READ)lastrmp) ->status == HOST_IDLE )
    {
        request = (struct request *)rmp->id;	/* retrieve user's struct */

	if( request->replymsg != 0 )
	    *request->replymsg = *(NxReply *)rmp;
	request->complete = 1;
	if( rmp->request == NET_READ )
	{
	    MAKEREADY(FROMENET);	/* indicate a packet was received */
	}
dprintf((" nxintr id $%x req %d",request,rmp->request));

	rmp->length = MSGLEN;
	rmp->id = 0;
	rmp->status = NX_BUSY;		/* free this msg buffer */

	lastrmp = ((MP)rmp)->next;
    }
}

/*
 * InitEnet() is init function which interfaces to Quirk kernel.
 * 	Return 0 if we fail to start the device for any reason
 *	Return 1 if we succeed at everything
 */
short DidInitEnet;
int
InitEnet()
{
    if( DidInitEnet )
	return 1;

    if( nxinit() )
    {
	MyHostAddress = *(Xhost *) &myaddr;
	readenable();
	MAKEREADY(TOENET);
	MAKENOTREADY(FROMENET);
	DidInitEnet++;
    }

    return DidInitEnet;
}


int
nxinit()
{
# include "m68vectors.h"

    extern int level2int();

    if( !nxprobe() )
	return 0;

    *EVEC_LEVEL2 = (long)level2int;

    /* Allocate space for msg buffers, read buffer and write buffer */
    if( !nxmalloc() )
    {
	printf("nxfirst: nxmalloc failed\n");
	return 0;
    }

    /* initialize the message queues and enable the controller */
    if( !nxconfig() )
	return 0;

    if( nxmode(CONNECT_TO_NET) == 0 )
	return 0;

    if( getslot(253, &myaddr) == 0 )	/* read our address */
	return 0;

    nxpresent = 1;
    return 1;
}

/*
 * See if the board is presnet and record result in nxpresent.
 * Set up interrupt vector.
 */
int
nxprobe()
{
    register char *rp;

    nxpresent = 0;

    /*
     * See if interface is present.
     * Reading Port A resets the board (probebyte(adr) reads from adr).
     */
    rp = 0;
    if( probe((char *)mbiotov(nx_ioaddr+PORTA_OFF),1) )
	rp = (char *)mbiotov(nx_ioaddr);
    else
    if( probe((char *)mbiotov(nx_OLDioaddr+PORTA_OFF),1) )
	rp = (char *)mbiotov(nx_OLDioaddr);
    if( rp == 0 )
    {
	printf("No ethernet\n");
	return 0;
    }

    PortA = rp+PORTA_OFF;
    PortB = rp+PORTB_OFF;

dprintf(("PortA = $%x B = $%x\n",PortA,PortB));
    /*
     * Test status after board reset. (probing PortA above did the reset)
     * If the Nx101 fails to respond to the reset, indicate non-presence
     * (we might want this to be a third category of response instead)
     */
    if( !buzzon(PortB,NX_ERROR_,0,400000L) )
    {
	printf("nxprobe failed\n");
	return 0;
    }

    return 1;
}

/*
 * Allocate multibus memory for operating the dma and message queues.
 * Leave the virtual address and physical multibus address as side-effects
 * in global variables nxva and nxpa.
 */

struct system_buffers {
    char		readbuffer[MAXPACKET],
    			writebuffer[MAXPACKET];
    NxReply		readreplybuffer;
    struct request	readreqbuffer;
    struct stats_reply	statsbuffer;
};

nxmalloc()
{
    extern char *gmalloc();

    register struct system_buffers *sp;
    register struct mqueues *mq;
               
    /* 
     * allocate space for the system buffers on the multibus,
     * then initialize the fixed global pointers into this area
     */
    if( readdatabuf == 0 )
    {
	sp = (struct system_buffers *)gmalloc(sizeof *sp);
	if( sp == 0 )
	    return 0;

	readdatabuf = sp->readbuffer;
	readreply = &sp->readreplybuffer;
	readrequest = &sp->readreqbuffer;
	writedatabuf = sp->writebuffer;
	statsbuf = &sp->statsbuffer;
    }

    /* 
     * allocate space for the host-controller message queues
     */
    if( nxmq == 0 )
    {
	nxmq = (struct mqueues *)gmalloc(sizeof *nxmq);
	if( nxmq == 0 )
	    return 0;
	nxva = (long)nxmq;
	nxpa = vtop(nxva);
	nxvseg = (long)nxva & (~0xffff);	/* used by HTOX() */

	mq = nxmq;
	mq->roffset = HTOX(mq->rbufs);
	mq->woffset = HTOX(mq->wbufs);
	lastrmp = mq->rbufs;
	mq->rhead = mq->rbufs;
	mq->whead = mq->wbufs;

	linkbufs(mq->rbufs,NRBUFS,NX_BUSY);
	linkbufs(mq->wbufs,NWBUFS,HOST_IDLE);
    }

    return 1;		
}

INTERNAL
linkbufs(bp,n,status)
    struct msgbuf *bp;
    int n;
    int status;
{
    register struct msgbuf *l,*p;

    /*
     * intialize the list of host-to-exos buffers message buffers
     */
    p = bp;
    l = p+n-1;
    while( --n >= 0 )
    {
	l->next = p;
	l->msg.link = HTOX(p);
	l->msg.length = MSGLEN;
	l->msg.status = status;
	l = p;
	p++;
    }
}

/*
 * Set up the host/controller queues and netbuf array.
 * Construct initialization message and send it.
 */
INTERNAL
struct testp testp = { 0x01,0x03,0x07,0x0F, 0x0103,0x070F, 0x0103070F };
INTERNAL
nxconfig()
{
    register struct init *im;

    /*
     * construct initialization (configuration) message.
     */
    im = (struct init *)readdatabuf;
    bzero((char *)im,sizeof *im);
    im->res0 = 1;		/* indicate this is a v1.4 init message */
    im->format[0] = im->format[1] = 1;/* use testp (below) */
    im->amode =3;		/* change to absolute addressing */

    *(struct testp *)im->mmap = testp;

    im->naddr = 0xff;
    im->nproc = 0xff;
    im->nmbox = 0xff;
    im->nhost = 1;

    im->hxitype = im->xhitype = 3;	/* use level interrupts */
    im->mvblk = 0xFFFFFFFF;

    im->hxseg = vtop(nxvseg);
    im->hxhead = (int)&nxmq->woffset - nxvseg;

    im->xhseg = vtop(nxvseg);
    im->xhhead = (int)&nxmq->roffset - nxvseg;

# ifdef BUG1
    im->res1[0] = 1;
# endif BUG1
    /*
     * calculate the physical dma address of the initialization message
     * and pass it to controller.
     *
     * Exos version 1.4 requires that a disallowed address be
     * sent first for synchronization (0xffff0000).  Valid addresses
     * must have high byte == 0 (24 bits is maximum phys address)
     */
    sendlong((long)0x0000FFFF);
    sendlong((long)vtop(im));

    im->code = 0xff;
    if( !buzzon(&im->code,0xFF,0xFF,10000L) )
    {
	printf("nxqsetup: timeout\n");
	return 0;
    }
    if( im->code != 0 )
    {
	printf("Ethernet init error $%x\n",(unsigned char)im->code);
	return 0;
    }

    return 1;
}


/* 
 * nxmode - set the mode of the Execelan interface
 */
nxmode(newmode)
{
    register MODE modemsg;

    modemsg = (MODE)getmsgbuf();	/* get a message buffer */

    /* Fill in the message buffer */
    modemsg->request = NET_MODE;
    modemsg->reqmask = WRITEREQ;
    modemsg->mode = newmode;

    return nxwaitreq(modemsg,0);
}

/*
 * getslot - read back the board's ethernet address
 */
int
getslot(slotno, a)
struct physnet *a;
{
    register ADDRS adrmsg;
    NxReply U;

    adrmsg = (ADDRS) getmsgbuf();

    adrmsg->request = NET_ADDRS;
    adrmsg->reqmask = READREQ;
    adrmsg->slot = slotno;

    if( !nxwaitreq(adrmsg,&U) )
    {
	printf("getslot: timeout\n");
	return 0;
    }

    *a = ((ADDRS)&U)->addr;
    return 1;
}

/*
 * nxstats() - returns all the network statistics to the user's buffer.
 * 		The stats are 8 longwords: 32 bytes.
 */
nxstats(usrbuf)
    struct stats_reply *usrbuf;
{
    register STATS		statmsg;

    statmsg = (STATS) getmsgbuf();

    statmsg->request = NET_STATS;
    statmsg->reqmask = READREQ | WRITEREQ;	/* read and reset stats */
    statmsg->index = 0;				/* start at beginning */
    statmsg->nobj = NSTATS;			/* read all stats */
    statmsg->baddr = (long)vtop(statsbuf);

    if( !nxwaitreq(statmsg,0) ) {
	printf("nxstats: timeout\n");
	return 0;
    }

    *usrbuf = *statsbuf;
    return 1;
}

ResetExcelan() {
    if (PortA != 0)
	probe(PortA,1);
}


int readenabled;

readenable()
{
    extern struct request *readrequest;
    extern NxReply *readreply;
    extern char *readdatabuf;
    register READ readmsg;

    if(readenabled)
	return;
    readenabled++;

    readmsg = (READ)getmsgbuf();

    readmsg->request = NET_READ;
    readmsg->nblocks = 1;
    readmsg->block[0].len = MAXPACKET;
    readmsg->block[0].addr = vtop(readdatabuf);

    sendreq(readrequest,readmsg,readreply);
}


int
ReadFromEnet()
{
    if( !readrequest->complete )
	return 0;

    readenabled = 0;
    MAKENOTREADY(FROMENET);
    return ((READ)readreply)->block[0].len;
}

WriteToEnet(buf, bytes)
register char	*buf;
register int	bytes;
{
    extern char *writedatabuf;
    register XMIT writemsg;

    writemsg = (XMIT)getmsgbuf();

    bcopy(buf, writedatabuf, bytes);	/* copy user's data into system buf */

    if (nx_loopback)
        writemsg->request = NET_XMIT_LOOP;
    else
        writemsg->request = NET_XMIT;

    writemsg->nblocks = 1;
    writemsg->block[0].len = bytes;
    writemsg->block[0].addr = (long)vtop(writedatabuf);

    return nxwaitreq(writemsg,0);
}    


/*
 * Utility routines and initialization code
 * for Excelan interface.
 */
/*
 * Locate next host-to-exos msgbuf.
 * Return 0 if none available.
 * status byte interpretation:
 *	3 - is busy and owned by exos
 *	2 - is busy and owned by host
 *	1 - is not busy but owned by exos
 *	0 - is available
 */
INTERNAL
MP igetmsgbuf()
{
    register i;
    register MP mp;
    register int oldpri;

    oldpri = spl7();

    mp = (MP)XTOH(nxmq->woffset);

    for( i = NWBUFS; --i >= 0; mp = mp->next )
	if( mp->msg.status == HOST_IDLE )
	{
	    mp->msg.status = HOST_BUSY;
	    mp->msg.res = 0;
	    splx(oldpri);

	    bzero(&mp->msg.pad,MSGLEN);
	    return(mp);
	}

    splx(oldpri);
    return 0;
}



/*
 * Obtain a host-to-exos msgbuf.
 * Wait if necessary to get one.
 */
INTERNAL
MP getmsgbuf()
{
    register MP mp;
    register timer;

    for( timer = 50; --timer >= 0; )
	if( (mp = igetmsgbuf()) != 0 )
	    return(mp);

    panic("getmsgbuf failed\n");
}

INTERNAL
sendlong(n)
    long n;
{
    register int i;

    for( i = sizeof (long); --i >= 0; )
    {
	while( *PortB & NX_READY_ )
	    ;
	*PortB = (char)n;
	n >>= NBBY;
    }
}

INTERNAL int
nxwaitreq(nxp,reply)
    register NxMsg *nxp;
    NxReply *reply;
{
    struct request R;

    sendreq(&R,nxp,reply);

    if( !buzzon(&R.complete,0xFF,0,100000L) )
    {
	printf("nxwaitreq: timeout\n");
	return 0;
    }

    return 1;
}

INTERNAL
sendreq(rp,nxp,reply)
    register struct request *rp;
    register NxMsg *nxp;
    NxReply *reply;
{
    rp->msg = nxp;
    rp->replymsg = reply;
    rp->complete = 0;

    nxp->id = (long)rp;
    nxp->status = NX_BUSY;
    *PortB = 0;
}

/*
 * buzzon() --
 * wait for the given condition to change,
 * up to N iterations.
 * this "should" be changed to use msdelay().
 */
INTERNAL int
buzzon(cp,mask,val,n)
    register unsigned char *cp;
    int mask,val;
    long n;
{
    while( --n != 0 )
	if( (*cp&mask) != val )
	    return 1;

    return 0;
}
