#ifndef	NSIG
/* @(#)signal.h	1.1 */

#define	NSIG	32

#define	SIGHUP	1	/* hangup */
#define	SIGINT	2	/* interrupt (rubout) */
#define	SIGQUIT	3	/* quit (ASCII FS) */
#define	SIGILL	4	/* illegal instruction (not reset when caught)*/
#define	SIGTRAP	5	/* trace trap (not reset when caught) */
#define	SIGIOT	6	/* IOT instruction */
#define	SIGEMT	7	/* EMT instruction */
#define	SIGFPE	8	/* floating point exception */
#define	SIGKILL	9	/* kill (cannot be caught or ignored) */
#define	SIGBUS	10	/* bus error */
#define	SIGSEGV	11	/* segmentation violation */
#define	SIGSYS	12	/* bad argument to system call */
#define	SIGPIPE	13	/* write on a pipe with no one to read it */
#define	SIGALRM	14	/* alarm clock */
#define	SIGTERM	15	/* software termination signal from kill */
#define	SIGUSR1	16	/* user defined signal 1 */
#define	SIGUSR2	17	/* user defined signal 2 */
#define	SIGCLD	18	/* death of a child */
#define	SIGCHLD	18	/*   for 4.2 fans */
#define	SIGPWR	19	/* power-fail restart */

/* 4.2 signals */
#define SIGWINCH 25	/* window size changes */
#define	SIGIO	26	/* input/output possible signal */
#define	SIGURG	27	/* urgent condition on IO channel */

/* 5.3 streams signals */
#define SIGPOLL	28

#define	SIG_DFL	(int (*)())0
#if lint
#define	SIG_IGN	(int (*)())0
#else
#define	SIG_IGN	(int (*)())1
#endif

#endif	NSIG
