/* controller commands */
struct	dkerror sii_cmds[] = {
	/* disk commands */
	{ 0x74, "read headers" },
	{ 0x81,	"read" },
	{ 0x82,	"write" },
	{ 0x83,	"verify" },
	{ 0x87,	"initialize" },
	{ 0x89,	"restore" },
	{ 0x8A,	"seek" },
	{ 0x8F,	"reset" },
	{ 0x93,	"read absolute" },
	{ 0x94,	"read non-cached" },
	{ 0x95,	"read logical sector" },
	{ 0x96,	"write logical sector" },
	{ 0x97,	"verify logical sector" },
	/* tape commands */
	{ 0xA0,	"retention the tape" },
	{ 0xA1, "read tape" },
	{ 0xA2, "write tape" },
	{ 0xA3, "verify tape" },
	{ 0xA4, "erase tape" },
	{ 0xA5, "write file mark" },
	{ 0xA6, "report tape status" },
	{ 0xA7, "configure tape" },
	{ 0xA9, "rewind tape" },
	{ 0xAA, "read file marks" },
	{ 0xAB, "seek tape blocks" },
	{ 0xAC, "command pass/tape drive" },
};
short	sii_ncmds = (sizeof(sii_cmds) / sizeof(struct dkerror));

/* error list */
struct	dkerror sii_errs[] = {
	{ 0x01,	"end of tape encountered during copy command" },
	{ 0x02,	"file mark encountered" },
#define	SIIERR_FILEMARK		0x02
	{ 0x10,	"disk not ready" },
	{ 0x11,	"invalid disk unit address" },
	{ 0x12,	"seek error" },
	{ 0x13,	"data field ecc/crc error" },
	{ 0x14,	"invalid command code" },
	{ 0x15,	"invalid cylinder address in iopb" },
	{ 0x16,	"invalid sector number in iopb" },
	{ 0x18,	"bus timeout error" },
	{ 0x1A,	"disk write protected" },
	{ 0x1B,	"disk not selected" },
	{ 0x1C,	"no address mark in header field" },
	{ 0x1D,	"no address mark in data field" },
	{ 0x1E,	"drive faulted" },
	{ 0x20,	"disk surface overrun" },
	{ 0x21,	"id field error, wrong sector" },
	{ 0x22,	"crc error in id field" },
	{ 0x23,	"uncorrectable data error" },
	{ 0x26,	"missing sector pulse" },
	{ 0x27,	"format timeout" },
	{ 0x28,	"no index pulse during format" },
	{ 0x29,	"sector not found" },
	{ 0x2A,	"id field error, wrong head" },
	{ 0x2D,	"seek timeout" },
	{ 0x2F,	"not on cylinder" },
	{ 0x30,	"restore/recalibrate timeout" },
	{ 0x40,	"unit not initialized" },
	{ 0x42,	"gap specification error" },
	{ 0x4C,	"mapped header error" },
	{ 0x50,	"sectors per track specification error" },
	{ 0x51,	"bytes per sector specification error" },
	{ 0x52,	"interleave factor specification error" },
	{ 0x53,	"invalid head number in iopb" },
	{ 0x60,	"protection timeout error" },
	{ 0x61,	"maximum cylinder number specification error" },
	{ 0x62,	"number of heads specification error" },
	{ 0x63,	"step pulse specification error" },
	{ 0x64,	"reserved byte specification error" },
	{ 0x65,	"ram failure on odd byte" },
	{ 0x66,	"ram failure on even byte" },
	{ 0x67,	"event ram failure" },
	{ 0x68,	"device not previously recalibrated" },
	{ 0x69,	"controller error" },
	{ 0x6A,	"invalid sector number" },
	{ 0x6B,	"timer failure" },
	{ 0x6C,	"rom failure on odd byte" },
	{ 0x6D,	"rom failure on even byte" },
	{ 0x80,	"tape drive not selected" },
	{ 0x81,	"tape drive not ready" },
#define	SIIERR_TAPENOTREADY	0x81
	{ 0x82,	"tape drive not online" },
	{ 0x83,	"cartridge not in place" },
	{ 0x84,	"unexpected beginning of tape" },
	{ 0x85,	"unexpected end of tape" },
	{ 0x86,	"unexpected file mark encountered" },
#define	SIIERR_PREMATURE_EOF	0x86
	{ 0x87,	"unrecoverable data error" },
	{ 0x88,	"block in error not located" },
	{ 0x89,	"no data detected" },
	{ 0x8A,	"write protected" },
	{ 0x8B,	"illegal command" },
	{ 0x8C,	"command sequence timeout" },
	{ 0x8D,	"status sequence timeout" },
#define	SIIERR_STATUSTIMEOUT	0x8D
	{ 0x8E,	"data block transfer timeout" },
	{ 0x8F,	"filemark search timeout" },
	{ 0x90,	"unexpected exception" },
	{ 0x91,	"invalid tape unit address" },
	{ 0x92,	"ready timeout" },
	{ 0x93,	"tape timeout specification error" },
	{ 0x94,	"invalid block count" },
};
short	sii_nerrs = (sizeof(sii_errs) / sizeof(struct dkerror));
