/*
 * Miscellaneous definitions for lint
 *
 * $Source: /d2/3.7/src/sys/pmII/RCS/Locore.c,v $
 * $Revision: 1.1 $
 * $Date: 89/03/27 17:33:26 $
 */

/*LINTLIBRARY*/

#include "../h/param.h"
#include "../h/dir.h"
#include "../h/user.h"
#include "../h/proc.h"
#include "../h/dk.h"
#include "../h/buf.h"
#include "../h/mount.h"
#include "../vm/vm.h"
#include "../h/utsname.h"
#include "../pmII/frame.h"
#include "../pmII/reg.h"
#include "../pmII/pte.h"
#include "../pmII/trap.h"
#include "../multibus/mbvar.h"

/* XXX get rid of me */
/* fill in gpib stuff not being used (RAWIB gunk) */
#include "ib.h"
#if NIB > 0
#include "../h/ib_ioctl.h"
#include "../gpib/ib_ieee.h"
#include "../gpib/ib_reg.h"
#include "../gpib/ib.defs"
#include "../gpib/ib_dbg.h"
#endif

/* fill in tcp refrences from tcp library */
#include "ex.h"
#if NEX > 0
struct	mb_driver exdriver;
#endif
int	sok_dev, ptc_dev;

/* gl2 graphics refrences */
#ifdef	GL2

#undef	imin
#undef	imax

#include <gl2/gl.h>
#include <gl2/device.h>
#include <gl2/gltypes.h>
#include <gl2/window.h>
#include <gl2/shmem.h>
#include <gl2/mouse.h>

int	gr_shmempte();
long	gr_setshmem();
struct	shmem *gr_getshmem();
#endif

/* things defined in locore.c or param.c or vers.c or ioconf.c */
struct	user u, pushutl, forkutl, xswap2utl, swaputl, xswaputl;
struct	pte usrpt[1];
char	debug_stack[1];
struct	utsname utsname;
struct	inode *acctp;
struct	sem_undo *sem_undo[1];
int	hz;
char	version[];
char	sgiversion[];
extern	long prom_mouseintr;

/* things defined by the loader */
int	etext;
int	end;

/* things refrenced here, and used in libraries only */
void	sushort();

/* macros to set and refrence variables/arrays */
#define	SR(abc)		abc = 0; x = (int)abc
#define	SRA(abc)	abc[0] = abc[1]
#define	R(abc)		(abc) = (abc)

start()
{
	int x;
	struct frame aframe;

	x = spl0();
	x = spl1();
	x = spl2();
	x = spl3();
	x = spl4();
	x = spl5();
	x = spl6();
	x = spl7();
	splx(x);

	start();
	mmuinit(0);
	premain();
	main();
	nullsys();
	bcopy((caddr_t)0, (caddr_t)0, 0);
	bzero((caddr_t)0, 0);

	duintr_both();
	duinit();
	x = kbgetchar();
	x = kbpeekchar();
	kb_putc(x);
	dial_putc((short)x);
	serial_ints(0, 0);

	hardclock((long)0, (long)0);
	softclock();
	trap(0, aframe);
	syscall(aframe);
	x = buserror(aframe);
	addresserror(aframe);

	kern_debug("die you gravy sucking pig");
	debug_stack[0] = 23; x = debug_stack[0];
	R(prom_mouseintr);
	ARS(dk_seek);
	ARS(dk_mspw);
#if NDEBUG > 0
	calldebug("foo");
#endif

#if NEX > 0
	x = passc(x);
	x = ptc_dev;
	x= sok_dev;
#endif
#if NIB > 0
	tlcrun((struct tlc *)0);
	ibropen((dev_t)0, 0);
	ibrclose((dev_t)0);
	ibrread((dev_t)0);
	ibrwrite((dev_t)0);
	ibrstrat((struct buf *)0);
#endif

#ifdef	GL2
{
	struct inputchan *gr_getgrhandle();
	struct inputchan *grhand;
	/*
	 * This refrences all the gl2 kgl stuff in unix_gr.c
	 */
	gr_coredump();
	x = gr_freepages();
	x = gr_txport();
	x = gr_shmempte();
	x = gr_lockmem((unsigned)0, (long)0);
	x = gr_getoshandle();
	grhand = gr_getgrhandle((struct proc *)0);
	R(grhand);
	gr_setgrhandle((struct proc *)0, (long)0);
	x = (int)gr_setshmem((struct proc *)0);
	gr_restoreshmem((long)0);
	gr_sleep((struct proc *)0, (long)0);
	gr_wakeup((struct proc *)0, (long)0);
	x = gr_systype();
	x = (int)gr_getshmem();
	sushort((struct proc *)0, (caddr_t)0, (short)0);
	gr_os_stopproc((struct proc *)0);
	gr_kill((struct proc *)0);
	sustuff((struct proc *)0, (caddr_t)0, (short)0, (short *)0);
	x = kb_issoft();
	win_softintr((short)0, (short)0, (char)0);
	mouse_check((struct mouse *)0);

	/*
	 * This section sets and refrences all the variables defined in the
	 * header files that the kernel uses.
	 */
	/* these are arrays */
	SRA(txport); SRA(gfport); SRA(inchan);
	SRA(piece); SRA(gl_buttons); SRA(gl_valuators);
	SRA(gl_RetraceEvents);

	/* these are simple variables */
	SR(gl_shmemptr); SR(gl_kernelshmemptr); SR(gefound); SR(gemask);
	SR(gl_gestatus); SR(gl_fbcstatus); SR(gl_fbcversion);
	SR(gl_softkeyboard); SR(gl_textportno); SR(gl_curric); SR(gl_useric);
	SR(gl_needtodoswaps); SR(gl_didswap); SR(gl_piecefreelist);
	SR(gl_origfbaddr); SR(gl_origfbcount); SR(gl_fbaddr); SR(gl_fbcount);
	SR(gl_fbwn); SR(gl_lock); SR(gl_gfport); SR(gl_wmport);
	SR(gl_wmbutton);
	SR(gl_cursorxvaluator); SR(gl_cursoryvaluator);
	SR(gl_cursorx); SR(gl_cursory); SR(gl_cursorxorgin);
	SR(gl_cursoryorgin); SR(gl_cursormoved); SR(gl_cursordrawn);
	SR(gl_autocursor); SR(gl_vpoffsetx); SR(gl_vpoffsety);
	SR(gl_kwritemask); SR(gl_userwritemask); SR(gl_kdbwritemask);
	SR(gl_userdbwritemask); SR(gl_SwapCount); SR(gl_MaxSwapInterval);
	SR(gl_cfr); SR(gl_dcr); SR(gl_displayab);
	SR(gl_blankmode); SR(gl_isblanked); SR(gl_framecount);
	SR(gl_lastupdate); SR(gl_kbdstate); SR(gl_numdoublebufferers);
	SR(gl_numrgbers); SR(gl_cursorconfig); SR(gl_cursorcolor);
	SR(gl_rcursorcolor); SR(gl_gcursorcolor); SR(gl_bcursorcolor);
	SR(gl_cursorwenable); SR(gl_rcursorwenable); SR(gl_gcursorwenable);
	SR(gl_bcursorwenable); SR(gl_cursoraddr);
}
#endif

#ifdef	KOPT_NOGL
	fprintf(main, "hi mom\n");
#endif
}

/* LINTLIBRARY */

/* locore/sed utilities */
int spl0() { return (0); }

int spl1() { return (0); }

int spl5() { return (0); }

int spl6() { return (0); }

int spl7() { return (0); }

int splx(i) int i; { i = i; return (0); }

long swapw(l) long l; { return (l); }

#ifdef	GL2
/*
 * Definitions for libkgl2.a routines
 */

	/*VARARGS1 PRINTFLIKE1*/
int	iprintf(s)	char *s; { return (0); }
	/*VARARGS1 PRINTFLIKE1*/
int	printf(s)	char *s; { return (0); }
	/*VARARGS1 PRINTFLIKE1*/
int	uprintf(s)	char *s; { return (0); }
	/*VARARGS2 PRINTFLIKE2*/
int	fprintf(f, s)	int (*f)(); char *s; { return (0); }
	/*VARARGS2 PRINTFLIKE2*/
int	sprintf(p, s)	char *p, *s; { return (0); }
#endif

#include "efs.h"
#include "efs2.h"
#if NEFS > 0 || NEFS2 > 0
/*
 * Definitions for bitmap operators, usually contained in locore.c
 */

int	bset(bp, b)	char *bp; int b;
	{ *bp = b; }
int	bclr(bp, b)	char *bp; int b;
	{ *bp = b; }
int	btst(bp, b)	char *bp; int b;
	{ *bp = b; return (b); }
int	bfset(bp, b, len)	char *bp; int b, len;
	{ *bp = b + len; }
int	bfclr(bp, b, len)	char *bp; int b, len;
	{ *bp = b + len; }
int	bftstset(bp, b, len)	char *bp; int b, len;
	{ *bp = b + len; return (0); }
int	bftstclr(bp, b, len)	char *bp; int b, len;
	{ *bp = b + len; return (0); }
#endif
