/* Stream configuration
 *
 *	These structures are generated by the 3B2 boot-time link-loader.
 *	We must do it statically.
 *
 * $Source: /d2/3.7/src/sys/streams/RCS/strconf.c,v $
 * $Revision: 1.1 $
 * $Date: 89/03/27 17:34:51 $
 */

#include "../h/types.h"
#include "../h/conf.h"
#define STREAM_DEF
#include "../streams/stream.h"
#include "../streams/strcomp.h"
#include "cypress.h"
#include "sgigsc.h"


struct val v = {NBLK4096,NBLK2048,NBLK1024,NBLK512,
	NBLK256,NBLK128,NBLK64,NBLK16,NBLK4};

#define TOT_NBLK (NBLK4096+NBLK2048+NBLK1024+NBLK512+NBLK256+NBLK128 \
		  +NBLK64+NBLK16+NBLK4)

#define TOT_MBLK ((3*TOT_NBLK)/2)
int nmblock = TOT_MBLK;
mblk_t mblock[TOT_MBLK];

dblk_t dblock[TOT_NBLK];

struct linkblk linkblk[NMUXLINK];
int nmuxlink = NMUXLINK;
int nstrpush = NSTRPUSH;
struct strevent strevent[NSTREVENT];
int nstrevent = NSTREVENT;
int maxsepgcnt = MAXSEPGCNT;
int strmsgsz = STRMSGSZ;
int strctlsz = STRCTLSZ;


extern struct streamtab stty_ldinfo;
#if NCYPRESS > 0
extern struct streamtab if_cyinfo;
#endif
#if NSGIGSC > 0
extern struct streamtab hack_info;
#endif
struct fmodsw fmodsw[] = {
	{"stty_ld", &stty_ldinfo},
#if NCYPRESS > 0
	{"if_cy", &if_cyinfo},
#endif
#if NSGIGSC > 0
	{"hack", &hack_info},
#endif
};
int fmodcnt = (sizeof(fmodsw)/sizeof(fmodsw[0]));
