(*****************************************************************************)
(*                                                                           *)
(*                             File: FLIBFW.TEXT                             *)
(*                                                                           *)
(*           (C) Copyright 1982, 1985 Silicon Valley Software, Inc.          *)
(*                                                                           *)
(*                            All Rights Reserved.               29-May-85   *)
(*                                                                           *)
(*****************************************************************************)


{$%+} {$R-} {$I-}

unit %flibfw;

interface

uses {$u flibinit} %flibinit,
     {$u flibrec}  %flibrec,
     {$u flibfmt}  %flibfmt;

implementation

procedure %_wrfch(fpac: ppac; paclen: longint);
  var lpaclen,i,lval: integer; hexptr: pint1array;
begin {%_wrfch}
%getfmt; 
if edlet = 'A'
then %%wrfch(fpac,paclen)
else
  if edlet = 'Z'
  then begin {Write a character under 'Z' format}
    if not EdwPresent then edw := paclen*2;
    moveleft(fpac,hexptr,4);
    %putblanks(edw - paclen*2);
    if edw < paclen*2 then lpaclen := edw else lpaclen := paclen*2;
    for i := 2 to lpaclen + 1 do begin
      lval := hexptr^[i div 2];
      if odd(i) then %puthex(lval and $F) else %puthex((lval and $F0) div 16);
      end;
    end
  else %error(46);
end; {%_wrfch}


{ Write an integer }

procedure %%wrfi(fint: int4);
  var buf: packed array[1..10] of char; i, col, colcnt: integer;
      Signed: Boolean; signch: char;
begin {%%wrfi}
if edlet <> 'I' then %error(41);
Signed := TRUE; { Unless otherwise discovered }
if fint = -2147483648
then begin signch := '-'; buf := '2147483648'; col := 0; end
else begin
  if fint < 0 
  then begin fint := - fint; signch := '-'; end
  else 
    if PrintOptionalPlus then signch := '+' else Signed := FALSE;
  col := 10; buf := '          ';
  if (edm = 0) and (fint = 0)
  then Signed := FALSE { Even if PrintOptionalPlus }
  else 
    repeat
      buf[col] := chr((fint mod 10) + ord('0'));
      fint := fint div 10; col := col - 1;
    until fint = 0;
  end;
if edm > (10 - col) then colcnt := edm else colcnt := 10 - col;
if Signed then colcnt := colcnt + 1;
if colcnt > edw 
then %putstars
else begin
  %putblanks(edw - colcnt);
  if Signed then %putch(signch);
  for i := 10 - col to edm - 1 do
    %putch('0');
  for i := col + 1 to 10 do
    %putch(buf[I]);
  end;
end; {%%wrfi}

procedure %_wrfi4(fint: int4);
begin
%getfmt;
if AorZFlag then %%wrfch(@fint,4) else %%wrfi(fint);
end; {%_wrfi4}

procedure %_wrfi2(fint: int2);
begin {%_wrfi2}
%getfmt;
if AorZFlag then %%wrfch(@fint,2) else %%wrfi(fint);
end; {%_wrfi2}

procedure %_wrfi1(fint: int1);
begin {%_wrfi1}
%getfmt;
if AorZFlag then %%wrfch(@fint,1) else %%wrfi(fint);
end; {%_wrfi1}


{ Write a logical }

procedure %%wrfl(flog: int4);
begin {%%wrfl}
if edlet <> 'L' then %error(45);
%putblanks(edw - 1);
if flog = 0 then %putch('F') else %putch('T');
end; {%%wrfl}

procedure %_wrfl4(flog: int4);
begin {%_wrfl4}
%getfmt;
if AorZFlag then %%wrfch(@flog,4) else %%wrfl(flog);
end; {%_wrfl4}

procedure %_wrfl2(flog: int2);
begin {%_wrfl2}
%getfmt;
if AorZFlag then %%wrfch(@flog,2) else %%wrfl(flog);
end; {%_wrfl2}

procedure %_wrfl1(flog: int1);
begin {%_wrfl1}
%getfmt;
if AorZFlag then %%wrfch(@flog,1) else %%wrfl(flog);
end; {%_wrfl1}

procedure %_wafi4(var fintarray: int4array; count: int4);
  var ctr: longint;
begin {%_wafi4}
for ctr := 1 to count do
  %_wrfi4(fintarray[ctr]);
end; {%_wafi4}

procedure %_wafi2(var fintarray: int2array; count: int4);
  var ctr: longint;
begin {%_wafi2}
for ctr := 1 to count do
  %_wrfi2(fintarray[ctr]);
end; {%_wafi2}

procedure %_wafi1(var fintarray: int1array; count: int4);
  var ctr: longint;
begin {%_wafi1}
for ctr := 1 to count do
  %_wrfi1(fintarray[ctr]);
end; {%_wafi1}

procedure %_wafl4(var flogarray: int4array; count: int4);
  var ctr: longint;
begin {%_wafl4}
for ctr := 1 to count do
  %_wrfl4(flogarray[ctr]);
end; {%_wafl4}

procedure %_wafl2(var flogarray: int2array; count: int4);
  var ctr: longint;
begin {%_wafl2}
for ctr := 1 to count do
  %_wrfl2(flogarray[ctr]);
end; {%_wafl2}

procedure %_wafl1(var flogarray: int1array; count: int4);
  var ctr: longint;
begin {%_wafl1}
for ctr := 1 to count do
  %_wrfl1(flogarray[ctr]);
end; {%_wafl1}

procedure %_wafch(fpac: pbyte; paclen: longint; count: int4);
  var lpaclen,i: integer; ctr: longint; p: ppac;
begin {%_wafch}
p := pointer(ord(fpac));
for ctr := 0 to count - 1 do begin
  %getfmt; if edlet <> 'A' then %error(46);
  if not EdwPresent then edw := paclen;
  %putblanks(edw - paclen);
  if edw < paclen then lpaclen := edw else lpaclen := paclen;
  for i := 1 to lpaclen do
    %putch(p^[i]);
  p := pointer(ord(p) + paclen);
  end;
end; {%_wafch}


end. {%flibfw}

                                                                                                                                                                                                   