; File: paspwr10.text
; Date: 17-Jun-85

        ident   paspwr10
        
        global  %_PWR10

;
; %_PWR10 - Power of Ten: returns 10 ^ i, 0 <= i <= 38
;           If i < 0, returns 0, if i > 38 returns +inf
;
; Parameters: ST.W - Integer
;
; Returns:    F1.S - Result
;
; Scratches: D0
;

%_PWR10
        move.l  a0,-(sp)
        move.w  8(sp),d0
        bmi.s   pwr_zer         ; < 0 --> Return 0
        cmp.w   #38,d0
        bgt.s   pwr_inf         ; > 38 --> return +inf
        lsl.w   #2,d0
        lea     tentbl,a0
        move.l  0(a0,d0.w),d0
pwr_rtn move.l  (sp)+,a0
        move.l  (sp),2(sp)
        addq.w  #2,sp
        move.l  d0,$8110.w      ; J_MOVEF D0,F1
        rts
pwr_zer clr.l   d0
        bra.s   pwr_rtn
pwr_inf move.l  #$7f800000,d0
        bra.s   pwr_rtn
        page
;
; power of ten table...generated by double precision program
;

tentbl
        data.l  $3F800000      ; 1.0E0
        data.l  $41200000      ; 1.0E1
        data.l  $42C80000      ; 1.0E2
        data.l  $447A0000      ; 1.0E3
        data.l  $461C4000      ; 1.0E4
        data.l  $47C35000      ; 1.0E5
        data.l  $49742400      ; 1.0E6
        data.l  $4B189680      ; 1.0E7
        data.l  $4CBEBC20      ; 1.0E8
        data.l  $4E6E6B28      ; 1.0E9
        data.l  $501502F9      ; 1.0E10
        data.l  $51BA43B7      ; 1.0E11
        data.l  $5368D4A5      ; 1.0E12
        data.l  $551184E7      ; 1.0E13
        data.l  $56B5E621      ; 1.0E14
        data.l  $58635FA9      ; 1.0E15
        data.l  $5A0E1BCA      ; 1.0E16
        data.l  $5BB1A2BC      ; 1.0E17
        data.l  $5D5E0B6B      ; 1.0E18
        data.l  $5F0AC723      ; 1.0E19
        data.l  $60AD78EC      ; 1.0E20
        data.l  $6258D727      ; 1.0E21
        data.l  $64078678      ; 1.0E22
        data.l  $65A96816      ; 1.0E23
        data.l  $6753C21C      ; 1.0E24
        data.l  $69045951      ; 1.0E25
        data.l  $6AA56FA6      ; 1.0E26
        data.l  $6C4ECB8F      ; 1.0E27
        data.l  $6E013F39      ; 1.0E28
        data.l  $6FA18F08      ; 1.0E29
        data.l  $7149F2CA      ; 1.0E30
        data.l  $72FC6F7C      ; 1.0E31
        data.l  $749DC5AE      ; 1.0E32
        data.l  $76453719      ; 1.0E33
        data.l  $77F684DF      ; 1.0E34
        data.l  $799A130C      ; 1.0E35
        data.l  $7B4097CE      ; 1.0E36
        data.l  $7CF0BDC2      ; 1.0E37
        data.l  $7E967699      ; 1.0E38
        
        end
; File: pasdpwr10.text
; Date: 16-Feb-83

        ident   pasdpwr10
        
        global  %_DPWR10
        

;
; %_DPWR10 - Double Power of Ten: returns 10Dx, 0 <= x <= 308
;
; Parameters: ST.W - Power
;
; Returns:    F1.D - Result
;
; Scratches: Only D0,D1
;

%_DPWR10
        move.l  (sp)+,d1
        move.w  (sp)+,d0
        move.l  d1,-(sp)
        move.l  a0,-(sp)
        tst.w   d0
        blt.s   dpowzer         ; Arg < 0 means return 0
        cmpi.w  #308,d0         ; Is it > 308?
        ble.s   dpowok          ; No. Its OK
        move.l  #$7ff00000,$8310.w ; Yes. Return inf. J_MOVEHI
        move.l  #0,$8410.w      ; J_MOVELO
        bra.s   dpowrts
dpowzer clr.l   d0
        clr.l   d1
        bra.s   dpowrts
dpowok  move.w  d0,d1
        andi.w  #15,d1          ; Find 10Dxx where
        lea     dtab1+8,a0      ; xx = lower 4 bits
        lsl.w   #3,d1
        adda.w  d1,a0
        move.l  -(a0),$8410.w   ; F1 := 10Dxx
        move.l  -(a0),$8310.w
        lsr.w   #4,d0           ; Find 10Dyy where
        lsl.w   #3,d0           ; yy = upper bits
        beq.s   dpowdon         ; No need if yy = 0
        lea     dtab16+8,a0
        adda.w  d0,a0
        move.l  -(a0),$8400.w   ; J_MOVELO
        move.l  -(a0),$9910.w   ; J_DMUL
dpowdon
dpowrts move.l	$8410.w,d1
		move.l	$8310.w,d0
		move.l  (sp)+,a0
        rts
        page
;
; power of ten tables...double precision version
;

dtab1   data.l  $3FF00000,$00000000  ; 1.0D+00
        data.l  $40240000,$00000000  ; 1.0D+01
        data.l  $40590000,$00000000  ; 1.0D+02
        data.l  $408F4000,$00000000  ; 1.0D+03
        data.l  $40C38800,$00000000  ; 1.0D+04
        data.l  $40F86A00,$00000000  ; 1.0D+05
        data.l  $412E8480,$00000000  ; 1.0D+06
        data.l  $416312D0,$00000000  ; 1.0D+07
        data.l  $4197D784,$00000000  ; 1.0D+08
        data.l  $41CDCD65,$00000000  ; 1.0D+09
        data.l  $4202A05F,$20000000  ; 1.0D+10
        data.l  $42374876,$E8000000  ; 1.0D+11
        data.l  $426D1A94,$A2000000  ; 1.0D+12
        data.l  $42A2309C,$E5400000  ; 1.0D+13
        data.l  $42D6BCC4,$1E900000  ; 1.0D+14
        data.l  $430C6BF5,$26340000  ; 1.0D+15
        data.l  $4341C379,$37E08000  ; 1.0D+16
        
dtab16  data.l  $3FF00000,$00000000  ; 1.0D+00
        data.l  $4341C379,$37E08000  ; 1.0D+16
        data.l  $4693B8B5,$B5056E17  ; 1.0D+32
        data.l  $49E5E531,$A0A1C873  ; 1.0D+48
        data.l  $4D384F03,$E93FF9F5  ; 1.0D+64
        data.l  $508AFCEF,$51F0FB5F  ; 1.0D+80
        data.l  $53DDF675,$62D8B363  ; 1.0D+96
        data.l  $5730A1F5,$B8132466  ; 1.0+112
        data.l  $5A827748,$F9301D32  ; 1.0+128
        data.l  $5DD48057,$38B51A75  ; 1.0+144
        data.l  $6126C2D4,$256FFCC3  ; 1.0+160
        data.l  $64794514,$5230B378  ; 1.0+176
        data.l  $67CC0E1E,$F1A724EB  ; 1.0+192
        data.l  $6B1F25C1,$86A6F04C  ; 1.0+208
        data.l  $6E714A52,$DFFC6799  ; 1.0+224
        data.l  $71C33234,$DE7AD7E3  ; 1.0+240
        data.l  $75154FDD,$7F73BF3C  ; 1.0+256
        data.l  $7867A93A,$2954F3B8  ; 1.0+272
        data.l  $7BBA44DF,$832B8D46  ; 1.0+288
        data.l  $7F0D2A1B,$E4048F90  ; 1.0+304
        
        end
