		.286c
function_int	equ	0f8h
boot_seg	segment at 1000h
		org	0
boot_location	label	far
boot_seg	ends
code		segment
		assume	cs:code,ds:code
		org	0h
;----------------------------------------------------------------
;  on entry bp has either 4 or 5 disk 0 or 1
;----------------------------------------------------------------
boot		proc	far
		jmp	boot_code
our_name	db	'SLICERCB'	;slicer concurrent bios
cylinders	dw	306
heads		db	4
rw_cyliner	dw	0
wp_cylinder	dw	0
error_burst	db	5
step_rate	db	7
sectors		dd	?
drives		db	0
p_ptr		dw	partition1
		dw	partition2
		dw	partition3
		dw	partition4
boot_code:
		mov	cx,1			;number of sectors in boot sector
		xor	bx,bx
		xor	dx,dx
		mov	si,0fd0h
		mov	es,si
		xor	si,si
		mov	ax,bp
		xchg	ah,al
		mov	al,0
		int	function_int		;read entire boot to seg fd0h
		or	al,al
		jz	b2
		jmp	boot_error
b2:		push	es
		push	offset boot_continue
		ret
boot		endp
dos_sector	dw	?
dir_sector	dw	?
boot_continue	proc	near
		push	cs
		pop	ds
		xor	si,si
bc1:		mov	di,p_ptr[si]
		cmp	byte ptr [di].boot_indicator,80h
		je	boot_it
		add	si,2
		cmp	si,8
		jae	boot_error
		jmp	bc1
boot_it:	mov	si,boot_seg
		mov	es,si
		xor	si,si
		mov	ax,bp
		mov	ah,al
		xor	al,al
		mov	cx,1
		mov	bx,word ptr[di].rel_sector
		mov	dx,word ptr[di+2].rel_sector
		int	function_int			;read secondary boot record
		or	al,al
		jnz	boot_error
		jmp	boot_location
boot_error:
		mov	si,offset message
		push	cs
		pop	es
		mov	ax,601h
		mov	cx,message_length
		int	function_int
		cli
		hlt
boot_continue	endp
message		db	0dh,0ah,'Error Loading secondary boot record.',0dh,0ah
message_length	equ	(this byte - message)
pr		struc
boot_indicator	db	?
begin_head	db	?
begin_sector	db	?
begin_cylinder	db	?
sys_indicator	db	?
end_head	db	?
end_sector	db	?
end_cylinder	db	?
rel_sector	dd	?
num_sectors	dd	?
pr		ends
		org	1beh
partition1	pr	<80h,0,2,0,0,0,0,0,1,0ffffh>
partition2	pr	<0,0,2,0,0,0,0,0,1,0ffffh>
partition3	pr	<0,0,2,0,0,0,0,0,1,0ffffh>
partition4	pr	<0,0,2,0,0,0,0,0,1,0ffffh>
		dw	0aa55h
code		ends
		end

