	.286C
	page 60,132
.xlist
		include	biosdata.asm
.list
;------------------------------------------------------------
;	Slicer drivers for the System Expansion Board
;       This driver provides an I/O channel for the printer
;       port on the Slicer System Expansion Board.
;
;------------------------------------------------------------
;
;	E Q U A T E S
;
;
;
w		equ	word ptr
b		equ	byte ptr
;
base		equ	200h
parport		equ	base+60h
stbon		equ	base+1ch
stboff		equ	base+1eh
inport		equ	base+1ah
ready		equ	08h
fault		equ	040h
fault_error	equ	20h
not_ready	equ	80h
bad_command	equ	1


cgroup		group	code
		public	new_parallel
;
code		segment	public byte 'code'
       		assume	cs:cgroup,es:nothing,ds:data
;
new_parallel	proc	far
		dec	al
		jz	prn_out
		dec	al
		dec	al
		jz	prn_stat
		mov	al,bad_command
		ret
prn_out:
		push	cx			 ;save character count
		jcxz	po_end
po_loop:
		mov	prn_countl,0
		mov	prn_counth,0ah
		mov	dx,inport
ack_wait:
		in	al,dx
		test	al,fault
		jz	po1
		mov	al,fault_error 		;out of paper
		jmp	po_end
po1:		test	al,ready
		jz	po2		      ;jump if ack
		dec	prn_countl
		jnz	ack_wait
		dec	prn_counth
		jnz	ack_wait
		mov	al,not_ready	    ; time out no ack
		jmp	po_end
po2:
		lods	b es:[si]
		call	send
		loop	po_loop		;loop for multiple characters
		xor	al,al
		xor	bl,bl
po_end:		pop	di	      ;return number of characters sent
		sub	di,cx
		mov	cx,di
		ret

send		proc	near
		mov	dx,parport
po9:		out	dx,al		;output data
		mov	dx,stbon	
		mov	al,80h
		out	dx,al		;send strobe low

		mov	dx,stboff	;send strobe high again
		out	dx,al
		ret
send		endp

;
;
;   S T A T U S
;
;
prn_stat:	
      		mov	dx,inport
statlp:		in	al,dx
		test	al,ready
		mov	al,0
		jz	pos_end		   ;jump if ready
		mov	al,printer_stat	     ;test if printer was used
		test	al,8
		jnz	stat1		    ;jump if printer was used
		or	printer_stat,8
		mov	al,0h
		call	send 		    ;send break for first ack
		mov	al,0
		jmp	pos_end
stat1:	

		mov	al,not_ready
pos_end:	       
		ret
new_parallel	endp
code		ends
		end

