#include <stdio.h>
#include <stdlib.h>

int main(int argc, char* argv[]) {
  FILE* in;
  int c, i;

  if (argc != 2) {
    fprintf(stderr,"Usage: %s ucsdfile.text > asciifile.txt\n", argv[0]);
    exit(1);
  }
  
  in = fopen(argv[1],"rb");
  if (!in) {
    fprintf(stderr,"Cannot open file %s\n",argv[1]);
    exit(2);
  }

  for (i=0; i<1024; i++) {
    if (fgetc(in) == EOF) {
      fprintf(stderr,"File seems to be truncated\n");
      exit(3);
    }
  }

  while (!feof(in)) {
    c = fgetc(in);
    if (c == EOF) break;
    switch (c) {
    case 0:
      continue;
    case 0x0d:
    case 0x0a:
      putchar('\n');
      break;
    case 0x10:
      c = fgetc(in) - 0x20;
      for (i=0; i<c; i++) putchar(' ');
      break;
    default:
      putchar(c);
    }
  }
  fclose(in);
  exit(0);
}
