/*	wintree.h	1.1	83/02/11	*/

/*	Copyright Sun Microsystems 1983.  All rights reserved */

/*
 * Kernel screen and window tree data structures
 */

/*
 * Per-viewsurface structure.
 *
 * This structure records physical attributes: whether the device
 * for the surface is present, its type (color, b/w, etc),
 * the physical addresses of the device, and the location of the
 * other screens in the system relative to this one (for multiplexing
 * a single mouse for several screens.)
 *
 * Each screen has an associated window tree for clipping, attached
 * to the screen starting at a root window.  If the cursor is on this
 * screen, then the window in which the cursor is located is given.
 * The window to which input is directed is also given here!?!
 */
#define	SCR_MEMORY	0	/* raster in memory */
#define	SCR_SUN1_BW	1	/* sun-1 1024*800 b/w frame buffer */
#define	SCR_SUN1_COLOR	2	/* sun-1 460*640 color frame buffer */

struct	ScreenData {
	short	flags;
#define	SF_PRESENT		0x01	/* the screen exists */
#define	SF_LOCKED_DISPLAY	0x02	/* the display is locked */
#define	SF_LOCKED_DATA		0x04	/* the tree data structure is locked */
#define	SF_DELAYCURSOR		0x08	/* synch. for cursoring */
	int	pa, va;			/* physical, virtual addresses */
	Rect	rect;			/* offset relative to upper left */
	int	nopen;			/* how many windows open */
	struct	WinSys *rootWin;	/* root window for screen */
	struct	WinSys *inputOwner;	/* window to which input is going */
	int	type;			/* SCREEN_BW, SCREEN_GREY, etc */
	struct	WinSys *parentInvalid;	/* rlInvalid is relative to this */
	RectList rlInvalid;		/* Accumulated damaged rl */
	Screen	neighbors[NEIGHBORS];	/* where are other screens? */
};

struct WinSys {
	short	flags;
#define	WF_OPEN			0x01	/* device is open */
#define	WF_LOCKED_DISPLAY	0x02	/* locked display */
#define	WF_LOCKED_DATA		0x04	/* locked tree data structure */
#define	WF_INSTALLED		0x08	/* installed in a tree */
#define	WF_WANTMOUSE		0x10	/* wants the mouse */
#define	WF_SIZECHANGED		0x20	/* size changed */
#define	WF_RCOLL		0x40	/* select collided */
#define	WF_NBIO			0x80	/* non-blocking i/o wanted */
#define	WF_ROOTWINDOW		0x100	/* root window of screen */
	struct	WinSys *link[5];
#define	WL_PARENT	0
#define	WL_OLDERSIB	1
#define	WL_YOUNGERSIB	2
#define	WL_OLDESTCHILD	3
#define	WL_YOUNGESTCHILD 4

#define	NWINLINKS	5

#define	ENCLOSING	link[0]
#define	COVERED		link[1]
#define	COVERING	link[2]
#define	BOTTOM_KID	link[3]
#define	TOP_KID		link[4]

	Rect	rect;			/* parent relative...
					   used when computing rlExposed */
	Rect	rectSaved;		/* used for icon/normal toggle */
	coord	screenOffsetX;		/* screen relative (used when paint) */
	coord	screenOffsetY;		/* screen relative (used when paint) */
	int	pid;			/* pid that will signal to */
	int	clippingID;		/* incarnation of information */
	/* All RectList's are self relative; use screenOffset's when paint */
	RectList rlExposed;		/* for normal clipping */
	RectList rlExposedOld;		/* for saving bits (wmgr) */
	RectList rlFixup;		/* for fixing damage (user) */
	unsigned int mask;			/* input mask */
#define	M_CHANGEMASK(old, new)	\
	    ((new)|((7&~(new))<<4)|(((new)&~(old))<<8)|(((old)&~(new))<<12))
	struct	clist input;		/* input queue */
	struct	proc *rsel;		/* process selecting */
	short	cx, cy;			/* cursor position */
	int	transition;		/* mouse event being waited for */
	int	oldbuttons;		/* mouse buttons on last event */
	struct	pointer_c cursor;	/* per-window cursor shape */
};

typedef	struct WinSys WinSys;
typedef	struct ScreenData ScreenData;

WinSys	wins[NWIN*NSCR];
ScreenData screens[NSCR];

/******* Error codes *******/
#define WIN_OK			0
#define WIN_TABLE_FULL		1
#define WIN_PARAM_BAD		2
#define WIN_NULL_PARENT		3
#define WIN_TREE_BAD		4
#define WIN_UNKNOWN_ERR		5
#define WIN_INDEX_BAD		6
#define WIN_PTR_BAD		7
#define WIN_RLINVALID_NOT_NULL	8
#define WIN_SIG_BAD		9
#define WIN_LAST_ERR		9

postWinErr();	/* (int) */
	/* Pass in error code and will post error message. */

/********* World Conversion Utilities *********/
WinSys *
ptFromIndex();	/* (int index) */

int
indexFromPt();		/* (*WinSys) */

/********* Temp externally used Utilities *********/
getScreenRelativeRect();	/* (*WinSys; *Rect) */

getScreenRelativeRL();	/* (*WinSys; *RectList) */

/********* WinSys basics *********/
initWin();		/* (*WinSys) */

copyWin();		/* (*WinSys winFrom, winTo) */

installWin();		/* (*WinSys) */
	/* Determine parent from given windows link. */

destroyWin();		/* (*WinSys) */
	/* Destroyes node and all children. */

/********* WinSys features *********/
WinSys *
intersectedWin();	/* (*WinSys; coord x, y) */
	/* Finds the window that contains x, y in the given window's coordinate space. */

setClipping();		/* (*WinSys) */
	/* Only clipping for this window and above need change */

/********* Screen Basics *********/
WinSys *
createScr();		/* (*screenInfo) returns the root */
	/* This call locks the screen.  Caller then must unlockScreen(root); */

destroyScr();	/* (*WinSys) the root */

/********* Debugging stuff *********/
printWin();		/* (*WinSys, *tag) */

#define	LOCKPRI	28
#define	MOUSEPRI 27

struct	winmouse
{
	int	x, y;
	int	oldx, oldy;
	int	buttons;
	int	stillticks;
} winmouse;
#define	MOUSETIMO	(hz/20)

WinSys	*inputGrabber;
/* Debugging switches toggled by ioctl calls */
int	printAll; /* if true then print every printf message */
#define	unit(dev)	(minor(dev)/NWIN)	/* which unit is this dev? */
#define dwindow(dev)	(minor(dev)%NWIN)	/* which window is this? */

WinSys *findRoot();
