This is an exerciser and benchmarking facility for
UNIX systems, written by Martin Tuori at
DCIEM in Toronto.
It runs under V7, 4BSD, etc.
This is version 3.0, Jul 2, 1982.
Its purpose is to load a
system with editors, C compiles,
floating point execution and nroff'ing,
and optionally, to time the run, and check the results for
consistency.
An appropriate job mix should be determined by looking at your own 'typical'
user load, and modifying the parameters at runtime.
By default, it runs two of each job, for a total of 8 'users'.

The command file "run" will guide you through the process.
It accepts commands either from standard
input, or as arguments. These include:
setup (se will work) to set up the necessary directories
for individual programs to run in,
run (ru) to set them all in motion
cleanup (cl) to remove all the work files
param (pa) to change the parameters in use.
For starters, try 'run se ru cl' as a casual (non-su) user.

There is a parameter to select the number of copies of each
task to be carried out simultaneously; if want to change
this, be sure to clean up with the old counts, then
change the counts, then setup up again -- otherwise
the necessary directories may not exist.

There is also a paramter to check the output of
programs run, to ensure that they are working correctly.
This is done by comparison with a base copy
created at setup time. While this may seem like asking
a crook if he's lying to you, it at least eliminates
variations in compilers, underlying machine, etc.

There is also a parameter to select timing
of the exercise run. This is a handy measure of the performance
of the system being tested.

Note that vanilla UNIX V7 limits the number of processes
a casual user may run at one time (su excepted). This
has the effect of limiting the extent to which this exercise
package can simulate lots of users. If you run the exercises
as root, you may run into a bug in cc.c. Its efforts to
create temp files is poor, so that root can clobber them
if he/she has two compiles going at once. The fix is
to use mktemp() in cc.c.

Another relevant bug is the declaration of f_count as a char in
sys/h/file.h. This has the effect that, when these many processes
share open files (/dev/tty), the count overflows, and the file is
reallocated. Nasty things happen. The fix is to declare it as a short,
and recompile the entire kernel. We've done this in our UNIX V7 from
TWG, and I believe it is standard in 4BSD.

The command file 'devex' is another, separate, tool --
it is a tool for flogging the devices on a system.
It is configured for a local set of peripherals
at the moment. It is easy to read and modify.

In my experience, any system that can withstand
devex and exercises overnight is running sound
hardware. Good luck.

.nf
		Martin Tuori
		DCIEM
		PO Box 2000
		Downsview, Ontario
		Canada M3M 3B9

		decvax!hcr!dciem!martin
		or decvax!utcsrgv!dciem!martin
