   
/*
 * Tektronix 8560 Unix - Unix Copy
 *
 *	Based on Western Electric System III Unix
 *
 *	Tektronix Modifications from Western Electric code
 *	Copyright C, 1981, Tektronix Inc.
 *	All rights Reserved
 */


#ifdef SCCSID
static char *sccsid = "@(#)@(#)setline.c	5.1 (82/12/08) Tektronix 8560 Unix";
#endif

/***
 *	setline - optimize line setting for sending or receiving files
 *
 *	return code - none
 */

#include "uucp.h"
#ifndef UCB
#include <termio.h>
#endif

#define PACKSIZE	64
#define SNDFILE	'S'
#define RCVFILE 'R'
#define RESET	'X'

setline(type)
char type;
{
#ifndef UCB
	struct termio tbuf, sbuf;
#endif

	int set = 0;

	DEBUG(2, "setline - %c\n", type);
	switch(type) {
	case SNDFILE:
		break;
	case RCVFILE:
#ifndef UCB
		ioctl(Ifn, TCGETA, &tbuf);
		sbuf = tbuf;
		tbuf.c_cc[VMIN] = PACKSIZE;
		ioctl(Ifn, TCSETAW, &tbuf);
#endif
		set++;
		break;
	case RESET:
		if (set == 0) break;
#ifndef UCB
		ioctl(Ifn, TCSETAW, &sbuf);
#endif
		break;
	}
}
