
/*
 * UUCP server server
 * 	Looks for attempt to connect on our uucp socket.  When it
 *	finds one it execs the appropriate uucp module to handle it.
 */
#include <stdio.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/in.h>

extern int errno;

struct	sockaddr_in myaddr = { AF_INET };
struct	sockaddr_in hisaddr;

u_short localport = IPPORT_UUCP;
int	debug;

main(argc, argv)
	int argc;
	char **argv;
{
	int ctrl;
	int i;
	int status;
	int options = SO_ACCEPTCONN|SO_KEEPALIVE;

	debug = 0;
	for(i = 1; i < argc; i++) {
		if(argv[i][0] == '-')
			switch(argv[i][1]) {
			    case 'd':
				debug = 1;
				options |= SO_DEBUG;
				continue;
			    case 'p':
				localport = atoi(argv[++i]);
				continue;
			    default:
				fprintf(stderr, "Unknown flag %s\n",
					 &argv[i][1]);
				usage();
			}
		else
			usage();
	}
	if (fork()) {	/* put process in background */
		exit(0);
	}

	for (i = 0; i < 20; i++) {
		(void) close(i);
	}
	(void) open("/", 0);
	(void) dup2(0, 1);
	(void) dup2(0, 2);
	i = open("/dev/tty", 2);
	if (i >= 0) {
		ioctl(i, TIOCNOTTY, 0);
		(void) close(i);
	}


	myaddr.sin_port = localport;
#if vax || pdp11
	myaddr.sin_port = htons(myaddr.sin_port);
#endif
	for (;;) {
		ctrl = socket(SOCK_STREAM, 0, &myaddr, options);
		if (ctrl < 0 || accept(ctrl, &hisaddr) < 0) {
			perror("Connection failed");
			close(ctrl);
			sleep(5);
			continue;
		}
		if (fork() == 0) {
/*
 *			fork twice so that grandchild becomes associated
 *			with init after its parent goes away.  That way
 *			when grandchild finishes it will go away without
 *			requiring its grandparent (which doesn't ever go away)
 *			to "wait" on it.
 */
			if (fork() == 0) {
				dup2(ctrl, 0);
				close(ctrl);
				dup2(0, 1);
				execl ("/usr/lib/uucp/uucico", "-r0", "-v", 0);
			} else
				exit(0);
		} else {
			(void) wait(status);
			if (status != 0) {
				perror("uucpd: bad exit status");
			}
		}
		close(ctrl);
	}
}
usage()
{
	fprintf(stderr, "Usage: uucpd [ -p ] port number\n");
	exit(1);
}

