/*
 * John Buck -- 7/82
 *
 * We have flakey dz's that occasionally miss a TX ready interrupt (
 * just dont send one!)... this sort of fixes that.  You know this happens
 * if 8 ports stop doing output, and, you have DZ's.
 */
#include "sys/types.h"
#include "sys/stat.h"

struct	dz	{
	int	dzcsr, dzrbuf;
	char	dztcr, dzdtr;
	char	dztbuf, dzbrk;
} dz;

main(c,v)
char **v;
{
	char ttynam[24];
	int mem, dev;
	short resetflg;
	long	kad;
	struct stat statb;

	resetflg = 0;
	if(c > 3){
usage:
		printf("Usage: %s ttyx [-reset]\n", v[0]);
		exit(1);
	}
	if(c == 3)
		resetflg = 2;
	if(c < 2)
		goto usage;
	strcpy(ttynam, "/dev/");
	strcat(ttynam, v[1]);
	if(stat(ttynam, &statb)){
		printf("%s: not found\n", ttynam);
		exit(1);
	}
	dev = statb.st_rdev;
	if(((dev >> 8) & 0377) != 4){
		printf("%s is not on a dz\n", ttynam);
		exit(2);
	}
	dev &= 0377;
	kad = 0160100L + (dev & ~07);
	printf("DZ at 0%O...\n", kad);
	if((mem = open("/dev/kmem", resetflg)) == -1){
		printf("Can not open /dev/kmem\n");
		exit(1);
	}
reloop:
	lseek(mem, kad, 0);
	if(read(mem, &dz, sizeof (dz)) != sizeof dz){
		printf("DZ structure read error\n");
		exit(5);
	}
	printf("CSR=%o\nRBUF=%o\nTCR=%o\nDTR=%o\nTBUF=%o\nBRK=%o\n\n",
		dz.dzcsr, dz.dzrbuf, dz.dztcr, dz.dzdtr, dz.dztbuf, dz.dzbrk);
	if(resetflg){
		lseek(mem, kad, 0);
		printf("Resetting Dz...\n");
		dz.dzcsr=0;
		write(mem, &dz, 2);
		sleep(1);
		lseek(mem, kad, 0);
		dz.dzcsr=040140;
		write(mem, &dz, 2);
		sleep(1);
		lseek(mem, kad+4, 0);
		write(mem, "\377\377", 2);
		resetflg = 0;
		goto reloop;
	}
	close(mem);
}
