/*
 * login.c
 */
#include	"sys/types.h"
#include	"sys/stat.h"
#include	"login.h"
#include	"defs.h"
#include	"actstat.h"

main(argc,argv)
char *argv[];
{
	register char *s , *t;
	register i;
	int loc , u , g;

	signal(3, 1);		/* Do not want coredumps in / */
	signal(14,tmout);	/* So we don't get hung up in login */
	nice(-100);		/* Get to highest prio possible first */
	nice(20);		/* Then go to zero, which is nice, in general */
	nice(0);		/* Why not? */


	mytty = logtty();
	t = ttyx+5;
	s = mytty;
	while(*t++ = *s++);
	if(argc > 1) {		/* Form: login logname */
		sep(argv[1],unm);
		goto gotnm;	/* Got login name */
	}


loop:				/* General re-prompt loop */

	alarm(30);		/* Give him 30 seconds to type name */
	if(getnm(unm) == -1)
		exit(2);

gotnm:
	if(unm[0] == 0)		/* Carriage return for 'Name:' prompt */
		goto loop;

	alarm(0);
	if(getname(unm) == -1){
				/* Name not in list, or something */
		if(cleanam(unm))
			logit(0, unm, (char*)0);
bad:
		printf("Login incorrect.\n");
		goto loop;	/* Try again. */
	}


				/* At this point, we have all necessary
				   info from user, except password. */
	u = val(pwe.uid);	/* Get Uid. */
	g = val(pwe.gid);	/* Get Gid. for this group */

	if(pwe.passwd[0] != 0){
				/* Is there a password? */
		alarm(60);
		if(getpaswd(pw) == -1)exit(6);
		alarm(0);
		if(!equal(pw, pwe.passwd)){
			logit(1, unm, passbuf);
			goto bad;
		}
		validate(unm, passbuf);
	}

	if(u && g){	/* If not prived, do acct status checking and
			 * set quota flag 
			 */
		actstat = pwe.pstat;
#include	"actstat2.h"
		quoflg = quota(unm);
	}
	loc = whom(unm);
	if(usercnt > LOGLIMIT && g > 3 ){
		printf("\nResource shortage -- Login not permitted at this time\n");
		printf("\nTry again in 10 minutes.\n");
		signal(2,1);
		signal(3,1);
		logit(2, unm, usercnt);
		sleep(30); /* since shortage anyway, lets wait abit */
		exit(9);
	}
	i = val(pwe.termlim);
	if(u && g  && pwe.termlim[0] != '*' && loc >= i){
				/* If We are not prived, not a dialup term,
				   and we do not have infinite number of
				   maximum logons... */
toomany:
			printf("\nToo many users logged in under this account.");
			if((loc == i && quoflg == 0) || dialup()){
				printf("\n\nYou will be given five minutes\n\n");
				killsleep(300);
				kflg++;
				logit(3, unm, (loc == i && !quoflg));
			}
			else	{
				printf("  Log another terminal off.\n");
				logit(4, unm, 0);
				sleep(3);
				exit(7);
			}
	}


	if(quoflg){
               printf("You will be given ten minutes");
		if(q.q_mquo == 0 || q.q_mused <= q.q_mquo)
			printf(" to clean up the account");
		printf(".\n\n");
#ifdef	NICEFIELD
		pwe.prio[0] = '3';
		pwe.prio[1] = 0;
#endif
		logit(5, unm, 0);
		killsleep(OVERTIME);
	}
#ifdef EXPSTUFF
	else	if(!kflg)
		if(equal(mytty, EXPRESS1)){
			s = unm;
			t = entry.names;
			while(t < entry.names+8 && (*t++ = *s++));
			while(t < entry.names+8) *t++ = 0;
			entry.ttys = mytty;
			time(&(entry.times));
			expsleep();
			printf("%d minute express terminal.\n\n",
				FIFTEEN/60);
		}
#endif
	if(chdir(pwe.homedir) < 0) {
				/* Directory not found */
		logit(6, unm, pwe.homedir);
		printf("No directory: %s\n",pwe.homedir);
		goto bad;
	}
	clhash();
	signal(2,1);		/* Turn everything off, we run smooth
				   sailing from here on... */
	addme();		/* Put me in utmp, wtmp, and logpost() */
	motd();			/* Print MOTD, if desired */
	login(u,g);		/* Do login */
	if(u && g && pwe.termlim[0] != '*' && whom(unm) >= i+kflg){
		loc = 99;
		goto toomany;
	}
				/* Check for wiseguys */
#ifdef	HALTSTAT
	haltstat();		/* Is system coming down? */
#endif
	if(motdflg != 2 && (q.q_flg & NONOTIFY) == 0){
		printf("\nYou ");
		if(q.q_mquo)
			printf("have $%d left and ",
				((short)(q.q_mquo - q.q_mused))/10);
		printf("are using %d/%d disk blocks and %d/%d files.\n",
			q.q_dused, q.q_dquo, q.q_fused, q.q_fquo);
	}
	if(loc){			/* Anyone else logged in? */
		s = (loc == 1 ? "" : "s");
		printf("\n%d other user%s %s logged in under this account on: ",
			loc, s, loc == 1 ? "is" : "are");
		for(i = 0; i < loc; i++)
			printf("%s ", terms[i]);
		printf("\n");
	}
	mailcall();		/* Is there mail? */
	signal(2,0);
	signal(3,0);
	signal(1,0);
	signal(14,0);
	shell();		/* Get shell and set environment */
	logit(7, unm, pwe.shell);
	printf("No shell.\n");
	exit(9);
}
