unsigned short constants[256] = {
0xffff, 0x3fff, 0x0000, 0x1fff, 0xbfff, 0x5fff, 0x0fff, 0xe000, 
0xf7ff, 0x00ff, 0xfdff, 0xf77f, 0xfbff, 0xffdf, 0xfeff, 0xd77f, 
0x977f, 0xffed, 0xfffd, 0xff80, 0xa00f, 0xffef, 0x9000, 0xf801, 
0x4200, 0xc3a9, 0xedf9, 0xff03, 0x0f0f, 0x5a5a, 0x6571, 0xab7f, 
0xfffe, 0xdde3, 0xf000, 0xbb80, 0x02ff, 0xffc0, 0xf16f, 0xf0ff, 
0xffe0, 0x0003, 0x003f, 0x957f, 0xfffc, 0xfffb, 0x000f, 0xe37f, 
0xf37f, 0x9e7f, 0xbe7f, 0xb77f, 0xfe7f, 0xee7f, 0xde7f, 0xbf7f, 
0x357f, 0xff8f, 0x2000, 0x4fff, 0x0800, 0x8100, 0x7c00, 0x603e, 
0x0020, 0x007e, 0x8fff, 0x7dff, 0x2fff, 0xcc00, 0x807f, 0x667f, 
0xb180, 0x7fdf, 0x44ff, 0x97ff, 0xb7ff, 0x37ff, 0x7f7f, 0x67ff, 
0x423f, 0xffd9, 0x7fcf, 0xff69, 0xf580, 0xff89, 0xff39, 0xff99, 
0xff29, 0x1f29, 0xdf29, 0x2f29, 0xbf29, 0x6f29, 0x9f29, 0x4f29, 
0x8f29, 0x00df, 0x5780, 0x817f, 0x3000, 0x009f, 0xc00f, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

0x7fff, 0xdfff, 0x0000, 0xefff, 0x8000, 0x9fff, 0x0000, 0xe000, 
0x07ff, 0xff00, 0x01ff, 0x757f, 0x03ff, 0xff7f, 0x1fff, 0x0fff, 
0xe77f, 0xffc9, 0xc000, 0x0001, 0xfff0, 0xfff7, 0x2800, 0xff01, 
0xff0f, 0x37bd, 0xfff3, 0xfc00, 0xf0f0, 0xc780, 0x6f7b, 0xfd7f, 
0xf800, 0xd7e9, 0x4000, 0x3eff, 0x6000, 0xfb80, 0xfb45, 0xfe00, 
0xfff8, 0xffbf, 0x001f, 0x157f, 0x007f, 0x7000, 0x0007, 0xffcf, 
0x37e7, 0x1e7f, 0x3e7f, 0x377f, 0x7e7f, 0xae7f, 0x5e7f, 0xf000, 
0xd57f, 0x81ff, 0xafff, 0xe03f, 0xd800, 0xe7ff, 0x07ff, 0xf800, 
0x6fff, 0x0200, 0xf3ff, 0xe67f, 0xcfff, 0x155f, 0x0100, 0xba7f, 
0xe580, 0x77ff, 0x00bf, 0x17ff, 0xd7ff, 0x57ff, 0x7fff, 0x3fff, 
0x847f, 0xff59, 0xffb9, 0xff49, 0xfcff, 0xff19, 0xefff, 0xcfff, 
0x7f29, 0xef29, 0x5f29, 0xcf29, 0x3f29, 0xaf29, 0xf7ff, 0xfbff, 
0x0f29, 0x005f, 0x9780, 0x4180, 0xd780, 0x037f, 0xfdff, 0xfeff, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfcff, 0x00ff, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};


unsigned short constantsV2[256] = {
0xffff, 0x3fff, 0x0000, 0x1fff, 0xbfff, 0x5fff, 0x0fff, 0xe000, 
0xf7ff, 0x00ff, 0xfdff, 0xf77f, 0xfbff, 0xffdf, 0xfeff, 0xd77f, 
0x977f, 0xffed, 0xfffd, 0xff80, 0xa00f, 0xffef, 0x9000, 0xf801, 
0x4200, 0xc3a9, 0xedf9, 0xff03, 0x0f0f, 0x5a5a, 0x6571, 0xab7f, 
0xfffe, 0xdde3, 0xf000, 0xbb80, 0x02ff, 0xffc0, 0xf16f, 0xf0ff, 
0xffe0, 0x0003, 0x003f, 0x957f, 0xfffc, 0xfffb, 0x000f, 0xe37f, 
0xf37f, 0x9e7f, 0xbe7f, 0xb77f, 0xfe7f, 0xee7f, 0xde7f, 0xbf7f, 
0x357f, 0xff8f, 0x2000, 0x4fff, 0x0800, 0x8100, 0x7c00, 0x603e, 
0x0020, 0x007e, 0x8fff, 0x7dff, 0x2fff, 0xcc00, 0x807f, 0x667f, 
0xb180, 0x7fdf, 0x44ff, 0x97ff, 0xb7ff, 0x37ff, 0x7f7f, 0x67ff, 
0x423f, 0xffd9, 0x7fcf, 0xff69, 0xf580, 0xff89, 0xff39, 0xff99, 
0xff29, 0x1f29, 0xdf29, 0x2f29, 0xbf29, 0x6f29, 0x9f29, 0x4f29, 
0x8f29, 0x00df, 0x5780, 0x817f, 0x3000, 0x009f, 0xc00f, 0xffdb, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 

0x7fff, 0xdfff, 0x0000, 0xefff, 0x8000, 0x9fff, 0x0000, 0xe000, 
0x07ff, 0xff00, 0x01ff, 0x757f, 0x03ff, 0xff7f, 0x1fff, 0x0fff, 
0xe77f, 0xffc9, 0xc000, 0x0001, 0xfff0, 0xfff7, 0x2800, 0xff01, 
0xff0f, 0x37bd, 0xfff3, 0xfc00, 0xf0f0, 0xc780, 0x6f7b, 0xfd7f, 
0xf800, 0xd7e9, 0x4000, 0x3eff, 0x6000, 0xfb80, 0xfb45, 0xfe00, 
0xfff8, 0xffbf, 0x001f, 0x157f, 0x007f, 0x7000, 0x0007, 0xffcf, 
0x37e7, 0x1e7f, 0x3e7f, 0x377f, 0x7e7f, 0xae7f, 0x5e7f, 0xf000, 
0xd57f, 0x81ff, 0xafff, 0xe03f, 0xd800, 0xe7ff, 0x07ff, 0xf800, 
0x6fff, 0x0200, 0xf3ff, 0xe67f, 0xcfff, 0x155f, 0x0100, 0xba7f, 
0xe580, 0x77ff, 0x00bf, 0x17ff, 0xd7ff, 0x57ff, 0x7fff, 0x3fff, 
0x847f, 0xff59, 0xffb9, 0xff49, 0xfcff, 0xff19, 0xefff, 0xcfff, 
0x7f29, 0xef29, 0x5f29, 0xcf29, 0x3f29, 0xaf29, 0xf7ff, 0xfbff, 
0x0f29, 0x005f, 0x9780, 0x4180, 0xd780, 0x037f, 0xfdff, 0xfeff, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xfcff, 0x00ff, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000
};


unsigned short newconst[256];

unsigned char uR0[1024];
unsigned char uR1[1024];
unsigned char uR2[1024];
unsigned char uR3[1024];
unsigned char uR4[1024];
unsigned char uR5[1024];
unsigned char uR6[1024];
unsigned char uR7[1024];

unsigned char cons0[256];
unsigned char cons1[256];
unsigned char cons2[256];
unsigned char cons3[256];

#include <stdio.h>
printBin(unsigned int i, int digits);

printBin(unsigned int i, int digits)
{
	char *p;
	char buf[33];
	buf[33] = '\0';
	p = &buf[32];

	while(digits--){
	 if(i&1)
	  *p-- = '1';
	 else
	  *p-- = '0';
	 i >>= 1;
	}
	printf("%s ",++p);
}

main()
{
	FILE * fp;

	int i, j;
	unsigned short c1, c2;

	fp = fopen("55x.3","rb");
	fread(uR0,1, 1024, fp);
	fclose(fp);
	fp = fopen("64x.3","rb");
	fread(uR1,1, 1024, fp);
	fclose(fp);
	fp = fopen("65x.3","rb");
	fread(uR2,1, 1024, fp);
	fclose(fp);
	fp = fopen("63x.3","rb");
	fread(uR3,1, 1024, fp);
	fclose(fp);
	fp = fopen("53x.3","rb");
	fread(uR4,1, 1024, fp);
	fclose(fp);
	fp = fopen("60x.3","rb");
	fread(uR5,1, 1024, fp);
	fclose(fp);
	fp = fopen("61x.3","rb");
	fread(uR6,1, 1024, fp);
	fclose(fp);
	fp = fopen("62x.3","rb");
	fread(uR7,1, 1024, fp);
	fclose(fp);

	fp = fopen("c0.3","rb");
	fread(cons3,1,256, fp);
	fclose(fp);
	fp = fopen("c1.3","rb");
	fread(cons2,1,256, fp);
	fclose(fp);
	fp = fopen("c2.3","rb");
	fread(cons1,1,256, fp);
	fclose(fp);
	fp = fopen("c3.3","rb");
	fread(cons0,1,256, fp);
	fclose(fp);

	freopen("dsm","w", stdout);
	
/*		
	for(i=0; i<256; i++){
	 if(!(i%8))printf("\n");
	 printf("0x%x%x%x%x, ",
	  (cons0[i])&0xf, (cons1[i])&0xf, (cons2[i])&0xf, (cons3[i])&0xf);
	}
*/	
	for(i=1023; i>=0; i--){
	  j = ((~uR0[i])&0xf) <<28 |
	      ((~uR1[i])&0xf) <<24 |
	      ((~uR2[i])&0xf) <<20 |
	      (((~uR3[i])&0xf)^0x8) <<16 |
	      (((~uR4[i])&0xf)^0x8) <<12 |
	      (((~uR5[i])&0xf)^0x4) <<8  |
	      ((~uR6[i])&0xf) <<4  |
	       (~uR7[i])&0xf;

	 if(!((~i) % 32))
	  printf("\nadr  data     rsel  aluf bs  f1   f2   T L next \n");	       

	 printf("%04o %08x ",~i&0x3ff, j);
	 printBin((j >> 27) & 0x1f, 5);
	 printBin((j >> 23) & 0xf,  4);
	 printBin((j >> 20) & 0x7,  3);
	 printBin((j >> 16) & 0xf,  4);
	 printBin((j >> 12) & 0xf,  4);
	 printBin((j >> 11) & 1,    1);
	 printBin((j >> 10) & 1,    1);
	 printBin(j & 0x3ff,        10);
	 printf(" next=%4o \n",j&0x3ff);
	}
#ifdef FOO	
	for(i=0; i<256; i++){
	 j = ((i & 0x1)  << 7) |
	     ((i & 0x2)  << 1) |
	     ((i & 0x4)  >> 1) |
	     ((i & 0x8)  >> 3) |
	     ((i & 0x10) >> 1) |
	     ((i & 0x20) >> 1) |
	     ((i & 0x40) >> 1) |
	     ((i & 0x80) >> 1);


	 c1 = ~(
	 	  ((constants[i] & 0x1)   <<15) |
	 	  ((constants[i] & 0x2)   <<13) |
	 	  ((constants[i] & 0x4)   <<11) |
	 	  ((constants[i] & 0x8)   <<9)  |
	 	  ((constants[i] & 0x10)  <<7)  |
	 	  ((constants[i] & 0x20)  <<5)  |
	 	  ((constants[i] & 0x40)  <<3)  |
	 	  ((constants[i] & 0x80)  <<1)  |
	 	  ((constants[i] & 0x100) >>1)  |
	 	  ((constants[i] & 0x200) >>3)  |
	 	  ((constants[i] & 0x400) >>5)  |
	 	  ((constants[i] & 0x800) >>7)  | 
	 	  ((constants[i] & 0x1000)>>9)  |
	 	  ((constants[i] & 0x2000)>>11) |
	 	  ((constants[i] & 0x4000)>>13) |
	 	  ((constants[i] & 0x8000)>>15)
	      ) & 0xffff;

	 c2 = ~(
	 	  ((constants[j] & 0x1)   <<15) |
	 	  ((constants[j] & 0x2)   <<13) |
	 	  ((constants[j] & 0x4)   <<11) |
	 	  ((constants[j] & 0x8)   <<9)  |
	 	  ((constants[j] & 0x10)  <<7)  |
	 	  ((constants[j] & 0x20)  <<5)  |
	 	  ((constants[j] & 0x40)  <<3)  |
	 	  ((constants[j] & 0x80)  <<1)  |
	 	  ((constants[j] & 0x100) >>1)  |
	 	  ((constants[j] & 0x200) >>3)  |
	 	  ((constants[j] & 0x400) >>5)  |
	 	  ((constants[j] & 0x800) >>7)  | 
	 	  ((constants[j] & 0x1000)>>9)  |
	 	  ((constants[j] & 0x2000)>>11) |
	 	  ((constants[j] & 0x4000)>>13) |
	 	  ((constants[j] & 0x8000)>>15)
	      ) & 0xffff;

	 printf("%02x %6o  %02x %6o\n", i, c1, j, c2);
	 newconst[i] = c2;
	}

	for(i=0; i<256; i++){
	 if(!(i%8)) printf("\n/* %04x */\n", i);
	 printf("0%07o, ", newconst[i]);
	}
	printf("\n");
	
	for(i=0; i<256; i++){
	 if(!(i%8)) printf("\n/* %04x */\n", i);
	 printf("0x%04x, ", newconst[i]);
	}
#endif
}
