;******************************************************************************
;THIS PROGRAM PROVIDES IN THE FORM OF SUBROUTINES,THE ABILITY TO ERASE,ENABLE
;READ, AND WRITE TO THE NMC9306 EEPROM.
;*******************************************************************************
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;
	.TITLE  EPROM
	.INCLD COP820.INC
      	.SECT   MAIN,ROM,INPAGE

  SNDBUF = 0         ;CONTAINES THE COMMAND BYTE TO BE WRITTEN TO NMC9306
  RDATL  = 1         ;LOWER BYTE OF THE NMC9306 REGISTER DATA READ
  RDATH  = 2         ;UPPER BYTE OF //   //     //       //  //
  WDATL  = 3         ;LOWER BYTE OF THE DATA TO BE WRITTEN TO NMC9306 REG.
  WDATH  = 4         ;UPPER BYTE OF  //  //  //  //  //    //  //    //
 ADRESS  = 5         ;THE LOWER 4-BITS OF THE LOCATION CONTAIN THE ADRESS
                     ;OF THE COP 494 REGISTERS TO BE READ/WRITTEN
 FLAGS   = 6         ;USED FOR SETTING UP FLAGS
                     ;
                     ;FLAG VALUE          ACTION
                     ; 00                 ERASE,ENABLE,DISABLE,ERASE ALL
                     ; 01                 READ CONTENTS OF NMC9306 REGISTER
                     ; 03                 WRITE TO NMC9306 REGISTER
                     ; OTHERS             ILLEGAL COMBINATION
 DLYH    =  0F0
 DLYL    =  0F1
;
;THE INTERFACE BETWEEN THE COP820C/840C AND THE COP 494 (256-BIT EEPROM)
;CONSISTS OF FOUR LINES.THE GO(CHIP SELECT LINE),G4(SERIAL OUT SO),
;G5(SERIAL CLOCK SK )AND G6 (SERIAL IN SI ).
;############################################################################
;
;INITIALIZATION
;
        LD      PORTGC,#031     ;SETUP G0,G4,G5 ASOUTPUT
        LD      PORTGD,#000     ;INATIALIZE G DATA REG TO ZERO
        LD      CNTRL,#008      ;ENABLE MSEL,SELECT MW RATE OF 2TC
        LD      B,#PSW
        LD      X,#SIOR
;
MAIN:   JSR     EWEN            ;DRIVER ROUTINES
        NOP
        JSR     ERASE
        NOP
        JSR     WRITE
        NOP
        JSR     READ
        NOP
SELF:   JP      SELF
;
;THIS RUOTINE ERASES THE MEMORY LOCATION POINTED TO BY THE ADRESS
;CONTAINED IN THE LOCATION ADRESS.THE LOWER NIBBLE OF THE "ADRESS"
;CONTAINS THE NMC9306 REGISTER ADDRESS. THE UPPRE NIBLE SHOULD BE
;SET ZERO.
;
;

ERASE:  LD      A,ADRESS
        OR      A,#0C0
        X       A,SNDBUF
        LD      FLAGS,#05       ;DELAY BEFORE CS GOES LOW
        JSR     INIT
        RET
;
;THIS ROUTINE ENABLS PROGRAMMING TO COP 494.PROGRAMMING MUST BE
;PRECEDED ONCE BY PROGRAMMING ENABLE (EWEN).
;
EWEN:   LD      SNDBUF,#030
        LD      FLAGS,#00
        JSR     INIT
        RET
;
;THIS ROUTINE DISABLES PROGRAMMING OF NMC9306.
;
EWDS:   LD      SNDBUF,#00
        LD      FLAGS,#00
        JSR     INIT
        RET
;
;THIS RUOTINE ERASES ALL REGISTERS OF NMC9306.
;
ERAL:   LD      SNDBUF,#020
        LD      FLAGS,#05
        JSR     INIT
        RET
;
;THIS RUOTINE READS THE CONTENTS OF THE NMC9306 REGISTER.THE NMC9306
;ADDRESS IS SPECIFID IN THE LOWER NIBBLE OF LOCATION "ADDRESS".THE UPPER
;NIBBBLE SHOULD BE SET TO ZERO.THE 16-BIT CONTENTS OF NMC9306 REGISTER ARE
;STORED IN RDATL AND RDATH.
;
READ:   LD      A,ADRESS
        OR      A,#080
        X       A,SNDBUF
        LD      FLAGS,#01
        JSR     INIT
        RET
;
;THIS WRITES A 16-BIT VALUE STORED IN WDATL AND WDADTH TO THE VOP 494
;REGISTER WHOSE ADDRESS IS CONTAINED IN THE LOWER NIBBLE OF THE
;LOCATION "ADRESS".THE UPPER NIBBLE OF THE ADDRES SHOULD BE SET TO ZERO.
;
WRITE:  LD      A,ADRESS
        OR      A,#040
        X       A,SNDBUF
        LD      FLAGS,#03
        JSR     INIT
        RET
;
;THIS ROTINE SENDS OUT THE START BIT AND COMMAND BYTE.IT ALSO
;DECIPHERS THE CONTENTS OF THE ;FLAG LOCATION AND TAKES A DECISION
;REGARDING WRITE,READ OR RETURN TO THE CALLING RUOTINE.
;
INIT:   SBIT    0,PORTGD        ;SET CHIP SELECT HIGH
        LD      SIOR,#001       ;LOAD SIOR WHITH START BIT
        SBIT    BUSY,[B]        ;SEND OUT THE START BIT
PUNT1: IFBIT    BUSY,[B]
        JP      PUNT1
        LD      A,SNDBUF
        X       A,[X]         ; LOAD SIOR WITH COMMAND BYTE
        SBIT    BUSY,[B]      ; SEND OUT COMMAND BYTE
PUNT2:  IFBIT   BUSY,[B]
        JP      PUNT2
        IFBIT   0,FLAGS         ;ANY FURTHER PROCESSING ?
        JP      NOTDON          ;YES
        RBIT    0,PORTGD        ;NO, RESET CS AND RETURN
        RET
;
;               DO EXTRA PROCESSING HERE:
;
NOTDON: IFBIT   1,FLAGS         ;READ OR WRITE ?
        JP      WR494           ;JMP TO WRITE ROUTINE
        IFBIT   2,FLAGS         ;ERASE DELAY NEEDED ? 
        JMP     TMOUT           ;YES
        LD      SIOR,#000       ;NO, DO READ NMC9306
        SBIT    BUSY,PSW        ;DUMMY CLOCK TO READ ZERO
        RBIT    BUSY,[B]
        SBIT    BUSY,[B]
PUNT3:  IFBIT   BUSY,[B]
        JP      PUNT3
        X       A,[X]
        SBIT    BUSY,[B]
        X       A,RDATH
PUNT4:  IFBIT   BUSY,[B]
        JP      PUNT4
        LD      A,[X]
        X       A,RDATL
        RBIT    0,PORTGD
        RET
;
WR494:  LD      A,WDATH
        X       A,[X]
        SBIT    BUSY,[B]
PUNT5:  IFBIT   BUSY,[B]
        JP      PUNT5
        LD      A,WDATL
        X       A,[X]
        SBIT    BUSY,[B]
PUNT6:  IFBIT   BUSY,[B]
        JP      PUNT6
        RBIT    0,PORTGD
        JMP     TOUT
;
;ROUTINE TO GENERATE DELAY FOR WRITE
;***************************************
;
TMOUT:  RBIT    0,PORTGD
TOUT:   LD      DLYH,#00A
WAIT:   LD      DLYL,#0FF
WAIT1:  DRSZ    DLYL
        JP      WAIT1
        DRSZ    DLYH
        JP      WAIT
        RET
        .END
