; THE FOLLOWING "INCLUDE FILE" IS DEDICATED TO BE USED      
;AS PART OF THE DEFINITION- AND INITIALIZATION PHASE     
;IN COP800 PROGRAMS.                                                        
; REGISTER NAMES,CONTROL BITS ETC ARE NAMED IN THE          
;SAME WAY AS IT IS DONE IN THE COP800 DATA-SHEETS.                        

; DATE: 13TH MAR.87


;       --- COP800  MEMORY MAPPED ---


; **************************************************** 
; * PORT  -, CONFIGURATION  -  AND CONTROL REGISTERS *
; ****************************************************


     PORTLD    =    0D0         ; L-PORT DATA REGISTER
     PORTLC    =    0D1         ; L-PORT CONFIGURATION
     PORTLP    =    0D2         ; L-PORT INPUT REGISTER
 
     PORTGD    =    0D4         ; G-PORT DATA REGISTER
     PORTGC    =    0D5         ; G-PORT CONFIGURATION
     PORTGP    =    0D6         ; G-PORT INPUT REGISTER
 
     PORTD     =    0DC         ; D-PORT (OUTPUT)
     PORTI     =    0D7         ; I-PORT (INPUT)

 
     SIOR      =    0E9         ; MWIRE SHIFT REGISTER
     TMRLO     =    0EA         ; TIMER LOW-BYTE
     TMRHI     =    0EB         ; TIMER HIGH-BYTE
     TAULO     =    0EC         ; T.-AUTO REG.LOW BYTE
     TAUHI     =    0ED         ; T.-AUTO REG.HIGH BYTE

     CNTRL     =    0EE         ; CONTROL REGISTER
     PSW       =    0EF         ; PSW-REGISTER
                    .FORM
;             **********************
;             *  CONSTANT DECLARE  *
;             **********************


;         ---  CONTROL REGISTER BITS --- 


     S0        =     00     ; MICROWIRE CLOCK DIVIDE BY
                            ;      --- BIT 0 ---
     S1        =     01     ; MICROWIRE CLOCK DIVIDE BY
                            ;      --- BIT 1 ---
     IEDG      =     02     ; EXTERNAL INTERRUPT EDGE 
                            ; POLARITY SELECT (0=RISING
                            ; EDGE,1=FALLING EDGE)
     MSEL      =     03     ; ENABLE MICROWIRE FUNCTION
                            ;     --- SO AND SK ---
     TRUN      =     04     ; START/STOP THE TIM/COUNT.
                            ;     (1=RUN;0=STOP)
     TEDG      =     05     ; TIMER INPUT EDGE POL.SEL.     
                            ; (0=RIS. EDGE;1=FAL. EDGE)   
     CSEL      =     06     ; SELECTS THE CAPTURE MODE
                            ;
     TSEL      =     07     ; SELECTS THE TIMER MODE



;          ---  P S W    REGISTER ---



     GIE       =     00     ; GLOBAL INTERRUPT ENABLE
     ENI       =     01     ; EXTERNAL INTERRUPT ENABLE
     BUSY      =     02     ; MICROWIRE BUSY SHIFTING
     IPND      =     03     ; EXTERNAL INTERR. PENDING   
     ENTI      =     04     ; TIMER INTERRUPT ENABLE
     TPND      =     05     ; TIMER INTERRUPT PENDING
     C         =     06     ; CARRY FLAG
     HC        =     07     ; HALF CARRY FLAG

                .FORM
                .END
