;24 BIT BY 16 BIT DIVISION
;THIS ROUTINE PERFORMS THE BINARY DIVIDE OPERATION 
;ON A DIVIDEND AND DIVISOR (Y,Z). THE DIVIDEND IS   
;LOCATED IN MEMORY LOCATIONS 2,3 AND 4. DIVISOR IS
;LOCATED IN MEMORY LOCATIONS 0 AND 1. Q=Y/Z.
;THE MEMORY ASSIGNMENTS ARE AS FOLLOWS:
;
;	M(6)	M(5)	M(4)	M(3)	M(2)
;	 0	 0	 Y	 Y	 Y
;      ----------------------------------------
;	M(1)	M(0)
;	 Z	 Z
;WHEN THE ROUTINE IS THROUGH THE QUOTIENT WILL BE 
;WHERE THE DIVIDEND Y WAS AND THE REMAINDER WILL
;BE LOCATED IN MEMORY LOCATONS 5 AND 6. DIVISION 
;BY ZERO WILL RESULT IN THE QUOTIENT BEING ALL 1'S
;AND THE REMAINDER BEING THE Y ARGUMENT.
;
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 
;

	.TITLE  BDIV
	.CHIP	ANYCOP
        .SECT   MAIN,ROM,INPAGE

	CNTR=0FF
DIV:	LD	CNTR,#018	;INITIALIZE CNTR
	LD	B,#005		;FOR 24 COUNTS
	LD	[B+],#000	;PUT 0 IN M(6,5)
	LD	[B] ,#000
	LD	X,#005
LSHFT:	LD	B,#002		;LEFT SHIFT
	RC			;M(6,5,4,3,2)
LUP:	LD	A,[B]
	ADC	A,[B]
	X	A,[B+]
	IFBNE	#007
	JP	LUP
	IFC
	JP	SUBT
TSUBT:	LD	B,#000		;SUBTRACT AND TEST
	SC			;SUBTRACT Z FROM M(6,5)
	LD	A,[X+]
	SUBC	A,[B]
	LD	B,#001
	LD	A,[X-]
	SUBC	A,[B]
	IFNC
	JP	TEST
SUBT:	LD	B,#000		;SUBTRACT Z FROM M(6,5)
	LD	A,[X]
	SUBC	A,[B]
	X	A,[X+]
	LD	B,#001
	LD	A,[X]
	SUBC	A,[B]
	X	A,[X-]
	LD	B,#002
	SBIT	0,[B]
TEST:	DRSZ	CNTR		;DECREMENT CNTR
	JP 	LSHFT		;CNTR IS NOT 0
	RET

	.END
	