;DTMF PROGRAM FOR COP820C/840C         VERNE H. WILSON
;                                          8/25/87
;DTMF - DUAL TONE MULTIPLE FREQUENCY
;
;PROGRAM NAME: DTMF.MAC  
;
; EDITTED MAY 11, 1994 - REVISED FOR NEW ASSEMBLER (ASMCOP v4.2) 

          .TITLE DTMF
	  .CHIP  820
          .SECT  MAIN,ROM,ABS=0

;
;******* THE DTMF SUBROUTINE CONTAINS 110 BYTES *******
; ***** THE DTMF SUBROUTINE TIMES OUT IN 100MSEC ***** 
;   ** FROM THE FIRST TOGGLE OF THE G2/G3 OUTPUTS **
;      *** BASED ON A 20 MHZ COP820C/840C CLOCK ***
;
;G PORT IS USED FOR THE TWO OUTPUTS  
;    -    HIGH BAND (HB) FREQUENCY OUTPUT ON G3
;    -    LOW BAND (LB) FREQUENCY OUTPUT ON G2
;
;TIMER COUNTS OUT
;    -    HB FREQUENCIES 
;
;PROGRAM COUNTS OUT  
;    -    LB FREQUENCIES 
;    -    100 MSEC DIVIDED BY LB HALF PERIOD QUOTIENT
;    -    100 MSEC DIVIDED BY LB HALF PERIOD REMAINDER
;
;FORMAT FOR THE 16 HEX DIGIT MATRIX VECTOR IS 1101RRCC,
;    WHERE  -  RR IS ROW SELECT (LB FREQUENCIES)
;           -  CC IS COLUMN SELECT (HB FREQUENCIES)    
;
;FORMAT FOR THE 16 CORE VECTORS FROM THE MATRIX SELECT 
;    TABLE IS TT00XX00, WHERE  -  TT IS HB SELECT
;                                 XX IS LB SELECT              
;
;FREQUENCY VECTORS (HB & LB) FOR FREQ PARAMETER TABLE                       
;    MADE FROM CORE VECTORS
;                                                 
;HB FREQUENCY VECTORS(4) END WITH 00 FOR TIMER COUNTS,
;    WHERE VECTOR FORMAT IS 1100TT00
;
;LB FREQUENCY VECTORS(12) END WITH:
;    11 FOR HALF PERIOD LOOP COUNTS, 
;         WHERE VECTOR FORMAT IS 1100XX11
;    10 FOR 100 MSEC DIVIDED BY HALF PERIOD QUOTIENTS,    
;         WHERE VECTOR FORMAT IS 1100XX10
;    01 FOR 100 MSEC DIVIDED BY HALF PERIOD REMAINDERS,
;         WHERE VECTOR FORMAT IS 1100XX01
;              
;HEX DIGIT MATRIX TABLE AT HEX 01D* (OPTIONAL LOCATION,
;    DEPENDING ON  'ADD  A,#0D0' INST. IMMEDIATE VALUE)
;
;FREQ PARAMETER TABLE AT HEX 01C*  (REQUIRED LOCATION)
               .FORM
;              
;MAGIC:       CORE VECTOR
;               TT00XX00
;
;    TIMER     T    TTOO
;    R1        F    XX11
;    R2        Q    XX10
;    R3        R    XX01
;
;DECLARATIONS:
          PORTLD = 0D0          ; PORTL DATA REG       
          PORTLC = 0D1          ; PORTL CONFIG REG
          PORTGD = 0D4          ; PORTG DATA REG
          PORTGC = 0D5          ; PORTG CONFIG REG
           PORTD = 0DC          ; PORTD REG
         TIMERLO = 0EA          ; TIMER LOW COUNTER
           CNTRL = 0EE          ; CONTROL REG
             PSW = 0EF          ; PROC STATUS WORD
              R0 = 0F0          ; LB FREQ LOOP COUNTER
              R1 = 0F1          ; LB FREQ LOOP COUNT
              R2 = 0F2          ; LB FREQ Q COUNT
              R3 = 0F3          ; LB FREQ R COUNT
              R4 = 0F4          ; LB FREQ TABLE VECTOR
;
START:    LD        SP,#02F        ; HEX DIGIT MATRIX
          LD        PORTLC,#0FF    ; 1  2  3  A
          LD        PORTLD,#080    ; 4  5  6  B
          LD        B,#PORTD       ; 7  8  9  C
          LD        [B],#0         ; *  0  #  D
LOOP:     LD        A,[B]          ; DTMF TEST LOOP        
          JSR       DTMF           ; HEX MATRIX DIGIT
          LD        B,#PORTD       ; TO SUBROUTINE IS 
          LD        A,[B]          ; OUTPUT TO PORTD
          ADD       A,#5           ; D0 WILL TOGGLE    
          X         A,[B]          ; FOR EACH CALL OF  
          RBIT      4,[B]          ; DTMF SUBROUTINE   
          LD        A,PORTLD       ; PORTL OUTPUTS  
          SC                       ; PROVIDE SYNC 
          RRC       A              ; OUTPUT ORDER IS
          X         A,PORTLD       ; 1,5,9,D,4,8,#,A,
          JP        LOOP           ; 7,0,3,B,*,2,6,C 
;
               .FORM     
;
               .=0160
;
DTMF:     LD        B,#PORTGC
          LD        [B-],#03F
          RBIT      3,[B]          ; OPTIONAL
          RBIT      2,[B]          ; OPTIONAL
;
          ADD       A,#0D0   
          LAID                     ; DIGIT MATRIX TABLE
;
          LD        B,#0
          X         A,[B]
          LD        A,[B]
          OR        A,#0C3
          LD        B,#R1
          LD        X,#R4
          X         A,[X]
LUP:      LD        A,[X]
          LAID                     ; LB FREQ TABLES
          X         A,[B+]         ;   (3 PARAMETERS)
          DRSZ      R4
          IFBNE     #4
          JP        LUP
;
          LD        B,#0
          LD        A,[B]
          SWAP      A
          OR        A,#0C0
          LAID                     ; HB FREQ TABLE
          LD        B,#TIMERLO     ;   (1 PARAMETER)
          LD        [B+],#15
          LD        [B+],#0
          X         A,[B+]
          LD        [B+],#1
          LD        [B],#0B0       ; START TIMER PWM
;
          LD        B,#PORTGD
          LD        X,#R1
;
LUP1:     LD        A,[X-]
          IFBIT     2,[B]          ; TEST LB OUTPUT
          JP        BYP1
          X         A,[X+]
          SBIT      2,[B]          ; SET LB OUTPUT
          JP        BYP2
BYP1:     NOP
          RBIT      2,[B]          ; RESET LB OUTPUT
          X         A,[X+]
BYP2:     DRSZ      R2             ; DECR. QUOT. COUNT            
          JP        LUP2 
          JP        FINI           ; Q COUNT FINISHED
;
LUP2:     DRSZ      R0             ; DECR. F COUNT
          JP        LUP2           ; LB (HALF PERIOD)
;
          NOP                      ; *************
          LD        A,[X]          ; BALANCE
          IFEQ      A,#104         ; LB FREQUENCY    
          JP        LUP1           ; HALF PERIOD 
;                                  ; RESIDUE    
          NOP                      ; DELAY FOR
          IFEQ      A,#93          ; EACH OF 4
BACK:     JP        LUP1           ; LB FREQ'S
          JP        BACK           ; *************
;                                  
FINI:     DRSZ      R3             ; DECR. REM. COUNT
          JP        FINI           ; R CNT NOT FINISHED
;
          RBIT      4,CNTRL        ; STOP TIMER
          RBIT      3,[B]          ; CLR HB OUTPUT
          RBIT      2,[B]          ; CLR LB OUTPUT
;
          RET
;    
               .FORM
;
;FREQUENCY AND 100MSEC PARAMETER TABLE
               .=01C0    
;
          .BYTE     158            ; T
          .BYTE      53            ; R                 
          .BYTE     140            ; Q
          .BYTE     114            ; F
          .BYTE     118            ; T
          .BYTE       6            ; R
          .BYTE     155            ; Q
          .BYTE     104            ; F
          .BYTE      83            ; T
          .BYTE      32            ; R
          .BYTE     171            ; Q
          .BYTE      93            ; F
          .BYTE      50            ; T
          .BYTE      25            ; R
          .BYTE     189            ; Q
          .BYTE      83            ; F
;
;DIGIT MATRIX TABLE
               .=01D0
;                                         ROW  COL
          .BYTE     000            ; 1      1    1
          .BYTE     004            ; 2      1    2
          .BYTE     008            ; 3      1    3
          .BYTE     00C            ; A      1    4
          .BYTE     040            ; 4      2    1
          .BYTE     044            ; 5      2    2
          .BYTE     048            ; 6      2    3
          .BYTE     04C            ; B      2    4
          .BYTE     080            ; 7      3    1
          .BYTE     084            ; 8      3    2
          .BYTE     088            ; 9      3    3
          .BYTE     08C            ; C      3    4
          .BYTE     0C0            ; *      4    1
          .BYTE     0C4            ; 0      4    2
          .BYTE     0C8            ; #      4    3
          .BYTE     0CC            ; D      4    4
;
               .END
