        .width    132
;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
; get_pmask function                                                      ;
;                                                                         ;
;   Return the pixel mask, stored in replicated form in the GSP's         ;
;   PMASK register.  Given a pixel size of N bits, the mask is right      ;
;   justified in the N LSBs of the return value, and zero extended.       ;
;                                                                         ;
;   Example:  If PMASK is 0x55555555 and PSIZE is 4, the value returned   ;
;             is 0x00000005.                                              ;
;-------------------------------------------------------------------------;
; Usage:  get_pmask()                                                     ;
;                                                                         ;
; Description of stack arguments:  NONE                                   ;
;                                                                         ;
; Returned in register A8:  32-bit pixel mask value                       ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   09/04/86...Original version written...................Jerry Van Aken  ;
;   03/02/87...Modified source file header................Jerry Van Aken  ;
;   09/24/88...Modified to clear MS 16 bits ..............Graham Short    ;
;   02/09/90...Changed return val to non-replicated form..Jerry Van Aken  ;
;-------------------------------------------------------------------------;
;
        .title    'get pmask'
        .file     'getpmask.asm'
;
        include   gspreg.inc
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .def      _get_pmask
;
;
;     ENTRY POINT
;
_get_pmask:

        move      B0,*-SP,1           ;save register
        movk      1,B0                ;x = 1, y = 0
        cvxyl     B0,B0               ;get pixel size + offset
        sub       OFFSET,B0           ;remove offset
        exgf      B0,0                ;field size = pixel size
        move      @PMASK,A8,0         ;load return value
        zext      A8,0                ;ensure value is zero extended
        move      *SP+,B0,1           ;restore register
        rets      0
        .end

