;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1986-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;                                                                         ;
; poke_breg function                                                      ;
;                                                                         ;
;   Stores the specified 32-bit value in the B-file register identified   ;
;   by the regno argument.  The 4 LSBs of regno select a B-file register  ;
;   in the range 0 to 15.  The other MSBs of regno are ignored.           ;
;-------------------------------------------------------------------------;
; Usage:  poke_breg(regno, value);                                        ;
;                                                                         ;
; Description of stack arguments:                                         ;
;   short regno;  /* B-file register number (range:  0 to 15) */          ;
;   long value;  /* 32-bit value to be loaded into register */            ;
;                                                                         ;
; Returned in register A8:  Void (undefined).                             ;
;                                                                         ;
; Registers altered:  A8, <the B-file register identified by regno>       ;
;                                                                         ;
; Notes:                                                                  ;
;   -- All but the 4 LSBs of the regno argument are ignored.              ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;   2/10/86...Original version written...................Gwyn Guidy       ;
;   5/16/86...Added TI copyright notice..................Jerry Van Aken   ;
;   3/02/87...Modified source file header................JV               ;
;   9/23/88...Added TIGA direct mode.....................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'poke into B file'
        .file     'pokebreg.asm'
;
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl    _poke_breg
        .globl    _dm_poke_breg
;
;     ENTRY POINT
;
_poke_breg:
        MOVE      A0,*-SP,1           ;Save A0
        MOVE      *-A14,A0,1          ;Get regno argument
        MOVE      *-A14,A8,1          ;Get value argument
        JRUC      COMMON_EP
_dm_poke_breg:
        MOVE      A0,*-SP,1           ;Save A0
        MOVE      *-A14,A8,1          ;Get pointer to data area
        SETF      16,1,0
        MOVE      *A8+,A0,0           ;Get regno 
        MOVE      *A8,A8,1            ;Get value
COMMON_EP:
        ANDI      15,A0               ;Mask off all but 4 LSBs
        SLL       5,A0                ;Convert regno to offset
        ADDI      SWITCH,A0           ;Switch table base address
        JUMP      A0                  ;Jump into switch table
SWITCH:
        MOVE      A8,B0               ;
        JRUC      EXIT                ;
        MOVE      A8,B1               ;
        JRUC      EXIT                ;
        MOVE      A8,B2               ;
        JRUC      EXIT                ;
        MOVE      A8,B3               ;
        JRUC      EXIT                ;
        MOVE      A8,B4               ;
        JRUC      EXIT                ;
        MOVE      A8,B5               ;
        JRUC      EXIT                ;
        MOVE      A8,B6               ;
        JRUC      EXIT                ;
        MOVE      A8,B7               ;
        JRUC      EXIT                ;
        MOVE      A8,B8               ;
        JRUC      EXIT                ;
        MOVE      A8,B9               ;
        JRUC      EXIT                ;
        MOVE      A8,B10              ;
        JRUC      EXIT                ;
        MOVE      A8,B11              ;
        JRUC      EXIT                ;
        MOVE      A8,B12              ;
        JRUC      EXIT                ;
        MOVE      A8,B13              ;
        JRUC      EXIT                ;
        MOVE      A8,B14              ;
        JRUC      EXIT                ;
        MOVE      A8,SP               ;
EXIT:
        MOVE      *SP+,A0,1           ;Restore A0
        RETS      2
        .end


