;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1988-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
        .title    'workspace functions'
        .file     'workspac.asm'
;
;   Include external defs
;
        .include  gsptypes.inc
        .include  gspglobs.inc            
        .include  gspreg.inc
        .mlib     gspmac.lib   ;macros

;-------------------------------------------------------------------------;
;   name            set_wksp                                              ;
;                                                                         ;
;   synopsis        void set_wksp( addr, pitch )                          ;
;                   unsigned long addr;     /* starting address */        ;
;                   unsigned long pitch;    /* workspace pitch  */        ;
;                                                                         ;
;   description     The set_wksp() function sets the workspace            ;
;                   environment variables to the specified address and    ;
;                   pitch.  The workspace memory is used by functions     ;
;                   such as fill_polygon to draw a 1-bit per pixel        ;
;                   image of the polygon before expanding it to the       ;
;                   screen.                                               ;
;-------------------------------------------------------------------------;
;
;   Declare globals
;
        .globl    _set_wksp 
        .globl    _dm_set_wksp 
;
;   Direct-mode entry point 
;
_dm_set_wksp: 
        push    A0 
        popc    A8              ;get dm-data area address
        move    *A8+,A0,1       ;1st dword is workspace address
        move    *A8,A8,1        ;2nd dword is workspace pitch
        jruc    common_ep
;
;   C-packet entry point
;
_set_wksp:
        push    A0
        popc    A0              ;pop workspace address
        popc    A8              ;pop workspace pitch
;
;   2 entry points join up here
;
common_ep:
        move    A0,@(_config+CONFIG_WKSP_ADDR),1
        move    A8,@(_config+CONFIG_WKSP_PITCH),1
        pop     A0
        rets    2

;-------------------------------------------------------------------------;
;   name            get_wksp                                              ;
;                                                                         ;
;   synopsis        s = get_wksp( addr, pitch )                           ;
;                   short s;    /* 0=no wksp, 1=wksp allocated */         ;
;                   unsigned long *addr;    /* starting address */        ;
;                   unsigned long *pitch;   /* workspace pitch  */        ;
;                                                                         ;
;   description     The get_wksp() function returns information about     ;
;                   the current workspace.  The address and pitch of the  ;
;                   current workspace are returned via the supplied       ;
;                   pointers.  The function returns the workspace alloc   ;
;                   status.  If the workspace has been allocated, 1 is    ;
;                   returned.  Otherwise, 0 is returned.                  ;
;                                                                         ;
;   history                                                               ;
;       01/30/89    Original version written.................. W.S.Egr    ;
;-------------------------------------------------------------------------;
;
;   Declare globals
;
        .globl    _get_wksp 
;
;   C-packet entry point
;
_get_wksp:
        push    A0                          ; Save A0
;
;   2 entry points join up here
;
gw_common_ep:
        popc    A0                          ; Get address of wksp addr parm
        move    @(_config+CONFIG_WKSP_ADDR),A8,1  ; Read current wksp addr    
        move    A8,*A0,1                    ; Return wksp addr
        popc    A0                          ; Get address of wksp pitch parm
        move    @(_config+CONFIG_WKSP_PITCH),A8,1 ; Read current wksp pitch
        move    A8,*A0,1                    ; Return wksp pitch
        jrz     gw_exit                     ; If pitch=0, then return 0
        movk    1,A8                        ; Otherwise, return 1
gw_exit:
        pop     A0                          ; Restore A0
        rets    2                           ; Return to calling routine

        .end
