/*-----------------------------------------------------------------------*/
/*                              TIGA 2.0                                 */
/*       Copyright (c) 1988-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TIGA 2-D Graphics Library                                            */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  name            set_srcbm() - set src bitmap structure               */
/*                  set_dstbm() - set dst bitmap structure               */
/*                  swap_bm()   - swap src and dst bitmap structures     */
/*                                                                       */
/*  description     These functions are used to setup and manipulate     */
/*                  source and destination bitmap structures. These      */
/*                  structures as used as implied operands by the        */
/*                  drawing functions and are treated as follows:        */
/*                  If a pointer to a bitmap structure is NULL, then     */
/*                  the bitmap is assumed to be the screen, otherwise    */
/*                  the structure describes a memory (non-screen)        */
/*                  bitmap.                                              */
/*-----------------------------------------------------------------------*/
/* 09/28/88   Original Version Written                    J.G.Littleton  */
/* 12/06/88   Null bitmap pointer now indicates screen    JGL            */
/*-----------------------------------------------------------------------*/

#include <gsptypes.h>
#include <gspglobs.h>

static BITMAP srcmem;
static BITMAP dstmem;

/*----------------------------------------------------------------------*/
/*  SET_SRCBM - Setup the source bitmap                                 */
/*----------------------------------------------------------------------*/
set_srcbm( addr, pitch, xext, yext, psize)
uchar *addr;
unsigned short pitch, xext, yext, psize;
{
    if (!addr)
        env.srcbm = (BITMAP *)0;
    else
    {
        env.srcbm    = &srcmem;
        srcmem.addr  = addr;
        srcmem.pitch = pitch;
        srcmem.xext  = xext;
        srcmem.yext  = yext;
        srcmem.psize = psize;
    }
}

/*----------------------------------------------------------------------*/
/*  SET_DSTBM - Setup the destination bitmap                            */
/*----------------------------------------------------------------------*/
set_dstbm( addr, pitch, xext, yext, psize)
uchar *addr;
unsigned short pitch, xext, yext, psize;
{
    if (!addr)
        env.dstbm = (BITMAP *)0;
    else
    {
        env.dstbm    = &dstmem;
        dstmem.addr  = addr;
        dstmem.pitch = pitch;
        dstmem.xext  = xext;
        dstmem.yext  = yext;
        dstmem.psize = psize;
    }
}

/*----------------------------------------------------------------------*/
/*  SWAP_BM - Swap the source and destination bitmap pointers           */
/*----------------------------------------------------------------------*/
swap_bm()
{
    BITMAP bmTmp;

    /*------------------------------------------------------------------*/
    /*  Swap contents of the source and destination bitmap structures   */
    /*------------------------------------------------------------------*/
    bmTmp  = srcmem;
    srcmem = dstmem;
    dstmem = bmTmp;

    /*------------------------------------------------------------------*/
    /*  Swapping structures will suffice unless one of the bitmap ptrs  */
    /*  in NULL, indicating the screen.                                 */
    /*------------------------------------------------------------------*/
    if ( (env.srcbm > (BITMAP *)0) ^ (env.dstbm > (BITMAP *)0) )
    {
        if (!env.srcbm)
        {
            env.srcbm = &srcmem;
            env.dstbm = (BITMAP *)0;
        }
        else
        {
            env.dstbm = &dstmem;
            env.srcbm = (BITMAP *)0;
        }
    }
}
