/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test pen_line and patnpen_line functions.	Draw fat lines emanating
 *   in circular pattern from center of screen.  Alternate frames of
 *   solid-colored with frames of pattern-filled lines.  Insert 1-second
 *   delay between frames.
 *----------------------------------------------------------------------
 * Revision History:
 *   07/01/87...Original version written...................J.R. Van Aken
 *   04/12/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static CONFIG cfg;


main()
{
    long hres, vres, i, x, y, r, t, rmin, rmax, patn, color0, color1;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    set_draw_origin(hres/2, vres/2);
    color0 = 0;
    color1 = -1;
    patn = 0;
    rmin = hres << 16-5;
    rmax = (hres > vres) ? vres << 16-1 : hres << 16-1 ;

    /* Infinite loop below draws circular patterns of fat lines. */
    for (;;) {
	/* Draw solid-colored fat lines. */
	set_pensize(1+hres/200, 1+vres/200);
	clear_screen(-1);
	for (r = rmin; r <= rmax; r += r/16) {
            x = 0;
	    y = -r;
	    for (t = 202; t != 0; t--) {
		if (cfg.mode.disp_psize >= 4)  /* color display? */
		    set_fcolor(color1--);
		pen_line(x-x/4>>16, y-y/4>>16, x>>16, y>>16);
                x -= y >> 5;
                y += x >> 5;
            }
        }
	for (i = 60; i; i--)	 /* 1-second delay */
	    wait_scan(hres);

	/* Draw pattern-filled fat lines. */
	set_pensize(2+hres/100, 2+vres/100);
	clear_screen(-1);
	for (r = rmin; r <= rmax; r += r/16) {
            x = 0;
	    y = -r;
	    for (t = 101; t != 0; t--) {
		set_colors(color1--, color0++);
		current_patn.data = (PTR)&patnbits[patn];
		set_patn(&current_patn);
		if (++patn == NUM_PATNS)
		    patn = 0;
		patnpen_line(x-x/4>>16, y-y/4>>16, x>>16, y>>16);
                x -= y >> 4;
                y += x >> 4;
            }
        }
	color0++;
	color1--;
	for (i = 60; i; i--)	 /* 1-second delay */
	    wait_scan(hres);
    }
}

