/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *       Copyright (c) 1987-1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Test draw_line function.  This demo draws an animated "flying wing"
 *   wireframe defined by three moving points.  Each moving point
 *   travels in a straight line until it bounces off one of the sides of
 *   the screen.  Running this demo in a double-buffered graphics mode
 *   (i.e., one with two video pages) improves the appearance of the
 *   animation somewhat by reducing flicker.  When two pages are
 *   available, the program draws a new frame to one page while the other
 *   page is displayed.
 *----------------------------------------------------------------------
 * Revision History:
 *   03/23/87...Original version written...................J.R. Van Aken
 *   03/27/90...Modified for general portability...........J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

typedef struct { short x, y; } POINT2D;

static CONFIG cfg;


main()
{
    int hres, vres, i, disppage;
    int x1, y1, x2, y2, x3, y3, dx1, dy1, dx2, dy2;
    POINT2D xy[3], vxy[3];

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_frame_buffer(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */

    /* Adjust shape and movement parameters to screen dimensions. */
    xy[0].x = xy[1].x = 0;    xy[2].x = hres - 1;
    xy[0].y = vres - 1;       xy[1].y = xy[2].y = 0;
    vxy[0].x = hres/116;      /* x velocity of 1st end point */
    vxy[0].y = vres/107;      /* y velocity of 1st end point */
    vxy[1].x = hres/85;       /* x velocity of 2nd end point */
    vxy[1].y = vres/137;      /* y velocity of 2nd end point */
    vxy[2].x = hres/183;      /* x velocity of 3rd end point */
    vxy[2].y = vres/56;       /* y velocity of 3rd end point */

    /* Each loop draws a frame containing an updated flying wing. */
    for (disppage = 0; ; disppage = !disppage) {
	/* Schedule page swap at bottom of screen. */
	page_flip(disppage, !disppage);

	/* Update x and y coordinates of the three end points. */
	for (i = 0; i < 3; i++) {
	    xy[i].x += vxy[i].x;
	    if (cpw(xy[i].x, 0))
		vxy[i].x = -vxy[i].x;
	    xy[i].y += vxy[i].y;
	    if (cpw(0, xy[i].y))
		vxy[i].y = -vxy[i].y;
	}

	/* Get fixed-point x-y coordinates and displacements. */
	x1 = xy[0].x << 16;
	y1 = xy[0].y << 16;
	x2 = xy[1].x << 16;
	y2 = xy[1].y << 16;
	x3 = xy[2].x << 16;
	y3 = xy[2].y << 16;
	dx1 = (x2 - x1)/8;
	dy1 = (y2 - y1)/8;
	dx2 = (x3 - x2)/8;
	dy2 = (y3 - y2)/8;

	/* Wait until previously-requested page swap has completed. */
	while (page_busy())
	    ;

	/* Draw flying wing. */
	clear_page(-1);
	for (i = 9; i != 0; i--) {
	    draw_line(x1+0x8000>>16, y1+0x8000>>16,
					  x2+0x8000>>16, y2+0x8000>>16);
	    x1 += dx1;
	    y1 += dy1;
	    x2 += dx2;
	    y2 += dy2;
	}
    }
}

