/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*       Copyright (c) 1989-1990 Texas Instruments Incorporated.         */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            oemdata.c                                            */
/*                                                                       */
/*  description     This file contains global variable definitions for   */
/*                  alternate video modes and monitors                   */
/*                                                                       */
/*-----------------------------------------------------------------------*/
/*  06/19/89...Converted from OEMDATA.ASM file in CD..........Al Sharp	 */
/*  03/15/90...Added global num_modes....................J.R. Van Aken	 */
/*  09/27/90...Converted to 2 offscreen areas............J.R. Van Aken   */
/*-----------------------------------------------------------------------*/
#include <gsptypes.h>	      /* type definitions */
#include "oem.h"              /* hardware-specific constants */

#define NUM_MODES    4	      /* number of graphics modes supported */

/* List of globals defined in this file */
extern short num_modes;
extern SETUP mode_setup[];

short num_modes = NUM_MODES;  /* This global is accessed in CONFIG.C. */

/*-------------------------------------------------------------------*/
/*								     */
/*  34010 Software Development Board -- graphics modes 0 through 3   */
/*								     */
/*-------------------------------------------------------------------*/
SETUP mode_setup[NUM_MODES] =
{
    /*-------------------------------------------------------------------*/
    /*  SDB Mode 0: 640x480x4, 1 page for NEC monitor                    */
    /*-------------------------------------------------------------------*/
    {
       {
	  0,
	  sizeof(HEADER),
	  sizeof(HEADER)+sizeof(MODEINFO),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)
       },
       /*
        *  MODEINFO SDB Mode 0: 640x480x4, 1 page for NEC monitor
	*/
       {
	  0x00001000,			  /* disp_pitch       */
	  480,				  /* disp_vres	      */
	  640,				  /* disp_hres	      */
	  27,				  /* screen_wide - taken from  */
	  20,				  /* screen_high   monitorinfo */
	  4,				  /* disp_psize       */
          0x0000000F,                     /* pixel mask       */
	  4,				  /* palette gun depth*/
	  PALET_ENTRIES,		  /* palette entries  */
	  0x100,			  /* palette inset    */
	  1,				  /* n_of_pages       */
	  3,				  /* n of offscreen address blocks */
          0x00000B00,                     /* workspace address  */
          0x1000,                         /* workspace pitch    */
          0                               /* no VRAM block fill */
       },
       /*
        * MONITORINFO SDB Mode 0: 640x480x4, 1 page for NEC monitor
	*/
       {
	  0x001B,     /* hesync       */
	  0x001C,     /* heblnk       */
	  0x00CC,     /* hsblnk       */
	  0x00CD,     /* htotal       */
	  0x0001,     /* vesync       */
	  0x0018,     /* veblnk       */
	  0x01F8,     /* vsblnk       */
	  0x01FA,     /* vtotal       */
	  0xF010,     /* dpyctl       */
	  30,	      /* screen_delay */
	  0	      /* monitor flags*/
       },
       /*
        * PAGE INFO SDB Mode 0: 640x480x4
	*/
       {
           { 0x100, 0 },                         /* BaseAddr0, DpyStart0 */
           { 0, 0 },                             /* empty */
       },
       /*
        * OFFSCREEN INFO SDB Mode 0: 640x480x4
	*/
       {
          {(uchar *) 0x00000B00,  320, 480 },    /* offscreen buffer 0 */
          {(uchar *) 0x001E0000, 1024,  32 },    /* offscreen buffer 1 */
       }
    },

    /*-------------------------------------------------------------------*/
    /*	SDB Mode 1: 448x480x4, 2 pages for NEC monitor			 */
    /*-------------------------------------------------------------------*/
    {
       {
	  0,
	  sizeof(HEADER),
	  sizeof(HEADER)+sizeof(MODEINFO),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)
       },
       /*
	*  MODEINFO SDB Mode 1: 448x480x4, 2 pages for NEC monitor
	*/
       {
	  0x00001000,			  /* disp_pitch       */
	  480,				  /* disp_vres	      */
	  448,				  /* disp_hres	      */
	  27,				  /* screen_wide - taken from  */
	  20,				  /* screen_high   monitorinfo */
	  4,				  /* disp_psize       */
          0x0000000F,                     /* pixel mask       */
	  4,				  /* palette gun depth*/
	  PALET_ENTRIES,		  /* palette entries  */
	  0x100,			  /* palette inset    */
	  2,				  /* n_of_pages       */
	  1,				  /* n of offscreen address blocks */
	  0x0,				  /* workspace address	*/
	  0x0,				  /* workspace pitch	*/
          0                               /* no VRAM block fill */
       },
       /*
	* MONITORINFO SDB Mode 1: 448x480x4, 2 pages for NEC monitor
	*/
       {
	  0x001B,     /* hesync       */
	  0x0034,     /* heblnk       */
	  0x00B4,     /* hsblnk       */
	  0x00CD,     /* htotal       */
	  0x0001,     /* vesync       */
	  0x0018,     /* veblnk       */
	  0x01F8,     /* vsblnk       */
	  0x01FA,     /* vtotal       */
	  0xF010,     /* dpyctl       */
	  30,	      /* screen_delay */
	  0	      /* monitor flags*/
       },
       /*
        * PAGE INFO SDB Mode 1: 448x480x4
	*/
       {
	  { 0x100, 0 }, 			 /* BaseAddr0, DpyStart0 */
	  { 0x900, 0x800 },			 /* BaseAddr1, DpyStart1 */
       },
       /*
        * OFFSCREEN INFO SDB Mode 1: 448x480x4
	*/
       {
          {(uchar *) 0x001E0000, 1024, 32 },     /* offscreen buffer 0 */
          {(uchar *) 0, 0, 0 },                  /* empty */
       }
    },

    /*-------------------------------------------------------------------*/
    /*	SDB Mode 2: 640x480x4S, 1 page for SONY monitor 		 */
    /*-------------------------------------------------------------------*/
    {
       {
	  0,
	  sizeof(HEADER),
	  sizeof(HEADER)+sizeof(MODEINFO),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)
       },
       /*
        *  MODEINFO SDB Mode 1: 640x480x4, 1 page for SONY monitor
	*/
       {
	  0x00001000,			  /* disp_pitch       */
	  480,				  /* disp_vres	      */
	  640,				  /* disp_hres	      */
	  27,				  /* screen_wide - taken from  */
	  20,				  /* screen_high   monitorinfo */
	  4,				  /* disp_psize       */
          0x0000000F,                     /* pixel mask       */
	  4,				  /* palette gun depth*/
	  PALET_ENTRIES,		  /* palette entries  */
	  0x100,			  /* palette inset    */
	  1,				  /* n_of_pages       */
	  3,				  /* n of offscreen address blocks */
          0x00000B00,                     /* workspace address  */
          0x1000,                         /* workspace pitch    */
          0                               /* no VRAM block fill */
       },
       /*
        * MONITORINFO SDB Mode 2: 640x480x4, 1 page for SONY monitor
	*/
       {
	  0x001B,     /* hesync       */
	  0x001C,     /* heblnk       */
	  0x00CC,     /* hsblnk       */
	  0x00CD,     /* htotal       */
	  0x0001,     /* vesync       */
	  0x0018,     /* veblnk       */
	  0x01F8,     /* vsblnk       */
	  0x01FA,     /* vtotal       */
	  0xF010,     /* dpyctl       */
	  30,	      /* screen_delay */
	  0	      /* monitor flags*/
       },
       /*
        * PAGE INFO SDB Mode 2: 640x480x4
	*/
       {
          { 0x100, 0 },                          /* BaseAddr0, DpyStart0 */
          { 0, 0 },                              /* empty */
       },
       /*
        * OFFSCREEN INFO SDB Mode 2: 640x480x4
	*/
       {
          {(uchar *) 0x00000B00,  320, 480 },    /* offscreen buffer 0 */
          {(uchar *) 0x001E0000, 1024,  32 },    /* offscreen buffer 1 */
       }
    },

    /*-------------------------------------------------------------------*/
    /*	SDB Mode 3: 448x480x4, 2 pages for SONY monitor 		 */
    /*-------------------------------------------------------------------*/
    {
       {
	  0,
	  sizeof(HEADER),
	  sizeof(HEADER)+sizeof(MODEINFO),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES),
	  sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO10)+
	     (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)
       },
       /*
        *  MODEINFO SDB Mode 3: 448x480x4, 2 pages for SONY monitor
	*/
       {
	  0x00001000,			  /* disp_pitch       */
	  480,				  /* disp_vres	      */
	  448,				  /* disp_hres	      */
	  27,				  /* screen_wide - taken from  */
	  20,				  /* screen_high   monitorinfo */
	  4,				  /* disp_psize       */
          0x0000000F,                     /* pixel mask       */
	  4,				  /* palette gun depth*/
	  PALET_ENTRIES,		  /* palette entries  */
	  0x100,			  /* palette inset    */
	  2,				  /* n_of_pages       */
	  1,				  /* n of offscreen address blocks */
	  0x0,				  /* workspace address	*/
	  0x0,				  /* workspace pitch	*/
          0                               /* no VRAM block fill */
       },
       /*
        * MONITORINFO SDB Mode 3: 448x480x4, 2 pages for SONY monitor
	*/
       {
	  0x001B,     /* hesync       */
	  0x0034,     /* heblnk       */
	  0x00B4,     /* hsblnk       */
	  0x00CD,     /* htotal       */
	  0x0001,     /* vesync       */
	  0x0018,     /* veblnk       */
	  0x01F8,     /* vsblnk       */
	  0x01FA,     /* vtotal       */
	  0xF010,     /* dpyctl       */
	  30,	      /* screen_delay */
	  0	      /* monitor flags*/
       },
       /*
        * PAGE INFO SDB Mode 3: 448x480x4
	*/
       {
	  { 0x100, 0 }, 			 /* BaseAddr0, DpyStart0 */
	  { 0x900, 0x800 },			 /* BaseAddr1, DpyStart1 */
       },
       /*
        * OFFSCREEN INFO SDB Mode 3: 448x480x4
	*/
       {
          {(uchar *) 0x001E0000, 1024, 32 },       /* offscreen buffer 0 */
          {(uchar *) 0, 0, 0 },                    /* empty */
       }
    },
};

