;-------------------------------------------------------------------------;
;                                  TIGA                                   ;
;        Copyright (c) 1989-1990  Texas Instruments Incorporated.         ;
;			   All Rights Reserved				  ;
;-------------------------------------------------------------------------;
;   TIGA - Graphics Manager Core                                          ;
;-------------------------------------------------------------------------;
;   void clear_page(c)                                                    ;
;   long  c;            color index to clear screen to                    ;
;                                                                         ;
;   This function clears the current page to the color corresponding to   ;
;   the specified color index.                                            ;
;                                                                         ;
;   Since the SDB is not set up such that Shift-register-transfers can    ;
;   be done to clear one page without destroying the other, this function ;
;   simply jumps to the clear_screen entry points.                        ;
;                                                                         ;
;   Notes:- A8 is destroyed                                               ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  01/30/89...Original Version...........................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title  'clear page'
        .file   'clearpag.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .globl  _clear_page
        .globl  _dm_clear_page
;
;     EXTERNAL REFERENCES
;
        .globl  _clear_screen
        .globl  _dm_clear_screen
;
;   C-PACKET ENTRY POINT
;
_clear_page:  
        jruc    _clear_screen
;
;   DIRECT MODE ENTRY POINT
;
_dm_clear_page:
        jruc    _dm_clear_screen
;
        end
