/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            oemdata.c                                            */
/*                                                                       */
/*  description     This file contains global variable definitions for   */
/*		    alternate video modes and monitors. 		 */
/*									 */
/*  TMS34020 Software Development Card -- 18 Graphics Modes:		 */
/*									 */
/* mode #  resolution  # colors  # pages  monitor			 */
/* ------  ----------  --------  -------  -------			 */
/*    0     640x480x4	   16	    2	  NEC Multisync JC-1401 	 */
/*    1     640x480x8	  256	    2	  NEC Multisync JC-1401 	 */
/*    2     640x480x4	   16	    2	  NEC Multisync PLUS JC-1501	 */
/*    3     640x480x8	  256	    2	  NEC Multisync PLUS JC-1501	 */
/*    4    1024x768x4	   16	    2	  NEC Multisync PLUS JC-1501	 */
/*    5    1024x768x8	  256	    1	  NEC Multisync PLUS JC-1501	 */
/*    6     640x480x4	   16	    2	  SONY Multiscan CPD 1302	 */
/*    7     640x480x8	  256	    2	  SONY Multiscan CPD 1302	 */
/*    8     640x480x4	   16	    2	  Mitsubishi Diamond Scan HL 6605*/
/*    9     640x480x8	  256	    2	  Mitsubishi Diamond Scan HL 6605*/
/*   10    1024x768x4	   16	    2	  Mitsubishi Diamond Scan HL 6605*/
/*   11    1024x768x8	  256	    1	  Mitsubishi Diamond Scan HL 6605*/
/*   12     640x480x4	   16	    2	  NEC 3D JC-1404		 */
/*   13     640x480x8	  256	    2	  NEC 3D JC-1404		 */
/*   14     640x480x4	   16	    2	  NEC Multisync XL JC-2001	 */
/*   15     640x480x8	  256	    2	  NEC Multisync XL JC-2001	 */
/*   16    1024x768x4	   16	    2	  NEC Multisync XL JC-2001	 */
/*   17    1024x768x8	  256	    1	  NEC Multisync XL JC-2001	 */
/*-----------------------------------------------------------------------*/
/*  04/09/90...Converted from OEMDATA.ASM file in CD.....J.R. Van Aken	 */
/*  09/27/90...Modified offscreen area lists.............J.R. Van Aken   */
/*-----------------------------------------------------------------------*/
#include <gsptypes.h>	      /* type definitions */
#include "oem.h"              /* hardware-specific constants */

#define NUM_MODES    18       /* number of graphics modes supported */

/* List of globals defined in this file */
extern short num_modes;
extern SETUP mode_setup[];

short num_modes = NUM_MODES;  /* This global is accessed in CONFIG.C. */

/*-------------------------------------------------------------------*/
/*								     */
/*  34020 Software Development Card -- graphics modes 0 thru 17      */
/*								     */
/*-------------------------------------------------------------------*/
SETUP mode_setup[NUM_MODES] =
{
    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 0:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync monitor in analog mode		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 0			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   25,				   /* screen_wide      */
	   18,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 0			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x0005,	   /* HESYNC  register at 0xC0000010 */
	   0x001A,	   /* VEBLNK  register at 0xC0000020 */
	   0x0010,	   /* HEBLNK  register at 0xC0000030 */
	   0x01FA,	   /* VSBLNK  register at 0xC0000040 */
	   0x0060,	   /* HSBLNK  register at 0xC0000050 */
	   0x0200,	   /* VTOTAL  register at 0xC0000060 */
	   0x0062,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0061,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 0			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 0			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 }, /*1*/
            { (PTR)0x003C2000, 0x2000/4, 543 },  /* offscreen buffer 2 */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 0			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 1:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync monitor in analog mode		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 1			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   25,				   /* screen_wide      */
	   18,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 1			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x000C,	   /* HESYNC  register at 0xC0000010 */
	   0x001A,	   /* VEBLNK  register at 0xC0000020 */
	   0x0023,	   /* HEBLNK  register at 0xC0000030 */
	   0x01FA,	   /* VSBLNK  register at 0xC0000040 */
	   0x00C3,	   /* HSBLNK  register at 0xC0000050 */
	   0x0200,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C7,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00C6,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 1			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 1			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },      /* 1 */
            { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },          /* 2 */
            { (PTR)0x00782000, 0x2000/8, 63 },                    /* 3 */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 1			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 2:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync PLUS monitor in analog mode	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 2			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   26,				   /* screen_wide      */
	   20,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 2			 */
	/*---------------------------------------------------------------*/
	{
	   0x0002,	   /* VESYNC  register at 0xC0000000 */
	   0x0002,	   /* HESYNC  register at 0xC0000010 */
	   0x0018,	   /* VEBLNK  register at 0xC0000020 */
	   0x000C,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F8,	   /* VSBLNK  register at 0xC0000040 */
	   0x005C,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F9,	   /* VTOTAL  register at 0xC0000060 */
	   0x005F,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x005E,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 2			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 2			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 }, /*1*/
            { (PTR)0x003C2000, 0x2000/4, 543 },                     /*2*/
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 2			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 3:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync PLUS monitor in analog mode	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 3			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   26,				   /* screen_wide      */
	   20,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 3			 */
	/*---------------------------------------------------------------*/
	{
	   0x0002,	   /* VESYNC  register at 0xC0000000 */
	   0x0006,	   /* HESYNC  register at 0xC0000010 */
	   0x0018,	   /* VEBLNK  register at 0xC0000020 */
	   0x001A,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F8,	   /* VSBLNK  register at 0xC0000040 */
	   0x00BA,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F9,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C0,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00BF,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 3			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 3			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },      /* 1 */
            { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },          /* 2 */
            { (PTR)0x00782000, 0x2000/8, 63 },                    /* 3 */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 3			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 4:	  1024x768x4,  16 colors,  2 video pages,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  NEC Multisync PLUS monitor in analog mode	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 4			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   26,				   /* screen_wide      */
	   20,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 4			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x0008,	   /* HESYNC  register at 0xC0000010 */
	   0x0023,	   /* VEBLNK  register at 0xC0000020 */
	   0x0022,	   /* HEBLNK  register at 0xC0000030 */
	   0x0323,	   /* VSBLNK  register at 0xC0000040 */
	   0x00A2,	   /* HSBLNK  register at 0xC0000050 */
	   0x0324,	   /* VTOTAL  register at 0xC0000060 */
	   0x00A9,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00A8,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 4			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00003000, 0x00003000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 4			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/4, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 4			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT4)			     /* 1024x768, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 5:	  1024x768x8,  256 colors,  1 video page,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  NEC Multisync PLUS monitor in analog mode	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 5			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   26,				   /* screen_wide      */
	   20,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   1,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 5			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x0010,	   /* HESYNC  register at 0xC0000010 */
	   0x0024,	   /* VEBLNK  register at 0xC0000020 */
	   0x0043,	   /* HEBLNK  register at 0xC0000030 */
	   0x0324,	   /* VSBLNK  register at 0xC0000040 */
	   0x0143,	   /* HSBLNK  register at 0xC0000050 */
	   0x0325,	   /* VTOTAL  register at 0xC0000060 */
	   0x0151,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0150,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 5			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
            { 0, 0 },                           /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 5			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/8, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 5			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT8)			     /* 1024x768, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 6:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  SONY Multiscan monitor in analog mode 	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 6			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   27,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 6			 */
	/*---------------------------------------------------------------*/
	{
	   0x000F,	   /* VESYNC  register at 0xC0000000 */
	   0x000E,	   /* HESYNC  register at 0xC0000010 */
	   0x0014,	   /* VEBLNK  register at 0xC0000020 */
	   0x0010,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F4,	   /* VSBLNK  register at 0xC0000040 */
	   0x0060,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F6,	   /* VTOTAL  register at 0xC0000060 */
	   0x0063,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0062,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 6			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 6			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 }, /*1*/
            { (PTR)0x003C2000, 0x2000/4, 543 },                     /*2*/
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 6			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 7:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  SONY Multiscan monitor in analog mode 	 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 7			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   27,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 7			 */
	/*---------------------------------------------------------------*/
	{
	   0x000F,	   /* VESYNC  register at 0xC0000000 */
	   0x001E,	   /* HESYNC  register at 0xC0000010 */
	   0x0014,	   /* VEBLNK  register at 0xC0000020 */
	   0x0022,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F4,	   /* VSBLNK  register at 0xC0000040 */
	   0x00C2,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F6,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C7,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00C6,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 7			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 7			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },      /* 1 */
            { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },          /* 2 */
            { (PTR)0x00782000, 0x2000/8, 63 },                    /* 3 */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 7			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 8:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  Mitsubishi Diamond Scan monitor		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 8			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   28,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 8			 */
	/*---------------------------------------------------------------*/
	{
	   0x0002,	   /* VESYNC  register at 0xC0000000 */
	   0x0002,	   /* HESYNC  register at 0xC0000010 */
	   0x0018,	   /* VEBLNK  register at 0xC0000020 */
	   0x000C,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F8,	   /* VSBLNK  register at 0xC0000040 */
	   0x005C,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F9,	   /* VTOTAL  register at 0xC0000060 */
	   0x005F,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x005E,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 8			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 8			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 }, /*1*/
            { (PTR)0x003C2000, 0x2000/4, 543 },                     /*2*/
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 8			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 9:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  Mitsubishi Diamond Scan monitor		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 9			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   28,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 9			 */
	/*---------------------------------------------------------------*/
	{
	   0x0002,	   /* VESYNC  register at 0xC0000000 */
	   0x0006,	   /* HESYNC  register at 0xC0000010 */
	   0x0018,	   /* VEBLNK  register at 0xC0000020 */
	   0x001A,	   /* HEBLNK  register at 0xC0000030 */
	   0x01F8,	   /* VSBLNK  register at 0xC0000040 */
	   0x00BA,	   /* HSBLNK  register at 0xC0000050 */
	   0x01F9,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C0,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00BF,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 9			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 9			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
            { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },      /* 1 */
            { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },          /* 2 */
            { (PTR)0x00782000, 0x2000/8, 63 },                    /* 3 */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 9			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 10:	  1024x768x4,  16 colors,  2 video pages,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  Mitsubishi Diamond Scan monitor		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 10			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   28,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 10			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x0008,	   /* HESYNC  register at 0xC0000010 */
	   0x0023,	   /* VEBLNK  register at 0xC0000020 */
	   0x0022,	   /* HEBLNK  register at 0xC0000030 */
	   0x0323,	   /* VSBLNK  register at 0xC0000040 */
	   0x00A2,	   /* HSBLNK  register at 0xC0000050 */
	   0x0324,	   /* VTOTAL  register at 0xC0000060 */
	   0x00A9,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00A8,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 10			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00003000, 0x00003000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 10			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/4, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 10			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT4)			     /* 1024x768, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 11:	  1024x768x8,  256 colors,  1 video page,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  Mitsubishi Diamond Scan monitor		 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 11			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   28,				   /* screen_wide      */
	   21,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   1,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 11			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x0010,	   /* HESYNC  register at 0xC0000010 */
	   0x0024,	   /* VEBLNK  register at 0xC0000020 */
	   0x0043,	   /* HEBLNK  register at 0xC0000030 */
	   0x0324,	   /* VSBLNK  register at 0xC0000040 */
	   0x0143,	   /* HSBLNK  register at 0xC0000050 */
	   0x0325,	   /* VTOTAL  register at 0xC0000060 */
	   0x0151,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0150,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 11			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
            { 0, 0 },                           /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 11			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/8, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 11			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT8)			     /* 1024x768, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 12:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync 3D monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 12			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   24,				   /* screen_wide      */
	   18,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 12			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x000B,	   /* HESYNC  register at 0xC0000010 */
	   0x0021,	   /* VEBLNK  register at 0xC0000020 */
	   0x0011,	   /* HEBLNK  register at 0xC0000030 */
	   0x0201,	   /* VSBLNK  register at 0xC0000040 */
	   0x0061,	   /* HSBLNK  register at 0xC0000050 */
	   0x020C,	   /* VTOTAL  register at 0xC0000060 */
	   0x0064,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0063,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 12			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 12			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
	    { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 },
	    { (PTR)0x003C2000, 0x2000/4, 543 },
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 12			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 13:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync 3D monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 13			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   24,				   /* screen_wide      */
	   18,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 13			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x0017,	   /* HESYNC  register at 0xC0000010 */
	   0x0021,	   /* VEBLNK  register at 0xC0000020 */
	   0x0023,	   /* HEBLNK  register at 0xC0000030 */
	   0x0201,	   /* VSBLNK  register at 0xC0000040 */
	   0x00C3,	   /* HSBLNK  register at 0xC0000050 */
	   0x020C,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C9,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00C8,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 13			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 13			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
	    { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },
	    { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },
	    { (PTR)0x00782000, 0x2000/8, 63 },
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 13			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 14:	  640x480x4,  16 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync XL monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 14			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   35,				   /* screen_wide      */
	   26,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   3,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 14			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x000B,	   /* HESYNC  register at 0xC0000010 */
	   0x0021,	   /* VEBLNK  register at 0xC0000020 */
	   0x000D,	   /* HEBLNK  register at 0xC0000030 */
	   0x0201,	   /* VSBLNK  register at 0xC0000040 */
	   0x005D,	   /* HSBLNK  register at 0xC0000050 */
	   0x020C,	   /* VTOTAL  register at 0xC0000060 */
	   0x0064,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0063,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 14			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00002A00, 0x00002A00 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 14			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/4, 480 },     /* offscreen buffer 0 */
	    { (PTR)0x00003680, (0x2000-0x0A00-0x0A00-640)/4, 480 },
	    { (PTR)0x003C2000, 0x2000/4, 543 },
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 14			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT4) 		     /*  640x480, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 15:	  640x480x8,  256 colors,  2 video pages,	 */
    /*			  statically allocated workspace buffer,	 */
    /*			  NEC Multisync XL monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 15			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   480, 			   /* disp_vres        */
	   640, 			   /* disp_hres        */
	   35,				   /* screen_wide      */
	   26,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   4,				   /* n of offscreen address blocks */
	   0x3400,			   /* workspace address*/
	   0x2000,			   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 15			 */
	/*---------------------------------------------------------------*/
	{
	   0x0001,	   /* VESYNC  register at 0xC0000000 */
	   0x0017,	   /* HESYNC  register at 0xC0000010 */
	   0x0021,	   /* VEBLNK  register at 0xC0000020 */
	   0x001C,	   /* HEBLNK  register at 0xC0000030 */
	   0x0201,	   /* VSBLNK  register at 0xC0000040 */
	   0x00BC,	   /* HSBLNK  register at 0xC0000050 */
	   0x020C,	   /* VTOTAL  register at 0xC0000060 */
	   0x00C9,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00C8,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 15			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x003C2000, 0x003C2000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 15			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00003400, 640/8, 480 },     /* offscreen buffer 0 */
	    { (PTR)0x00003680, (0x2000-0x1400-640)/8, 480 },
	    { (PTR)0x003C3400, (0x2000-0x1400)/8, 480 },
	    { (PTR)0x00782000, 0x2000/8, 63 },
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 15			 */
	/*---------------------------------------------------------------*/
	{
	    (RATE|BIT8) 		     /*  640x480, 8 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 16:	  1024x768x4,  16 colors,  2 video pages,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  NEC Multisync XL monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 16			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   35,				   /* screen_wide      */
	   26,				   /* screen_high      */
	   4,				   /* disp_psize       */
           0x0000000F,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   16,				   /* palette entries  */
	   0,				   /* palette inset    */
	   2,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 16			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x0078,	   /* HESYNC  register at 0xC0000010 */
	   0x0023,	   /* VEBLNK  register at 0xC0000020 */
	   0x001A,	   /* HEBLNK  register at 0xC0000030 */
	   0x0323,	   /* VSBLNK  register at 0xC0000040 */
	   0x009A,	   /* HSBLNK  register at 0xC0000050 */
	   0x0327,	   /* VTOTAL  register at 0xC0000060 */
	   0x00A4,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x00A3,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 16			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
	    { 0x00003000, 0x00003000 }, 	/* BaseAddr1, DpyStart1 */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 16			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/4, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 16			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT4)			     /* 1024x768, 4 bits/pixel */
	}
    },

    /*-------------------------------------------------------------------*/
    /*	SDB20 Mode 17:	  1024x768x8,  256 colors,  1 video page,	 */
    /*			  NO statically allocated workspace buffer,	 */
    /*			  NEC Multisync XL monitor			 */
    /*-------------------------------------------------------------------*/
    {
	{
	   0,
	   sizeof(HEADER),
	   sizeof(HEADER)+sizeof(MODEINFO),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN),
	   sizeof(HEADER)+sizeof(MODEINFO)+sizeof(MONITORINFO20)+
	      (sizeof(PAGE)*MAX_PAGES)+(sizeof(OFFSCREEN_AREA)*MAX_OFFSCREEN)+
	      sizeof(OEMDATA)
	},
	/*---------------------------------------------------------------*/
	/*  MODEINFO			 SDB20 Mode 17			 */
	/*---------------------------------------------------------------*/
	{
	   0x00002000,			   /* disp_pitch       */
	   768, 			   /* disp_vres        */
	   1024,			   /* disp_hres        */
	   35,				   /* screen_wide      */
	   26,				   /* screen_high      */
	   8,				   /* disp_psize       */
           0x000000FF,                     /* pixel mask       */
	   8,				   /* palette gun depth*/
	   256, 			   /* palette entries  */
	   0,				   /* palette inset    */
	   1,				   /* n_of_pages       */
	   1,				   /* n of offscreen address blocks */
	   0,				   /* workspace address*/
	   0,				   /* workspace pitch  */
	   1				   /* VRAM block write */
	},
	/*---------------------------------------------------------------*/
	/*  MONITORINFO20		 SDB20 Mode 17			 */
	/*---------------------------------------------------------------*/
	{
	   0x0003,	   /* VESYNC  register at 0xC0000000 */
	   0x000F,	   /* HESYNC  register at 0xC0000010 */
	   0x0023,	   /* VEBLNK  register at 0xC0000020 */
	   0x0038,	   /* HEBLNK  register at 0xC0000030 */
	   0x0323,	   /* VSBLNK  register at 0xC0000040 */
	   0x0138,	   /* HSBLNK  register at 0xC0000050 */
	   0x0327,	   /* VTOTAL  register at 0xC0000060 */
	   0x0149,	   /* HTOTAL  register at 0xC0000070 */
	   0xF007,	   /* DPYCTL  register at 0xC0000080 */
	   0x2000,	   /* DINCLO  register at 0xC0000240 */
	   0x0000,	   /* DINCHI  register at 0xC0000250 */
	   0x0148,	   /* HESERR  register at 0xC0000270 */
	   0x0001,	   /* DPYMSK  register at 0xC00002E0 */
	   30,		   /* screen_delay		     */
	   0		   /* monitor flags		     */
	},
	/*---------------------------------------------------------------*/
	/*  PAGE			 SDB20 Mode 17			 */
	/*---------------------------------------------------------------*/
	{
	    { 0x00002000, 0x00002000 }, 	/* BaseAddr0, DpyStart0 */
            { 0, 0 },                           /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OFFSCREEN_AREA		 SDB20 Mode 17			 */
	/*---------------------------------------------------------------*/
	{
            { (PTR)0x00602000, 0x2000/8, 255 },  /* offscreen buffer 0 */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
            { (PTR)0, 0, 0 },                    /* empty */
	},
	/*---------------------------------------------------------------*/
	/*  OEMDATA			 SDB20 Mode 17			 */
	/*---------------------------------------------------------------*/
	{
	    (BIT8)			     /* 1024x768, 8 bits/pixel */
	}
    },
};


