/*-----------------------------------------------------------------------*/
/*                                 TIGA                                  */
/*          Copyright (c) 1990 Texas Instruments Incorporated.           */
/*                         All Rights Reserved                           */
/*-----------------------------------------------------------------------*/
/*  TMS340 Graphics Library						 */
/*-----------------------------------------------------------------------*/
/*                                                                       */
/*  file            oem.c                                                */
/*                                                                       */
/*  description     This file contains global variable definitions used  */
/*                  in the Graphics Manager portion of TIGA.  The data   */
/*                  used to auto-initialize these globals may be system  */
/*                  dependent and should therefore be reviewed carefully */
/*                  if porting TIGA to another system.                   */
/*-----------------------------------------------------------------------*/
/*  03/14/90    Added 1 and 2 bpp default palettes              W.S.Egr  */
/*  09/27/90    Removed unused SETUP autoinit data          J. Van Aken  */
/*=======================================================================*/
#include <gsptypes.h>       /* type definitions     */
#include "oem.h"            /* hardware-specific constants  */

/*----------------------------------------------------------------------*/
/*  CONFIG structure [config]                                           */
/*                                                                      */
/*      This structure contains a number of global variables used       */
/*      throughout the TIGA Graphics Manager.  Note that some of the    */
/*      structure member are auto-initialized to hardware-specific      */
/*      values from 'oem.h'.                                            */
/*----------------------------------------------------------------------*/
extern ulong    start_of_dram;           /* symbols declared in...  */
extern ulong    end_of_dram;             /* ...                     */
extern ulong    stack_size;              /* ...link control file    */

CONFIG config =
{
    TIGA_VERSION_NUMBER,
    0,			    /* size of communications buffer (bytes)	    */
    0l,                     /* system flags                                 */
    0l,                     /* device rev, init'd by getrev() in set_config */
    1,                      /* initially only 1 mode is supported           */
    0,                      /* CurrentMode = 0                              */
    (ulong) &start_of_dram, /* symbols defined in                           */
    (ulong) &end_of_dram,   /* link control file                            */
    VIDEO_MEMORY_START,
    VIDEO_MEMORY_END,
    (ulong) &stack_size,        
    SHARED_MEM_SIZE,
    SHARED_HOST_ADDR,
    SHARED_GSP_ADDR,
    0                       /* mono monitor flag */
    /* mode field will get initialized by set_config */
};

/*-----------------------------------------------------------------------*/
/*  These arrays contain the default palettes.                           */
/*-----------------------------------------------------------------------*/

PALET Palet1bpp[] =
{
    0x00, 0x00, 0x00, 0x00,     /* BLACK         */
    0xFF, 0xFF, 0xFF, 0xFF      /* WHITE         */
};

PALET Palet2bpp[] =
{
    0x00, 0x00, 0x00, 0x00,     /* BLACK         */
    0x20, 0xA0, 0x20, 0x22,     /* GREEN         */
    0xB0, 0x30, 0x30, 0x44,     /* RED           */
    0xFF, 0xFF, 0xFF, 0xFF      /* WHITE         */
};

PALET Palet4bpp[] = {
    0x00, 0x00, 0x00, 0x00,     /* BLACK         */
    0x20, 0x20, 0xB0, 0x11,     /* BLUE          */
    0x20, 0xA0, 0x20, 0x22,     /* GREEN         */
    0x30, 0xC0, 0xC0, 0x33,     /* CYAN          */
    0xB0, 0x30, 0x30, 0x44,     /* RED           */
    0xB0, 0x30, 0xB0, 0x55,     /* MAGENTA       */
    0x80, 0x40, 0x40, 0x66,     /* BROWN         */
    0xC0, 0xC0, 0xC0, 0x77,     /* LIGHT GRAY    */
    0x50, 0x50, 0x50, 0x88,     /* DARK  GRAY    */
    0x20, 0x20, 0xFF, 0x99,     /* LIGHT BLUE    */
    0x20, 0xE0, 0x20, 0xAA,     /* LIGHT GREEN   */
    0x20, 0xE0, 0xE0, 0xBB,     /* LIGHT CYAN    */
    0xE0, 0x20, 0x20, 0xCC,     /* LIGHT RED     */
    0xE0, 0x10, 0xE0, 0xDD,     /* LIGHT MAGENTA */
    0xFF, 0xFF, 0x10, 0xEE,     /* YELLOW        */
    0xFF, 0xFF, 0xFF, 0xFF      /* WHITE         */
};

/*----------------------------------------------------------------------*/
/*  PALET array [palet]                                                 */
/*                                                                      */
/*      This array allocate space for the current palette.              */
/*----------------------------------------------------------------------*/
PALET palet[PALET_ENTRIES];

/*--------------------------------------------------------------------------*/
/*  SETUP structure [setup]                                                 */
/*                                                                          */
/*      This structure contains all the mode-dependent information          */
/*      that will be downloaded from host to GSP when the current           */
/*      mode is changed.                                                    */
/*--------------------------------------------------------------------------*/
SETUP       default_setup;

/*--------------------------------------------------------------------------*/
/*  Structure pointers                                                      */
/*                                                                          */
/*      These are initialized to point to addresses withing the SETUP       */
/*      structure where the various sub-structures begin                    */
/*--------------------------------------------------------------------------*/
SETUP          *setup        = &default_setup;
MODEINFO       *modeinfo     = &(default_setup.Mode_Info);
MONITORINFO10  *monitorinfo  = &(default_setup.Monitor_Info);
PAGE	       *page	     = default_setup.Page_Info;
OFFSCREEN_AREA *offscreen    = default_setup.Off_Screen;
/*--------------------------------------------------------------------------*/
/*  Add OEM_Data initialization if OEMDATA structure was defined in the     */
/*  oem.h file. 							    */
/*--------------------------------------------------------------------------*/
 OEMDATA        *oemdata      = &(default_setup.OEM_Data);                  

