/*----------------------------------------------------------------------
 *			 TMS340 Graphics Library
 *          Copyright (c) 1990 Texas Instruments Incorporated.
 *                         All Rights Reserved
 *----------------------------------------------------------------------
 * Demonstration Program
 *
 *   Display the 16 colors of the default palette.  Fill 16 horizontal
 *   bars with the 16 default colors, and label each bar with the symbol
 *   name of the color, as defined in the "colors.h" include file.
 *   Obviously, the results may be less than grand if the current
 *   graphics mode supports only 1 or 2 bits per pixel.
 *----------------------------------------------------------------------
 * Revision History:
 *   04/10/90...Original version written...................J.R. Van Aken
 *----------------------------------------------------------------------
 */
#include <gsptypes.h>
#include "patterns.h"

/* If MODE not defined at preprocessor command line, set to default. */
#ifndef  MODE
#define  MODE	  0	  /* default graphics mode */
#endif

static char *s[16] = {
    "BLACK        ", "BLUE         ", "GREEN        ", "CYAN         ",
    "RED          ", "MAGENTA      ", "BROWN        ", "LIGHT_GRAY   ",
    "DARK_GRAY    ", "LIGHT_BLUE   ", "LIGHT_GREEN  ", "LIGHT_CYAN   ",
    "LIGHT_RED    ", "LIGHT_MAGENTA", "YELLOW       ", "WHITE        ",
};


static CONFIG cfg;


main()
{
    unsigned long fcolor, bcolor;
    short hres, vres, w, h, len, color;

    /* Initialize graphics environment. */
    if (!set_config(MODE, 1))
	exit(1);		 /* invalid graphics mode number */
    clear_screen(-1);
    get_config(&cfg);
    hres = cfg.mode.disp_hres;	 /* horizontal resolution */
    vres = cfg.mode.disp_vres;	 /* vertical resolution */
    len = text_width(s[0]);
    w = hres - 24 - len;
    h = vres/16 - 4;
    get_colors(&fcolor, &bcolor);
    for (color = 0; color < 16; color++) {
	set_fcolor(color);
	fill_rect(w, h, 4, 2+color*(h+4));
	set_fcolor(fcolor);
	text_out(16+w, 2+color*(h+4), s[color]);
	draw_rect(w, h, 4, 2+color*(h+4));
    }
}

