/*----------------------------------------------------------------------*/
/* TiGA for PharLap Dos Extender                                        */
/*----------------------------------------------------------------------*/
/* Large Bitmap Demonstration Program                                   */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*----------------------------------------------------------------------*/

#include <stdio.h>
#include <stdlib.h>
#include "..\metatiga.h"

#define FALSE 0
#define TRUE 1

#define XEXT  config.mode.disp_hres
#define YEXT  config.mode.disp_vres
#define PSIZE config.mode.disp_psize
#define PITCH config.mode.disp_pitch

CONFIG config;                          /* TIGA board/mode data structure */

main()
{

    /*--------------------------------------------------------------*/
    /* Attempt to open the CD                                       */
    /*--------------------------------------------------------------*/
    if( tiga_set( CD_OPEN ) )
    {
        printf("Tiga CD is not installed\n");
        exit(1);
    }

    /*--------------------------------------------------------------*/
    /* Check to see that graphical interface is installed.          */
    /*--------------------------------------------------------------*/
    if(!set_videomode(TIGA,INIT))
        error("FATAL ERROR - unable to initialize TIGA, aborting...\n");
    if( install_primitives() < 0 )
        error("Primitive installation error\n");

    clear_screen(0);

    /*------------------------------------------------------------------*/
    /*  Get CONFIGURATION data structure                                */
    /*------------------------------------------------------------------*/
    get_config(&config);

    bit_flip();

    set_videomode(PREVIOUS,NO_INIT);
}


bit_flip()
{
    unsigned long size,gptr;
    unsigned char *buffer,*hptr,*invert,*tptr;
    int hy,hpitch;

    /*------------------------------------------------------------------*/
    /*  Now alloc enough RAM for entire screen                          */
    /*------------------------------------------------------------------*/
    size = XEXT * PSIZE / 8 * YEXT;
    if( !(buffer = malloc( size )) )
        error("Error attempting to malloc %d bytes\n",size);

    draw_stuff();
    printf("About to Read Page -- Press Key to Continue\n");
    getchar();

    /*------------------------------------------------------------------*/
    /*  Read off entire screen into RAM and clear screen                */
    /*------------------------------------------------------------------*/
    hptr = buffer;
    gptr = peek_breg(4);
    hpitch = XEXT * PSIZE / 8;
    for(hy=0; hy<YEXT; hy++)
    {
        gsp2hostxy(gptr,PITCH,hptr,hpitch,0,hy,0,0,XEXT,1,PSIZE,0);
        hptr += hpitch;
    }
    clear_screen(0);
    printf("Page Read -- Press Key to Continue\n");
    getchar();

    /*------------------------------------------------------------------*/
    /*  Now Blit RAM back to screen                                     */
    /*------------------------------------------------------------------*/
    hptr = buffer;
    for(hy=0; hy<YEXT; hy++)
    {
        host2gspxy(hptr,hpitch,gptr,PITCH,0,0,0,hy,XEXT,1,PSIZE,0);
        hptr += hpitch;
    }

    /*------------------------------------------------------------------*/
    /*  Malloc an inverted buffer                                       */
    /*------------------------------------------------------------------*/
    if( !(invert = malloc( size )) )
        error( "Error attempting to malloc %d bytes\n",size);

    tptr = invert;
    while(size--)
        *tptr++ = *--hptr;

    printf("Page Inverted -- Press Key to Continue\n");
    getchar();

    /*------------------------------------------------------------------*/
    /*  Now Blit RAM back to screen                                     */
    /*------------------------------------------------------------------*/
    hptr = invert;
    for(hy=0; hy<YEXT; hy++)
    {
        host2gspxy(hptr,hpitch,gptr,PITCH,0,0,0,hy,XEXT,1,PSIZE,0);
        hptr += hpitch;
    }
}


draw_stuff()
{
    int i,j;
    unsigned long color;

    color = 1;
    for( i=0,j=0; i<XEXT; i+=(XEXT/20),j+=(YEXT)/20)
    {
        set_fcolor(color++ % 16);
        fill_rect(XEXT/10,YEXT/10,i,j);
        fill_rect(XEXT/10,YEXT/10,i,YEXT/4+j/2);
    }
}

error(s)
char *s;
{
    printf("%s",s);
    tiga_set( CD_CLOSE );
    exit(1);
}
