;-------------------------------------------------------------------------;
;                                    TIGA                                 ;
;          Copyright (C) 1986-1990  Texas Instruments Incorporated.       ;
;                            All Rights Reserved                          ;
;-------------------------------------------------------------------------;
;   TiGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
;                                                                         ;
; fill_rect function                                                      ;
;                                                                         ;
;   Draw a filled-in rectangle.  The dimensions of the rectangle are      ;
;   specified in the first two input arguments, width and height.         ;
;   The location of the rectangle is specified in terms of the            ;
;   coordinates of its upper left corner, which are contained in input    ;
;   arguments xleft and ytop.  The rectangle is filled in solid color 1.  ;
;-------------------------------------------------------------------------;
; Usage:  fill_rect(width, height, xleft, ytop);                          ;
;                                                                         ;
; Stack arguments:                                                        ;
;         long width, height;  /* rectangle dimensions */                 ;
;         long xleft, ytop;  /* coordinates at top left corner */         ;
;                                                                         ;
; Registers altered:  A8                                                  ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  02/05/86...Original version written...................John Black       ;
;  10/20/86...Added TI copyright notice..................Stanley Acton    ;
;  03/18/87...Eliminated unnecessary operations..........Jerry Van Aken   ;
;  07/12/88...Added TiGA direct mode and dstbm check.....W.S.Egr          ;
;  09/07/88...Access globals thru env struct.............W.S.Egr          ;
;-------------------------------------------------------------------------;
;
        .title    'fill rectangle'
        .file     'fillrect.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .def      _fill_rect
        .def      _dm_fill_rect
;
;     DECLARE EXTERNAL VARIABLES
;
        .globl    _xyorigin
;
;    DIRECT-MODE ENTRY POINT
;
_dm_fill_rect:
        move      A0,*-SP,1           ;save register
        mmtm      SP,B2,B7,B10,B11,B12,B13,B14
        move      -*A14,A8,1          ;get dm-data area address
        move      *A8+,A0,1           ;1st dword is height::width
        move      A0,B7               ;load height::width into DYDX
        move      *A8,A0,1            ;2nd dword is ytop::xleft
        jruc      common_ep           ;jump to common entry point
;
;
;    C-PACKET ENTRY POINT
;
_fill_rect:
* Save registers
        MOVE      A0,*-SP,1           ;save register
        MMTM      SP,B2,B7,B10,B11,B12,B13,B14
        MOVE      *-A14,A0,1          ;get width
        MOVE      *-A14,A8,1          ;get height
        SLL       16,A8               ;
        MOVY      A8,A0               ;concatenate width & height
        MOVE      A0,B7               ;load DYDX
        MOVE      *-A14,A0,1          ;get xleft
        MOVE      *-A14,A8,1          ;get ytop
        SLL       16,A8               ;
        MOVY      A8,A0               ;concatenate xleft & ytop
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
;
* Convert from viewport relative coord's to screen coord's
        MOVE      @_xyorigin,A8,1     ;viewport origin displacement
        ADDXY     A8,A0               ;convert to screen coord's
        MOVE      A0,B2               ;load DADDR
        FILL      XY                  ;fill the rectangle
* All done.  Restore registers and return
EXIT:
        MMFM      SP,B2,B7,B10,B11,B12,B13,B14
        MOVE      *SP+,A0,1           ;restore register
        RETS      2                   ;
        .end

