/*----------------------------------------------------------------------
 *                                    TIGA
 *          Copyright (C) 1989-1990  Texas Instruments Incorporated.
 *                            All Rights Reserved
 *----------------------------------------------------------------------
 *
 *            Define constants for TIGA flight simulator.
 *
 *----------------------------------------------------------------------
 */
#define  NIL         0

/*----------------------------------------------------------------------
 *           colors in 3D scene visible from cockpit window
 *----------------------------------------------------------------------
 */
#define  EARTHCOLOR  0x22222222         /* earth green      */
#define  SKYCOLOR    0xBBBBBBBB         /* sky blue         */
#define  SUNCOLOR    0xEEEEEEEE         /* sun yellow       */

#define  RED1        0xDDDDDDDD         /* light red        */
#define  RED2        0x55555555         /*                  */
#define  RED3        0x11111111         /* dark red         */

#define  BLUGRN1     0xAAAAAAAA         /* light blue-green */
#define  BLUGRN2     0x99999999         /* dark blue-green  */

#define  BROWN1      0xCCCCCCCC         /* beige            */
#define  BROWN2      0x44444444         /*                  */
#define  BROWN3      0x66666666         /* dark brown       */

#define  GRAY1       0xFFFFFFFF         /* light gray       */
#define  GRAY2       0x77777777         /*                  */
#define  GRAY3       0x33333333         /*                  */
#define  GRAY4       0x88888888         /*                  */
#define  GRAY5       0x00000000         /* dark gray        */

/*----------------------------------------------------------------------
 *        dimensions of instrument panel and individual meters
 *----------------------------------------------------------------------
 */
#define MRADIUS 23             /* radius of meter face            */
#define MDIAM   50             /* meter front cover diameter      */
#define MSPACE  54             /* meter center-to-center distance */
#define IPHT    72             /* height of instrument panel      */

/*----------------------------------------------------------------------
 *           visibility limits for small or distant objects
 *----------------------------------------------------------------------
 */
#define RVIS    2      /* radius above which object becomes visible   */
#define RDOT    4      /* radius below which object is a single pixel */
#define RNPC    64     /* radius above which object needs preclipping */


/*----------------------------------------------------------------------
 *           unit vector rotation modes for rotvec function
 *----------------------------------------------------------------------
 */
#define UV     4              /* rotate u toward v */
#define VU     1              /* rotate v toward u */
#define VW     9              /* rotate v toward w */
#define WV     6              /* rotate w toward v */
#define WU     2              /* rotate w toward u */
#define UW     8              /* rotate u toward w */
#define XY     20             /* rotate x toward y */
#define YX     17             /* rotate Uy,Vy,Wy toward Ux,Vx,Wx */
#define YZ     25             /* rotate Uy,Vy,Wy toward Uz,Vz,Wz */
#define ZY     22             /* rotate Uz,Vz,Wz toward Uy,Vy,Wy */
#define ZX     18             /* rotate Uz,Vz,Wz toward Ux,Vx,Wx */
#define XZ     24             /* rotate Ux,Vx,Wx toward Uz,Vz,Wz */

