;-------------------------------------------------------------------------;
;                                    TIGA                                 ;
;          Copyright (C) 1989-1990  Texas Instruments Incorporated.       ;
;                            All Rights Reserved                          ;
;-------------------------------------------------------------------------;
;   TiGA - Graphics Manager Extension                                     ;
;-------------------------------------------------------------------------;
; set_draw_origin                                                         ;
;                                                                         ;
;   This sets the drawing origin with which all drawing operations are    ;
;   referenced to, to the specified coordinate.                           ;
;-------------------------------------------------------------------------;
; Usage:  set_pensize(x, y);                                              ;
;                                                                         ;
; Description of the arguments:                                           ;
;   short x, y;           // coordinates of new origin //                 ;
;-------------------------------------------------------------------------;
; Revision history:                                                       ;
;  02/15/89...Original version written...................Graham Short     ;
;-------------------------------------------------------------------------;
;
        .title    'set draw origin'
        .file     'set_draw.asm'
;
;     DECLARE GLOBAL FUNCTION NAME
;
        .def      _set_draw_origin
        .def      _dm_set_draw_origin
;
;     DECLARE EXTERNAL VARIABLES
;
        .globl    _xyorigin
;
;    DIRECT-MODE ENTRY POINT
;
_dm_set_draw_origin:
        move      -*A14,A8,1                 ;get dm-data area address
        move      *A8,A8,1                   ;get 1st and 2nd parms
        jruc      common_ep
;
;    C-PACKET ENTRY POINT
;
_set_draw_origin:
* Save registers and pop arguments
        move      -*A14,A8,1                 ;pop xorg
        move      -*A14,A14,1                ;pop yorg
        sll       16,A14                     ;concatenate
        movy      A14,A8                     ;  yorg::xorg
;
;    2 ENTRY POINTS JOIN UP HERE
;
common_ep:
        move      A8,@_xyorigin,1            ;save global xyorigin
        move      *SP(32),A14,1              ;restore program stack ptr
        rets      2                          ;return
        .end
