/*---------------------------------------------------------------------------*/
/* Program to resostore TiGA Environment after Callback or Protected Mode    */
/*---------------------------------------------------------------------------*/
#include <stdio.h>
#include <tiga.h>

main()
{
    unsigned short revision;

    printf("\nOldAp support for Tiga 2.0\n");

    if( tiga_set( CD_OPEN ) )
    {
        printf("\nTiga CD is not installed\n");
        exit(1);
    }

    revision = (unsigned short)(tiga_set( CD_STATUS ) >> 16);
    printf("\nCD Revision Level is %d.%02d\n",(revision>>8),revision&0xFF);

    printf("Resetting Tiga CD to Version 1.1 Compatible State\n");
    tiga_set( CD_CLOSE );
}
