#include "..\\ndptiga.h"

CONFIG config;
FONTINFO fontinfo;
AUX_CONFIG aux_config;

main()
{
    unsigned long far_ptr;
    char strbuf[256];
    unsigned long cd_ret;
    unsigned short rev_level;

    /*--------------------------------------------------------------*/
    /* Attempt to open the CD                                       */
    /*--------------------------------------------------------------*/
    if( tiga_set( CD_OPEN ) )
    {
        printf("Tiga CD is not installed\n");
        exit(1);
    }

    printf("\nTiGA System Responding...\n\n");

    /*--------------------------------------------------------------*/
    /* Read the CD status                                           */
    /*--------------------------------------------------------------*/
    cd_ret = tiga_set( CD_STATUS );

    if( cd_ret & 2 )
        printf("CD is operating in protected mode, ");
    else
        printf("CD is operating in real mode, ");

    if( cd_ret & 4 )
        printf("using HW Interrupt Communications.\n");
    else
        printf("using Polled Communications.\n");

    rev_level = (unsigned short) (cd_ret >> 16);
    printf("CD Revision Level is %d.%02d\n\n",rev_level>>8,rev_level&0xFF);

    /*--------------------------------------------------------------*/
    /* Check to see if a text string identifying the hardware is    */
    /* available.                                                   */
    /*--------------------------------------------------------------*/
    if( !(far_ptr = aux_command( 0, 0 )) )
        printf("No identifying string available\n\n");
    else
    {
        datacopy( strbuf, far_ptr, 256 );
        printf("Hardware is : %s \n\n",strbuf);
    }

    /*--------------------------------------------------------------*/
    /* Report the protected mode environment                        */
    /*--------------------------------------------------------------*/
    if( !(far_ptr = aux_command( 1, 0 )) )
        printf("Error in aux_config!\n");
    else
    {
        datacopy( &aux_config, far_ptr, sizeof( AUX_CONFIG ) );

        printf("Emulation Word = 0x%04X\n\n",aux_config.emulation);

        printf("Memory mapped segment count = %d\n\n",aux_config.mem_mapped);
        if(aux_config.mem_mapped)
        {
            int i;
            printf("Segments Reported:\n");
            for(i=0; i<aux_config.mem_mapped; i++)
                printf("Base : 0x%04X  Byte Range : %04d\n"
                           ,aux_config.mem[i].base,aux_config.mem[i].range);
            printf("\n\n");
        }
        printf("I/O mapped address count = %d\n\n",aux_config.io_mapped);
        if(aux_config.io_mapped)
        {
            int i;
            printf("I/O Addresses Reported:\n");
            for(i=0; i<aux_config.io_mapped; i++)
                printf("Base : 0x%04X  Byte Range : %04d\n"
                           ,aux_config.io[i].base,aux_config.io[i].range);
            printf("\n\n");
        }

    }
    tiga_set( CD_CLOSE );
}

