/*************************************************************************/
/* stdlib.h  v5.01                                                       */
/* Copyright (c) 1990 Texas Instruments Inc.                             */
/*************************************************************************/
#ifndef _STDLIB
#define _STDLIB

typedef struct { int quot, rem; } div_t, ldiv_t;

#define MB_CUR_MAX    1

#ifndef NULL
#define NULL ((void *)0)
#endif

#ifndef _SIZE_T
#define _SIZE_T
typedef unsigned int size_t;
#endif

#ifndef _WCHAR_T
#define _WCHAR_T
typedef char wchar_t;
#endif

double atof(const char *_st);
int    atoi(const char *_st);
long   atol(const char *_st);

double strtod(const char *_st, char **_endptr);
long   strtol(const char *_st, char **_endptr, int _base);
unsigned long strtoul(const char *_st, char **_endptr, int _base);

#define RAND_MAX 32767
int    rand(void);
void   srand(unsigned _seed);

void  *calloc(size_t _num, size_t _size);
void  *malloc(size_t _size);
void  *realloc(void *_ptr, size_t _size);
void   free(void *_ptr);

#define EXIT_FAILURE  0
#define EXIT_SUCCESS  1

void   abort(void); 
int    atexit(void (*_func)(void));
void *bsearch(const void *key, const void *base, size_t nmemb, size_t size,
              int (*compar)(const void *,const void *)); 
void   qsort(void *base, size_t nmemb, size_t size, int (*compar)());
void   exit(int _status);

int    abs(int _i);
long   labs(long _i);
div_t  div(int _numer, int _denom);
ldiv_t ldiv(long _numer, long _denom);

#endif
