***************************************************************************
**  Property of Texas Instruments Incorporated                            *
**                                                                        *
**  Unauthorized reproduction and/or distribution is strictly             *
**  prohibited.  (C) Copyright 1996 Texas Instruments Incorporated.       *
**  All rights reserved.                                                  *
**                                                                        *
**  These commodities, technical data, and software may be U.S. export    *
**  license controlled.  As such, prior to export or re-export, U.S.      *
**  Government approval and authorization may be required.                *
**                                                                        *
**  PLEASE BE AWARE THAT IN THE ABSENCE OF A SIGNED, WRITTEN AGREEMENT    *
**  TO THE CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
**  MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR IMPLIED.        *
**  Further, TI assumes no liability for: 1) the accuracy of the SPICE    *
**  models provided to your company; 2) the proper functioning of these   *
**  SPICE models in your design or for any resulting applications;  or    *
**  3) infringement of patents, copyrights or intellectual property       *
**  rights resulting from your use of these SPICE models.                 *
**                                                                        *
**  TI provides SPICE models as a service to our customers.  You and      *
**  your company shall not distribute, convey, sell or give these         *
**  models to anyone else without receiving prior written permission      *
**  from TI.                                                              *
**                                                                        *
**  TI reserves the right to make changes to its products or to           *
**  discontinue any semiconductor product or service without notice,      *
**  and advises its customers to obtain the latest version of relevant    *
**  information to verify, before placing orders, that the information    *
**  being relied on is current.                                           *
**                                                                        *
**  Please be aware that your receipt and subsequent use of the SPICE     *
**  information provided shall serve as acceptance of the terms and       *
**  conditions of this agreement.  If you do not accept these terms,      *
**  you should return the SPICE model and any other accompanying          *
**  information immediately.                                              *
***************************************************************************
**CDC339 SPICE I/O Model
**Advanced System Logic, Texas Instruments
****************************************************************
*
*NOTE:
*   The following files must be present to use this SPICE model:
*      339.CDC                (netlist)
*      EPIC2B.LIB              (Library file for process models)
*      EPIC2BN.13              (Nominal process models, CMOS Level 13)
*      EPIC2BS.13              (Strong  process models, CMOS Level 13)
*      EPIC2BW.13              (Weak    process models, CMOS Level 13)
*      EPIC2BN.3               (Nominal process models, CMOS Level 3)
*      EPIC2BN.3               (Strong  process models, CMOS Level 3)
*      EPIC2BN.3               (Weak    process models, CMOS Level 3)
*      PKGS.LIB                (Library file for packages)
*      SOIC20.PKG               (Package parasitics)
*      READ.ME                 (General use, release notes, ...)
*
*NOTE:
*   The CDC339 is also available in the SSOP20 package.
*INSTRUCTIONS:
*   To use this SPICE model, include the following lines in your main netlist:
*      .
*      .
*      .
*      .INCLUDE '339.CDC'
*      XCDC339_IN     1     2     3           199   100         CDC339IN
*      XCDC339_OUT    4     5     6     7     199   100         CDC339OUT
*      .
*      .
*      .
*      .
*      .
*      .
*
*   The diagrams below describe the nodes for the subcircuits:
*
*                                                   /|\
*                     ----                           |
*                     |   \____ Node 2               |
*      Node 1  _______|    \                     Node 199(VCC)
*                     |    /o__ Node 3           Node 100(GND)
*                     |   /                          |
*                     ----                           |
*                                                   ---
*               CDC339IN(Input Buffer)               -
* 
*
*
*                     NODE 7                        /|\
*                       |                            |
*                       |                            |
*                     ----                       Node 199(VCC)
*                    /    |___ Node 4            Node 100(GND)
*      Node 6  _____/     |                          |
*                   \     |o__ Node 5                |
*                    \    |                         ---
*                     ----                           -
*
*               CDC339OUT(Output Buffer)
*
*       
*   Please refer to the 'READ.ME' file for general instructions for use.
*
*    CDC339 SPICE I/O MODEL SUBCIRCUIT
*    SPP 
*    ADVANCED SYSTEM LOGIC, TEXAS INSTRUMENTS
*
*    SUBCIRCUITS:  CDC339IN, CDC339OUT
*    PROCESS MODELS 
	.LIB 'EPIC2B.LIB' NOMINAL_L13
*       .LIB 'EPIC2B.LIB' STRONG_L13
*       .LIB 'EPIC2B.LIB' WEAK_L13 
*
*    PACKAGE MODELS
        .LIB 'PKGS.LIB'   SOIC20
*
* CDC339 INPUT SUBCIRCUIT
*    NODES:        INPUT NODE
*                  |     INTERNAL OUTPUT NODE (CP)
*                  |     |     INTERNAL OUTPUT NODE (NCP) 
*                  |     |     |     VCC
*                  |     |     |     |     GRD
.SUBCKT CDC339IN   1     2     3     199   100  
 X_PKGIN           1     1001                    SOIC20_16
 X_PKGVCC          199   1199                    SOIC20_17
 X_PKGGND          100   1100                    SOIC20_15
 XCDC339IN         1001  2     3     1199  1100  CDC339__IN
.ENDS CDC339IN
*
* CDC339 OUTPUT SUBCIRCUIT   
*    NODES:        INTERNAL INPUT NODE (Q)
*                  |     INTERNAL INPUT NODE (NQ) 
*                  |     |     OUTPUT NODE 
*                  |     |     |     INTERNAL OE NODE 
*                  |     |     |     |     VCC
*                  |     |     |     |     |     GRD
.SUBCKT CDC339OUT  4     7     5     6     199   100  
 X_PKGOUT          5     1005                          SOIC20_18
 X_PKGVCC          199   1199                          SOIC20_17
 X_PKGGND          100   1100                          SOIC20_15
 XCDC339OUT        4     7     1005  6     1199  1100  CDC339__OUT
.ENDS CDC339OUT
*
.SUBCKT CDC339__IN  501 502 503 599 500
 QESD  501 500 500   Q7_NPN   200
 QD2 577 581 500  Q5_NPN 50
 Q1  552 577 554  Q2_NPN 10
 Q2  553 590 554  Q2_NPN 10
 Q3  555 570 500  Q2_NPN 10
 Q4  556 570 500  Q2_NPN 10
 Q5  580 553 556  Q2_NPN 10
 Q6  559 570 500  Q2_NPN 10
 Q7  554 570 500  Q2_NPN 10
 Q8  557 556 559  Q2_NPN 10
 Q9  558 563 559  Q2_NPN 10
 Q10 502 570 500  Q2_NPN 10
 Q11 503 570 500  Q2_NPN 10
 Q12 580 555 570  Q2_NPN 10
 Q13 563 570 500  Q2_NPN 10
 Q14 580 558 575  Q2_NPN 10
 Q15 580 557 576  Q2_NPN 10
 XR1 580 599 555 599 RMOS WR=6.5U RES=4K
 XR2 580 599 553 599 RMOS WR=6.5U RES=1200
 XR3 580 599 557 599 RMOS WR=6.5U RES=1200
 XR4 580 599 558 599 RMOS WR=6.5U RES=1200
 XR5 580 599 562 599 RMOS WR=6.5U RES=600
 RESD 581 500   900
 RNMO 501 577   50
 C1   501 500   0.3P
 D1   577 552  D1_GDS  150
 QD1  552 599 599 Q2_NPN 10
 QD3  562 562 563 Q2_NPN 10
 QD4  575 575 502 Q2_NPN 10
 QD5  576 576 503 Q2_NPN 10
 VREF 580 500 DC 3.2V
 VTH  590 500 DC 1.5V  
.ENDS CDC339__IN
*
.SUBCKT CDC339__OUT  501 503 502 505 599 500
 Q1   554 554 500  Q2_NPN  10
 Q6   553 554 500  Q2_NPN  10
 Q7   551 501 553  Q2_NPN  10
 Q8   552 503 553  Q2_NPN  10
 QLOP 502 563 500  Q11_NPN 600
 QUOP 572 570 502  Q11_NPN 600
 QDAR 571 580 570  Q3_NPN  15
 XR1  599 599 554 599 RMOS WR=6.5U RES=7.5K
 XR2  599 599 551 599 RMOS WR=6.5U RES=6K
 XR3  599 599 552 599 RMOS WR=6.5U RES=6K
 XR4  558 599 580 599 RMOS WR=6.5U RES=1.2K
 XR5  570 599 573 599 RMOS WR=4U   RES=4K
 XR6  599 599 571 599 RMOS WR=6.5U RES=1K
 RIOS 585 572 10
 CBP  502 500 0.3P
 D2   599 585 D5_GSD 3344
 D3   580 571 D1_GSD 300
 D5   564 519 D1_GSD 900
 D6   519 502 D1_GSD 900
 D7   573 502 D1_GSD 150
 QD1  572 571 571 Q2_NPN 10
 QD4  570 570 580 Q2_NPN 10
 QD8  566 566 500 Q2_NPN 10
 QC2  554 500 554 Q5_NPN 60
 XN5  565 505 500 500 NM WN=20U   LN=0.8U
 XN6  560 551 566 500 NM WN=10U   LN=0.8U
 XN7  557 552 566 500 NM WN=10U   LN=0.8U
 XN8  580 557 563 500 NM WN=40U   LN=0.8U
 XN9  580 505 500 500 NM WN=30U   LN=0.8U
 XN10 563 565 564 500 NM WN=400U  LN=0.8U
 XN13 563 560 500 500 NM WN=40U   LN=0.8U
 XN14 563 505 500 500 NM WN=40U   LN=0.8U
 XP2  565 505 599 599 PM WP=50U   LP=0.8U
 XP3  557 552 599 599 PM WP=40U   LP=0.8U
 XP4  560 551 599 599 PM WP=40U   LP=0.8U
 XP6  558 505 599 599 PM WP=400U  LP=0.8U
.ENDS CDC339__OUT
*                                                CDC33996038GL
