***************************************************************************
**  Property of Texas Instruments Incorporated                            *
**                                                                        *
**  Unauthorized reproduction and/or distribution is strictly             *
**  prohibited.  (C) Copyright 1994 Texas Instruments Incorporated.       *
**  All rights reserved.                                                  *
**                                                                        *
**  These commodities, technical data, and software may be U.S. export    *
**  license controlled.  As such, prior to export or re-export, U.S.      *
**  Government approval and authorization may be required.                *
**                                                                        *
**  PLEASE BE AWARE THAT IN THE ABSENCE OF A SIGNED, WRITTEN AGREEMENT    *
**  TO THE CONTRARY, TEXAS INSTRUMENTS ("TI") IS PROVIDING THE SPICE      *
**  MODELS "AS IS" AND WITHOUT ANY WARRANTY, EXPRESSED OR IMPLIED.        *
**  Further, TI assumes no liability for: 1) the accuracy of the SPICE    *
**  models provided to your company; 2) the proper functioning of these   *
**  SPICE models in your design or for any resulting applications;  or    *
**  3) infringement of patents, copyrights or intellectual property       *
**  rights resulting from your use of these SPICE models.                 *
**                                                                        *
**  TI provides SPICE models as a service to our customers.  You and      *
**  your company shall not distribute, convey, sell or give these         *
**  models to anyone else without receiving prior written permission      *
**  from TI.                                                              *
**                                                                        *
**  TI reserves the right to make changes to its products or to           *
**  discontinue any semiconductor product or service without notice,      *
**  and advises its customers to obtain the latest version of relevant    *
**  information to verify, before placing orders, that the information    *
**  being relied on is current.                                           *
**                                                                        *
**  Please be aware that your receipt and subsequent use of the SPICE     *
**  information provided shall serve as acceptance of the terms and       *
**  conditions of this agreement.  If you do not accept these terms,      *
**  you should return the SPICE model and any other accompanying          *
**  information immediately.                                              *
***************************************************************************
**CDC340 SPICE I/O Model
**Advanced System Logic, Texas Instruments
****************************************************************
*
*NOTE:
*   The following files must be present to use this SPICE model:
*      340.CDC                 (netlist)
*      EPIC2B.LIB              (Library file for process models)
*      EPIC2BN.13              (Nominal process models, CMOS Level 13)
*      EPIC2BS.13              (Strong  process models, CMOS Level 13)
*      EPIC2BW.13              (Weak    process models, CMOS Level 13)
*      EPIC2BN.3               (Nominal process models, CMOS Level 3)
*      EPIC2BS.3               (Strong  process models, CMOS Level 3)
*      EPIC2BW.3               (Weak    process models, CMOS Level 3)
*      PKGS.LIB                (Library file for packages)
*      SOIC20.PKG              (Package parasitics)
*      SSOP20.PKG              (Package parasitics)
*      READ.ME                 (General use, release notes, ...)
*
*INSTRUCTIONS:
*   To use this SPICE model, include the following lines in your main netlist:
*      .
*      .
*      .
*      .INCLUDE '340.CDC'
*      XCDC340_IN     1     2     199   100               CDC340IN
*      XCDC340_OUT    4     5     6     199   100         CDC340OUT
*      .
*      .
*      .
*
*   The diagrams below describe the nodes for the subcircuits:
*
*                                                   /|\
*                     ----                           |
*                     |   \                          |
*      Node 1  _______|    \O__  Node 2          Node 199(VCC)
*                     |    /                     Node 100(GND)
*                     |   /                          |
*                     ----                           |
*                                                   ---
*               CDC340IN (Input Buffer)               -
* 
*
*                      | Node 6                     /|\
*                      |                             |
*                      |                             |
*                     ----                       Node 199(VCC)
*                    /    |                      Node 100(GND)
*      Node 5  _____/     |___  Node 4               |
*                   \     |                          |
*                    \    |                         ---
*                     ----                           -
*
*               CDC340OUT (Output Buffer)
*
*       
*   Please refer to the 'READ.ME' file for general instructions for use.
*
*    CDC340 SPICE I/O MODEL SUBCIRCUIT
*    ADVANCED BUS INTERFACE
*    ADVANCED SYSTEM LOGIC, TEXAS INSTRUMENTS
*
*    SUBCIRCUITS:  CDC340IN, CDC340OUT
*
*    PACKAGE PARASITICS
	.LIB 'PKGS.LIB'	SSOP20
*	.LIB 'PKGS.LIB'	SOIC20
*
*    PROCESS MODELS 
        .LIB 'EPIC2B.LIB' NOMINAL_L13
*       .LIB 'EPIC2B.LIB' STRONG_L13
*       .LIB 'EPIC2B.LIB' WEAK_L13
*
* CDC340 INPUT SUBCIRCUIT
*    NODES:        INPUT NODE
*                  |     INTERNAL OUTPUT NODE 
*                  |     |     VCC
*                  |     |     |     GND
*                  |     |     |     |
.SUBCKT CDC340IN   1     2     199   100  
 X_PKGIN           1     1001                    SSOP20_04
 X_PKGGND          100   1100                    SSOP20_17
 X_VCCREG          7     199   100               CDC340REG
 R1                102   2                       100
 XCDC340IN         1001  102     7     1100      CDC340__IN
.ENDS CDC340IN
*                         
* CDC340 OUTPUT SUBCIRCUIT   
*    NODES:        INTERNAL INPUT NODE
*                  |     OUTPUT NODE
*                  |     |     INTERNAL OE NODE
*                  |     |     |     VCC
*                  |     |     |     |     GND
*                  |     |     |     |     |
.SUBCKT CDC340OUT  4     5     6     199   100  
 X_PKGOUT          5     1005                          SSOP20_19
 X_PKGVCC          199   1199                          SSOP20_20
 X_PKGGND          100   1100                          SSOP20_17
 X_VCCREG          7     199   100                     CDC340REG
 X_GINV            6     8     199   100               INV WP1=10U WN1=10U
 XCDC340OUT        4     1005  8     7     1199  1100  CDC340__OUT
.ENDS CDC340OUT
*
* CDC340 VOLTAGE REGULATOR SUBCIRCUIT
*    NODES:        VCC REGULATED
*                  |    VCC
*                  |    |    GND
*                  |    |    |
.SUBCKT CDC340REG  7    199  100  
 X_PKGVCC          199  1199                    SSOP20_01
 X_PKGGND          100  1100                    SSOP20_17
 XCDC340REG        7    1199 1100               CDC340__REG
.ENDS CDC340REG
*
.SUBCKT CDC340__REG  501 599 500
 XP1  501 502 599 599  PM      WP=1000U LP=1.0U
 XP2  502 502 599 599  PM      WP=10U   LP=1.0U
 XC1  505 504 505 505  PM      WP=30U   LP=10U
 XC2  501 502 501 501  PM      WP=30U   LP=20U
 XC3  503 501 503 503  PM      WP=30U   LP=20U
 Q1   504 505 500      Q3_NPN  15
 Q2   502 504 503      Q1_NPN  5
 D1   506 500          D2_GSD  250
 R1   505 504                  32K
 XR2  506 505 505 505  RMOS    WR=6U    RES=8K
 XR3  504 599 599 599  RMOS    WR=6U    RES=6K
 R6   503 501                  5K
 R7   500 503                  8K
.ENDS CDC340__REG
*
.SUBCKT CDC340__IN 501 502 597 500
 XP1    502 503 597 597  PM     WP=200U LP=0.8U
 XP2    502 505 597 597  PM     WP=20U  LP=0.8U
 XP3    505 502 597 597  PM     WP=12U  LP=0.8U
 XP4    597 500 597 597  PM     WP=200U LP=40U 
 XN1    502 503 500 500  NM     WN=240U LN=0.8U
 XN2    505 502 500 500  NM     WN=25U  LN=0.8U
 QESD1  501 500 500      Q7_NPN 200  
 QESD2  503 504 500      Q5_NPN 48  
 RMOAT  501 503                 50
 RESD2  504 500                 900 
 CBP    501 500                 0.3P
 CL     502 500                 0.1P
.ENDS CDC340__IN
*
.SUBCKT CDC340__OUT 501 502 503 597 599 500      
 XP4    558 564 599 599      PM      WP=30U  LP=0.8U
 XP10   575 565 561 599      PM      WP=20U  LP=0.8U
 XP11   561 503 599 599      PM      WP=30U  LP=0.8U
 XPC1   599 566 599 599      PM      WP=90U  LP=35U
 XPC2   567 568 567 567      PM      WP=120U LP=8U
 XN1    572 571 551 500      NM      WN=100U LN=0.8U
 XN2    551 573 500 500      NM      WN=30U  LN=0.8U
 XN3    564 565 500 500      NM      WN=30U  LN=0.8U
 XN5    558 563 576 500      NM      WN=30U  LN=0.8U
 XN6    564 503 500 500      NM      WN=30U  LN=0.8U
 XN7    576 504 500 500      NM      WN=90U  LN=0.8U
 XN8    569 567 570 500      NM      WN=20U  LN=0.8U
 XN12   581 568 500 500      NM      WN=60U  LN=0.8U
 XN13   551 503 500 500      NM      WN=30U  LN=0.8U
 XN14   566 504 572 500      NM      WN=300U LN=0.8U
 Q1     582 580 502          Q9_NPN  300
 Q3     502 551 500          Q11_NPN 400
 Q4     582 558 580          Q3_NPN  15
 Q5     502 570 551          Q3_NPN  15
 Q6     567 583 500          Q5_NPN  47
 QD5    580 558 558          Q2_NPN  10
 QD6    570 567 567          Q1_NPN  4
 QD7    500 568 568          Q2_NPN  10
 QESD   502 500 500          Q7_NPN  200
 D1     551 562              D6_GSD  900
 D2     562 502              D6_GSD  900
 D3     558 574              D1_GSD  150
 D4     574 582              D1_GSD  150
 R4     599 582                      12
 R5     567 502                      50
 R9     583 500                      900
 R10    580 581                      125
 XR1    566 599 599 599      RMOS    WR=8.5U RES=1.5K
 XR2    564 575 575 575      RMOS    WR=6.5U RES=10K
 XR6    500 599 568 599      RMOS    WR=6.5U RES=5K
 XINV1  563 565 597 500      INV     WP1=20U WN1=20U
 XINV2  571 573 597 500      INV     WP1=20U WN1=10U
 XINV3  503 504 597 500      INV     WP1=45U WN1=20U
 XINV4  501 563 597 500      INV     WP1=40U WN1=20U
 XINV5  501 571 597 500      INV     WP1=60U WN1=15U
 XNOR1  501 502 569 597 500  NOR     WP1=30U WP2=30U WN1=8U WN2=8U
 CBP    502 500                      0.3P
.ENDS CDC340__OUT
*
.SUBCKT INV  551 552 599 500  WP1=10U WN1=10U
 XP      552 551 599 599  PM WP='WP1' LP=0.8U
 XN      552 551 500 500  NM WN='WN1' LN=0.8U
.ENDS INV
*
.SUBCKT NOR 551 552 553 599 500  WP1=20U WP2=20U WN1=10U WN2=10U
 XP1  510 551 597 597  PM WP='WP1' LP=0.8U
 XP2  553 552 510 597  PM WP='WP2' LP=0.8U
 XN1  553 551 500 500  NM WN='WN1' LN=0.8U
 XN2  553 552 500 500  NM WN='WN2' LN=0.8U
.ENDS NOR
* 
*                                                CDC340B95122GL
